// Persistence of Vision Ray Tracer Scene Description File
// File: chest-of-drawers.inc
// Vers: 3.5
// Desc: Table
// Date: 2003/05/25
// Auth: Maurizio Tomasi
//

#version 3.5;

#include "rand.inc"
#include "colors.inc"
#include "woods.inc"

#local Wood1 =
texture
{
    T_Wood2
    
    finish
    {
        specular 0.7
        roughness 0.03
    }
    normal
    {
        bozo 0.3
        scale 0.5
    }
    
    scale 0.1
}
texture
{
    // This gives a colder tint to T_Wood2
    pigment { color rgbt <0.8, 0.8, 1.0, 0.91> }
}

#local Wood2 =
texture
{
    T_Wood2
    
    finish
    {
        specular 0.7
        roughness 0.03
    }
    normal
    {
        bozo 1.5
        scale 0.4
    }
    
    scale 0.5
}
texture
{
    // This gives a colder tint to T_Wood2
    pigment { color rgbt <0.75, 0.6, 1.0, 0.91> }
}

#local GraniteTexture =
texture
{
    pigment
    {
        granite
        color_map
        {
            [0.1 color rgb <0.3, 0.2, 0.1> * 0.1]
            [0.7 color rgb <0.3, 0.2, 0.1>]
            [0.7 color rgb <0.5, 0.5, 0.4>]
            [1.0 color rgb <0.5, 0.5, 0.4> * 0.4]
        }
    }
    
    finish
    {
        specular 0.4
        roughness 0.3
    }
    
    scale 0.4
}

// These points define the table shape
#local Vertexes = array[13]
{
    <-1.0,  1.2>,
    < 0.0,  1.5>,
    < 1.0,  1.3>,
    < 1.0,  1.0>,
    < 1.3,  0.0>,
    < 1.0, -1.0>,
    < 1.0, -1.3>,
    < 0.0, -1.5>,
    <-1.0, -1.2>,

    <-1.0,  1.2>,
    < 0.0,  1.5>,
    < 1.0,  1.3>,
    < 1.0,  1.0>,
}


#local TablePlane =
prism
{
    cubic_spline
    0.0, 0.1, dimension_size (Vertexes, 1)
    
    #local Count = 0;
    #while (Count < dimension_size (Vertexes, 1))
        Vertexes[Count]
        #local Count = Count + 1;
    #end
}

#local TablePlaneBorder =
sphere_sweep
{
    cubic_spline
    dimension_size (Vertexes, 1),
    
    #local Count = 0;
    #while (Count < dimension_size (Vertexes, 1))
        <Vertexes[Count].x, 0.05, Vertexes[Count].y>, 0.05
        #local Count = Count + 1;
    #end
}

#declare GranitePlane =
intersection
{
    union
    {
        object { TablePlane }
        object { TablePlaneBorder }
    }
    
    box
    {
        <0, 0, -1.5>, <1.5, 0.1, 1.5>
    }
}

#local TableBase =
intersection
{
    object { TablePlane }
    box { <0, 0, 0>, <1.5, 0.1, 1.5> }
    
    scale <0.95, 15, 0.95> 
    translate 0.5*y
    texture 
    { 
        Wood2
        rotate -30*x
    }
}

#local DrawerBase =
intersection
{
    object { TablePlane scale <1, 35, 1> }
    box { <0, 0.05, 0>, <1.5, 0.3, 0.8> }
}

#local HandlePlaque =
intersection
{
    object { DrawerBase }
    box { <1.1, 0.15, 0.45>, <1.5, 0.25, 0.68> }
    translate 0.005*x
}

#local DrawerHandle =
union
{
    object 
    { 
        HandlePlaque 
        
        texture
        {
            pigment { color rgb <0.64, 0.58, 0.0> * 0.7 }
            finish { specular 0.8 roughness 0.1 }
            normal { bozo 3 scale 0.005 }
        }
    }
    
    // Handle
    
    difference
    {
        union
        {
            cylinder
            {
                <0, 0.005, 0>, <0, 0.015, 0>, 0.1 
            }

            cylinder
            {
                <0, 0.010, 0>, <0, 0.020, 0>, 0.0925
            }
        }
        
        cylinder
        {
            <0, -0.1, 0>, <0, 0.1, 0>, 0.085
        }
        
        translate <1.15, 0.20, 0.56>
        
        texture
        {
            pigment { color rgb <0.64, 0.58, 0.0> * 0.7 }
            finish { specular 0.8 roughness 0.1 }
        }
    }
}

#local Drawer =
union
{
    object { DrawerBase }
    object { DrawerHandle }
}

#local DrawerCase =
union
{
    difference
    {
        object { TableBase }

        #local Count = 0.7;
        #while (Count <= 1.5)
            object { Drawer translate Count*y }
            #declare Count = Count + 0.4;
        #end

        cutaway_textures
    }

    #local DrawerSeed = seed (15231);
    
    #local Count = 0.7;
    #while (Count <= 1.5)
        object 
        { 
            Drawer 
            translate Count*y+RRand (-0.07, -0.02, DrawerSeed)*x 
            texture 
            { 
                Wood1
                rotate -30*x
                
                scale RRand(0.7, 0.9, DrawerSeed)
                translate 3*VRand(DrawerSeed)
            }
        }
        #declare Count = Count + 0.4;
    #end
    
    // Front legs
    
    cone
    {
        <1.0, 2.0, 1.3>, 0.1, <1.0, 0.0, 1.2>, 0.05
        texture
        {
            Wood1
            rotate 90*x
            scale RRand(0.9, 1.0, DrawerSeed)
            translate VRand(DrawerSeed)
        }
    }

    cone
    {
        <1.0, 2.0, -1.3>, 0.1, <1.0, 0.0, -1.2>, 0.05
        texture
        {
            Wood1
            rotate 90*x
            scale RRand(0.9, 1.0, DrawerSeed)
            translate VRand(DrawerSeed)
        }
    }

    // Back legs
    
    cone
    {
        <-0.1, 2.0, 1.3>, 0.1, <-0.1, 0.0, 1.3>, 0.05
        texture
        {
            Wood1
            rotate 90*x
            scale RRand(0.9, 1.0, DrawerSeed)
            translate VRand(DrawerSeed)
        }
    }

    cone
    {
        <-0.1, 2.0, -1.3>, 0.1, <-0.1, 0.0, -1.3>, 0.05
        texture
        {
            Wood1
            rotate 90*x
            scale RRand(0.9, 1.0, DrawerSeed)
            translate VRand(DrawerSeed)
        }
    }
}


// ---------------------------------------------
// Putting all together...

#declare ChestOfDrawers =
union
{
    union
    {
        object { GranitePlane scale <1, 0.33, 1> translate 0.167*y }
        object { GranitePlane scale <1.02, 0.67, 1.02> translate 0.1*y }
        object { GranitePlane scale <1.04, 1, 1.04> }
        
        texture { GraniteTexture }

        translate 2*y
    }

    object { DrawerCase }
    object { DrawerCase scale <1, 1, -1> }

}
