// Persistence of Vision Ray Tracer Scene Description File
// File: clock-func.inc
// Vers: 3.5
// Desc: Functions to place clock hands at the right angle
// Date: 2003/09/28
// Auth: Maurizio Tomasi

#ifndef (__CLOCK_FUNC_INC__)
#declare __CLOCK_FUNC_INC__ = 1;

/* In these two functions, "h" is a real number expressing
 * the hour of day, e.g. h = 1.5 means 1:30.  The number
 * returned is the angle (always positive) of rotation starting
 * from top.  Examples:
 *
 *    ClockHourHand (6.0)   = 180 degrees
 *    ClockMinuteHand (6.0) = 0 degrees
 *
 *    ClockHourHand (6.5)   = 195 degrees
 *    ClockMinuteHand (6.5) = 180 degrees
 *
 */ 
#declare ClockHourHand = function (h) { h * 360 / 12 }
#declare ClockMinuteHand = function (h) { (h - int(h)) * 360 }

#end // #ifndef (__CLOCK_FUNC_INC__)

