// POV-Ray 3.5 Scene File
// File: mtdevil1.pov
// Vers: 1.0
// Desc: The Devils: Stepan Trofimovic's studyroom
// Date: 2003/10/09
// Auth: Maurizio Tomasi
//

#declare CurrentTime = 7.42; // 7:25 (am)

#declare CAMERA_NUM = 1;

#declare USE_PARQUET = true;
#declare USE_AREA_LIGHTS = true;
#declare USE_WALL_DECORATIONS = true;
#declare USE_WRITING_DESK = true;
#declare USE_BOOKS = true;
#declare USE_BOOK_ENDS = true;
#declare USE_CHAIR = true;
#declare USE_STEFAN_TROFIMOVIC = true;
#declare USE_PENDULUM_CLOCK = true;
#declare USE_CHEST_OF_DRAWERS = true;
#declare USE_PAINTINGS = true;
#declare USE_THECA = true;
#declare USE_HARPSICHORD = true;
#declare USE_CHEST_OF_DRAWERS = true;

#include "rand.inc"
#include "arrays.inc"
#include "walls.inc"

global_settings
{
    assumed_gamma 1.0
    ambient_light 0
    max_trace_level 15
}


#if (USE_WRITING_DESK)
    #include "writing-desk.inc"
    #include "paper.inc"
    
    #local WritingDeskObj =
    object
    {
        WritingDesk
        rotate 180*y
        scale 0.31
    }
    
    union
    {
        object
        {
            WritingDeskObj
        }
        
        #local EmptyPaperTex =
        texture
        {
            pigment
            {
                color rgb 1.2
            }
            
            finish
            {
                crand 0.1
            }
        }
        
        // Determine the Y position of the desk's top shelf

        #local Norm = <0, 0, 0>;
        #local P = trace (WritingDeskObj, <0, 10, -1.0>, -y, Norm);
        #local DeskPlaneY = P.y;

        object
        {
            PaperSheet01
            
            texture
            {
                pigment
                {
                    uv_mapping
                    image_map
                    {
                        png "bodies-and-souls.png"
                        interpolate 2
                    }
                }
            }
            
            scale 0.6
            rotate 20*y
            translate <1.2, DeskPlaneY, -1.0>
        }
        
        
        object
        {
            PaperSheet02
            
            texture { EmptyPaperTex }
            
            scale <1, 0.3, 1> * 0.6
            rotate -10*y
            translate <-1, DeskPlaneY + 0.01, -1.0>
        }
        
        object
        {
            PaperSheet02
            
            texture { EmptyPaperTex }
            
            scale 0.6
            rotate -7*y
            translate <-1.15, DeskPlaneY + 0.03, -0.85>
        }
        
        #if (USE_BOOKS)
        
            #include "book.inc"
            #include "clock.inc"
            
            // Determine the Y position of the desk's top shelf
            
            #local Norm = <0, 0, 0>;
            #local P = trace (WritingDeskObj, <0, 10, 0.5>, -y, Norm);
            
            #local Thicknesses = array [6]
            {
                0.12,
                0.08,
                0.10,
                0.08,
                0.16,
                0.08
            }
            
            #local Heights = array [6]
            {
                0.60,
                0.70,
                0.65,
                0.74,
                0.80,
                0.75
            }
            
            #local Colors = array [6]
            {
                <0.53, 0.32, 0.28>,
                <0.32, 0.36, 0.33>,
                <0.34, 0.32, 0.21>,
                <0.22, 0.24, 0.24>,
                <0.25, 0.25, 0.27>,
                <0.68, 0.46, 0.14>
            }
            
            #local Titles = array[6]
            {
                "book-title01.png",
                "book-title02.png",
                "book-title03.png",
                "book-title04.png",
                "book-title05.png",
                "book-title06.png"
            }
            

            // Place the books on the writing desk
            
            #if (vlength (Norm) > 0)
            
                #local BaseY = P.y;

                #local StartPos = 0.2;
                #local CurPos = StartPos;
                #local CurBook = 0;
                #local CurTitleIndex = 0;
                #local BookSeed = seed (27643);
                
                #while (CurBook < 10)
                
                    #local CurColor = (Rand_Array_Item (Colors, BookSeed) + 0.0);
                    #local CurHeight = (Rand_Array_Item (Heights, BookSeed) + 0.0);
                    #local CurThickness = (Rand_Array_Item (Thicknesses, BookSeed) + 0.0);
                    
                    #local NumOfDeco = 0;
                    
                    #if (rand (BookSeed) > 0.7)
                        #declare NumOfDeco = 3 + int (2 * rand (BookSeed) + 0.5);
                    #end
                                        
                    object
                    {
                        CreateBook (0.4, CurHeight, CurThickness,
                            color rgb CurColor, NumOfDeco, color rgb CurColor * 1.5,
                            Titles [CurTitleIndex])
                        
                        translate <-1 + CurPos, BaseY, -1 + RRand (0, 0.05, BookSeed)>
                    }
                    
                    #if (NumOfDeco = 0)
                        #declare CurTitleIndex = CurTitleIndex + 1;
                        #if (CurTitleIndex >= dimension_size (Titles, 1))
                            #declare CurTitleIndex = 0;
                        #end
                    #end
                    
                    #declare CurPos = CurPos + CurThickness + 0.01;
                    #declare CurBook = CurBook + 1;
                    
                #end
                
                #if (USE_BOOK_ENDS)
                    #include "book-end_pov.inc"
                    
                    object
                    {
                        Book_end
                        rotate 90*y
                        translate <-1.3 + StartPos, BaseY, -0.5>
                    }

                    object
                    {
                        Book_end
                        rotate -90*y
                        translate <-0.9 + CurPos, BaseY, 0>
                    }
                #end
                
                object
                {
                    Clock
                    scale 0.4
                    rotate 30*y
                    translate <CurPos, BaseY, 1.0>
                }
            #end
        #end

        translate <5.4, 0, z1 - 1.5>
    }
    
#end


#if (USE_CHAIR)
    #include "chair.inc"
    
    object
    {
        Chair
        scale 3.1
        translate <5.4, 0, z1 - 3.8>
    }
#end


#if (USE_STEFAN_TROFIMOVIC)
    #include "stefan_pov.inc"
    
    object
    {
        Stefan
        
        scale 6.0
        translate <5.4, 0, z1 - 2.0>
    }

#end


#if (USE_PENDULUM_CLOCK)
    #include "pendulum-clock.inc"
    #include "key.inc"

    union
    {    
        object
        {
            PendulumClock
        }
        
        union
        {
            object { Lock }
            object 
            { 
                Key 
                rotate 20*z
                translate 0.1*y 
            }
            
            rotate 180*y
            scale 0.12
            translate <0.35, 2.8, 0.0>
        }

        scale 1.2
        translate <2.0, 0, z1 - 1.0>
    }
    
#end


#if (USE_PAINTINGS)
    #include "portraits.inc"
    
    object
    {
        Portrait
        translate <14.5, 6.2, z1 - 0.01>
    }
    
    object
    {
        Painting01
        
        scale 1.8
        translate <4.0, 6.9, z1 - 0.01>
    }

    object
    {
        Painting02
        
        scale 1.8
        translate <6.3, 6.5, z1 - 0.01>
    }

    object
    {
        Painting02
        
        scale 2.5
        translate <13, 6.5, z2 - 0.01>
    }

#end


#if (USE_THECA)
    #include "theca.inc"
    
    object
    {
        ThecaWithButterflies
        translate <15, 7.5, z1>
    }
    
#end

#if (USE_HARPSICHORD)
    #include "harpsichord.inc"
    
    object
    {
        Harpsichord
        
        rotate 90*y
        scale 1.0
        translate <13.5, 0.03, z1 - 0.2>
    }

#end


#if (USE_CHEST_OF_DRAWERS)
    #include "chest-of-drawers.inc"
    
    object
    {
        ChestOfDrawers
        scale 1.5
        translate <11.5, 0, z2 - 0.2>
    }
    
#end

////////////////////////////////////////////////////////////


#switch (CAMERA_NUM)

#case(1) // Default view
    #declare Location = <6.5, 3.8, z0 + 0.5>;
    #declare Direction = 1.0*z;
    #declare Right = x*image_width/image_height;
    #declare LookAt = <8.0, 3.8, z1>;
#break

#end

camera 
{
    location  Location
    direction Direction
    right     Right
    look_at   LookAt
}


//-------------------------------------------------------------
// Lights

light_source // Main light source (from the window on the right)
{
    <x3 - 0.5, 6, z1 - 5.0>
    color rgb <0.8, 0.77, 0.84> * 1.2

    #if (USE_AREA_LIGHTS)
        area_light 1.5*z, 8*y, 15, 15
        adaptive 1
    #end
    
    fade_power 2
    fade_distance 15
}

light_source // Contrasting light source (from the window on the left)
{
    <x1 + 0.5, 6, z0 + 1.5>
    color rgb 0.5 // 0.8
    
    #if (USE_AREA_LIGHTS)
        area_light 1.5*z, 8*y, 15, 15
        adaptive 1
    #end

    shadowless
        
    fade_power 4
    fade_distance 8
}

light_source // Fill light
{
    <x1 - 2.5, 3, z0 + 0.5>
    color rgb <0.8, 0.77, 0.84> * 0.20 // 0.25
    
    shadowless
    
    fade_power 2
    fade_distance 5
}
