// Persistence of Vision Ray Tracer Scene Description File
// File: pyr-base.inc
// Vers: 3.5
// Desc: Pyramid base macro
// Date: 2003/09/27
// Auth: Maurizio Tomasi

#ifndef (__PYR_BASE__)
#declare __PYR_BASE__ = 1;


/* Create a pyramid base with the following shape:
 *
 * z ^       A                y ^
 *   |  .<------->.             |   ^ |\
 *   |  .         .             | C | | \
 *   |  +---------+...          |   v.|..\
 *   |  |    ^    |  ^          |     |   |
 *   |  |    | C  |  |          |     |   |
 *   |  |    v    |  |          |     |   |
 *   |  |  +---+  |  |          |     |   |
 *   |  |  |   |  |  |          |     |<->|
 *   |  |  |   |  |  | B        |     | D |
 *   |  |  |   |  |  |          |     |   |
 *   |  |  +---+  |  |          |     |   |
 *   |  |         |  |          |     |   |
 *   |  |         |  |          |     |  /
 *   |  |         |  v          |     | /
 *   |  +---------+...          |     |/
 *   |                          |  
 *   +--------------> x         +-------------> z
 */

#macro PyramidBase (A, B, C, D)

    intersection
    {
        // The pyramid is fully contained by this box
        box
        {
            <-A/2, 0, -B/2>, <A/2, D, B/2>
        }

        #local RotationAngle = degrees (atan2 (D, C));

        plane
        {
            y, 0
            
            rotate z*RotationAngle
            translate -A/2*x
        }
            
        plane
        {
            y, 0
            
            rotate -z*RotationAngle
            translate A/2*x
        }

        plane
        {
            y, 0
            
            rotate -x*RotationAngle
            translate -B/2*z
        }
        
        plane
        {
            y, 0
            
            rotate x*RotationAngle
            translate B/2*z
        }
    }
        
#end


#end // #ifndef (__PYR_BASE__)
