// Persistence of Vision Ray Tracer Scene Description File
// File: theca.inc
// Vers: 3.5
// Desc: Theca with butterflies
// Date: 2003/09/29
// Auth: Maurizio Tomasi

#include "rand.inc"
#include "shapes.inc"
#include "colors.inc"
#include "woods.inc"

#include "pyr-base.inc"

#local Wood =
texture
{
    T_Wood2
    
    finish
    {
        specular 0.7
        roughness 0.03
    }
    normal
    {
        bozo 0.3
        scale 0.5
    }
    
    scale 0.1
}
texture
{
    // This gives a darker tint to T_Wood2
    pigment { color rgbt <0.6, 0.6, 0.8, 0.91> }
}


#local Glass =
material
{
    texture
    {
        pigment { color rgbt <0.97, 0.97, 0.99, 0.91> }
        finish { reflection { 0.015 } specular 1 roughness 0.01 }
    }

    interior { ior 1.3 }
    
}


/////////////////////////////////////////////////////////////////////////
// Theca

#local Width = 2.5;
#local Height = 0.8;
#local Thickness = 0.1;
#local Border = 0.1;
#local WallThickness = 0.02;
#local GlassBorder = 0.05;

#local Theca =
difference
{
    object
    {
        Round_Box_Union (<-Width/2, -Height/2, -Thickness>, 
            <Width/2, Height/2, 0.0>, WallThickness)
    }
    
    union
    {
        box
        {
            <-Width/2 + Border/2, -Height/2 + Border/2, -Thickness + WallThickness>,
            < Width/2 - Border/2,  Height/2 - Border/2, -WallThickness>
        }
        
        box
        {
            <-Width/2 + Border, -Height/2 + Border, -Thickness - 1>,
            < Width/2 - Border,  Height/2 - Border, -WallThickness>
        }
    }
    
    texture { Wood }
}


#local GlassWindow =
object
{
    PyramidBase (Width - 1.5 * Border, Height - 1.5 * Border, GlassBorder, 0.05)
    
    rotate -90*x
    translate -WallThickness*z

    material { Glass }
}


/////////////////////////////////////////////////////////////////////////
// Butterflies

#macro CreateButterfly (FileName, AspectRatio)
    box
    {
        <-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
        
        texture
        {
            pigment
            {
                image_map
                {
                    png FileName
                    interpolate 2
                    transmit all 0.1
                }
                translate <-0.5, -0.5>
            }
        }
        
        scale <1, AspectRatio, 1>
        scale <0.5, 0.5, 0.01>
        translate -Thickness*0.2*z
    }
#end

#local Butterfly = array[3];

#local Butterfly[0] =
object
{
    CreateButterfly ("butterfly01.png", 538/736)
}

#local Butterfly[1] =
object
{
    CreateButterfly ("butterfly02.png", 539/867)
}

#local Butterfly[2] =
object
{
    CreateButterfly ("butterfly03.png", 402/767)
}


/////////////////////////////////////////////////////////////////////////
// Plaques

#macro CreatePlaque (FileName)
    height_field
    {
        png FileName
        smooth
        
        translate <-0.5, 0, -0.5>
        rotate -90*x
        
        scale <1, 52/233, 1>
        scale <0.2, 0.2, 0.01>
        translate <0, -Height/2 + Border/2 * 1.05, -Thickness>
        
        texture
        {
            pigment { color rgb <0.7, 0.7, 0.6> }
            finish { specular 0.6 roughness 0.01 metallic }
        }
    }
#end

#local Plaque = array[3];

#local Plaque[0] =
object
{
    CreatePlaque ("butterfly-plaque01.png")
}

#local Plaque[1] =
object
{
    CreatePlaque ("butterfly-plaque02.png")
}

#local Plaque[2] =
object
{
    CreatePlaque ("butterfly-plaque03.png")
}


/////////////////////////////////////////////////////////////////////////
// The final object

#declare ThecaWithButterflies =
union
{
    object { Theca }
    object { GlassWindow }
    
    #local Count = 0;
    #while (Count < 3)
        union
        {
            object { Butterfly[Count] }
            object { Plaque[Count] }
            
            translate (Count - 1) * 0.9 * Width / 3 * x
        }
        #local Count = Count + 1;
    #end
}
