// Persistence of Vision Ray Tracer Scene Description File
// File: poppy.inc
// Vers: 3.5
// Desc: Contains Poppy object for remembrance.pov
// Date: October 30, 2003
// Auth: Philip Chan

#include "colors.inc"

#declare P_radius = 0.3;  // radius of the little circles in the interior of the poppy
#declare P_pos = 0.45;  // position of the little circles in the interior of the poppy

#declare Poppy = union {
	// center
	union {
		box { <-0.5, 0.02, -0.5>, <0.5, 0.04, 0.5> }
		cylinder { <-0.225, 0.02, -P_pos>, <-0.225, 0.04, -P_pos>, P_radius }
		cylinder { <0.225, 0.02, -P_pos>, <0.225, 0.04, -P_pos>, P_radius }
		cylinder { <-0.225, 0.02, P_pos>, <-0.225, 0.04, P_pos>, P_radius }
		cylinder { <0.225, 0.02, P_pos>, <0.225, 0.04, P_pos>, P_radius }
		cylinder { <-P_pos, 0.02, -0.225>, <-P_pos, 0.04, -0.225>, P_radius }
		cylinder { <-P_pos, 0.02, 0.225>, <-P_pos, 0.04, 0.225>, P_radius }
		cylinder { <P_pos, 0.02, -0.225>, <P_pos, 0.04, -0.225>, P_radius }
		cylinder { <P_pos, 0.02, 0.225>, <P_pos, 0.04, 0.225>, P_radius }		
		pigment { colour ForestGreen }
	}
	// flower
	union {
		box { <-0.8, 0, -0.8>, <0.8, 0.02, 0.8> }
		difference {
			union {
				sphere { <-0.8, 0, -1.5>, 0.7 }
				cylinder { <-0.8, 0, -1.5>, <0.8, 0, -1.5>, 0.7 }
				sphere { <0.8, 0, -1.5>, 0.7 }
				sphere { <-0.8, 0, 1.5>, 0.7 }
				cylinder { <-0.8, 0, 1.5>, <0.8, 0, 1.5>, 0.7 }
				sphere { <0.8, 0, 1.5>, 0.7 }
				sphere { <-1.5, 0, -0.8>, 0.7 }
				cylinder { <-1.5, 0, -0.8>, <-1.5, 0, 0.8>, 0.7 }
				sphere { <-1.5, 0, 0.8>, 0.7 }
				sphere { <1.5, 0, -0.8>, 0.7 }
				cylinder { <1.5, 0, -0.8>, <1.5, 0, 0.8>, 0.7 }
				sphere { <1.5, 0, 0.8>, 0.7 }
			}
			plane { y, 0 }
			scale <1, 0.1, 1>
			translate y*0.02
		}
		pigment { colour rgb <0.99, 0.34, 0.44> }
		rotate -y*45
	}
	// pin
	union {
		sphere { <0, 0, 0>, 1
			scale <0.2, 0.04, 0.2>
			translate y*0.04
		}
		cylinder { <0, -0.03, 0>, <0, -0.03, -3.5>, 0.05 }
		pigment { colour White }
		finish { diffuse 1.0 }
	}
}
	