//	Persistence of Vision Ray Tracer Scene Description File
//	File: Spider.pov
//	Date: October 2003
//	Author:  Katherine Donaldson

#ifndef (Master)
	#local Master = 1;
		
	camera { 
		location <1.0, 1, 1>*5
		//up y*image_height right x*image_width
		look_at <0.0, 0, 0.0>
	}
	light_source {
		<-10, 10, -40>
		rgb <1.0, 1.0, 1.0>
	}
#else
	#local Master = 0;
#end

#macro make_spider_leg(seg_bend_angle)
	union {
		//#local seg_bend_angle = 30;
		#local seg_length = 3;
		#local seg_radius = seg_length/20;
		#local joint_ratio = 1.5;
		#local seg = union {
			sphere {<0,0,0>,seg_radius*joint_ratio pigment {rgb 0.5}}
			cylinder {<-seg_length, 0,0>, <0,0,0>, seg_radius pigment {rgb 0.3}}
		}
		object {seg rotate seg_bend_angle*z}
		object {seg rotate seg_bend_angle*z	translate -seg_length*x	rotate seg_bend_angle*z}
		object {seg rotate seg_bend_angle*z	translate -seg_length*x	rotate seg_bend_angle*z	translate -seg_length*x	rotate seg_bend_angle*z}
	}
#end

//object {spider_leg}

#macro make_spider(seg_bend_angle)
	union {
		sphere {<0,0,0>,1 scale <1.5,1,2> pigment {rgb 0.2}}
		sphere {<0,0,2>,1 scale <1,0.5,1> pigment {rgb 0.2}}
		#local spider_leg_spacing = 29;
		object {make_spider_leg(seg_bend_angle) translate -x	rotate -45*y}
		object {make_spider_leg(seg_bend_angle)  translate -x	rotate (-45+spider_leg_spacing)*y}
		object {make_spider_leg(seg_bend_angle)  translate -x	rotate (-45+spider_leg_spacing*2)*y}
		object {make_spider_leg(seg_bend_angle)  translate -x	rotate (-45+spider_leg_spacing*3)*y}
	
		object {make_spider_leg(seg_bend_angle)  translate -x	rotate (-135-spider_leg_spacing*0)*y}
		object {make_spider_leg(seg_bend_angle)  translate -x	rotate (-135-spider_leg_spacing*1)*y}
		object {make_spider_leg(seg_bend_angle)  translate -x	rotate (-135-spider_leg_spacing*2)*y}
		object {make_spider_leg(seg_bend_angle)  translate -x	rotate (-135-spider_leg_spacing*3)*y}
	
	}
#end

#if (Master=1)

	object {make_spider(30)}
#end
