//	Persistence of Vision Ray Tracer Scene Description File
//	File: Spider.pov
//	Date: October 2003
//	Author:  Katherine Donaldson

#ifndef (Master)
	#declare Master = 1;
	camera { 
		location <0, 1, -1>*3
		//up y*image_height right x*image_width
		look_at <0.0, 0, 0.0>
	}
	light_source {
		<-10, 10, -40>
		rgb <1.0, 1.0, 1.0>
	}
#else
	#local Master = 0;
#end

#declare web_material = 	material {
		texture{
			pigment {
				rgb <0.691356, 0.726696, 1.000000>*0.8
			}
			normal {
				gradient <1.0, 1.0, 0>
				2 //amount
				scallop_wave
			}
			finish {
				irid {
					0.5
					thickness 2
					turbulence <0.0, 1.0, 0.0>
				}
				brilliance 1.0
				roughness 0.05
			}
		}
		scale <0.02, 0.02, 0.02>
	}

#declare hanging_web_sack = union {
	cylinder {<0,0,0>,<0,50,0>,0.05 }
	lathe {
		bezier_spline
		12, 
		<0.00000, 0.00000>,
		<0.12987, -0.00000>,
		<0.25126, 0.05242>,
		<0.25974, 0.16340>,
		<0.25974, 0.16340>,
		<0.26623, 0.24837>,
		<0.25325, 0.37908>,
		<0.13636, 0.52941>,
		<0.13636, 0.52941>,
		<0.10243, 0.57305>,
		<0.05844, 0.69935>,
		<0.04545, 1.00000>
		sturm
	}
	material {web_material scale 0.5}
}

#include "spider.pov"

#declare web_sack_with_spiders = union {
	object {hanging_web_sack}
	object {make_spider(40) scale 0.03 rotate -90*y rotate -45*z translate <0.3,0.6,0>  }
	object {make_spider(40) scale 0.03 rotate 90*y rotate 100*z translate <-0.4,0.1,0>  rotate -80*y}
	object {make_spider(40) scale 0.03 rotate 90*y rotate 100*z translate <-0.4,0.1,0>  rotate 100*y}
}

#if (Master = 1)
	object {web_sack_with_spiders}	
#end
