#include "crystalball.inc"

// perspective (default) camera
camera {
  location  <0.0, 30.0, -30.0>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
}

light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <40, 40, -40> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 30                // hotspot (inner, in degrees)
  tightness 2            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 30               // intensity falloff radius (outer, in degrees)
}

object { CrystalBall(8) }

plane { y,0 pigment { color rgb <1,1,1> } }   




