/*
    Use in the following way:
    
      object { cballstand }
    
    To get different dimensions, play with the "Settings" declares below.
*/
                   
#include "colors.inc"
#include "woods.inc"
#include "textures.inc" 
// various glass finishes, colors and interiors
//
#include "glass.inc"
#include "functions.inc"   
#include "stones1.inc"               
                   
// Settings
#declare tablethickness = 3;
#declare tablelength = 60;
#declare tablewidth = 60;  

#declare standheight = 80;
#declare standradius = 3;

#declare tabletop = 
box {
  <-tablelength/2, -tablethickness/2, -tablewidth/2>  // one corner position <X1 Y1 Z1>
  < tablelength/2,  tablethickness/2,  tablewidth/2>  // other corner position <X2 Y2 Z2>
}
            
// Modeling

#declare leftcyl =
difference {
  cylinder {
    (-tablewidth/2)*z,  (tablewidth/2)*z,  tablethickness/2 
    // open           
    translate (-tablelength/2)*x
  } 
  object { tabletop }
}
#declare rightcyl =
difference {
  cylinder {
    (-tablewidth/2)*z,  (tablewidth/2)*z,  tablethickness/2
    // open           
    translate (tablelength/2)*x
  }                    
  object { tabletop }
}
#declare frontcyl =
difference {
  cylinder {
    (-tablelength/2)*x,  (tablelength/2)*x,  tablethickness/2
    // open           
    translate (tablewidth/2)*z
  }
  object { tabletop }
}
#declare backcyl =
difference {
  cylinder {
    (-tablelength/2)*x,  (tablelength/2)*x,  tablethickness/2
    // open           
    translate (-tablewidth/2)*z
  } 
  object { tabletop }
}

// Corners 
#declare fl =     
intersection {
  object { frontcyl scale 2*x }
  object { leftcyl scale 2*z }
}
#declare bl =     
intersection {
  object { backcyl scale 2*x }
  object { leftcyl scale 2*z }
}
#declare fr =     
intersection {
  object { frontcyl scale 2*x }
  object { rightcyl scale 2*z }
}
#declare br =     
intersection {
  object { backcyl scale 2*x }
  object { rightcyl scale 2*z }
}
/*
#declare stand = 
cylinder {
  (-tablethickness/2)*y,  (-standheight-tablethickness/2)*y,  standradius
  // open          
}         
*/

#declare standlathe = 
  #local bottom = (-standheight-tablethickness/2);
  #local top = (-tablethickness/2);             
  #local yrange = top-bottom;
  // rotate a 2-D outline of points around the Y axis to create a 3-D shape
  lathe {
    cubic_spline // linear_spline | quadratic_spline | cubic_spline
    7, // number of points
    <2, bottom>,
    <2, bottom>, 
    <10, bottom+0.1*yrange>, 
    <8, bottom+0.3*yrange>, 
    <10, bottom+0.7*yrange>, 
    <2, top>, // the list of <u,v> points
    <2, top>
  }     

#declare standsubcyl =               
  #declare cylbit = 
  cylinder {
    top*y,  bottom*y,  standradius
  }         
  union {
    #local Nr = 0;     // start
    #local EndNr = 10; // end
    #while (Nr< EndNr) 
      object{ cylbit translate<2*standradius,0,0> rotate<0,Nr * 360/EndNr,0>} 
      #local Nr = Nr + 1;    // next Nr
    #end // ---------------  end of loop 
    rotate<0,0,0>
    translate<0,0,0>
  } // end of union


# declare wires =
isosurface {
  function{
     f_helix1(
        x,y,z,
        4,    // number of helixes, (1 = single helix, 2 = double helix etc.)
        0.1,    // period,      turns on the length of 2*pi 
        3, // minor radius,
        10, // major radius,
        0.75, // shape parameter, 
        2.0,  // cross section type, (0.0 to 1.0 = square ... rounded to circle
              //                 over 2.0 to 3.0 = rounded to diamond and concave diamond
        0     // cross section rotation angle
      )
  }          
 contained_by {box { <-100,-86,-100> , <100,0,100> }}
 max_gradient 8
 
 texture{ 
    Chrome_Metal
    //pigment{ color rgb <1,0.8,0.3>} 
    finish { ambient 0.1 diffuse 0.75 phong 0.2 }
           }
 rotate<0,0,0>
 scale <1,1,1>
 translate< 0,0,0>
}// end of isosurface -------------------------------------------------------------------



              
#declare stand =          
union {
difference {
  object { standlathe }
  object { standsubcyl }
} 
//object { wires }          
}

  
           
#declare footpiece = 
lathe {
  quadratic_spline // linear_spline | quadratic_spline | cubic_spline
  6, // number of points
  <0, 0>, <0, 0>, <0.5*tablewidth/2, 0>, <0.7*tablewidth/2, -0.5>, <tablewidth/2, -3>, <0, -3> 
  translate (-standheight-tablethickness/2)*y
}            

#macro mytex(tex,scl,rot)
  texture { tex scale scl rotate rot } 
#end                                        

                   
#declare topbit = 
union {
  object { tabletop }//mytex(T_Wood11,5,<0,5,0>)  }
  object { leftcyl }//mytex(T_Wood11,5,<0,5,90>) }
  object { rightcyl }//mytex(T_Wood11,5,<0,5,90>) }
  object { frontcyl }//mytex(T_Wood11,5,<0,5,90>) }
  object { backcyl }//mytex(T_Wood11,5,<0,5,90>) }
  object { fl }//mytex(T_Wood11,5,<0,5,45>) }
  object { fr }//mytex(T_Wood11,5,<0,5,45>) }
  object { bl }//mytex(T_Wood11,5,<0,5,45>) }
  object { br }//mytex(T_Wood11,5,<0,5,45>) }
}

#declare topbitoct = 
intersection {
  object { topbit scale 1.0001*y }
  object { topbit rotate <0,45,0> }
}
                                       
                                        
#declare cballstand = 
union {
  /*object { tabletop mytex(T_Wood11,5,<0,5,0>)  }
  object { leftcyl mytex(T_Wood11,5,<0,5,90>) }
  object { rightcyl mytex(T_Wood11,5,<0,5,90>) }
  object { frontcyl mytex(T_Wood11,5,<0,5,90>) }
  object { backcyl mytex(T_Wood11,5,<0,5,90>) }
  object { fl mytex(T_Wood11,5,<0,5,45>) }
  object { fr mytex(T_Wood11,5,<0,5,45>) }
  object { bl mytex(T_Wood11,5,<0,5,45>) }
  object { br mytex(T_Wood11,5,<0,5,45>) }
  */
  object { topbitoct mytex(T_Wood6 ,5,<0,5,90>) } 
  
  object { stand mytex(T_Wood6,5,<0,5,0>) }
/*  object { 
    stand 
    texture {
      pigment { color Col_Glass_Clear }
      finish { F_Glass5 }
      
    } 
    interior { I_Glass_Exp(10) }
  }
*/  
  
  
  
  
  object { footpiece mytex(T_Wood6,5,<0,5,0>) }
                     
  // pigment { color rgb <0,1,0> }
  translate <0,-tablethickness/2,0>
}
