/*
    Use in the following way:
    
      object { cardfan (NumCards, Degrees, Radius }
    
    NumCards: The number of tarot cards to use (<= 21)
    Degrees: The angle of the arc swept
    Radius: The radius of the arc
    
*/



#include "tarot/TarotCard.inc"  

#declare NumTarotCards = 21;
#declare CardFaces = array[NumTarotCards] {
   "tarot/blindwithswords.png",
   "tarot/death.png",
   "tarot/hermit.png",
   "tarot/hierophant.png",
   "tarot/highpriestess.png",
   "tarot/judgement.png",
   "tarot/justice.png",
   "tarot/kingofswords.png",
   "tarot/kingofwands.png",
   "tarot/knightofcups.png",
   "tarot/knightofpentacles.png",
   "tarot/knightofswords.png",
   "tarot/knightofwands.png",
   "tarot/lovers.png",
   "tarot/magician.png",
   "tarot/pageofcups.png",
   "tarot/queenofpentacles.png",
   "tarot/queenofswords.png",
   "tarot/swordsinback.png",
   "tarot/wheeloffortune.png",
   "tarot/world.png"
};




#macro CardFan(NumCards, Degrees, Radius)
union{
 #local Nr = 0;     // start
 #local EndNr = NumCards; // end
 #while (Nr < EndNr) 
   object{TarotCard(CardFaces[Nr])
   translate <-3.5, -6, 0>
   rotate 180*y
   rotate <-90, -90, 0>
   translate <-Radius, Nr*0.01, 0>
   rotate <0, Nr * Degrees/(EndNr - 1), 0>} 

 #local Nr = Nr + 1;    // next Nr
 #end // ---------------  end of loop 
} // end of union
#end