/*   

  This file is meant to be included in a main .pov file.
  
  It creates a tarot card, given a filename for 
  the image map.

*/

#include "roundbox.inc"


#macro TarotCard(Filename)             
  // create a box that extends between the 2 specified points
  object {
    RoundBox (<0, 0, 0>, < 1,  1,  1>, 0.05)
    pigment {
      image_map {
        png Filename
        map_type 0 
        once
      }        
    }  
    finish { ambient 0.5 phong 0.2 specular 0.2 roughness 0.01 }
    scale <7,12,0.01>
  }                         
#end