// various (mostly layered) wood textures
// T_Wood1 - T_Wood35
#include "woods.inc" 
#include "textures.inc"


#version 3.5;
global_settings {  
  //assumed_gamma 1.0 
  charset utf8
 }
          
#macro char(c)
text {
  ttf             // font type (only TrueType format for now)
  "msmincho.ttf",  // Microsoft Windows-format TrueType font file name
  c,      // the string to create
  0.5,              // the extrusion depth
  0               // inter-character spacing  
  texture { New_Penny }
  texture { 
    pigment { color rgbf <1,1,0.5,0.9> }
    finish { phong 1 } 
  }              
  rotate -45*y
  translate <-0.4,-0.2,-0.2>
}
#end           

#declare aries       = char("\u2648")
#declare taurus      = char("\u2649")
#declare gemini      = char("\u264A")
#declare cancer      = char("\u264B")
#declare leo         = char("\u264C")
#declare virgo       = char("\u264D")
#declare libra       = char("\u264E")
#declare scorpio     = char("\u264F")
#declare sagittarius = char("\u2650")
#declare capricorn   = char("\u2651")
#declare aquarius    = char("\u2652")
#declare pisces      = char("\u2652")

#macro charlight(n,d,p)
  // create a regular point light source
  light_source {
    <0,0,0>                  // light's position (translated below)
    color rgb <1,1,1>    // light's color
    // light_source { ...
    // put this inside a light_source to add light fading
    // light_source { ...
    // put this inside a light_source to give it a visible appearance
    looks_like { object { n } }
    fade_distance d
    fade_power p         
  }
#end

  



