/*
 * All textures used by more than one object is here
 *
 */

#include "functions.inc" 

#declare concrete_texture=
   	texture {
		pigment { color rgb <0.6, 0.6, 0.6> }
 		normal { bumps 0.05 }  
 		finish { //F_MetalA
 			//ambient 0.0
 		 	diffuse 0.7
 			specular 0.01
 			roughness 0.15
 	 	}
   	};


#declare dirtyconcrete_texture=
  	texture { concrete_texture }
  	texture {
   		pigment{
   			bumps
   			noise_generator 3
			scale <0.01,0.01, 1> 
			warp{ turbulence 1}
			pigment_map{
				[0.0 color rgbt 0.2]
				[0.2 color rgbt 0.2]
				[1.0 color rgbt 1.0]
			}
   		}
   	}
  	texture {
   		pigment{
   			bumps
   			noise_generator 3
			scale <0.1,0.1, 1> 
			warp{ turbulence 1}
			pigment_map{
				[0.0 color rgbt 0.2]
				[0.2 color rgbt 0.2]
				[1.0 color rgbt 1.0]
			}
   		}
   	}
  	texture {
   		pigment{
   			bumps
   			noise_generator 3
			scale <0.5,0.5,1>
			warp{ turbulence 1}
			pigment_map{
				[0.0 color rgbt 0.2]
				[0.2 color rgbt 0.2]
				[1.0 color rgbt 1.0]
			}
   		}
   	}
  	texture {
   		pigment{
   			bumps
   			noise_generator 3
			scale <1,1,1>
			warp{ turbulence 1}
			pigment_map{
				[0.0 color rgbt 0.2]
				[0.2 color rgbt 0.2]
				[1.0 color rgbt 1.0]
			}
   		}
   	};


#declare steel_texture= 
texture{
	pigment { color <0.560784, 0.560784, 0.560784 + 0.176471*0.5> }
	finish { 
		//ambient 0.0
		diffuse 0.15
		specular 0.3
		metallic
		roughness 0.15
	}
}
  
#declare window_texture=
 	texture{
 		cells
 		scale 0.01
 		texture_map{
			[0.5 pigment{ rgb 0 } finish{ambient 0 }]
			[0.5 pigment{ rgb<1,1,0.5> } finish{ambient <1,1,0.5>*0.8 }]
		}
 	};
 
#declare glass_texture=
	texture{
		pigment{ rgbf <1,1,1,0.99> }
		finish { 
			diffuse 0.01
			specular 0.3
			roughness 0.001
			//reflection { 0.01 }
		}
	};

