//ImageA79.pov for POV-Ray Megapatch 0.7: Distant Shores IV (c) 2003 Ch. Gerber

#version unofficial MegaPov 0.7;

//--- Control ---

#declare HQ = 1;
#declare Rad_on = 1;
#declare Stars_on = 0; //slows down rendering dramatically
#declare Planet_on = 1;
#declare Stones_on = 1;
#declare Horns_on = 1;

#declare cam_loc = <-100, 15, -150>;
#declare lookat = <0, 40, 0>;
#declare sky_vect = <0, 1, 0>;
#declare planet_dist = 100000;
#declare planet_loc = vaxis_rotate (planet_dist*z, x, -45);
#declare planet_loc = vaxis_rotate (planet_loc, y, 34);
#declare planet_rad = 50000;
#declare light_dist = 200000;
#declare light_loc = vaxis_rotate (light_dist*z, x, -14);
#declare light_loc = vaxis_rotate (light_loc, y, 40);
#declare light_rad = 1000; 

#include "colors.inc"
#include "mytextures.inc"

global_settings {
  assumed_gamma 2.6
  max_trace_level 25
  #if (Rad_on = 1) 
  ini_option "+QR"
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.01
    count 20
    nearest_count 5
    error_bound 0.4
    recursion_limit 1
    low_error_factor 0.5
    gray_threshold 0
    minimum_reuse 0.015
    brightness 1.5
    adc_bailout 0.006
    normal on
  }
  #end
}


//--- Camera  & Lights ---

camera {
  location cam_loc
  direction z
  up sky_vect
  right 4/3*x
  look_at lookat
}

light_source {
  <0,0,0> 
  color rgb 2*<0.75,0.65,0.5>
  translate light_loc
  parallel
  point_at cam_loc
  #if (HQ=1)
   area_light <light_dist/20,0,0>,<0,light_dist/20,0>,5,5
   adaptive 1
   jitter
   orient
  #end 
  media_attenuation on 
  media_interaction on
  groups "main" 
}

light_source {
  <0,0,0> 
  glow { 
    type 1 
    size light_rad*2.5
    color rgb <1,1,0.5>/4
  }
  translate light_loc
  groups "main"
}

#declare flare_brightness = 0.5;
#include "bigstar.flr"
#include "nkflare.inc"

light_source { //fill in land
  -500*z
  color rgb <0.525,0.4,0.45>/1.5
  shadowless 
  media_attenuation off 
  media_interaction off
  rotate <30,0,0>
  groups "main"
}

light_source { //fill in planet
  <0,0,0> 
  color rgb 2*<0.75,0.65,0.5>
  translate light_dist*z rotate <2,40,0>
  parallel point_at planet_loc
  media_attenuation off 
  media_interaction off 
  groups "planet"
}

fog {
  fog_type 2 
  distance 1000
  rgb <1,0.75,0.45>*0.75
  fog_offset 0
  fog_alt 30
}


//--- Planet ---

#if (Planet_on = 1)

#declare Atmosphere =  material {
  texture {pigment {rgbt 1}}
  interior {
    media {
      method 3
      intervals 1
      #if (HQ=1) samples 25,25 #else samples 5,5 #end
      scattering {2, rgb 0.00025 extinction 0.5}
      density {
        spherical
        color_map {
          [0.0 rgb 0]
          [0.2 rgb 0.05*<1, 0.8, 0.5>]
          [1.0 rgb 0.05*<1, 0.8, 0.5>]
        }
      }
    }
  }
  scale 0.8
}

#declare PlanetAtmosphere = sphere {0, 1 material {Atmosphere} scale 1.015/0.8 hollow }
#declare PlanetSphere = sphere {0, 1 texture {PlanetSurface}}

#declare Planet = union {
  object {PlanetSphere}
  object {PlanetAtmosphere scale 1.05}
}

object {Planet scale 50000 rotate <-30, 0, -30> translate planet_loc light_group "all"}

#end //Planet_on


//--- Stars ---

#declare galaxy_distance = 300000;

#if (Stars_on = 1)

#declare star_count = 10000;
#declare star_type = 1;
#declare star_scale = 0.3;
#declare star_distribution = 0.25;
#declare star_color = color rgb 1;
#declare star_color_turb = 0.75;
#include "galaxy.sf"

#end //Stars_on

#declare galaxy_color1 = <1.1, 1.1, 1.0>;
#declare galaxy_color2 = <1.1, 1.0, 0.4>;
#declare galaxy_color3 = <1.1, 0.6, 0.2>;
#declare galaxy_intensity = 0.7;
#declare galaxy_cluster_name = ""
#declare galaxy_declare_only = false;
#declare galaxy_bgnebula = 5;
#declare galaxy_bgstars = 1;
#include "GALAXY.BG" 


//--- Beach ---

#declare Beach = height_field {
  tga "Beach.tga" smooth translate <-0.5,0,-0.5>
  scale <500, 10, 500>
  texture {Sand}
  rotate 60*y
}

#declare Hills = height_field {
  tga "hills.tga" smooth translate <-0.5,0,-0.5>
  scale <2000, 100, 2000>
  texture {Sand scale 10}
  translate <250,0,1100>
}

object {Beach light_group "main"}
object {Hills light_group "main"}
plane {y,0 texture {Sand} light_group "main"}      
plane {y,7 hollow material {Water} light_group "main"}
 
#if (Stones_on = 1)

#declare Stone1 = object {#declare Seed = 317; #declare Splits = 4; #declare Rough = 0.2; #include "rock.inc" scale <1,0.5,1>*0.4  texture {Stone}} 
#declare Stone2 = object {#declare Seed = 222; #declare Splits = 3; #declare Rough = 0.2; #include "rock.inc" scale <1,0.5,1>*0.1  texture {Stone}} 
#declare Stone3 = object {#declare Seed = 629; #declare Splits = 3; #declare Rough = 0.2; #include "rock.inc" scale <1,0.5,1>*0.05 texture {Stone}} 

#declare StoneSeed = seed(2001);

#declare Norm = <0,0,0>;
#declare Xpos = -250;
#declare Zpos = -250; 
#declare Pig = pigment {spotted color_map {[0 rgb 1][1 rgb 0]} scale 10 translate <-50,0,250>}
#while (Xpos<250)
  #while (Zpos<250)
    #declare SPos = <Xpos,100,Zpos>;
    #declare PP = eval_pigment(Pig,<Xpos,0,Zpos>);
    #declare XX = PP.x;
    #declare Inter = trace (Beach,SPos,<0,-1,0>,Norm); 
    #if (vlength(Norm) != 0 & XX > 0.65)
      #if (Inter.y > 7.5)
        object {
          Stone1 
          scale <1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5>
          rotate <-20+rand(StoneSeed)*40,rand(StoneSeed)*360,-20+rand(StoneSeed)*40> 
          translate <Inter.x+rand(StoneSeed)*10,Inter.y+0.8,Inter.z+rand(StoneSeed)*10>
          light_group "main"
        }
      #end
    #end 
    #declare Zpos = Zpos + 10;
  #end           
  #declare Zpos = -250;
  #declare Xpos = Xpos + 10; 
#end 

#declare Norm = <0,0,0>;
#declare Xpos = -250;
#declare Zpos = -250; 
#declare Pig = pigment {spotted color_map {[0 rgb 1][1 rgb 0]} scale 10 translate <50,0,-50>}
#while (Xpos<250)
  #while (Zpos<250)
    #declare SPos = <Xpos,100,Zpos>;
    #declare PP = eval_pigment(Pig,<Xpos,0,Zpos>);
    #declare XX = PP.x;
    #declare Inter = trace (Beach,SPos,<0,-1,0>,Norm); 
    #if (vlength(Norm) != 0 & XX > 0.6)
      #if (Inter.y > 7.5)
        #declare R = rand(StoneSeed);
        #switch(R)
          #range (0,1/3)
            object {
              Stone2
              scale <1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5>
              rotate <-20+rand(StoneSeed)*40,rand(StoneSeed)*360,-20+rand(StoneSeed)*40> 
              translate <Inter.x+rand(StoneSeed)*4,Inter.y+0.2,Inter.z+rand(StoneSeed)*4> 
              light_group "main"
            }
          #break
          #range (1/3,1)
            object {
              Stone3
              scale <1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5>
              rotate <-20+rand(StoneSeed)*40,rand(StoneSeed)*360,-20+rand(StoneSeed)*40> 
              translate <Inter.x+rand(StoneSeed)*4,Inter.y+0.1,Inter.z+rand(StoneSeed)*4>
              light_group "main"
            }  
          #break
        #end   
      #end
    #end 
    #declare Zpos = Zpos + 4;
  #end           
  #declare Zpos = -250;
  #declare Xpos = Xpos + 4; 
#end 

#declare Norm = <0,0,0>;
#declare Xpos = -750;
#declare Zpos =  100; 
#declare Pig = pigment {spotted color_map {[0 rgb 1][1 rgb 0]} scale 10 translate <-50,0,250>}
#while (Xpos<1250)
  #while (Zpos<2100)
    #declare SPos = <Xpos,1000,Zpos>;
    #declare PP = eval_pigment(Pig,<Xpos,0,Zpos>);
    #declare XX = PP.x;
    #declare Inter = trace (Hills,SPos,<0,-1,0>,Norm); 
    #if (vlength(Norm) != 0 & XX > 0.65)
      #if (Inter.y > 7.5 & Inter.y < 15 )
        object {
          Stone1 
          scale <1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5,1-rand(StoneSeed)*0.5>
          rotate <-20+rand(StoneSeed)*40,rand(StoneSeed)*360,-20+rand(StoneSeed)*40> 
          translate <Inter.x+rand(StoneSeed)*10,Inter.y+0.8,Inter.z+rand(StoneSeed)*10>
          light_group "main"
        }
      #end
    #end 
    #declare Zpos = Zpos + 10;
  #end           
  #declare Zpos = 100;
  #declare Xpos = Xpos + 10; 
#end 

#end //Stones_on

#if (Horns_on =1)

#include "unihorna.inc"

object {Unihorna scale 3.5 rotate   0*y translate <-70,-4,-100> texture {IridMetal scale 20} light_group "main"}
object {Unihorna scale 3.5 rotate  90*y translate <-35,-4, -80> texture {IridMetal scale 20} light_group "main"}
object {Unihorna scale 3.5 rotate -90*y translate <-55,-4,  50> texture {IridMetal scale 20} light_group "main"}

#declare Norm = <0,0,0>;
#declare Xpos = -750;
#declare Zpos =  100; 
#declare Pig = pigment {spotted color_map {[0 rgb 1][1 rgb 0]} scale 10 translate <-50,0,250>}
#while (Xpos<1250)
  #while (Zpos<2100)
    #declare SPos = <Xpos,1000,Zpos>;
    #declare PP = eval_pigment(Pig,<Xpos,0,Zpos>);
    #declare XX = PP.x;
    #declare Inter = trace (Hills,SPos,<0,-1,0>,Norm); 
    #if (vlength(Norm) != 0 & XX < 0.25)
      #if (Inter.y > 7.5 & Inter.y < 15 )
        object {
          Unihorna scale 3.5 rotate 360*rand(StoneSeed)*y
          translate <Inter.x+rand(StoneSeed)*10,Inter.y-4,Inter.z+rand(StoneSeed)*10>
          texture {IridMetal scale 20}
          light_group "main"
        }
      #end
    #end 
    #declare Zpos = Zpos + 10;
  #end           
  #declare Zpos = 100;
  #declare Xpos = Xpos + 10; 
#end

#end //Horns_on


