
 
#declare Bol = sphere {<0, 0, 0>, .5 }
#declare FanCyl = cylinder { <0, -1, 0>, <0, 0, 0>, 0.5 }
 
 
//TorSplinemacro by Ronald L. Parker
#macro TorusSpline( TorRadius, Points, StartVect )

 #local V=<0,0,0>+StartVect;
 #local Numpoints = dimension_size( Points, 1 );
 #local Cur = 0;

 union {

   #while (Cur < Numpoints-1 )
     #local TSA=Points[Cur];
     #local B=Points[Cur+1];
     #if (V.x=0&V.y=0&V.z=0)
       #local C=Points[Cur+2];
       #if (vlength(vcross(C-TSA,B-TSA))=0)
         #local V=B-TSA;
         #local Cos=0;
         #local Axis=<0,0,0>;
       #else
         #local Axis=vnormalize(vcross((C-TSA),(B-TSA)));
         #local Base1=vnormalize(C-TSA);
         #local Base2=vnormalize(vcross(Axis,Base1));
         #local VB=<0.5*vlength(C-TSA),0,0>;
         #local VA=vcross(VB,z);
         #local VD=.5*<vdot(B-TSA,Base1),vdot(B-TSA,Base2),0>;
         #local VC=vcross(VD,z);
         #local Beta=((VD-VB).y*VA.x-(VD-VB).x*VA.y)/(VC.x*VA.y-VC.y*VA.x);
         #local Center=TSA+VD.x*Base1+VD.y*Base2+Beta*(VC.x*Base1+VC.y*Base2);
         #local Radius=vlength(Center-TSA);
         #local Cos=1;
         #local V=vcross( Axis,Center-TSA );
       #end
       #local B=C;
       #local Cur=Cur+1;
     #else
       #local Axis=vnormalize(vcross((B-TSA),V));
       #local Dir=vnormalize(vcross(V, Axis ));
       #local Cos=vdot(vnormalize(B-TSA), Dir);
       #local Radius=abs(.5*vlength(B-TSA)/Cos);
       #local Center=TSA+Radius*Dir;
     #end
     #local V1=V;

     #if ( Cos & (Axis.x!=0|Axis.y!=0|Axis.z!=0))
       #if (Axis.y = 0 & vlength(<Axis.x,0,Axis.z>) = 0)
         #local RZ=0;
       #else
         #local RZ=-degrees(atan2(vlength(<Axis.x,0,Axis.z>), Axis.y));
       #end
       #if (Axis.z = 0 & Axis.x = 0 )
         #local RY=0;
       #else
         #local RY=-degrees(atan2(Axis.z, Axis.x));
       #end
       #local V1=vcross(B-Center, Axis);

       #if ( vdot(vcross(V,TSA-Center),vcross(V, V1))>0 )
         #local Planes =  union{
           plane{-V, vdot( TSA-.0001*TorRadius*V, vnormalize(-V) ) }
           plane{V1, vdot( .0001*TorRadius*V1+B, vnormalize(V1))}
         }
       #else
         #local Planes =  intersection {
           plane{-V, vdot( TSA-.0001*TorRadius*V, vnormalize(-V) ) }
           plane{V1, vdot( .0001*TorRadius*V1+B, vnormalize(V1))}
         }
       #end

       intersection{
         object {Planes}
         torus{ Radius, TorRadius rotate RZ*z rotate RY*y translate Center }
       }
     #else
       cylinder {TSA-.0001*TorRadius*V, B+.0001*TorRadius*V, TorRadius}
     #end
     #declare Cur=Cur+1;
     #declare V=V1;
   #end
 }
#end
//----------------------------------------------------------
#declare TorusWorm = object {TorusSpline (0.1, array[3]{<0, 0, 0>, <2, 2, 1>, <0.5, 1, 2>}, <1, 0, 0.5>)
  scale <1, 1, 1>
  rotate <0, 0, 0>
  translate <0, 0, 0>
}
 
 
 #declare Worm1 = object {
  TorusWorm
   }
 
#declare TrLink =  object {FanCyl scale <2,1,5> rotate <0,0,90>}
 
#declare Tail =  object {Bol scale <1,3.5,1> }
 
#declare FanWorm =  union {
  object { Tail 
           texture {pigment {color Pink * 1.5 transmit .3}} 
           finish{ambient .4 diffuse .5} 
           normal {granite 1.}
         }
  object { TrLink 
           texture {pigment {color Pink * .5 transmit .9}} 
           finish{ambient .4 diffuse .5} 
           normal {granite 1.}
           scale <1.000, 1.000, 1.000>
           rotate <0, 0, 0>
           rotate <0, 0, 0>
           translate <0.000, 0.000, 0.000>
 } 
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 0, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 16, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 16, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 33, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 33, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 49, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 49, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 65, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 65, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 82, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 82, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 98, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 98, 0>
  translate <0.000, 0.000, 0.000>
 }                                             
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 114, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 114, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 131, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 131, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 147, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 147, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 163, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 163, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 180, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 180, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 196, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 0>
  rotate <0, 196, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 212, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 212, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 228, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 228, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 245, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 245, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 261, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 261, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 277, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 277, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 294, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 294, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 310, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 310, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 326, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 326, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 343, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 343, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 359, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 359, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * 1.49 transmit .3}}finish{ambient .4 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 375, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 375, 0>
  translate <0.000, 0.000, 0.000>
 }
  object { TrLink texture {pigment {color Pink * .5 transmit .9}}finish{ambient .3 diffuse .5}
  normal {granite 1.}
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 392, 0>
  translate <0.000, 0.000, 0.000>
 }
 object { 
 Worm1
  scale <1.000, 1.000, 1.000>
  rotate <0, 0, 1>
  rotate <0, 392, 0>
  translate <0.000, 0.000, 0.000>
 }
 }
 

