 monitor1.pov
ZmZ  8"mY* HGt

4
H
2   mZ 
iTEXTPOV3         Q  F^                         // Persistence of Vision Ray Tracer Scene Description File
// File: monitor1.pov
// Vers: 3.5
// Desc: One monitor readout for "Goodbye to the Cradle"
// Date: 12/23/03
// Auth: Josh English
//
#version 3.5;
#include "colors.inc"
#include "screen.inc"
global_settings {
  assumed_gamma 1.0
  max_trace_level 15
}
// ----------------------------------------
Set_Camera(<0.0, 0, -6.0>, <0.0, 0.0,  0.0>, 90) // set location, look_at and angle
Set_Camera_Aspect(image_width,image_height) // set width in relation to height
Set_Camera_Sky(<0,1,0>) // set the sky vector


//background { rgb <0.7,0.7,0.9> }


// ----------------------------------------

	
	
box { <-50,-3.5,0> <50,50,0.1> 
	pigment { 
		onion
		//rotate -90*x 
		triangle_wave
		frequency 2
		translate 8*x
		#declare cnt = 0;
		pigment_map {
		#while (cnt < 255)
			[ cnt/255 spiral1 1  frequency 6
				color_map {
				  [ 0.0 rgb <0.3,0,0> ]
				  [cnt/255 rgb <0.75,0,0>]
				  //[cnt/255 rgb <0.75,0.85,0>] 
				  [ 1.0 rgb 1 ]}
				turbulence 0.1 octaves 3 lambda 1.1 omega 0.1
				]
			#declare cnt = cnt +255/255;
		#end
		}
		//turbulence 0.1 octaves 3 lambda 1.5
		warp { black_hole <-9,0,0> 15 strength 3 falloff 2}
		}
	finish { ambient 1 } }



#declare MyTextObject =
text {
   ttf "crystal.ttf", "MAGNETOSPHERE DISTORTION", 0.01, <0,0>
   scale 0.1
   pigment {color <0.0,1.5,0.2>}
   finish {ambient 1 diffuse 0}
}

// Place MyTextObject in the right bottom corner
// with spacing 0.04 horizontally and 0.02 vertically.
// Confine object to visible area and scale it by 0.01.
Screen_Object ( MyTextObject, <0,0>, <0.03,0.02>, true, 0.005 )                                                         }                                                                                                                                                                                                                                                   D   @      PRec   @      WKin   @                   0    D   @      PRec   @      WKin   @                   2 `Y     @      *ADep   @      LAEFr   @      AFCl   @     AFFr   @      AIFr   @      AJit   @      <AMet   @     (ASFr   @      AThr   @      DBPCo   @      BThr   @      ZCIma   @      DACh   @      DAni   @      DAnt   @      6DBSl   @      TDCom   @      DFAc   @     "DFRe   @     
DMPE   @       DMPS   @      DMPr   @      DPIm   @     DPre   @      DSAc   @     DSUn   @      hHeig   @      IFTy   @      IPat   
@     0LVer   @      OBSi   @      PIRe   @     8QTSp   @      QTTe   	@      Qual   @      (RINI   @     RUBo   @      bRadi   @      0ULBu   @      nUOBu   @      zUVBu   @      tWidt   @        @     P   7    @                  	    V              >                   @                       2            x   PICT                    a   png                 
            
      
                ?   ?      j        !                            @          }SORT   J  POVR  
    H     &   H          Window PreferencesWindow PreferencesRender Prefs                                                                                                                               