//macros for moonlife

//textures for buildings macro
#declare B_Blue = texture {
  pigment {
    gradient y
    triangle_wave
    color_map {
      [0 rgb <0.2,0.2,0.6>]
      [.7 rgb <0.2,0.2,0.6>]
      [1 Black]
    }
  }
  finish { brilliance 2 specular .2 roughness .00001 }
  scale .5
}

#declare B_Yellow = texture {
  pigment {
    gradient y
    triangle_wave
    color_map {
      [0 rgb <0.4,0.5,0.6>]
      [.7 rgb <0.4,0.5,0.6>]
      [1 Black]
    }
  }
  finish { brilliance 1.5 specular .3 roughness .00001 }
  scale .5
}

#declare B_Dark = texture {
  pigment {
    gradient y
    triangle_wave
    color_map {
      [0 rgb <0.2,0.2,0.2>]
      [.7 rgb <0.2,0.2,0.2>]
      [1 Black]
    }
  }
  finish { specular .4 roughness .0001 }
  scale .5
}

#declare B_Gray = texture {
  pigment {
    gradient y
    triangle_wave
    color_map {
      [0 rgb <0.5,0.5,0.5>]
      [.7 rgb <0.5,0.5,0.5>]
      [1 Black]
    }
  }
  finish { brilliance 1.5 specular .3 roughness .00001 }
  scale .5
}

#declare B_White = texture {
  pigment {
    gradient y
    triangle_wave
    color_map {
      [0 rgb <1,1,1>]
      [.7 rgb <1,1,1>]
      [1 Black]
    }
  }
  finish { brilliance 2 specular .2 roughness .00001 }
  scale .5
}

#declare B_Blueish = texture {
  pigment {
    gradient y
    triangle_wave
    color_map {
      [0 rgb <0.6,0.6,0.8>]
      [.7 rgb <0.6,0.6,0.8>]
      [1 Black]
    }
  }
  finish { brilliance 2 specular .2 roughness .00001 }
  scale .5
}

//makes a cirular spot of buildings
//max recommended buildings: radius x 30
//max recommended heigh: 10
#macro Buildings (Radius,Number,Short,Tall)
   #local RNG = seed(1);
   #local HRange = Tall-Short;
   #local Colors = array[6] { B_Blue,B_Yellow,B_Dark,B_Gray,B_White,B_Blueish }
   #while (Number > 0)
     #local Hght = (HRange*rand(RNG))+Short;
     #local Dist = (Radius*rand(RNG));
     #local Rot = (rand(RNG)*360);
     #local Shape = int(rand(RNG)*4);
     #local Color = int(rand(RNG)*6);
     #switch(Shape)
       #case(0)
         cylinder { <0,0,0>,<0,Hght,0>,Hght/10+1 translate x*Dist rotate y*Rot texture { Colors[Color] } }
       #break
       #case(1)
         box { <-.5,0,-.5>,<.5,Hght,.5> translate x*Dist rotate y*Rot texture { Colors[Color] } }
       #break
       #case(2)
         cylinder { <0,0,0>,<0,Hght,0>,Hght/5+1 translate x*Dist rotate y*Rot texture { Colors[Color] } }
       #break
     #end  
     #local Number = Number-1;
   #end
#end

//makes a crater-like object with given params
//also translates it down to be differenced from the ground.
#macro CraterRim (Radius,Depth)
  difference {
    cone { <0,-Depth,0>,5*Radius,<0,0,0>,Radius }
    sphere { <0,0,0>,Radius scale <1,(Depth/Radius),1> }
    translate y*(Depth/8)
  }
#end

#macro CraterPit (Radius,Depth)
  sphere { <0,0,0>,Radius scale <1,(Depth/Radius),1> pigment { Clear } }
#end
