//----------------------------------------------------------------
// Persistence of Vision Ray Tracer Scene Description File        
// Version: MegaPOV 1.0                                           
// File: gundam.pov                                               
// Date: 12/20/2003                                               
// Author: Paolo Brasolin                                         
// EMail: pbrasolin@yahoo.it                                      
// Description: My entry for Nov/Dec IRTC (Future)                
//----------------------------------------------------------------

//----------------------------------------------------------------Includes
#include "metals.inc"
#include "woods.inc"
#include "idol.inc"

//----------------------------------------------------------------Settings
global_settings {
  max_trace_level 16
  radiosity { brightness 0.1 }
}

//----------------------------------------------------------------Camera
camera {
  location <17,28,-31>
  look_at <0,9,-4>
  angle 72
}

//----------------------------------------------------------------Ceiling lights
light_source { <   0,250,1000> color rgb 0.05 }
light_source { <   0,250, 800> color rgb 0.05 }
light_source { <   0,250, 600> color rgb 0.05 }
light_source { <   0,250, 400> color rgb 0.05 }
light_source { <   0,250, 200> color rgb 0.05 }
light_source { <   0,250,   0> color rgb 0.05 }
light_source { < 200,250,   0> color rgb 0.05 }
light_source { < 400,250,   0> color rgb 0.05 }
light_source { < 600,250,   0> color rgb 0.05 }
light_source { < 800,250,   0> color rgb 0.05 }
light_source { <1000,250,   0> color rgb 0.05 }

//----------------------------------------------------------------Ceiling
plane {
  y,250 
  texture {
    pigment { color rgb 1 }
    normal { granite 0.1 }
  }
}

//----------------------------------------------------------------Floor
plane {
  y,-120
  texture { 
    pigment {
      checker
      pigment { agate color_map { [0.9 color rgb 1] [1 color rgb 0] } translate -10 }
      pigment { agate color_map { [0.9 color rgb 0] [1 color rgb 1] } translate 10 }
    }
    normal { checker 0.1 }
    scale 30
  }
}

//----------------------------------------------------------------Walls
union {
  plane { x,-200 }
  plane { z,200 }
  box { <200,-120,-200>,<1000,1000,-1000> }
  texture {
    pigment { color rgb 1 }
    normal { granite 0.1 }
  }
}

//----------------------------------------------------------------Skirting-Boards
union {
  box { <-200,-120,198>,<1000,-115,200> }
  box { <-198,-120,200>,<-200,-115,-1000> }
  box { <198,-120,-198>,<1000,-115,-1000> }
  texture { T_Wood2 scale 30 }
}

//----------------------------------------------------------------Cable
union {
  box { <-199,15-120,40>,<-200,30-120,65> }
  cylinder { <-199.5,30-120,52.5>,<-199.5,1000,52.5>,0.5 }
  texture {
    pigment {
      color rgb <1,1,0.95>
    }
    finish {
      phong 1
      phong_size 100
    }
  }
}

//----------------------------------------------------------------Capital
union {
  box { <-16,-2,-16>,<16,0,16> pigment { color rgb 1 } }
  box { <-15,-120,-15>,<15,-2,15> pigment { color rgb 0.75 } }
  texture {
    finish { 
      specular 0.5
      roughness 0.05
      brilliance 0.05
    }
    normal { granite 0.1 }
  }
}

//----------------------------------------------------------------Number
text { 
  ttf "arial.ttf"
  "#37" 1, 0
  scale 10
  translate <-14,-11,-15.5>
  texture { T_Gold_1B }
}

//----------------------------------------------------------------Reliquiary
union {
  box { <14,0,-15>,<15,24,14> }
  box { <-15,0,-14>,<-14,24,15> }
  box { <-14,0,14>,<15,24,15> }
  box { <-15,0,-15>,<14,24,-14> }
  box { <-15,24,-15>,<15,25,15> }
  hollow on
  texture {
    pigment { color rgbf <0.97,0.99,0.98,0.9> }
    finish {
      specular 0.7
      roughness 0.001
      ambient 0
      diffuse 0
      reflection {
        0.05, 0.2
        fresnel on
      }
      conserve_energy
    }
  }
  interior {
    ior 1.5
    fade_power 1
    fade_distance 8
    fade_color <0.97,0.99,0.98>
  }
}

//----------------------------------------------------------------Supports
#declare Support = union {
  union {
    cylinder { <13,0,13>,<13,24,13>,0.5 }
    cylinder { <13,24,13>,<13,25,13>,0.25 }
    cylinder { <13,25,13>,<13,25.25,13>,0.5 }
    cylinder { <13,23,13>,<14,23,13>,0.5 }
    cylinder { <14,23,13>,<15,23,13>,0.25 }
    cylinder { <15,23,13>,<15.25,23,13>,0.5 }
    cylinder { <13,23,13>,<13,23,14>,0.5 }
    cylinder { <13,23,14>,<13,23,15>,0.25 }
    cylinder { <13,23,15>,<13,23,15.25>,0.5 }
    difference {
      cone { <13,23,13>,0.5,<11,21,11>,1.5 }
      cone { <13,23,13>,0.4,<10,20,10>,1.4 }
    }
    texture { T_Chrome_2B }
  }
  
  light_source {
    <11.5,21.5,11.5>
    color rgb 0.2
  
    area_light
    x,y
    4,4
    jitter
    circular
    orient
    
    spotlight             
    point_at <0, 10, 0>   
    radius 20             
    tightness 0           
    falloff 30            
  
    looks_like { sphere { 0,1 pigment { color rgb 1 } finish { ambient 2 } } }
  }
}

object { Support rotate y*0 }
object { Support rotate y*90 }
object { Support rotate y*180 }
object { Support rotate y*270 }

//----------------------------------------------------------------Explanation
union {
  box { <0,0,0>,<12,8,0.2> rotate x*20 }
  box { <0,0,0>,<12,0.2,4> }
  texture {
    pigment { 
      image_map { gif "explanation.gif" } 
      scale <12,8,1>
      rotate x*20
    }
    finish {
      phong 1
      phong_size 100
    }
  }
  rotate y*-8
  translate <1.5,0,-13.5>
}

//----------------------------------------------------------------Laser
#declare beta = 0;

#while (beta <360)

  light_source { <sin(pi/180*beta)*10,0.7,cos(pi/180*beta)*10> color red 1 fade_distance 0.3 fade_power 2 }
  light_source { <sin(pi/180*beta)*10,23.3,cos(pi/180*beta)*10> color red 1 fade_distance 0.3 fade_power 2 }
  
  cylinder {
    <sin(pi/180*beta)*10,0.5,cos(pi/180*beta)*10>, <sin(pi/180*beta)*10,23.5,cos(pi/180*beta)*10>, 0.03
    texture {
      pigment {
        agate
        color_map {
          [0 rgbt <1,0,0,0.89>]
          [1 rgbt <1,0,0,0.99>]
        }
        scale 5
      }
      finish {
        ambient 2
      }
    }
    no_shadow
  }
  
  union {
    cone { <sin(pi/180*beta)*10,0,cos(pi/180*beta)*10>, 1, <sin(pi/180*beta)*10,0.5,cos(pi/180*beta)*10>, 0.5 }
    cone { <sin(pi/180*beta)*10,24,cos(pi/180*beta)*10>, 1, <sin(pi/180*beta)*10,23.5,cos(pi/180*beta)*10>, 0.5 }
    texture { T_Chrome_2B }
  }

#declare beta = beta+45;
#end

//----------------------------------------------------------------Gundam
object {
  Idol
  scale <-1,1,1>
}

//----------------------------------------------------------------End Of File