// Scene: Quantium (IRTC Subject: Future)
//
// Author: Michael Raiford
// 
// Description: In the too distant future a new type of computer has been invented
// The quantum computer. This model is the Quanterion 4000, complete with holographic 
// display, Intel Quantium (tm) processor, and 100TB storage card drive. Shown on the "screen" is POVRay 12.0 for 
// Windows QE, Rendering a Julia Fractal. 

// Some scene settings

// Scale: 1 unit = 1 cm

#declare focal_blur = off;          // Set on to allow for depth-of-field effect

#include "colors.inc"
#include "woods.inc"

global_settings
{
    ambient_light 0
    
    radiosity
    {
        //count 1600
        //nearest_count 10    
        //minimum_reuse 0.005 
    
        //pretrace_start 0.1  
        //pretrace_end 0.002
        brightness 0.25
    }   
}

// Object building "studio"
//plane {y, -4 pigment { checker color rgb 1.0 color rgb 0.5 }}
light_source {
     <-100,100,-100> color 1.0 
     area_light <30, 0, 0>, <0, 30, 0> 100, 100
     circular 
     orient
     adaptive 1
     media_interaction off
     
     
     }

light_source {
     <0,100,-100> color 0.5 
     area_light <30, 0, 0>, <0, 30, 0> 100, 100
     circular 
     orient
     adaptive 1
     media_interaction off
     
     
     }

/*media { 
    scattering { 1 rgb 1.0 
    }
    density {color rgb 0.05}
}*/


//cylinder {<0, 0, 0>, <1000, 0, 0>, 0.1 pigment { color red 1.0 }}
//cylinder {<0, 0, 0>, <0, 1000, 0>, 0.1 pigment { color green 1.0 }}
//cylinder {<0, 0, 0>, <0, 0, 1000>, 0.1 pigment { color blue 1.0 }}

// The camera, a basic perspective camera with focal blur. 

camera {
 location <-33, 3, -63>
 look_at <-20, 10, -25>
 
 #if(focal_blur)
 
    aperture 1/10
    
    blur_samples 20000
    confidence 0.99
    variance 1/10000
    
    focal_point <0, 0, 0>
    
 #end
 
}

/*****************************************************************************/
// Computer label. (Intel Inside Logo), 10x12.29 mm
/*****************************************************************************/

// This is the base of the label.
// It's the intel logo painted onto a brushed aluminum background (slightly off-white)
#declare label_base = 

intersection
{

    box { -.5, .5 
    scale <1,1,0.002>
    
    }
    superellipsoid
    {
    <0.1,0.1>
    pigment { color rgb 1.0 } 
    scale <0.5, 0.5, 1.0>
    }

 
 texture {
 
    material_map
    {
       png "intelinsidemm.png"
       once
       texture {
        normal 
        {
           bumps 0.4
           scale <1.0, 0.001, 0.0001>   
        }
        
        pigment {
            color rgb <1.0, 0.98, 0.92>
        }
       
        finish {
            ambient 0.0
            diffuse 0.8
            specular 1.0
            metallic
            reflection {
                0.5 metallic
            }
        }
       
       }
       texture {
            pigment {
                image_map { 
                    png "intelinside.png"
                }
            }
            finish { ambient 0.3 diffuse 0.8 specular 0.8 roughness 0.01 reflection 0.12}
            scale <1.0, 1.0, 5.0>
        }
    }
    translate <-.5, -.5>
    
 }
}

// This is a clear plexiglass cover on the label. It had a rouned top. 
// This is mostly a realism thing more than anything, but it makes it look
// nice.
#declare label_cover = difference
{
    superellipsoid
    {
    
    <0.1,0.1>
   
    }
    box { <-1.1,-1.1, -1>, <1.1,1.1,1.1> 
        translate z*.05
    }   

    pigment { color rgbt 1.0 }
    finish {
        
        ambient 0 
        diffuse 0 
        reflection { 0.1 0.01 fresnel on }
        specular 1.0
        roughness 0.001
    }
    interior {
        ior 1.5
    }
    
    translate z*0.95
    scale <0.5, 0.5, 1.0>
    
}

// The label itself. Just a union of the two parts
#declare label = union
{
    object { label_base }
    object { label_cover }
    scale <1.0, 1.229, 1>
    
}
/*****************************************************************************/
// The computer (4x16x2cm)
/*****************************************************************************/
#declare seam = difference 
{
        box {<-.01, 0.8, -1>, <.01, 1.5, 1>}
        superellipsoid {<0.1, 0.1>}
}

#declare computer_case = difference 
{
    superellipsoid {<0.1, 0.1>}
    box {<-1.1, -1.1, -1.1>, <1.1, 1.1, -0.8>}
    box {<-0.95, -0.95, -1>, <0.95, 0.95, 0.75>}
    object{ seam translate <-0.85, -0.01, 0> }
    object{ seam translate <0.85, -0.01, 0> }
    #local i = 1;
    
    union
    {
    
    #while( i < 11 )
        
        box {<i * .1, -0.80, 0>, <i * .1 + .05, 0.80, 1.1> }
        
        #declare i = i + 1;
        
    #end
    
    translate x * -0.90
    
    }

    translate z*0.8
    
}



#declare front_bezel = difference
{
        superellipsoid {<0.1, 0.1>}
        box {<-1.1, -1.1, -0.8>, <1.1, 1.1, 1.1>}
        box {<-0.95, -0.95, -0.75>, <0.95, 0.95, 1.1>}
        
        translate z*( 0.8 - 0.01)
}

    
#declare unit_computer_shell= union 
{
    object {computer_case}
    object {front_bezel}


}


#declare computer_shell = merge
{
    #local computer_shell_top = difference
    {
        object { unit_computer_shell }
        box {<-1.1, 1-(.75/2),-1.1>, <1.1, -1.1, 1.9>}
    }
    #local computer_shell_bottom = difference
    {
        object { unit_computer_shell }
        box {<-1.1, -1+(.75/2),-1.1>, <1.1, 1.1, 1.9>}
    }
    
    object{computer_shell_top translate -y * (1.0001-.75/2)}
    object{computer_shell_bottom translate y * (1.0001-.75/2)}

    box { <0, -.2, -.201>, <.8, .2, 0.2> } // Location of the drive (light doesn't shine through)
    
}

#declare card =  object 
{ 
    box { <0,0,0>, <1, 1, 0.01> 
        texture
        {
            material_map { png "PVDiskMap.png"     
                texture
                {
                    pigment { color blue 0.5 }
                    finish { specular 0.2 roughness 0.1 }
                    normal { crackle .5 form <1, 0, 0> scale 0.01 }
                }
 
                texture
                {
                    pigment { image_map {png "pvdisklabel.png" interpolate 4} }
                    finish { specular 0.2 roughness 0.1 }
                    normal { crackle .5 form <1, 0, 0> scale 0.01 }
                }
            }
        }
        translate <-.5, -.5, -0.05>
        scale <0.55, 0.75, 1>         
    }
}

#declare computer_case = union
{
    difference 
    {
        object {computer_shell}
        box { <.1, -.02, -.5> , <.7, .02, 0.15> }
        box { <.6, -.08, -.5> , <.7, -.04, 0.0> }
        sphere { <.4, 0, -.35>, .2 }
        
        // This object needs bounding!!
        bounded_by {
            box { <-1.1, -0.5, -0.5>, <1.1, 0.5, 1.9> }
        }
    }

    object {card rotate z* 180 rotate x*90 translate <0.105+.55/2, -0.05, 0.5-.75/2> }

    light_source { <0, 0, .5> color rgb <0, 0, 1> }    
}


#declare computer = union 
{        
    object { computer_case 
           pigment { color rgb <1.0, 0.95, 0.85>}
           finish { specular 0.2 roughness 0.1 }
           normal { crackle .5 form <1, 0, 0> scale 0.01 }
    }


    box { <.6, -.08, -.2> , <.7, -.04, 0.0> 
            pigment { color rgbf <0.25, 1.0, 0.01, 1.0> }
            finish { reflection 0.15 }
            interior { ior 1.5 }
    }
    
    light_source { <.65, -0.06, -0.1> color rgb <0.25, 1.0, 0.01> fade_power 2 fade_distance 5}
    
    object { label
        scale 0.25
        translate <-.7, 0, -.21>
        }
    
    scale 4
    
   // rotate x*60
}


/*****************************************************************************/
// The projector (1cm3)
/*****************************************************************************/

#declare projector = union
{
    difference
    {
        box { <-1, -1, -1>, <1, 1, 1> }    
        box { <-1, -1, -1.0001>, <1, 1, 1.0001> translate y*1.6 rotate z*30 }    
        cone { <1.0001, 0, 0>, 0.95, <-0.95, 0, 0>, 0 }
        scale 0.5
        pigment { color rgb <1.0, 0.95, 0.85>}
        finish { specular 0.2 roughness 0.1 }
        normal { crackle .5 form <1, 0, 0> scale 0.01 }
    }

    cylinder { <1.0, 0, 0>, <0.95, 0, 0>, .95 
        pigment { color rgbt 1.0 }
        finish { specular 1.0 roughness 0.001 reflection 0.5 }
        interior { ior 1.458 }
        normal { wood 0.1 scale 0.02 rotate y*90 }
        scale 0.5
            
    }
    
    light_source { <0, 0, 0> color rgb <0.5, 0.5, 1.0> fade_power 2 fade_distance 5}
}



/*****************************************************************************/
// The scene, as rendered by our quantum computer
/*****************************************************************************/

#macro scanlines(tx)        
            texture { gradient y 
                scale 0.02
                texture_map
                {
                    [0.0 pigment {color rgbt 1.0}]
                    [0.4 tx]
                    [0.6 tx]
                    [1.0 pigment {color rgbt 1.0}]
                }
           }
#end

#declare scene_geometry = union 
{
    plane {-z, -1 
        #local tex = texture {
            pigment { checker color rgb <1.0, 0.98, 0.85> color rgb <0.5, 0.3, 0.2> scale 0.25 }
            scale 1/0.02
        }
        scanlines(tex)
    }
    
    plane {-x, -1 
        #local tex = texture {
            pigment { checker color rgb <1.0, 0.98, 0.85> color rgb <0.5, 0.3, 0.2> scale 0.25 }
            scale 1/0.02
        }
        scanlines(tex)
    }
    
    plane {y, -1 
        #local tex = texture {
            pigment { checker color rgb <1.0, 0.98, 0.85> color rgb <0.5, 0.3, 0.2> scale 0.25 }
            scale 1/0.02
        }
        scanlines(tex)
    }
    
    
    julia_fractal {
        <0, 0, 0.5, 0>
        max_iteration 10
        #local tex = texture
        {
            pigment { color rgb <1.0, 0, 0> }
            finish { specular 1.0 roughness 0.01 }
        }
        scale 0.5
        scanlines(tex)
    }
    
    
    bounded_by { box {<-1.0001, -1.0001, -1.0001>, <1.0001, 1.0001, 1.0001> }}
    clipped_by {bounded_by}
}

#declare scene = light_group
{
    light_source {<-3, 3, -3> color rgb 1.0 media_interaction off}
    light_source {<1, 3, -3> color rgb 0.5 media_interaction off}
    object { scene_geometry 
        pigment {color rgb 0.0}
        }
}

#declare desk = box {
    <-500, -5, -50>, <0, 0, 0>
    texture {T_Wood1
        finish { reflection 0.1 }
        rotate y * 90
        scale 10
        }
}

/*****************************************************************************/
// The set
/*****************************************************************************/
object {desk translate <-5, 0, -5>}

difference {
    
        box {<-401, -336/2, -801>, <1, 336/2, 0>}
        box {<-400, -333/2, -800>, <0, 333/2, 0>}
        
        pigment{color White}
        finish{ diffuse 0.9 }
        normal { bozo 0.15 
            slope_map
            {
                [0.0 <0,0>      ]   // Flat
                [0.45 <0,1>      ]   // Rise up @ 45 degrees
                [0.5 <0.5, 0.5> ]   // Gentle rise (round off a bit)
                [0.55 <1,0>      ]   // flat
                [1.0 <1,0>      ]   // flat
            }
            scale 0.5
        }
            
    
}

object { computer rotate y*-26 translate <-30, 1.2, -50> }
#declare scene_local = object { scene scale 10 rotate y*-26 translate <-20, 12, -35>}
object { scene_local }
object { projector rotate y*-26 translate <-30, 3.0, -46> }
object { card scale 4 rotate x*90 rotate y*38 translate <-28, 0.04, -53.5> }
#macro make_projector_lights(w, h)

    light_group
    {

    #local i = 0;
    #local j = 0;

    #while( i < h )
        #declare j = 0;
        #while( j < h )
            #local ray = vrotate(<1,0,0>, <0, -26, 0>);
            #local origin = vrotate(<1.0,0,0>, <0, -26, 0>)+<-30, 3.5, -46>;
            #declare ray = vrotate(ray, <0, 180*(i/h)-90, 180*(j/w)-90>);
            #local norm = <0, 0, 0>;
            #local isect = trace( scene_local, origin, ray, norm);
            #if(vlength(norm) > 0)
                #debug "Light Ray Fired\n"
                light_source
                {
                    origin rgb <0.85, 0.98, 1.0>*3 spotlight
                    radius 1.0
                    point_at isect
                    
                }
                
                /*cone
                {
                    origin 0, isect 1.0 pigment { color rgb < 0.85, 0.98, 1.0 > }    
                }*/
                    
            #end
            
            #declare j = j + 1;
        #end
        #declare i = i + 1;
    #end
    }
#end

//make_projector_lights(10,10)