// Persistence of Vision Ray Tracer Scene Description File
// File: alchemy.pov
// Vers: 3.5
// Desc: "Alchemy"
// Date: 4/30/2003
// Auth: J Moore

global_settings {
	max_trace_level 10
	ambient_light 0
	radiosity {
		count 100
		error_bound 1
		pretrace_start 0.08
	   	pretrace_end 0.004
		distance_maximum 0.1
		brightness 1
		normal on
		media on
	}
	photons {count 100000}
}

#include "colors.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"
#include "woods.inc"
#include "skies.inc"
#include "rand.inc"
#include "functions.inc"
#include "transforms.inc"

camera {
	up y
	right 4/3*x
	angle 60
	location <0, 2, -10>
	look_at y*1.5
}

light_source {<0, 3, -3> rgb <1, 1, 0.75> photons {refraction on}}

sky_sphere {S_Cloud1}

#declare t1=texture {T_Glass3 normal {ripples}};
#declare t2=texture {T_Gold_5A normal {ripples}};
//#declare t2=texture {T_Glass1 normal {ripples}};

plane {y, 0
	texture {
		boxed translate <1, 0, 1>
		warp {repeat z*2 flip 1}
		warp {repeat x*2 flip 1}
		texture_map {
			[0 t1]
			[1 t2]
		}
	}
}

#declare m_water=
material {
	texture {
		pigment {rgbf 0.99}
		finish {specular 0.7 roughness 0.02 reflection 0.7}
		normal {wrinkles 0.3 scale 0.2}
	}
	interior {ior 1.2 fade_distance 1 fade_power 2}
}

merge {
	#declare c=0;
	#declare maxc=500;
	#declare sd=seed(0);
	#while (c<maxc)
		sphere {0, 0.02
			scale <1, 1.25, 0.5>
			translate z
			rotate <RRand(0, 360, sd), RRand(0, 360, sd), 0>
		}
		#declare c=c+1;
	#end
	sphere {0, 1}
	material {m_water}
	photons {target refraction on}
	scale 2
	translate y*3
}

blob {
	threshold 0.25
	#declare sd=seed(123);
	#declare m=500;
	#declare c=0;
	#declare dl=1.5;
	#while (c<m)
		sphere {0, 0.1, 1
			scale <RRand(0.75, 1, sd), RRand(0.05, 0.1, sd), RRand(0.75, 1, sd)>
			translate z*RRand(0, dl, sd)
			rotate y*RRand(0, 360, sd)
		}
		#declare c=c+1;
	#end
	material {m_water}
	scale 2
}

