// Persistence of Vision Ray Tracer Scene Description File
// File: ssa.pov
// Vers: 3.5
// Desc: "Some Strings Attached"
// Date: 12/28/2003
// Auth: J Moore

//--------------------------------------------------------

#include "transforms.inc"
#include "shapes.inc"
#include "rand.inc"
#include "functions.inc"
#include "metals.inc"
#include "./puppets/p1.inc"
#include "./puppets/p2.inc"
#include "./puppets/p3.inc"
#include "./puppets/p45.inc"
#include "./puppets/p6.inc"
#include "./puppets/p7.inc"
#include "./puppets/p8.inc"

global_settings {max_trace_level 25}

//--------------------------------------------------------

camera {
	up y
	right 4/3*x
	angle 50
	location <-0.3, 4, -2>
	look_at <-0.2, 3.5, 0>
}

//--------------------------------------------------------
//--------------------------------------------------------
// candle

#declare t_met=
texture {
	pigment {rgb <1, 0.95, 0.9>}
	normal {granite 0.05 scale 0.5}
	finish {diffuse 0.4 specular 1.2 roughness 0.02 reflection {0.5 metallic} brilliance 4 metallic}
}

#declare t_dec=
texture {
	pigment {rgb <1, 0.95, 0.9>*0.1}
	normal {granite 0.05 scale 0.5}
	finish {diffuse 0.4 specular 1.2 roughness 0.02 reflection {0.5 metallic} brilliance 4 metallic}
}

#declare t_ch=
texture {
	gradient y
	texture_map {
		[0 t_met]
		[0.012 t_met]
		[0.012 t_dec]
		[0.035 t_dec]
		[0.035 t_met]
		[0.43 t_met]
		[0.43 t_dec]
		[0.51 t_dec]
		[0.51 t_met]
		[1 t_met]
	}
}

#declare dec1=
union {
	#local ang=10;
	#local c1=0;
	#local c2=1;
	#while (c1<360)
		union {
			difference {
				torus {0.03, 0.007 rotate x*90}
				#if (odd(c2))
					plane {y, 0}
				#else
					plane {-y, 0}
				#end
			}
			sphere {<-0.03, 0, 0>, 0.008}
			sphere {<0.03, 0, 0>, 0.008}
			scale <1, 0.5, 0.25>
			rotate z*15
			#if (odd(c2))
				translate <0, 0.48, 0.2>
			#else
				translate <0, 0.46, 0.201>
			#end
			rotate y*c1
		}
		#local c1=c1+ang;
		#local c2=c2+1;
	#end
	texture {t_met}
}

#declare dec2=
union {
	#local ang=10;
	#local c1=0;
	#local c2=1;
	#while (c1<360)
		union {
			difference {
				torus {0.03, 0.01 rotate x*45}
				#if (odd(c2))
					plane {z, 0}
				#else
					plane {-z, 0}
				#end
			}
			sphere {<-0.03, 0, 0>, 0.011}
			sphere {<0.03, 0, 0>, 0.011}
			scale <1, 0.25, 0.5>
			rotate y*15
			#if (odd(c2))
				translate <0, 0.025, 0.29>
			#else
				translate <0, 0.025, 0.29>
			#end
			rotate y*c1
		}
		#local c1=c1+ang;
		#local c2=c2+1;
	#end
	texture {t_met}
}

#declare ch=
union {
	difference {
		union {
			lathe {
				cubic_spline
				11,
				<0, 0>, <0.3, 0>, <0.3, 0.02>, <0.1, 0.1>, <0.1, 0.2>, <0.2, 0.3>,
				<0.2, 0.5>, <0.225, 0.55>, <0.225, 0.56>, <0, 0.55>, <0, 0.55>
				hollow
			}
			torus {0.2025, 0.045 scale <1, 0.25, 1> translate y*0.555}
		}
		cylinder {y*0.4, y*0.57, 0.18 texture {t_met}}
	}
	object {dec1}
	object {dec2}
	texture {t_ch}
}

#declare drip=
lathe {
	cubic_spline
	8
	<0.02, 0.01>,
	<0, 0>,
	<0.02, 0.01>,
	<0.02, 0.02>,
	<0.01, 0.05>,
	<0.005, 0.09>,
	<0, 0.1>,
	<0.005, 0.09>
	sturm
	translate y*-0.1
}

#declare cshape=
merge {
	difference {
		cone {y*-1, 0.175, y*0.8, 0.15}
		sphere {0, 0.135 scale <1, 0.1, 1> translate y*0.8}
	}
	torus {0.13, 0.02 scale <1, 0.4, 1> translate y*0.8}
	#local sd=seed(11);
	#local step=5;
	#local ang=0;
	#while (ang<360)
		sphere {0, RRand(0.01, 0.02, sd)
			scale <RRand(0.9, 1.2, sd), RRand(0.8, 1, sd), RRand(0.7, 1, sd)>
			translate <0, 0.8, 0.131>
			rotate y*ang
		}
		#declare ang=ang+step;
	#end
	object {drip scale <0.5, 2, 0.5> translate <0, 0.79, -0.152>}
	object {drip scale <0.65, 3, 0.55> translate <0, 0.8, -0.152> rotate y*8}
	object {drip scale <1, 3, 0.7> translate <0, 0.8, -0.152> rotate y*-50}
	object {drip scale <0.65, 1.5, 0.5> translate <0, 0.79, -0.152> rotate y*200}
	object {drip scale <0.65, 1, 0.5> translate <0, 0.79, -0.152> rotate y*130}
	object {drip scale <0.65, 3, 0.55> translate <0, 0.8, -0.152> rotate y*180}
	object {drip scale <1, 3.5, 0.7> translate <0, 0.8, -0.152> rotate y*-185}
	hollow
}

#declare csh=
object {
	cshape
	no_shadow
	double_illuminate
	scale 0.99
	translate y*1.3
	texture {
		pigment {rgb <1, 0.95, 0.9>}
		finish {specular 0.2 roughness 0.3}
	}
}

#declare csi=
object {
	cshape
	hollow
	texture {
		pigment {rgbf <1, 0.95, 0.9, 1>}
	}
	interior {
		ior 1.4
		media {
			method 3
			samples 3, 3
			scattering {2, 0.35}
			absorption <0.5, 0.7, 0.9>
		}
	}
	translate y*1.3
}

#declare cf=
cylinder {y*-1, y*1, 1
	hollow
	pigment {rgbt 1}
	interior {
		media {
			method 1
			intervals 5
			samples 5, 5
			emission rgb 65
			density {
				spherical turbulence 0.3 lambda 8 omega 0.6
				density_map {
					[0 rgb 0]
					[0.1 rgb 0]
					[0.8 rgb 1]
					[1 blue 1]
				}
			}
			density {
				planar
				turbulence 0.1
				scale 1.1
				translate y*-0.6
				density_map {
					[0 rgb <0.9, 0.6, 0.3>]
					[0.3 rgb <1, 0.8, 0.4>]
					[0.55 blue 1]
				}
			}
		}
	}
	clipped_by {plane {-y, 0.1}}
	scale <0.07, 0.5, 0.07>
}

#declare wick=
sphere_sweep {
	linear_spline
	6,
	<0, 2.09, 0>, 0.01,
	<0, 2.09, 0>, 0.01,
	<0, 2.1, 0>, 0.01,
	<-0.01, 2.16, -0.005>, 0.01,
	<0.005, 2.25, 0>, 0.01,
	<0.01, 2.25, -0.005>, 0.01
	no_shadow
	pigment {
		gradient y
		color_map {
			[0 rgb 0.1]
			[0.93 rgb 0.1]
			[1 rgb <1, 0.5, 0.2>*5]
		}
		translate y*1.24
	}
}

#declare candle=
union {
	object {ch}
	object {csh}
	object {csi}
	object {wick}
	light_source {<0, 2.18, 0> rgb <1, 1, 0.75>*0.45
		looks_like {cf}
		fade_distance 7
		fade_power 2
		media_interaction on
		media_attenuation on
	}
}

//--------------------------------------------------------
//crystal ball

#declare cb=
sphere {0, 1
	pigment {rgbf <0.95, 0.96, 0.98, 0.99>}
	finish {
		specular 0.9
		roughness 0.001
		reflection 0.5
		ambient <0.3, 0.3, 0.5>
		conserve_energy
	}
	interior {
		ior 1.5
		fade_distance 1
		fade_power 2
		caustics 0.9
	}
	translate y*2.256
}

#declare arm=
union {
	cylinder {<0, 0.3, 0>, <0, 1, 0>, 0.1 translate x*0.1414}
	cylinder {<0.3414, 0.1, 0>, <1, 0.1, 0>, 0.1}
	sphere {<0, 0.2, 0>, 0.1 rotate z*-45 translate <1, 0.3, 0>}
	intersection {
		torus {0.2, 0.1}
		Wedge(135)
		rotate x*90
		translate <1, 0.3, 0>
	}
	intersection {
		torus {0.2, 0.1}
		Wedge(90)
		rotate x*90
		rotate z*-90
		translate <0.3414, 0.3, 0>
	}
	intersection {
		torus {0.2, 0.1}
		Wedge (75)
		rotate x*-90
		rotate z*90
		translate <0.3414, 1, 0>
	}
	intersection {
		torus {1.1, 0.1}
		Wedge(45)
		rotate x*90
		rotate z*15
		translate y*2.255
	}
	intersection {
		torus {0.2, 0.1}
		Wedge(150)
		rotate x*90
		rotate z*90
		translate <1.126, 1.604, 0>
	}
	sphere {z*0.2, 0.1
		rotate x*90
		rotate z*90
		translate <1.126, 1.604, 0>
	}
}

#declare cbs=
union {
	object {arm}
	object {arm rotate y*90}
	object {arm rotate y*180}
	object {arm rotate y*270}
	
	#local rad1=0.25;
	#local rad2=0.025;
	#local sp=0.1;
	#local minx=0.35;
	#local maxx=0.95;
	#local ang=degrees(asin(0.5*sp/rad1));
	#local c=0;
	#local cx=minx;
	#while (cx<maxx)
		torus {rad1, rad2
			#if (odd(c))
				rotate z*(90+ang)
				clipped_by {plane {z, 0 inverse}}
			#else
				rotate z*(90-ang)
				clipped_by {plane {z, 0}}
			#end
			translate x*cx
			rotate z*90
		}
		#local c=c+1;
		#local cx=cx+sp;
	#end
	texture {t_met}
	rotate y*30
}

//--------------------------------------------------------
//sky

#declare sk=
sphere {0, 1
	hollow
	pigment {rgbt 1}
	interior {
		media {
		method 3
			intervals 1
			samples 10
			scattering {4, <0.8, 0.85, 0.9>*0.003}
			absorption 0.01
			density {rgb 0.5}
		}
	}
	scale <1000, 50, 1000>
}

//--------------------------------------------------------
//ground

#declare gnd=
plane {y, 0
	texture {
		pigment {
			wrinkles scale 0.2 turbulence 0.3 omega 0.9
			color_map {
				[0 rgb <0.9, 0.8, 0.6>]
				[1 rgb <0.7, 0.6, 0.4>]
			}
		}
		normal {wrinkles 1 scale 0.2 turbulence 0.3 omega 0.9}
		finish {specular 0.3 roughness 0.5}
		scale 5
	}
}

//--------------------------------------------------------
//table

#declare t_wood=
texture {
	pigment {
		wood turbulence 0.1
		color_map {
			[0 rgb <0.75, 0.6, 0.3>*0.9]
			[0.5 rgb <0.75, 0.6, 0.3>]
			[0.95 rgb <0.75, 0.6, 0.3>*0.95]
			[1 rgb <0.75, 0.6, 0.3>*0.8]
		}
		scale <0.2, 0.1, 0.2>
		rotate y*85
		translate y*0.125
	}
	finish {specular 0.8 roughness 0.001 reflection {0, 0.2}}
	normal {dents scale <0.2, 0.005, 0.01> turbulence 0.2}
}

#declare t_dirt=
texture {
	pigment {
		wrinkles
		scale 0.2
		color_map {
			[0 rgb <0.7, 0.55, 0.2>*0.5]
			[1 rgb <0.7, 0.55, 0.2>*0.25]
		}
	}
	normal {wrinkles scale 0.2}
}

#declare t_table=
texture {
	wrinkles turbulence 0.1
	scale <0.1, 0.05, 0.05>
	texture_map {
		[0 t_wood scale <10, 20, 20>]
		[0.8 t_wood scale <10, 20, 20>]
		[0.95 t_dirt]
		[1 t_dirt]
	}
}

#declare t_carve= 
texture {
	pigment {
		wood turbulence 0.1
		color_map {
			[0 rgb <0.75, 0.6, 0.3>*0.45]
			[0.5 rgb <0.75, 0.6, 0.3>*0.5]
			[0.95 rgb <0.75, 0.6, 0.3>*0.425]
			[1 rgb <0.75, 0.6, 0.3>*0.4]
		}
		scale <0.2, 0.1, 0.2>
		rotate y*85
		translate y*0.125
	}
	finish {specular 0.8 roughness 0.001}
	normal {dents 0.05 scale <0.2, 0.005, 0.01> turbulence 0.2}
}

#declare table=
difference {
	box {<-3.2, 1.8, 0>, <3.2, 1.9, 5>}
	union {
		text {ttf "dragonw.ttf", "J Moore,", 0.1, 0
			rotate x*90
			scale 0.1
			translate <0.5, 1.9, 1.2>
		}
		text {ttf "dragonw.ttf", "2003", 0.1, 0
			rotate x*90
			scale 0.08
			translate <1.2, 1.9, 1.2>
		}
		texture {t_carve}	
	}
	 texture {t_table}
}

//--------------------------------------------------------
// lightnight bolt & rod

#declare s_lb=
spline {
	linear_spline
	#local lseed=seed(1);
	#local yy=0;
	#local maxy=10;
	#local step=0.1;
	#local dist=0.1;
	#local loc=0;
	#while (yy<maxy)
		#local loc=loc+<RRand(-dist, dist, lseed), step, RRand(-dist, dist, lseed)>;
		yy, loc
		#local yy=yy+step;
	#end
}

#macro lb(yy, maxy, step)
union {
	#while (yy<maxy)
		#local loc1=s_lb(yy, natural_spline);
		sphere {0, 1
			hollow
			pigment {rgbt 1}
			interior {
				media {
					emission 10
					density {
						spherical
						density_map {
							[0 blue 1]
							[0.65 rgb <0.5, 0.5, 1>]
							[0.9 rgb 1]
							[1 rgb 10]
						}
					}
				}
			}
			scale 0.04
			translate loc1
		}
		#local yy=yy+step;
	#end
}
#end

#declare lbolt=
union {
	object {lb(0, 10, 0.01)}
	object {lb(0, 2.25, 0.01) scale 0.5 rotate <-60, 40, 180> translate s_lb(3)}
	object {lb(0, 2.2, 0.01) scale 0.7 rotate <-30, -50, 180> translate s_lb(4.9)}
	object {lb(0, 2.5, 0.01) scale 0.6 rotate <30, -50, 180> translate s_lb(4.8)}
	rotate <-15, 0, -10>
	translate <4, 0, 25>
}

#declare lrod=
union {
	sphere_sweep {
		cubic_spline,
		13,
		<0, -0.5, 0>, 0.03
		<0, -0.5, 0>, 0.03
		<0, 0.1, 0>, 0.03
		<0, 0.4, 0>, 0.02
		<0, 0.45, 0>, 0.025
		<0, 0.5, 0>, 0.02
		<0, 0.66, 0>, 0.02
		<0, 0.7, 0>, 0.025
		<0, 0.74, 0>, 0.02
		<0, 0.9, 0>, 0.015
		<0, 0.95, 0>, 0.02
		<0, 1, 0>, 0
		<0, 1, 0>, 0
		scale 3
	}
	cylinder {x*-1, <-0.02, 1.4, 0>, 0.015 rotate y*60}
	cylinder {x*-1, <-0.02, 1.4, 0>, 0.015 rotate y*180}
	cylinder {x*-1, <-0.02, 1.4, 0>, 0.015 rotate y*300}
	cylinder {x*-1, <-0.02, 2.15, 0>, 0.015 rotate y*60}
	cylinder {x*-1,<-0.02, 2.15, 0>, 0.015 rotate y*180}
	cylinder {x*-1, <-0.02, 2.15, 0>, 0.015 rotate y*300}
	cylinder {<-1, 0, 0>, <-1, 0.001>, 0.1 rotate y*60}
	cylinder {<-1, 0, 0>, <-1, 0.001>, 0.1 rotate y*180}
	cylinder {<-1, 0, 0>, <-1, 0.001>, 0.1 rotate y*300}
	texture {T_Silver_5B}
	scale <0.5, 1, 0.5>
	translate <4.1, 0, 25>
}

//--------------------------------------------------------
//monitor & keyboard

#declare t_kbm=
texture {
	pigment {rgb <0.99, 0.98, 0.92>}
	normal {granite 0.02 scale 0.05}
	finish {
		specular 0.3
		roughness 0.2
		metallic
		ambient 0.2
	}
}

#declare t_light=
texture {
	pigment {rgb <0.5, 1, 0.5>}
	finish {ambient 1 diffuse 0}
}

#declare kb=
union {
	height_field {
		png "kbhf.png" smooth
		water_level 0.01	
		texture {
			pigment {
				image_pattern {png "kblabel.png" once interpolate 2}
				color_map {
					[0 rgb 0]
					[1 rgb <0.99, 0.98, 0.92>*0.95]
				}
				rotate x*90
			}
			normal {granite 0.02 scale 0.05}
			finish {
				specular 0.3
				roughness 0.2
				metallic
				ambient 0.2
			}
		}
		translate <-0.5, 0, -0.5>
		scale <1.5, 0.085, 0.7>
	}
	difference {
		Round_Box_Merge (<-0.77, -0.03, -0.53>, <0.82, 0.07, 0.53>, 0.02)
		union {
			box {<-0.725, 0, -0.44>, <0.225, 1, 0.24>}
			box {<0.47, 0, -0.44>, <0.725, 1, 0.24>}
			box {<0.25, 0, -0.44>, <0.447, 1, -0.29>}
			box {<0.315, 0, -0.43>, <0.385, 1, -0.163>}
			box {<0.25, 0, -0.038>, <0.447, 1, 0.24>}
			box {<-0.725, 0, 0.315>, <-0.66, 1, 0.442>}
			box {<-0.62, 0, 0.315>, <-0.37, 1, 0.442>}
			box {<-0.33, 0, 0.315>, <-0.077, 1, 0.442>}
			box {<-0.032, 0, 0.315>, <0.22, 1, 0.442>}
			box {<0.251, 0, 0.315>, <0.442, 1, 0.442>}
			translate y*0.068
			pigment {rgb 0.02}
		}
		box {<0.47, 0.069, 0.315>, <0.725, 1, 0.442>}
		scale <1, 1, 0.7>
		texture {t_kbm}
	}
	box {<-0.012, 0, -0.005>, <0.012, 0.005, 0.005>
		texture {t_light}
		translate <0.52, 0.069, 0.34>
		scale <1, 1, 0.7>
	}
	box {<-0.012, 0, -0.005>, <0.012, 0.005, 0.005>
		texture {t_light}
		translate <0.6, 0.069, 0.34>
		scale <1, 1, 0.7>
	}
	box {<-0.012, 0, -0.005>, <0.012, 0.005, 0.005>
		texture {t_light}
		translate <0.68, 0.069, 0.34>
		scale <1, 1, 0.7>
	}
	text {
		ttf "crystal.ttf" "Keyboard", 2, 0
		scale 0.04
		rotate x*90
		translate <0.52, 0.07, 0.38>
		scale <1, 1, 0.7>
		pigment {rgb 0.1}
		finish {specular 0.3 roughness 0.3 ambient 0.3}
	}
}

#macro sb (p1, p2, p3, p4, p5, p6, p7, p8)
	union {
		triangle {p1, p2, p3}
		triangle {p3, p4, p2}
		triangle {p1, p2, p6}
		triangle {p1, p5, p6}
		triangle {p1, p3, p7}
		triangle {p1, p5, p7}
		triangle {p2, p4, p8}
		triangle {p2, p6, p8}
		triangle {p3, p4, p8}
		triangle {p3, p7, p8}
		triangle {p5, p6, p7}
		triangle {p7, p8, p6}
	}
#end

#declare mon=
union {
	//front of box
	difference {
		union {
			Round_Box_Merge (<-0.6, -0.6, 0>, <0.6, 0.6, 1>, 0.02)
			sphere {<0.58, -0.58, 0.98>, 0.02}
			sphere {<0.58, 0.58, 0.98>, 0.02}
			sphere {<-0.58, -0.58, 0.98>, 0.02}
			sphere {<-0.58, 0.58, 0.98>, 0.02}

			cylinder {<0.58, -0.58, 0.98>, <0.3, -0.58, 1.5>, 0.02}
			cylinder {<0.58, 0.58, 0.98>, <0.3, 0.4, 1.5>, 0.02}
			cylinder {<-0.58, -0.58, 0.98>, <-0.3, -0.58, 1.5>, 0.02}
			cylinder {<-0.58, 0.58, 0.98>, <-0.3, 0.4, 1.5>, 0.02}
			
			triangle {<0.6, 0.58, 0.98>, <0.6, -0.58, 0.98>, <0.32, 0.4, 1.5>}
			triangle {<0.6, -0.58, 0.98>, <0.32, -0.58, 1.5>, <0.32, 0.4, 1.5>}
			
			triangle {<-0.6, 0.58, 0.98>, <-0.6, -0.58, 0.98>, <-0.32, 0.4, 1.5>}
			triangle {<-0.6, -0.58, 0.98>, <-0.32, -0.58, 1.5>, <-0.32, 0.4, 1.5>}
			
			triangle {<-0.58, 0.6, 0.98>, <0.58, 0.6, 0.98>, <-0.3, 0.42, 1.5>}
			triangle {<0.58, 0.6, 0.98>, <-0.3, 0.42, 1.5>, <0.3, 0.42, 1.5>}
			
			triangle {<-0.58, -0.6, 0.98>, <0.58, -0.6, 0.98>, <-0.3, -0.6, 1.5>}
			triangle {<0.58, -0.6, 0.98>, <-0.3, -0.6, 0.98>, <0.3, -0.6, 1.5>}
			
			scale <1, 1, 0.4>
		}
		Round_Box_Merge (<-0.5, -0.45, -0.1>, <0.5, 0.45, 0.1>, 0.02)
	}

	//screen
	intersection {
		Round_Box_Merge (<-0.499, -0.449, -1>, <0.499, 0.449, 0.1>, 0.02)
		sphere {0, 3 scale <1, 1, 0.3> translate z*0.92}
		#if (yes)
			pigment {
				image_map {png "alchemy.png" interpolate 2 once}
				translate <-0.5, -0.5, 0>
				scale <1, 0.9, 1>
			}
		#else
			pigment {rgb 0.02}
		#end
		finish {
			specular 0.8
			roughness 0.001
			reflection 0.2
			ambient 0.8
		}
	}
	
	//back of box
	cylinder {<-0.5, -0.652, 0.38>, <-0.4, -0.45, 1.2>, 0.02}
	cylinder {<0.5, -0.652, 0.38>, <0.4, -0.45, 1.2>, 0.02}
	cylinder {<-0.5, 0.5, 0.38>, <-0.4, 0.4, 1.2>, 0.02}
	cylinder {<0.5, 0.5, 0.38>, <0.4, 0.4, 1.2>, 0.02}	
	sphere {<-0.4, -0.45, 1.2>, 0.02}
	sphere {<0.4, -0.45, 1.2>, 0.02}
	sphere {<-0.4, 0.4, 1.2>, 0.02}
	sphere {<0.4, 0.4, 1.2>, 0.02}
	cylinder {<-0.4, -0.45, 1.2>, <0.4, -0.45, 1.2>, 0.02}
	cylinder {<-0.4, 0.4, 1.2>, <0.4, 0.4, 1.2>, 0.02}
	cylinder {<-0.4, -0.45, 1.2>, <-0.4, 0.4, 1.2>, 0.02}
	cylinder {<0.4, -0.45, 1.2>, <0.4, 0.4, 1.2>, 0.02}
	Round_Box_Merge (<-0.52, -0.672, 0.02>, <0.52, -0.55, 0.4>, 0.01)
	triangle {<-0.52, -0.652, 0.38>, <-0.52, 0.5, 0.38>, <-0.42, 0.4, 1.2>}
	triangle {<-0.52, -0.652, 0.38>, <-0.42, 0.4, 1.2>, <-0.42, -0.45, 1.2>}
	triangle {<0.52, -0.652, 0.38>, <0.52, 0.5, 0.38>, <0.42, 0.4, 1.2>}
	triangle {<0.52, -0.652, 0.38>, <0.42, 0.4, 1.2>, <0.42, -0.45, 1.2>}
	triangle {<-0.5, -0.672, 0.38>, <0.5, -0.672, 0.38>, <0.4, -0.47, 1.2>}
	triangle {<-0.5, -0.672, 0.38>, <0.4, -0.47, 1.2>, <-0.4, -0.47, 1.2>}
	triangle {<-0.5, 0.52, 0.38>, <0.5, 0.52, 0.38>, <0.4, 0.42, 1.2>}
	triangle {<-0.5, 0.52, 0.38>, <0.4, 0.42, 1.2>, <-0.4, 0.42, 1.2>}
	triangle {<-0.4, -0.45, 1.22>, <-0.4, 0.4, 1.22>, <0.4, 0.4, 1.22>}
	triangle {<-0.4, -0.45, 1.22>, <0.4, -0.45, 1.22>, <0.4, 0.4, 1.22>}
	#local yy=-0.4;
	#local my=0.38;
	#local step=0.02;
	#while (yy<my)
		sb(
			<-0.53, yy, 0.38>, <0.53, yy, 0.38>, <-0.43, yy, 1.2>, <0.43, yy, 1.2>
			<-0.53, yy+step, 0.38>, <0.53, yy+step, 0.38>, <-0.43, yy+step, 1.2>, <0.43, yy+step, 1.2>
		)
		#if (yy+step*2<my)
			object {
				sb(
					<-0.521, yy+step, 0.38>, <0.521, yy+step, 0.38>, <-0.422, yy+step, 1.19>, <0.422, yy+step, 1.19>
					<-0.521, yy+step*2, 0.38>, <0.521, yy+step*2, 0.38>, <-0.422, yy+step*2, 1.19>, <0.422, yy+step*2, 1.19>
				)
				pigment {rgb <0.99, 0.98, 0.92>*0.75}
				normal {granite 0.02 scale 0.05}
				finish {
					specular 0.3
					roughness 0.2
					metallic
					ambient 0.2
				}
			}
		#end
		#local yy=yy+step*2.5;
	#end
	//stand
	sphere {0, 1
		scale <0.3, 0.15, 0.3>
		translate <0, -0.6, 0.4>
	}
	cylinder {<0, -0.6, 0.4>, <0, -0.78, 0.4>, 0.2}
	Round_Box_Merge (<-0.4, -0.8, 0.1>, <0.4, -0.75, 0.8>, 0.02)
	
	
	//buttons
	difference {
		cylinder {<0, 0, 0>, <0, 0, 0.1>, 0.03}
		torus {0.015, 0.003 rotate x*90}
		translate <0.54, -0.51, -0.008>
	}
	box {<-0.01, -0.01, -0.001>, 0.01
		translate <0.47, -0.52, 0>
		texture {t_light}
	}
	sphere {0, 1 scale <0.02, 0.017, 0.004> translate <0, -0.51, 0>}
	sphere {0, 1 scale <0.02, 0.017, 0.004> translate <0.1, -0.51, 0>}
	sphere {0, 1 scale <0.02, 0.017, 0.004> translate <0.2, -0.51, 0>}
	sphere {0, 1 scale <0.02, 0.017, 0.004> translate <-0.1, -0.51, 0>}
	sphere {0, 1 scale <0.02, 0.017, 0.004> translate <-0.2, -0.51, 0>}
	
	//label
	text {
		ttf "crystal.ttf" "ViewMaster 2ooo", 1, 0
		scale 0.038
		translate <-0.52, 0.5, -0.003>
		pigment {rgb 0.1}
		finish {specular 0.3 roughness 0.3 ambient 0.3}
	}	
	
	texture {t_kbm}
	translate <0, 0.8, 0>
	scale <1.3, 1.1, 1.3>
}

//--------------------------------------------------------
//bricks

#macro o_brick(qual)
	#local grad=90;
	#local f_grn=
	function {
		pigment {
			granite
			phase RRand(0, 1, sd)
			color_map {
				[0 rgb 0]
				[1 rgb 0.8]
			}
		}
	}
	#switch (qual)
	#case (1)
		isosurface {
			function {f_rounded_box(x,y,z, 0.01, 0.52, 0.12, 0.2)-f_grn(x*0.5, y, z*0.8).gray*0.05}
			contained_by {box {<-0.6, -0.2, -0.5>, <0.6, 0.2, 0.5>}}
			max_gradient grad
		}
	#break
	#case (2)
		isosurface {
			function {f_rounded_box(x,y,z, 0.01, 0.34, 0.11, 0.2)-f_grn(x*0.5, y, z*0.8).gray*0.05}
			contained_by {box {<-0.4, -0.2, -0.5>, <0.4, 0.2, 0.5>}}
			max_gradient grad
			translate x*-0.15
		}
	#break
	#case (3)
		isosurface {
			function {f_rounded_box(x,y,z, 0.01, 0.08, 0.11, 0.2)-f_grn(x*0.5, y, z*0.8).gray*0.05}
			contained_by {box {<-0.4, -0.2, -0.5>, <0.4, 0.2, 0.5>}}
			max_gradient grad
			translate x*-0.42
		}
	#break
	#case (9)
		box {<-0.55, -0.15, -0.25>, <0.55, 0.15, 0.25>}
	#end
#end

//--------------------------------------------------------
//brick textures

#declare sd=seed(1);
#macro t_brick()
	#local col=RRand(0.3, 0.7, sd);
	pigment {
		wrinkles scale 0.05
		color_map {
			/*[0 rgb col]
			[1 rgb col+0.2]*/
			[0 rgb <col, col*0.8, col*0.8>]
			[1 rgb col+0.2]
		}
	}
	normal {granite 0.3 scale <0.15, 0.06, 0.1>}
	finish {specular 0.2 roughness 0.4}
#end

//--------------------------------------------------------
//pennies

#declare pennyh=
cylinder {0, y*0.06, 0.46
	pigment {
		image_map {png "pennyh.png" interpolate 2}
		rotate x*90
		translate <-0.5, 0.1, -0.5>
	}
	normal {
		bump_map {png "pennyh.png" interpolate 2}
		bump_size 5
		rotate x*90
		translate <-0.5, 0.1, -0.5>
	}
	finish {
		specular 0.6
		roughness 0.1
		reflection 0.05
	}
}

#declare pennyt=
cylinder {0, y*0.06, 0.46
	pigment {
		image_map {png "pennyt.png" interpolate 2}
		rotate x*90
		translate <-0.5, 0.1, -0.5>
	}
	normal {
		bump_map {png "pennyt.png" interpolate 2}
		bump_size 5
		rotate x*90
		translate <-0.5, 0.1, -0.5>
	}
	finish {
		specular 0.6
		roughness 0.1
		reflection 0.05
	}
}

//--------------------------------------------------------
//sky, ground, lightning & computer

light_group {
	//light_source {<-5, 100, 40> rgb <1, 0.9, 0.75>*2.3
	light_source {<75, 100, 60> rgb <1, 0.9, 0.75>*2.6
		media_interaction on
		media_attenuation on
	}
	object {sk}
	object {gnd}
	object {lbolt}
	object {lrod}
	object {kb rotate <-5, 20, 0> translate <2.5, 0.05, 24>}
	object {mon rotate y*20 translate <2.5, 0, 24.5>}
	global_lights
}

sky_sphere {pigment {rgb <0.75, 0.75, 1>}}

//--------------------------------------------------------

#declare t_string=
texture {
	pigment {
		wrinkles
		color_map {
			[0 rgb <0.6, 0.58, 0.55>]
			[1 rgb <0.6, 0.58, 0.55>*0.3]
		}
	}
	normal {wrinkles 0.3}
	finish {specular 0.2 roughness 0.3 diffuse 1 ambient 0.2}
	scale 0.02
}
#declare rad=0.005;		//string radius
#declare isowall=yes;	//use isosurface wall

light_group {
	light_source {<0, 4, 0> rgb <1, 0.6, 0.3> shadowless}

	//--------------------------------------------------------
	//puppets
	
	union {
		object {p1
			scale 1.6
			scale <1, 1, -1>
		}
		sphere_sweep {
			b_spline
			10,
			<0.17, 0.05, -0.1>, rad,
			<0.17, -0.01, -0.1>, rad,
			<0.23, rad, -0.25>, rad,
			<0.3, rad, -0.3>, rad,
			<0.5, rad, -0.4>, rad,
			<0.45, rad, -0.15>, rad,
			<0.35, rad, 0>, rad,
			<0.3, 0.1, 0>, rad
			<0.3, 2, 0>, rad,
			<0.6, 10, 0>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			8,
			<-0.11, 0.05, -0.1>, rad,
			<-0.14, -0.01, -0.1>, rad,
			<-0.2, rad, -0.2>, rad,
			<-0.25, rad, -0.25>, rad,
			<-0.3, rad, -0.2>, rad,
			<-0.35, 0.1, -0.1>, rad,
			<-0.4, 2, -0.06>, rad,
			<-0.4, 10, -0.06>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			8,
			<-0.11, 0.05, -0.53>, rad,
			<-0.11, -0.01, -0.53>, rad,
			<-0.2, rad, -0.7>, rad,
			<-0.25, rad, -0.65>, rad,
			<-0.3, rad, -0.6>, rad,
			<-0.5 0.05, -0.55>, rad,
			<-0.4, 2, -0.5>, rad,
			<-0.4, 10, -0.5>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			9,
			<0.12, 0.05, -0.55>, rad,
			<0.12, 0.05, -0.55>, rad,
			<0.2, -0.01, -0.7>, rad,
			<0.3, rad, -0.6>, rad,
			<0.4, rad, -0.65>, rad,
			<0.45, rad, -0.65>, rad,
			<0.4, 0.1, -0.6>, rad,
			<0.45, 2, -0.6>, rad,
			<0.45, 10, -0.6>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			8,
			<0, 0.57, -0.07>, rad,
			<0, 0.57, -0.07>, rad,
			<0, 0.59, -0.07>, rad,
			<0.05, 0.56, -0.1>, rad,
			<0.07, 0.5, -0.13>, rad,
			<0.1, 0.6, -0.14>, rad,
			<0.1, 2, -0.15>, rad,
			<0.12, 10, -0.17>, rad
			texture {t_string}
		}
		translate <2.4, 1.9, 4.9>
	}
	
	union {
		object {p2 scale 1.4}
		sphere_sweep {
			b_spline
			8,
			<-0.04, 0.1, -0.018>, rad,
			<-0.04, 0.1 -0.018>, rad,
			<0, rad, -0.1>, rad,
			<-0.2, rad, -0.1>, rad,
			<-0.3, rad, -0.3>, rad,
			<-0.4, rad, -0.15>, rad,
			<-0.5, rad, -0.3>, rad,
			<-0.6, rad, -0.4>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			7,
			<0.04, 0.1, -0.018>, rad,
			<0.04, 0.1, -0.018>, rad,
			<-0.1, rad, -0.2>, rad,
			<-0.2, rad, -0.3>, rad
			<-0.4, rad, -0.4>, rad
			<-0.3, rad, -0.45>, rad,
			<-0.5, rad, -0.4>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<-0.17, 0.91, 0.23>, rad,
			<-0.17, 0.91, 0.23>, rad,
			<-0.2, 0.91, 0.23>, rad,
			<-0.2, 0.9, 0.23>, rad,
			<-0.18, 0.5, 0.22>, rad,
			<-0.17, 0.5, 0.21>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<0.17, 0.91, 0.23>, rad,
			<0.17, 0.91, 0.23>, rad,
			<0.2, 0.91, 0.23>, rad,
			<0.2, 0.9, 0.23>, rad,
			<0.21, 0.5, 0.24>, rad,
			<0.19, 0.5, 0.23>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			7,
			<0, 1.02, 0.05>, rad,
			<0, 1.02, 0.05>, rad,
			<0, 1.04, 0.05>, rad,
			<0, 1.03, 0>, rad,
			<0, 0.76, -0.04>, rad
			<0, 0.77, -0.05>, rad
			<0, 0.77, -0.06>, rad
			texture {t_string}
		}
		translate <0, 1.96, -0.6>
		rotate y*50
		translate z*3
	}

	union {
		object {p3
			scale 1.4
			scale <1, 1, -1>
		}
		sphere_sweep {
			b_spline
			5,
			<0, 1.02, -0.1>, rad,
			<0, 1.02, -0.1>, rad,
			<0, 1.1, -0.12>, rad,
			<0, 3, -0.13>, rad,
			<0, 10, -0.13>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			5,
			<0.03, 0.5, -0.15>, rad,
			<0.03, 0.5, -0.15>, rad,
			<0.1, 1, -0.1>, rad,
			<0.02, 3, -0.15>, rad,
			<0.02, 10, -0.15>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<-0.04, 0.03, 0>, rad,
			<-0.04, 0.03, 0>, rad,
			<-0.13, 0.05, 0>,rad,
			<-0.13, 1, 0>, rad,
			<-0.23, 3, 0>, rad,
			<-0.36, 10, 0>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<0.04, 0.03, 0>, rad,
			<0.04, 0.03, 0>, rad,
			<0.13, 0.05, 0>,rad,
			<0.13, 1, 0.05>, rad,
			<0.23, 3, 0>, rad,
			<0.36, 10, 0>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			5,
			<0.07, 0.94, 0.05>, rad,
			<0.07, 0.94, 0.05>, rad,
			<0.1, 1, 0.03>, rad,
			<0.1, 2, 0.03>, rad,
			<0.1, 10, 0.03>, rad
			texture {t_string}
		}
		union {
			sphere {0, 0.03
				scale <3, 0.05, 0.3>
				clipped_by {plane {-x, 0}}
				pigment {rgb 1}
				finish {specular 0.7 roughness 0.001 ambient 0.7}
			}
			cylinder {<-0.04, 0, 0>, <0, 0, 0>, 0.03
				scale <1, 0.052, 0.3>
				pigment {rgb <0.3, 0.05, 0.06>}
				finish {specular 0.3 roughness 0.2}
			}
			translate x*0.07
			rotate <-60, 0, 30>
			translate <0, 1.05, -0.13>
		}
		rotate y*45
		translate <-1.3, 1.9, 2>
	}

	union {
		object {p45
			scale 1.4
			scale <1, 1, -1>
		}
		sphere_sweep {
			b_spline
			6,
			<-0.04, 0.03, 0>, rad,
			<-0.04, 0.03, 0>, rad,
			<-0.13, 0.05, -0.04>,rad,
			<-0.13, 1, -0.05>, rad,
			<-0.23, 3, -0.05>, rad,
			<-0.36, 10, -0.07>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<0.04, 0.03, 0>, rad,
			<0.04, 0.03, 0>, rad,
			<0.13, 0.05, 0>,rad,
			<0.13, 1, -0.05>, rad,
			<0.23, 3, 0>, rad,
			<0.36, 10, 0>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			5,
			<-0.086, 0.94, -0.07>, rad,
			<-0.086, 0.94, -0.07>, rad,
			<-0.086, 0.9, -0.08>, rad,
			<-0.087, 0.65, -0.08>, rad,
			<-0.087, 0.65, -0.08>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			8,
			<0.03, 0.95, -0.04>, rad,
			<0.03, 0.95, -0.04>, rad,
			<0.02, 0.98, -0.05>, rad,
			<-0.02, 1, -0.06>, rad,
			<-0.05, 0.97, -0.1>, rad,
			<-0.05, 0.9, -0.12>, rad,
			<-0.04, 0.76, -0.15>, rad,
			<0, 0.76, -0.2>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			10,
			<0.225, 0.47, 0.11>, rad,
			<0.225, 0.47, 0.11>, rad,
			<0.21, 0.4, 0.14>, rad,
			<0.2, 0.3, 0.2>, rad,
			<0.2, 0.4, 0.25>, rad,
			<0.18, 0.45, 0.25>, rad,
			
			<0.18, 0.5, 0.27>, rad,
			<0.18, 1, 0.27>, rad,
			<0.2, 2, 0.24>, rad,
			<0.2, 19, 0.24>, rad
			texture {t_string}
		}
			
		//----------------------------------------
		sphere_sweep {
			b_spline
			6,
			<0.067, 0.03, 0.54>, rad,
			<0.067, 0.03, 0.54>, rad,
			<-0.023, 0.05, 0.54>,rad,
			<-0.023, 1, 0.54>, rad,
			<-0.123, 3, 0.54>, rad,
			<-0.253, 10, 0.54>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<0.147, 0.03, 0.54>, rad,
			<0.147, 0.03, 0.54>, rad,
			<0.277, 0.05, 0.54>,rad,
			<0.277, 1, 0.54>, rad,
			<0.377, 3, 0.54>, rad,
			<0.467, 10, 0.54>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			5,
			<0.1, 0.91, 0.39>, rad,
			<0.1, 0.91, 0.39>, rad,
			<0.1, 1, 0.34>, rad,
			<0.1, 2, 0.34>, rad,
			<0.1, 10, 0.3>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			5,
			<0.194, 0.49, 0.295>, rad,
			<0.194, 0.49, 0.295>, rad,
			<0.25, 0.48, 0.32>, rad,
			<0.25, 2, 0.35>, rad,
			<0.3, 10, 0.4>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			5,
			<0.155, 0.54, 0.255>, rad,
			<0.155, 0.54, 0.255>, rad,
			<0.08, 0.52, 0.32>, rad,
			<0.04, 2, 0.35>, rad,
			<0, 10, 0.35>, rad
			texture {t_string}
		}
		rotate y*75
		translate <1.2, 1.9, 2>
	}

	union {
		object {p6
			scale 1.4
			scale <-1, 1, -1>
			rotate x*5
		}
		sphere_sweep {
			b_spline
			6,
			<0, 0.44, 0.025>, rad,
			<0, 0.44, 0.025>, rad,
			<0.03, 1, -0.07>, rad,
			<0.05, 2, -0.13>, rad,
			<0.06, 10, -0.18>, rad,
			<0.06, 10, -0.18>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			8,
			<0.33, 0.27, 0.26>, rad,
			<0.33, 0.27, 0.26>, rad,
			<0.34, 0.28, 0.24>, rad,
			<0.35, 0.35, 0.16>, rad,
			<0.37, 1, 0.06>, rad,
			<0.39, 2, -0.05>, rad,
			<0.44, 10, -0.2>, rad,
			<0.44, 10, -0.2>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			7,
			<0.1, 0.1, -0.14>, rad,
			<0.1, 0.1, -0.14>, rad,
			<0.1, 0.12, -0.14>, rad,
			<0.05, 0.5, -0.15>, rad,
			<0, 1, -0.16>, rad,
			<-0.2, 10, -0.2>, rad,
			<-0.2, 10, -0.2>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			7,
			<-0.07, -0.155, -0.265>, rad,
			<-0.07, -0.155, -0.265>, rad,
			<-0.14, -0.175, -0.27>, rad,
			<-0.2, -0.02, -0.27>, rad,
			<-0.3, 1, -0.27>, rad,
			<-0.45, 10, -0.27>, rad,
			<-0.45, 10, -0.27>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			7,
			<0.12, -0.155, -0.23>, rad,
			<0.12, -0.155, -0.23>, rad,
			<0.2, -0.175, -0.27>, rad,
			<0.25, -0.02, -0.27>, rad,
			<0.3, 1, -0.27>, rad,
			<0.45, 10, -0.27>, rad,
			<0.45, 10, -0.27>, rad
			texture {t_string}
		}
		translate <-1, 2.1, 5>
	}

	union {
		object {p7
			scale 1.4
			scale <-1, 1, -1>
		}
		sphere_sweep {
			b_spline
			12,
			<-0.08, 0.05, -0.38>, rad,
			<-0.08, 0.05, -0.38>, rad,
			<-0.08, 0.05, -0.42>, rad,
			<-0.12, 0.04, -0.42>, rad,
			<-0.25, 0.06, -0.4>, rad,
			<-0.3, 0, -0.2>, rad,
			<-0.45, rad, 0>, rad,
			<-0.6, rad, 0.4>, rad,
			<-1.6, rad, 1>, rad,
			<-2, rad, 1.5>, rad,
			<-3, rad, 2>, rad,
			<-4, rad, 3>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			7,
			<-0.24, 0.03, -0.44>, rad,
			<-0.24, 0.03, -0.44>, rad,
			<-0.3, 0.03, -0.3>, rad,
			<-0.5, rad, 0.3>, rad,
			<-1, rad, 0>, rad,
			<-4, rad, 2>, rad,
			<-4, rad, 2>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			13,
			<0.28, 0.02, 0.07>, rad,
			<0.26, 0.02, 0.07>, rad,
			<0.26, 0, 0.07>, rad,
			<0.25, 0.01, 0.2>, rad,
			<0.2, 0.02, 0.26>, rad,
			<0.12, 0.03, 0.28>, rad,
			<0.08, 0.055, 0.3>, rad,
			<0, 0.06, 0.27>, rad,
			<-0.16, 0.08, 0.25>, rad,
			<-0.2, 0, 0.25>, rad,
			<-0.6, rad, 0.8>, rad,
			<-3, rad, 1.6>, rad,
			<-3, rad, 1.6>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			7,
			<-0.135, 0.03, 0.5>, rad,
			<-0.135, 0.03, 0.5>, rad,
			<-0.2, rad, 0.44>, rad,
			<-0.4, rad, 0.6>, rad,
			<-0.5, rad, 1>, rad,
			<-3, rad, 1.8>, rad,
			<-3, rad, 1.8>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			7,
			<0.04, 0.02, 0.515>, rad,
			<0.04, 0.02, 0.515>, rad,
			<0.18, rad, 0.45>, rad,
			<0.12, rad, 0.8>, rad,
			<-0.2, rad, 1>, rad
			<0, rad, 1.5>, rad,
			<0.2, rad, 2>, rad
			texture {t_string}
		}
		rotate y*-140
		translate <-0.8, 1.9, 1.8>
	}

	union {
		object {p8
			scale 1.4
			scale <-1, 1, -1>
			rotate y*5
		}
		sphere_sweep {
			b_spline
			6,
			<-0.03, 0.032, 0>, rad,
			<-0.03, 0.032, 0>, rad,
			<-0.05, 0.032, 0>, rad,
			<-0.1, -0.3, 0>, rad,
			<-0.2, 0.6, 0>, rad,
			<-0.5, 10, 0>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<0.03, 0.032, 0>, rad,
			<0.03, 0.032, 0>, rad,
			<0.05, 0.032, 0>, rad,
			<0.1, -0.3, 0>, rad,
			<0.16, 0.6, 0>, rad,
			<0.4, 10, 0>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			11,
			<-0.15, 0.9, 0>, rad,
			<-0.15, 0.9, 0>, rad,
			<-0.16, 0.9, 0>, rad,
			<-0.2, 0.72, -0.04>, rad,
			<0, 0.8, -0.02>, rad,
			<0.01, 0.83, 0>, rad,
			<-0.09, 0.79, 0.04>, rad,
			<-0.03, 0.8, -0.03>, rad,
			<-0.01, 0.82, -0.01>, rad,
			<-0.01, 1.3, -0.01>, rad,
			<-0.01, 10, -0.02>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<-0.11, 0.4, 0.02>, rad,
			<-0.11, 0.4, 0.02>, rad,
			<-0.13, 0.4, 0.02>, rad,
			<-0.16, 0.2, 0.02>, rad,
			<-0.21, 0.4, 0.02>, rad,
			<-0.5, 10, 0.02>, rad
			texture {t_string}
		}
		sphere_sweep {
			b_spline
			6,
			<0.17, 1.05, 0.02>, rad,
			<0.17, 1.05, 0.02>, rad,
			<0.18, 1.04, 0.02>, rad,
			<0.25, 0.7, 0.02>, rad,
			<0.4, 1.1, 0.02>, rad,
			<0.65, 10, 0.02>, rad
			texture {t_string}
		}
		translate <-2.5, 2.6, 4.8>
	}

	object {cbs scale 0.4 translate <0, 1.9, 3>}
	object {cb scale 0.4 translate <0, 1.9, 3>}

	object {candle scale 0.4 translate <1, 1.9, 4>}
	object {candle scale 0.4 rotate y*180 translate <-1.3, 1.9, 3.8>}
	
	object {table}

	union {
		object {pennyt rotate y*30 translate x*-0.5}
		object {pennyt rotate y*-10 translate <0.5, 0, 0.1>}
		object {pennyh rotate <-7, 10, 2> translate <-0.05, 0.06, -0.6>}
		object {pennyh rotate y*110 translate <-0.4, 0, 1.2>}
		object {pennyt rotate y*0 translate <0.8, 0, -1.5>}
		scale 0.2
		translate <-2.2, 1.9, 3.2>
	}
	
	object {pennyt scale 0.2 rotate y*45 translate <0.6, 1.9, 2>}
	object {pennyh scale 0.2 rotate y*-35 translate <1.6, 2.1, 5.3>}
	object {pennyh scale 0.2 translate <0, 1.9, -0.5> rotate y*55 translate z*3}
	object {pennyt scale 0.2 rotate y*-100 translate <-1.1, 1.9, 4.6>}
	
	//--------------------------------------------------------
	//front wall

	#declare maxc=106;
	#declare pos=array[maxc]
	{
	//brick locations
	//row 1
	<-5.5, 1.55, 5.2>, <-4.4, 1.55, 5.2>, <-3.3, 1.55, 5.2>, <-2.2, 1.55, 5.2>, <-1.1, 1.55, 5.2>,
	<0, 1.55, 5.2>, <1.1, 1.55, 5.2>, <2.2, 1.55, 5.2>, <3.3, 1.55, 5.2>, <4.4, 1.55, 5.2>, <5.5, 1.55, 5.2>,
	//row 2
	<-4.95, 1.85, 5.2>, <-3.85, 1.85, 5.2>, <-2.75, 1.85, 5.2>, <-1.65, 1.85, 5.2>, <-0.55, 1.85, 5.2>,
	<0.55, 1.85, 5.2>, <1.65, 1.85, 5.2>, <2.75, 1.85, 5.2>, <3.85, 1.85, 5.2>, <4.95, 1.85, 5.2>,
	//row 3
	<-5.5, 2.15, 5.2>, <-4.4, 2.15, 5.2>, <-3.3, 2.15, 5.2>, <-2.2, 2.15, 5.2>,
	<2.5, 2.15, 5.2>, <3.3, 2.15, 5.2>, <4.4, 2.15, 5.2>, <5.5, 2.15, 5.2>,
	//row 4
	<-4.95, 2.45, 5.2>, <-3.85, 2.45, 5.2>, <-2.75, 2.45, 5.2>, <-1.65, 2.45, 5.2>, <2.45, 2.45, 5.2>,
	<2.75, 2.45, 5.2>, <3.85, 2.45, 5.2>, <4.95, 2.45, 5.2>,
	//row 5
	<-5.5, 2.75, 5.2>, <-4.4, 2.75, 5.2>, <-3.3, 2.75, 5.2>, <-2.2, 2.75, 5.2>,
	<2.5, 2.75, 5.2>, <3.3, 2.75, 5.2>, <4.4, 2.75, 5.2>, <5.5, 2.75, 5.2>,
	//row 6
	<-4.95, 3.05, 5.2>, <-3.85, 3.05, 5.2>, <-2.75, 3.05, 5.2>, <-1.65, 3.05, 5.2>, <2.45, 3.05, 5.2>,
	<2.75, 3.05, 5.2>, <3.85, 3.05, 5.2>, <4.95, 3.05, 5.2>,
	//row 7
	<-5.5, 3.35, 5.2>, <-4.4, 3.35, 5.2>, <-3.3, 3.35, 5.2>, <-2.2, 3.35, 5.2>,
	<2.5, 3.35, 5.2>, <3.3, 3.35, 5.2>, <4.4, 3.35, 5.2>, <5.5, 3.35, 5.2>,
	//row 8
	<-4.95, 3.65, 5.2>, <-3.85, 3.65, 5.2>, <-2.75, 3.65, 5.2>, <-1.65, 3.65, 5.2>, <2.45, 3.65, 5.2>,
	<2.75, 3.65, 5.2>, <3.85, 3.65, 5.2>, <4.95, 3.65, 5.2>,
	//row 9
	<-5.5, 3.95, 5.2>, <-4.4, 3.95, 5.2>, <-3.3, 3.95, 5.2>, <-2.2, 3.95, 5.2>,
	<2.5, 3.95, 5.2>, <3.3, 3.95, 5.2>, <4.4, 3.95, 5.2>, <5.5, 3.95, 5.2>,
	//row 10
	<-4.95, 4.25, 5.2>, <-3.85, 4.25, 5.2>, <-2.75, 4.25, 5.2>, <-1.65, 4.25, 5.2>, <2.45, 4.25, 5.2>,
	<2.75, 4.25, 5.2>, <3.85, 4.25, 5.2>, <4.95, 4.25, 5.2>,
	//row 11
	<-5.5, 4.55, 5.2>, <-4.4, 4.55, 5.2>, <-3.3, 4.55, 5.2>, <-2.2, 4.55, 5.2>, <-1.1, 4.55, 5.2>,
	<0, 4.55, 5.2>, <1.1, 4.55, 5.2>, <2.2, 4.55, 5.2>, <3.3, 4.55, 5.2>, <4.4, 4.55, 5.2>, <5.5, 4.55, 5.2>,
	//row 12
	<-4.95, 4.85, 5.2>, <-3.85, 4.85, 5.2>, <-2.75, 4.85, 5.2>, <-1.65, 4.85, 5.2>, <-0.55, 4.85, 5.2>,
	<0.55, 4.85, 5.2>, <1.65, 4.85, 5.2>, <2.75, 4.85, 5.2>, <3.85, 4.85, 5.2>, <4.95, 4.85, 5.2>
	}
	#declare typ=array[maxc]
	{
	//brick types
	//row 1
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	//row 2
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	//row 3
	1, 1, 1, 2, 2, 1, 1, 1,
	//row 4
	1, 1, 1, 3, 3, 1, 1, 1,
	//row 5
	1, 1, 1, 2, 2, 1, 1, 1,
	//row 6
	1, 1, 1, 3, 3, 1, 1, 1,
	//row 7
	1, 1, 1, 2, 2, 1, 1, 1,
	//row 8
	1, 1, 1, 3, 3, 1, 1, 1,
	//row 9
	1, 1, 1, 2, 2, 1, 1, 1,
	//row 10
	1, 1, 1, 3, 3, 1, 1, 1,
	//row 11
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	//row 12
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1
	}

	#if (isowall)
		#declare c=0;
		#while (c<maxc)
			object {
				o_brick(typ[c])
				texture {t_brick()}
				translate pos[c]+VRand_In_Box(-0.02, 0.03, sd)
			}
			#declare c=c+1;
		#end
	#end

	//--------------------------------------------------------
	//back walls
	difference {
		#declare c=0;				//offset counter
		#declare yy=0;				//starting y
		#declare maxy=5;			// max y
		#declare maxx=5;			// max x
		#declare sx=1.1;			// size x + offset
		#declare sy=0.3;			// size y + offset
		#while (yy<maxy)
			#declare xx=-5;
			#if (odd(c))
				#declare xx=xx+sx/2;
			#end
			#while (xx<maxx)
				#if (!isowall)
					object {o_brick(9) translate <xx, yy, 5.2> texture {t_brick()}}
				#end
				object {o_brick(9) translate <xx, yy, -5.2> texture {t_brick()}}
				object {o_brick(9) translate <xx, yy, -5.2> rotate y*90 texture {t_brick()}}
				object {o_brick(9) translate <xx, yy, -5.2> rotate y*-90 texture {t_brick()}}
				#declare xx=xx+sx;
			#end
			#declare yy=yy+sy;
			#declare c=c+1;
		#end
		box {<-2.03, 2, 0>, <2.03, 4.4, 10>}
	}

	//--------------------------------------------------------
	//roof
	box {<-5, 5, -5>, <5, 5.1, 5>
		pigment {
			wrinkles scale 0.3
			color_map {
				[0 rgb 0.6]
				[1 rgb 0.7]
			}
		}
	}

	//--------------------------------------------------------
	//window sill
	object {Round_Box_Merge(<-2.1, 2, 4.9>, <2.1, 2.1, 5.9>, 0.05) texture {t_table}}
	object {Round_Box_Merge (<-2.1, 4.35, 4.9>, <2.1, 4.45, 5.4>, 0.05) texture {t_table translate y*4}}

	//--------------------------------------------------------
	//mortar
	difference {
		box {<-5, 0, 5.06>, <5, 5, 5.18>}
		box {<-2.03, 2, 0>, <2.03, 4.4, 10>}
		pigment {rgb <0.95, 0.99, 0.99>}
		normal {granite 0.5 scale 0.05}
		finish {specular 0.2 roughness 0.4}
	}
	
	global_lights
}

//--------------------------------------------------------
//monitor & keyboard reflection

light_group {
	light_source {<0, 3, 3.5> rgb 0.7}
	union {
		object {kb rotate x*-5 translate <0, 1.95, 0>}
		object {mon translate <0, 1.9, 0.5>}
		rotate y*160
		no_image
		no_shadow
		translate z*2.7
	}
	global_lights
}


