/*intervals 3
samples 10,1500
confidence 0.99
variance 1/200
method 3*/

//global_settings{max_trace_level 10}

/*camera {             	
	location <10,0,0>
	look_at <0,0,0>
	sky z
}*/

//sphere{<-5,0,0>,3 pigment{rgb 1} /*finish{ambient 1}*/}
//sphere{<0,0,0>,7 inverse pigment{rgb 1} /*finish{ambient 1}*/}

#declare pos = function(x){(abs(x)+x)/2};

//#declare fogcone = function{pos(atan2( sqrt( x*x + y*y ), z)/pi-0.85)*6};
#declare fogcone = function{pos(-(sqrt(x*x + y*y)+z-1))*1.5}
#declare hollowcone = function{pos(0.01-pow(sqrt(x*x + y*y)+z-1,2))*100}

#declare flare_drift = z*clock;
#declare fire_drift = z*clock*2;
#declare trail_drift = z*clock*4;
//#function 

//#declare flare = density{planar color_map {[0 rgb 0][1 rgb 10]} rotate x*90 translate z*-1};

#declare coretrail = density{
		function{fogcone(x,y,z)}
		translate z*-0.9
		scale <1,1,3>
		scale <10,10,1>
		translate -trail_drift
		warp{turbulence <0,0,1> octaves 1 }
		translate trail_drift
		scale <0.1,0.1,1>
		warp{turbulence 0.2 octaves 1}
		translate z*1.5
	};

#macro redfire(Length)
	#declare whynot = 1.85 + Length - 3;
	density{
		checker
			density{
				checker
					density{cylindrical density_map{[0 function{0}][0.3 function{max(min(-y,1),0)} scale 0.01]} scale 0.8 rotate x*90 scale <0.3,0.3,100> translate z*1.5 translate <-100,-100,-whynot> scale 0.001}
					density{function{hollowcone(x,y,z/(Length/3))} translate <-100,-100,-whynot> scale 0.001}
				scale 1000
				translate <100,100,whynot>
				
				translate <-100,-100,-1.22> 
				scale 0.001
			}	
			density{function{0}}
		scale 1000
		translate <100,100,1.22>
		scale 4
		translate -fire_drift
		warp{turbulence <3,3,1> octaves 1}
		translate fire_drift
		scale 1/4
		warp{black_hole <0,0,1.5>, 2 falloff 2}
		scale<1,1,3>
		translate z*-0.8
	}
#end

	
#macro fireball(TailLength,TailStretch)
#declare RealLength = TailLength / TailStretch;
merge{
	cylinder{z*-0.00001,z*TailLength,1}
	sphere{0,1 scale <1,1,1.1>}
	sphere{<0,0,3>,1}
	hollow true
	pigment{rgbt<1,1,1,1>}
	
	interior{
		media{
			density{
				checker
					density{coretrail translate z*-1 scale 0.001}
					density{
						spherical density_map {
							[0.0 function{0}]
    						[0.15 coretrail scale 1/0.8]
  						}
  						scale 0.8 translate z*-1 scale 0.001
  					}
  				
  				//density_map{[0 density{function{0}}][1 density{function{1}}]}
  				scale 1000
  				translate z*1
  			}
			emission rgb<0.3,0.3,1>*2
			intervals 3
			samples 5,1500
			confidence 0.9999
			variance 1/400
			method 3
		}
		media{
			density{
				checker 
					density{function{0}}
					density{spherical color_map {[0 rgb 1][0.05 rgb 0]} translate <-100,-100,-0.7> scale 0.001}
				scale 1000
				translate <100,100,0.7>
  				scale 1.3
  				translate z*0.4
  				scale <5,5,100>
  				translate -flare_drift
  				warp{turbulence 0.2 octaves 1}
  				translate flare_drift
  				scale <1/5,1/5,1/100>
				//Hope I remember what's going on here
				scale <1.3,1.3,5>
				translate z*3.2
  			}
  			intervals 3
			samples 10,1500
			confidence 0.99
			variance 1/200
			method 3        
			emission rgb<1.3,1.3,10>
		}
			
		media{
			redfire(RealLength)
			emission rgb<1.5,0.7,0.3>*3
			intervals 3
			samples 5,1500
			confidence 0.9999
			variance 1/400
			method 3
		}
	} 	
	translate z*-1
	//rotate y*360*(clock) 	
}
#end

//fireball(3,1)

/*sphere{
	<-1,-1,-1>,2
	pigment{rgb <1,1,1>}
	//finish{ambient 1}
}*/
	