#include "_DEF_simple.pov"

#declare TriOffset = 0.25/(2*sin(60));


#declare Book = union{
	box{
		<0.25,0.3,0.005>
		<-0.25,-0.3,0>
		pigment{rgb <0.3,0.2,0.1>*0.6}
	}
	intersection{
		prism{
			cubic_spline
			-0.23,0.23,8,
			<0.5,-0.5>,
			<0.53,0.05>,
			<0.07,-0.05>,
			<0,0>,
			<0.07,0.05>,
			<0.30,0.04>,
			<0.53,0.05>,
			<0.5,-0.5>
			pigment{
				bumps scale 0.01
				pigment_map{
					[0.4 rgb 0.5]
					[0.4 rgb <0.9,0.9,0.8>]
				}
			}
			rotate z*90
		}
		box{
			<0.4,0.4,0.4>
			<-0.4,-0.4,0>
		}
		plane{
			z,0
			rotate -x*45
			translate y*0.25
			pigment{
				gradient z scale 0.02
				pigment_map{
					[0 rgb 0.5]
					[1 rgb <0.9,0.9,0.8>]
				}
			}
		}
	}
	intersection{
		prism{
			cubic_spline
			-0.23,0.23,8,
			<0.5,-0.5>,
			<0.53,0.05>,
			<0.07,-0.05>,
			<0,0>,
			<0.07,0.05>,
			<0.30,0.04>,
			<0.53,0.05>,
			<0.5,-0.5>
			pigment{
				bumps scale 0.01
				pigment_map{
					[0.4 rgb 0.5]
					[0.4 rgb <0.9,0.9,0.8>]
				}
			}
			rotate z*90
		}
		box{
			<0.4,0.4,0.4>
			<-0.4,-0.4,0>
		}
		plane{
			z,0
			rotate -x*45
			translate y*0.25
			pigment{
				gradient z scale 0.02
				pigment_map{
					[0 rgb 0.5]
					[1 rgb <0.9,0.9,0.8>]
				}
			}
		}
		scale <1,-1,1>
	}
		
}

#declare pedestal = union{
	// base and pillar
	intersection{
		union{
			// base supports
			object{geo_simple_basesegtop_60 rotate z*30 translate x*TriOffset}
			object{geo_simple_basesegtop_60 rotate z*30 translate x*TriOffset rotate z*120}
			object{geo_simple_basesegtop_60 rotate z*30 translate x*TriOffset rotate z*240}
			// pillar sides
			object{geo_simple_side_60 rotate z*30 translate <TriOffset,0,1>}
			object{geo_simple_side_60 rotate z*30 translate <TriOffset,0,1> rotate z*120}
			object{geo_simple_side_60 rotate z*30 translate <TriOffset,0,1> rotate z*240}
			object{geo_simple_side_60 rotate z*30 translate <TriOffset,0,2>}
			object{geo_simple_side_60 rotate z*30 translate <TriOffset,0,2> rotate z*120}
			object{geo_simple_side_60 rotate z*30 translate <TriOffset,0,2> rotate z*240}
			// top support
			object{geo_simple_basesegtop_60 scale <1,1,-1> rotate <0,0,30> translate <TriOffset,0,2.25>}
			scale 0.5
		}
		plane{z,0 rotate y*30 translate z*1.1}
	}
	// angled shelf support layer
	intersection {
		intersection {
			box {
			<-0.45,-0.3,0>
			<0.3,0.3,0.2>
			}
			plane {-x,0 rotate -y*45 translate -x*0.425}

			rotate y*15 translate z*1.03
		}
		plane{z,0 rotate y*30 translate z*1.1}
		plane{-z,0 rotate y*45 rotate x*45 translate <0.1,0.3,0.5>}
		plane{-z,0 rotate y*45 rotate -x*45 translate <0.1,-0.3,0.5>}
		//plane{z,0 rotate <45,45,0> translate <0,0,1>}
	}
	// angled shelf
	box {
		<-0.5,-0.4,0>
		<0.4,0.4,0.06>
		rotate y*30 translate z*1.1
	}
	object{
		Book
		translate z*0.06
		rotate y*30 translate z*1.1
	}
	// shelf ledge
	box {
		<0.3,-0.36,0.05>
		<0.35,0.36,0.125>
		rotate y*30 translate z*1.1
	}
	
	texture{SimpleStone}
}

/*camera{
	location 2
	look_at 0
	sky z
}

light_source{<5,-5,5> rgb 1}
light_source{<5,5,5> rgb 1}
object{pedestal}*/