//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 25 materials and 189 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 02/29/2004    (29.02.2004)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment


// Scene Includes

#include "forest.inc"

// End Scene Includes

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       0.1
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.1
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     200.0
  color <0.917647,0.917647,0.94902,0.0,0.0>
  turbulence   <1.0,1.0,1.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.0
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      30.0
}

camera {  //  Camera StdCam
  location  <      0.000,      -0.001,     100.000>
  sky       <    0.07395,    -0.07388,     0.99452> // Use right handed-system (rotated by 6.00 degrees)!
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    2.06418,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      20.000
  look_at   <      1.000,       1.000,     100.000>
}

//    Other cameras are commented out.
/*
camera {  //  Camera CloseupCam
  location  <    264.160,     309.008,      73.215>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <    384.067,     428.681,      25.710>
}

*/

/*
camera {  //  Camera TopCamera
  location  <      6.227,       9.985,     102.900>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <     11.746,      12.284,      98.529>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <0.714, 0.714, 0.686>*0.7139
  shadowless
  translate  <7.629977, 0.762273, 99.576803>
}

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.886>
  translate  <-306.517386, -0.779596, 408.487684>
}


//
// ********  MATERIALS  *******
//

#include "baron.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

cylinder { // Bullet04
  <0,0,1>, <0,0,0>, 1 
  material {
    BulletTexture
    translate <0.000000, 0.000000, 0.010000>
  }
  no_shadow
  scale <0.01, 0.01, 6.0>
  rotate <-207.123428, -261.082031, -173.55896>
  translate  <33.097134, 24.200031, 104.125553>
}


cylinder { // Bullet03
  <0,0,1>, <0,0,0>, 1 
  material {
    BulletTexture
    translate <0.000000, 0.000000, 0.010000>
  }
  no_shadow
  scale <0.01, 0.01, 6.0>
  rotate <-33.180973, 80.476387, 0.0>
  translate  <21.522516, 17.535957, 101.891445>
}


cylinder { // Bullet02
  <0,0,1>, <0,0,0>, 1 
  material {
    BulletTexture
    translate <0.000000, 0.000000, 0.010000>
  }
  no_shadow
  scale <0.01, 0.01, 6.0>
  rotate <-207.123428, -261.082031, -173.55896>
  translate  <6.052761, 5.81992, 98.890423>
}


cylinder { // Bullet01
  <0,0,1>, <0,0,0>, 1 
  material {
    BulletTexture
    translate <0.000000, 0.000000, 0.010000>
  }
  no_shadow
  scale <0.01, 0.01, 6.0>
  rotate <-33.180973, 80.476387, 0.0>
  translate  <5.860084, 9.310115, 98.271893>
}


#include "manfred.inc"

#declare Default_Object1_Ref = object {
  Default_Object1
  material {
    BrownLeather
  }
}
#declare Default_Object2_Ref = object {
  Default_Object2
  material {
    EyeTexture
  }
}
#declare Default_Object3_Ref = object {
  Default_Object3
  material {
    EyeTexture
  }
}
#declare Default_Object4_Ref = object {
  Default_Object4
  material {
    DarkLeather
  }
}
#declare Default_Object5_Ref = object {
  Default_Object5
  material {
    DarkLeather
  }
}
#declare Default_Object6_Ref = object {
  Default_Object6
  material {
    DarkLeather
  }
}
#declare Default_Object7_Ref = object {
  Default_Object7
  material {
    SkinTexture
  }
}
#declare Default_Object8_Ref = object {
  Default_Object8
  material {
    DarkLeather
  }
}
#declare Default_Object9_Ref = object {
  Default_Object9
  material {
    DarkLeather
  }
}
#declare Default_Object10_Ref = object {
  Default_Object10
  material {
    DarkLeather
  }
}
#declare Manfred = union {
  object { Default_Object1_Ref }
  object { Default_Object2_Ref }
  object { Default_Object3_Ref }
  object { Default_Object4_Ref }
  object { Default_Object5_Ref }
  object { Default_Object6_Ref }
  object { Default_Object7_Ref }
  object { Default_Object8_Ref }
  object { Default_Object9_Ref }
  object { Default_Object10_Ref }
  scale 0.014
  rotate <14.842746, 0.0, -90.0>
  translate  <2.13, 0.015054, 1.1724>
}
#include "spandau.inc"

#declare Body_Object1_Ref = object {
  Body_Object1
}
#declare Barrel_Object2_Ref = object {
  Barrel_Object2
}
#declare Barrel_Object3_Ref = object {
  Barrel_Object3
}
#declare Barrel_Object4_Ref = object {
  Barrel_Object4
}
#declare Barrel_Object5_Ref = object {
  Barrel_Object5
}
#declare Barrel_Object6_Ref = object {
  Barrel_Object6
}
#declare Barrel_Object7_Ref = object {
  Barrel_Object7
}
#declare Barrel_Object8_Ref = object {
  Barrel_Object8
}
#declare Detail_Object9_Ref = object {
  Detail_Object9
}
#declare Detail_Object10_Ref = object {
  Detail_Object10
}
#declare Detail_Object11_Ref = object {
  Detail_Object11
}
#declare Detail_Object12_Ref = object {
  Detail_Object12
}
#declare Detail_Object13_Ref = object {
  Detail_Object13
}
#declare Detail_Object14_Ref = object {
  Detail_Object14
}
#declare Detail_Object15_Ref = object {
  Detail_Object15
}
#declare Detail_Object16_Ref = object {
  Detail_Object16
}
#declare Detail_Object17_Ref = object {
  Detail_Object17
}
#declare Detail_Object18_Ref = object {
  Detail_Object18
}
#declare Detail_Object19_Ref = object {
  Detail_Object19
}
#declare Detail_Object20_Ref = object {
  Detail_Object20
}
#declare Detail_Object21_Ref = object {
  Detail_Object21
}
#declare Body_Object22_Ref = object {
  Body_Object22
}
#declare Ammunition_Object23_Ref = object {
  Ammunition_Object23
}
#declare Ammunition_Object24_Ref = object {
  Ammunition_Object24
}
#declare Ammunition_Object25_Ref = object {
  Ammunition_Object25
}
#declare Ammunition_Object26_Ref = object {
  Ammunition_Object26
}
#declare Ammunition_Object27_Ref = object {
  Ammunition_Object27
}
#declare Ammunition_Object28_Ref = object {
  Ammunition_Object28
}
#declare Ammunition_Object29_Ref = object {
  Ammunition_Object29
}
#declare Body_Object30_Ref = object {
  Body_Object30
}
#declare Barrel_Object31_Ref = object {
  Barrel_Object31
}
#declare Detail_Object32_Ref = object {
  Detail_Object32
}
#declare Body_Object33_Ref = object {
  Body_Object33
}
#declare Detail_Object34_Ref = object {
  Detail_Object34
}
#declare Detail_Object35_Ref = object {
  Detail_Object35
}
#declare Barrel_Object36_Ref = object {
  Barrel_Object36
}
#declare Body_Object37_Ref = object {
  Body_Object37
}
#declare Spandau1 = union {
  object { Body_Object1_Ref }
  object { Barrel_Object2_Ref }
  object { Barrel_Object3_Ref }
  object { Barrel_Object4_Ref }
  object { Barrel_Object5_Ref }
  object { Barrel_Object6_Ref }
  object { Barrel_Object7_Ref }
  object { Barrel_Object8_Ref }
  object { Detail_Object9_Ref }
  object { Detail_Object10_Ref }
  object { Detail_Object11_Ref }
  object { Detail_Object12_Ref }
  object { Detail_Object13_Ref }
  object { Detail_Object14_Ref }
  object { Detail_Object15_Ref }
  object { Detail_Object16_Ref }
  object { Detail_Object17_Ref }
  object { Detail_Object18_Ref }
  object { Detail_Object19_Ref }
  object { Detail_Object20_Ref }
  object { Detail_Object21_Ref }
  object { Body_Object22_Ref }
  object { Ammunition_Object23_Ref }
  object { Ammunition_Object24_Ref }
  object { Ammunition_Object25_Ref }
  object { Ammunition_Object26_Ref }
  object { Ammunition_Object27_Ref }
  object { Ammunition_Object28_Ref }
  object { Ammunition_Object29_Ref }
  object { Body_Object30_Ref }
  object { Barrel_Object31_Ref }
  object { Detail_Object32_Ref }
  object { Body_Object33_Ref }
  object { Detail_Object34_Ref }
  object { Detail_Object35_Ref }
  object { Barrel_Object36_Ref }
  object { Body_Object37_Ref }
  material {
    GunMetal
  }
  scale 0.0015
  rotate -180.0*z
  translate  <1.417041, -0.13, 1.0>
}
#declare Body_Object2_Ref = object {
  Body_Object1
}
#declare Barrel_Object9_Ref = object {
  Barrel_Object2
}
#declare Barrel_Object10_Ref = object {
  Barrel_Object3
}
#declare Barrel_Object11_Ref = object {
  Barrel_Object4
}
#declare Barrel_Object12_Ref = object {
  Barrel_Object5
}
#declare Barrel_Object13_Ref = object {
  Barrel_Object6
}
#declare Barrel_Object14_Ref = object {
  Barrel_Object7
}
#declare Barrel_Object15_Ref = object {
  Barrel_Object8
}
#declare Detail_Object22_Ref = object {
  Detail_Object9
}
#declare Detail_Object23_Ref = object {
  Detail_Object10
}
#declare Detail_Object24_Ref = object {
  Detail_Object11
}
#declare Detail_Object25_Ref = object {
  Detail_Object12
}
#declare Detail_Object26_Ref = object {
  Detail_Object13
}
#declare Detail_Object27_Ref = object {
  Detail_Object14
}
#declare Detail_Object28_Ref = object {
  Detail_Object15
}
#declare Detail_Object29_Ref = object {
  Detail_Object16
}
#declare Detail_Object30_Ref = object {
  Detail_Object17
}
#declare Detail_Object31_Ref = object {
  Detail_Object18
}
#declare Detail_Object33_Ref = object {
  Detail_Object19
}
#declare Detail_Object36_Ref = object {
  Detail_Object20
}
#declare Detail_Object37_Ref = object {
  Detail_Object21
}
#declare Body_Object23_Ref = object {
  Body_Object22
}
#declare Ammunition_Object30_Ref = object {
  Ammunition_Object23
}
#declare Ammunition_Object31_Ref = object {
  Ammunition_Object24
}
#declare Ammunition_Object32_Ref = object {
  Ammunition_Object25
}
#declare Ammunition_Object33_Ref = object {
  Ammunition_Object26
}
#declare Ammunition_Object34_Ref = object {
  Ammunition_Object27
}
#declare Ammunition_Object35_Ref = object {
  Ammunition_Object28
}
#declare Ammunition_Object36_Ref = object {
  Ammunition_Object29
}
#declare Body_Object31_Ref = object {
  Body_Object30
}
#declare Barrel_Object32_Ref = object {
  Barrel_Object31
}
#declare Detail_Object38_Ref = object {
  Detail_Object32
}
#declare Body_Object34_Ref = object {
  Body_Object33
}
#declare Detail_Object39_Ref = object {
  Detail_Object34
}
#declare Detail_Object40_Ref = object {
  Detail_Object35
}
#declare Barrel_Object37_Ref = object {
  Barrel_Object36
}
#declare Body_Object38_Ref = object {
  Body_Object37
}
#declare Spandau2 = union {
  object { Body_Object2_Ref }
  object { Barrel_Object9_Ref }
  object { Barrel_Object10_Ref }
  object { Barrel_Object11_Ref }
  object { Barrel_Object12_Ref }
  object { Barrel_Object13_Ref }
  object { Barrel_Object14_Ref }
  object { Barrel_Object15_Ref }
  object { Detail_Object22_Ref }
  object { Detail_Object23_Ref }
  object { Detail_Object24_Ref }
  object { Detail_Object25_Ref }
  object { Detail_Object26_Ref }
  object { Detail_Object27_Ref }
  object { Detail_Object28_Ref }
  object { Detail_Object29_Ref }
  object { Detail_Object30_Ref }
  object { Detail_Object31_Ref }
  object { Detail_Object33_Ref }
  object { Detail_Object36_Ref }
  object { Detail_Object37_Ref }
  object { Body_Object23_Ref }
  object { Ammunition_Object30_Ref }
  object { Ammunition_Object31_Ref }
  object { Ammunition_Object32_Ref }
  object { Ammunition_Object33_Ref }
  object { Ammunition_Object34_Ref }
  object { Ammunition_Object35_Ref }
  object { Ammunition_Object36_Ref }
  object { Body_Object31_Ref }
  object { Barrel_Object32_Ref }
  object { Detail_Object38_Ref }
  object { Body_Object34_Ref }
  object { Detail_Object39_Ref }
  object { Detail_Object40_Ref }
  object { Barrel_Object37_Ref }
  object { Body_Object38_Ref }
  material {
    GunMetal
  }
  scale 0.0015
  rotate -180.0*z
  translate  <1.416774, 0.13, 1.0>
}
#include "fokker.inc"

#declare Lofts_Object1_Ref = object {
  Lofts_Object1
}
#declare Details_Object2_Ref = object {
  Details_Object2
  material {
    BlackRubber
  }
}
#declare Details_Object3_Ref = object {
  Details_Object3
}
#declare Details_Object4_Ref = object {
  Details_Object4
}
#declare Details_Object5_Ref = object {
  Details_Object5
  material {
    BlackRubber
  }
}
#declare Engine_Object6_Ref = object {
  Engine_Object6
  material {
    Chrome_Metal
  }
}
#declare Engine_Object7_Ref = object {
  Engine_Object7
  material {
    Chrome_Metal
  }
}
#declare Lofts_Object8_Ref = object {
  Lofts_Object8
  material {
    FuselageTexture
    scale <4.94031, 1.05, 1.08823>
    rotate 90.0*x
    translate <0.610720, 0.000000, 0.066000>
  }
}
#declare Engine_Object9_Ref = object {
  Engine_Object9
  material {
    Chrome_Metal
  }
}
#declare Engine_Object10_Ref = object {
  Engine_Object10
  material {
    Chrome_Metal
  }
}
#declare Engine_Object11_Ref = object {
  Engine_Object11
  material {
    Chrome_Metal
  }
}
#declare Engine_Object12_Ref = object {
  Engine_Object12
  material {
    Chrome_Metal
  }
}
#declare Lofts_Object13_Ref = object {
  Lofts_Object13
  material {
    RudderTexture
    scale <0.82684, 0.9509, 1.0>
    rotate 90.0*x
    translate <4.930270, 0.000000, 0.558190>
  }
}
#declare Lofts_Object15_Ref = object {
  Lofts_Object15
}
#declare Lofts_Object21_Ref = object {
  Lofts_Object18
}
#declare Lofts_Object23_Ref = object {
  Lofts_Object20
}
#declare Lofts_Object29_Ref = object {
  Lofts_Object21
}
#declare Lofts_Object30_Ref = object {
  Lofts_Object22
}
#declare Lofts_Object31_Ref = object {
  Lofts_Object23
}
#declare Details_Object24_Ref = object {
  Details_Object24
}
#declare Details_Object25_Ref = object {
  Details_Object25
  material {
    GunMetal
  }
}
#declare Lofts_Object32_Ref = object {
  Lofts_Object26
}
#declare Lofts_Object33_Ref = object {
  Lofts_Object27
}
#declare Lofts_Object34_Ref = object {
  Lofts_Object28
}
#declare Lofts_Object35_Ref = object {
  Lofts_Object29
}
#declare Details_Object37_Ref = object {
  Details_Object30
  material {
    DarkLeather
  }
}
#declare Details_Object38_Ref = object {
  Details_Object31
}
#declare Details_Object39_Ref = object {
  Details_Object32
}
#declare Details_Object40_Ref = object {
  Details_Object33
}
#declare Details_Object41_Ref = object {
  Details_Object34
}
#declare Details_Object42_Ref = object {
  Details_Object35
}
#declare Details_Object43_Ref = object {
  Details_Object36
}
#declare Details_Object44_Ref = object {
  Details_Object37
}
#declare Lofts_Object38_Ref = object {
  Lofts_Object38
}
#declare Lofts_Object39_Ref = object {
  Lofts_Object39
}
#declare Lofts_Object42_Ref = object {
  Lofts_Object42
}
#declare Lofts_Object43_Ref = object {
  Lofts_Object43
}
#declare Details_Object45_Ref = object {
  Details_Object44
}
#declare Details_Object46_Ref = object {
  Details_Object45
}
#declare Details_Object47_Ref = object {
  Details_Object46
  material {
    BrownLeather
  }
}
#declare Lofts_Object47_Ref = object {
  Lofts_Object47
}
#declare Lofts_Object48_Ref = object {
  Lofts_Object48
}
#declare Engine_Object49_Ref = object {
  Engine_Object49
  material {
    Chrome_Metal
  }
}
#declare Lofts_Object14_Ref = object {
  Lofts_Object14
}
#declare Lofts_Object20_Ref = object {
  Lofts_Object17
}
#declare Lofts_Object22_Ref = object {
  Lofts_Object19
}
#declare Lofts_Object16_Ref = object {
  Lofts_Object16
}
#declare Lofts_Object40_Ref = object {
  Lofts_Object40
}
#declare Lofts_Object41_Ref = object {
  Lofts_Object41
}
#declare UpperWing = union {
  object { Lofts_Object14_Ref }
  object { Lofts_Object20_Ref }
  object { Lofts_Object22_Ref }
  object { Lofts_Object16_Ref }
  object { Lofts_Object40_Ref }
  object { Lofts_Object41_Ref }
  material {
    WingsTexture
    scale <1.11967, 7.16582, 1.0>
    translate <0.665535, -3.585125, 1.869449>
  }
}
#declare Fokker = union {
  object { Lofts_Object1_Ref }
  object { Details_Object2_Ref }
  object { Details_Object3_Ref }
  object { Details_Object4_Ref }
  object { Details_Object5_Ref }
  object { Engine_Object6_Ref }
  object { Engine_Object7_Ref }
  object { Lofts_Object8_Ref }
  object { Engine_Object9_Ref }
  object { Engine_Object10_Ref }
  object { Engine_Object11_Ref }
  object { Engine_Object12_Ref }
  object { Lofts_Object13_Ref }
  object { Lofts_Object15_Ref }
  object { Lofts_Object21_Ref }
  object { Lofts_Object23_Ref }
  object { Lofts_Object29_Ref }
  object { Lofts_Object30_Ref }
  object { Lofts_Object31_Ref }
  object { Details_Object24_Ref }
  object { Details_Object25_Ref }
  object { Lofts_Object32_Ref }
  object { Lofts_Object33_Ref }
  object { Lofts_Object34_Ref }
  object { Lofts_Object35_Ref }
  object { Details_Object37_Ref }
  object { Details_Object38_Ref }
  object { Details_Object39_Ref }
  object { Details_Object40_Ref }
  object { Details_Object41_Ref }
  object { Details_Object42_Ref }
  object { Details_Object43_Ref }
  object { Details_Object44_Ref }
  object { Lofts_Object38_Ref }
  object { Lofts_Object39_Ref }
  object { Lofts_Object42_Ref }
  object { Lofts_Object43_Ref }
  object { Details_Object45_Ref }
  object { Details_Object46_Ref }
  object { Details_Object47_Ref }
  object { Lofts_Object47_Ref }
  object { Lofts_Object48_Ref }
  object { Engine_Object49_Ref }
  object { UpperWing }
  material {
    DirtyFabric
  }
}
union { // RedBaron
  box { // Radial
    <-1, -1, -1>, <1, 1, 1>
    material {
      RadialMaterial
      scale 2.0
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <0.436935, 0.436935, 0.000364>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.427537, 0.007824, 0.582868>
  }
  box { // Propeller
    <-1, -1, -1>, <1, 1, 1>
    material {
      PropellerMaterial
      scale 2.0
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <1.2, 1.2, 0.001>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.126142, 0.0, 0.583882>
  }
  object { Manfred }
  object { Spandau1 }
  object { Spandau2 }
  cylinder { // Wire04
    <0,0,1>, <0,0,0>, 1 
    material {
      WireTexture
    }
    scale <0.004, 0.004, 1.0>
    rotate <20.97016, -22.681585, 9.934027>
    translate  <1.334504, -0.234753, 0.95759>
  }
  cylinder { // Wire03
    <0,0,1>, <0,0,0>, 1 
    material {
      WireTexture
    }
    scale <0.004, 0.004, 1.0>
    rotate <-30.362724, -12.137619, 11.903341>
    translate  <1.325942, 0.206127, 0.979316>
  }
  cylinder { // Wire02
    <0,0,1>, <0,0,0>, 1 
    material {
      WireTexture
    }
    scale <0.004, 0.004, 1.1>
    rotate <40.787567, 21.938202, 0.944641>
    translate  <0.656416, 0.004057, 1.048705>
  }
  cylinder { // Wire01
    <0,0,1>, <0,0,0>, 1 
    material {
      WireTexture
    }
    scale <0.004, 0.004, 1.1>
    rotate <-44.668285, 14.617787, -10.20118>
    translate  <0.654275, 0.015079, 1.053999>
  }
  object { Fokker }
  rotate <3.0, -14.0, 25.0>
  translate  <8.27, 10.09, 98.6>
}


#include "camel.inc"

#declare Engine_Object1_Ref = object {
  Engine_Object1
  material {
    EngineMaterial
  }
}
#declare Lofts_Object3_Ref = object {
  Lofts_Object2
}
#declare Details_Object6_Ref = object {
  Details_Object3
  material {
    Chrome_Metal
  }
}
#declare Details_Object7_Ref = object {
  Details_Object4
}
#declare Details_Object8_Ref = object {
  Details_Object5
  material {
    BlackRubber
  }
}
#declare Details_Object9_Ref = object {
  Details_Object6
  material {
    Chrome_Metal
  }
}
#declare Details_Object10_Ref = object {
  Details_Object7
  material {
    Chrome_Metal
  }
}
#declare Details_Object11_Ref = object {
  Details_Object8
  material {
    Chrome_Metal
  }
}
#declare Details_Object20_Ref = object {
  Details_Object9
  material {
    Chrome_Metal
  }
}
#declare Details_Object21_Ref = object {
  Details_Object10
  material {
    BlackRubber
  }
}
#declare Details_Object22_Ref = object {
  Details_Object11
}
#declare Lofts_Object12_Ref = object {
  Lofts_Object12
}
#declare Details_Object23_Ref = object {
  Details_Object13
}
#declare Details_Object30_Ref = object {
  Details_Object14
}
#declare Details_Object31_Ref = object {
  Details_Object15
}
#declare Details_Object32_Ref = object {
  Details_Object16
}
#declare Lofts_Object17_Ref = object {
  Lofts_Object17
}
#declare Lofts_Object18_Ref = object {
  Lofts_Object18
}
#declare Lofts_Object19_Ref = object {
  Lofts_Object19
}
#declare Lofts_Object24_Ref = object {
  Lofts_Object20
}
#declare Lofts_Object25_Ref = object {
  Lofts_Object21
}
#declare Details_Object33_Ref = object {
  Details_Object22
}
#declare Details_Object34_Ref = object {
  Details_Object23
}
#declare Details_Object35_Ref = object {
  Details_Object24
}
#declare Details_Object36_Ref = object {
  Details_Object25
}
#declare Lofts_Object26_Ref = object {
  Lofts_Object26
}
#declare Lofts_Object27_Ref = object {
  Lofts_Object27
}
#declare Lofts_Object28_Ref = object {
  Lofts_Object28
}
#declare Engine_Object29_Ref = object {
  Engine_Object29
  material {
    Chrome_Metal
  }
}
#declare Armament_Object30_Ref = object {
  Armament_Object30
  material {
    GunMetal
  }
}
#declare Armament_Object31_Ref = object {
  Armament_Object31
  material {
    GunMetal
  }
}
#declare Armament_Object32_Ref = object {
  Armament_Object32
  material {
    GunMetal
  }
}
#declare Armament_Object33_Ref = object {
  Armament_Object33
  material {
    GunMetal
  }
}
#declare Armament_Object34_Ref = object {
  Armament_Object34
  material {
    GunMetal
  }
}
#declare Armament_Object35_Ref = object {
  Armament_Object35
  material {
    GunMetal
  }
}
#declare Armament_Object36_Ref = object {
  Armament_Object36
  material {
    GunMetal
  }
}
#declare Armament_Object37_Ref = object {
  Armament_Object37
  material {
    GunMetal
  }
}
union { // Camel
  object { Engine_Object1_Ref }
  object { Lofts_Object3_Ref }
  object { Details_Object6_Ref }
  object { Details_Object7_Ref }
  object { Details_Object8_Ref }
  object { Details_Object9_Ref }
  object { Details_Object10_Ref }
  object { Details_Object11_Ref }
  object { Details_Object20_Ref }
  object { Details_Object21_Ref }
  object { Details_Object22_Ref }
  object { Lofts_Object12_Ref }
  object { Details_Object23_Ref }
  object { Details_Object30_Ref }
  object { Details_Object31_Ref }
  object { Details_Object32_Ref }
  object { Lofts_Object17_Ref }
  object { Lofts_Object18_Ref }
  object { Lofts_Object19_Ref }
  object { Lofts_Object24_Ref }
  object { Lofts_Object25_Ref }
  object { Details_Object33_Ref }
  object { Details_Object34_Ref }
  object { Details_Object35_Ref }
  object { Details_Object36_Ref }
  object { Lofts_Object26_Ref }
  object { Lofts_Object27_Ref }
  object { Lofts_Object28_Ref }
  object { Engine_Object29_Ref }
  object { Armament_Object30_Ref }
  object { Armament_Object31_Ref }
  object { Armament_Object32_Ref }
  object { Armament_Object33_Ref }
  object { Armament_Object34_Ref }
  object { Armament_Object35_Ref }
  object { Armament_Object36_Ref }
  object { Armament_Object37_Ref }
  box { // Propeller1
    <-1, -1, -1>, <1, 1, 1>
    material {
      PropellerMaterial
      scale 2.0
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <1.0, 1.0, 0.001>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.204557, 0.0, 0.026988>
  }
  box { // Flame1
    <-1, -1, -1>, <1, 1, 1>
    material {
      FlameTexture
      scale 2.0
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <0.15, 0.15, 0.00008>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.192493, 0.154262, 0.5936>
  }
  box { // Flame2
    <-1, -1, -1>, <1, 1, 1>
    material {
      FlameTexture
      scale 2.0
      translate <-1.000000, -1.000000, 0.000000>
    }
    scale <0.15, 0.15, 0.00008>
    rotate <-0.0, -90.0, 0.0>
    translate  <0.192493, -0.139364, 0.5936>
  }
  material {
    GreenFabric
  }
  no_shadow
  scale 0.973485
  rotate <-8.139182, -14.79163, 30.960911>
  translate  <119.970212, 85.340364, 117.242549>
}




#include "house_moray.inc"

object {
  House
  material {
    WhiteWall
  }
  scale 0.05
  rotate 155.963135*z
  translate  <370.358124, 229.945743, 27.3>
}


plane { // Plane001
  z,0
  material {
    GroundMaterial
  }
}


sphere { // Sky
  <0,0,0>,1
  material {
    Bright_Sky_2
  }
  no_shadow
  hollow
  scale 10000.0
}


object {   // Ground
  height_field {
    tga "output.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    TexturedGroundMaterial
    scale 2.0
    translate <-1.000000, -1.000000, 0.000000>
  }
  scale <1000.0, 1000.0, 30.0>
  translate  <1000.0, 1000.0, 30.0>
}




