/*
	Scene.cpp
*/

#include "stdafx.h"
#include "CRays.h"
#include "CRaysDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifndef RANDU
// 0 < RANDU < 1.0
#define RANDU (scalar(rand())/scalar(RAND_MAX))
#endif
#ifndef ABS
#define ABS(A) ((A) < 0 ? -(A) : (A))
#endif
#ifndef FRACTION
#define FRACTION(A)     ( (A) - (long)(A) )
#endif
#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif

#include "colors.inc"
#include "finish.inc"

#include "marker.hpp"


// One-time initialization (before scene generation):
void CCRaysDoc::initScene(void)
	{
	;
	}

/////////////////////////////////////////////////////////////////////////////
// Per-frame initialization:
void CCRaysDoc::SetupFrame() {
	afxMemDF &= ~allocMemDF ;

	CString title ;

	CreateScene(pScene);	// builds scene from scratch
	pScene->rotate(0,frame*2*PI/60.,0);		// rotate about Y axis
	title.Format("CRays - Frame %6.2f", frame) ;
	SetTitle(title) ;
	afxMemDF |= allocMemDF ;
	}

/////////////////////////////////////////////////////////////////////////////
// Per-frame cleanup:
void CCRaysDoc::EndFrame() {
	afxMemDF &= ~allocMemDF ;
	CString file ;
	int iframe ;

	pScene->removeAll();	// remove all scene elements and delete them
	iframe = (int)frame ;
	file.Format(".\\frame%03i.bmp",iframe) ;
	OnSaveDocument(file) ;
	afxMemDF |= allocMemDF ;
	}

/////////////////////////////////////////////////////////////////////////////
// Textures
#include "ray.hpp"

class PaperTexture : public Texture {
public:
   PaperTexture() : Texture(Tan, Dull) { 
		ambient = .3;
		diffuse = .8;
		brilliance = 0 ;
		specular = 0;
		roughness = .15;
		metalness = 0;
		reflectivity = 0;
		_bmpPaper = new CDIB("paper.bmp") ;
		}
	~PaperTexture() { 
		delete _bmpPaper ;
		};
protected:
	Texture* proc(Hit& hit, Shader const* shader) const ;
	CDIB* _bmpPaper ;
	} ;

class WoodTexture : public Texture {
public:
	WoodTexture() : Texture((Beige+Brown)/2.) { 
		ambient = .3;
		diffuse = .8;
		brilliance = 0 ;
		specular = 0;
		roughness = .15;
		metalness = 0;
		reflectivity = 0;
		_bmpWood = new CDIB("wood.bmp") ;
		}
	~WoodTexture() { 
		delete _bmpWood ;
		}
protected:
   Texture* proc(Hit& hit, Shader const* shader) const ;
   CDIB* _bmpWood ;
   } ;

class WallTexture : public Texture {
public:
	WallTexture() : Texture(White) { 
		ambient = .3;
		diffuse = .6;
		brilliance = 0 ;
		specular = 0;
		roughness = .35;
		metalness = 0;
		reflectivity = 0;
		_bmpWall = new CDIB("wall.bmp") ;
		}
   ~WallTexture() { 
	   	 delete _bmpWall ;
		 }
protected:
	Texture* proc(Hit& hit, Shader const* shader) const ;
	CDIB* _bmpWall ;
	} ;

class HangingTexture : public Texture {
public:
	HangingTexture() : Texture((Beige+Brown)/2.) { 
		ambient = .3;
		diffuse = .8;
		brilliance = 0 ;
		specular = 0;
		roughness = .15;
		metalness = 0;
		reflectivity = 0;
		_bmpHanging = new CDIB("tapestry.bmp") ;
		}
	~HangingTexture() { 
		delete _bmpHanging ;
	}
protected:
	Texture* proc(Hit& hit, Shader const* shader) const ;
	CDIB* _bmpHanging ;
	} ;


/////////////////////////////////////////////////////////////////////////////
// Scene Creation


extern Union* Dragon() ;
void CCRaysDoc::CreateScene(Union* pScene) {


	Union* dragon = Dragon();		// see dragon.cpp

	dragon->move(0,2.2,0);
	dragon->rotate(-RADIANS(15),-RADIANS(90),0);
	dragon->move(-2.,0,0);
	pScene->add(dragon);


//============================================================
	Union* pPaper = new Union;
	Union* scrolls = new Union;

	#include "paper.scn"

	pPaper->move(0,0,-5);

	pScene->add(pPaper);

//============================================================

	Box* desk = new Box(Position(-20,-1,-20),Position(20,0,20));
	desk->setTexture(new WoodTexture);

	pScene->add(desk);

//============================================================

	WallTexture* wallTexture = new WallTexture;
	Box* wall = new Box(Position(-21,-10,20),Position(-20,20,-100));
	wall->userdata = 0;
	wall->setTexture(wallTexture);
	pScene->add(wall);

	wall = new Box(Position(-50,-10,-21),Position(20,20,-20));
	wall->setTexture(wallTexture);
	wall->userdata = 1;
	pScene->add(wall);

	wall = new Box(Position(0,3,-19.25),Position(20,45,-20));
	wall->setTexture(new HangingTexture);
	pScene->add(wall);

extern Union* fire();
	pScene->add(fire());	// see smoke.cpp

	} // End of CreateScene



Texture* PaperTexture::proc(Hit& hit,
							Shader const* shader) const {

	Position xyz ;
	int r, c;
	scalar u, v;
	RGBQUAD rgbq ;
	Texture* pptx = new Texture(*this) ;

	xyz = hit.ray->point(hit.t) ;

	BITMAPINFOHEADER* pbmp = _bmpPaper->GetBMIH() ;
	v = (6.5-xyz.z)/13.;
	if (v < 0)
		v = 0;
	v = FRACTION(v);
	r = (LONG)(v*(scalar)pbmp->biHeight);

	u = (xyz.x+8.5)/16.;
	if (u < 0)
		u = 0;
	u = FRACTION(u);
	c = (LONG)(u*(scalar)pbmp->biWidth);

	rgbq = _bmpPaper->GetRGB(r,c) ;
	pptx->color.x = (scalar)rgbq.rgbRed/255.;
	pptx->color.y = (scalar)rgbq.rgbGreen/255.;
	pptx->color.z = (scalar)rgbq.rgbBlue/255.;
	return pptx ;
	}

Texture*  WoodTexture::proc(Hit& hit,
							Shader const* shader) const {
    
	Position xyz ;
	int r, c;
	RGBQUAD rgbq ;
	Texture* pptx = new Texture(*this) ;

	xyz = hit.ray->point(hit.t) ;
 	
	BITMAPINFOHEADER* pbmp = _bmpWood->GetBMIH() ;
	scalar u, v;
	u = xyz.x+20.;
	u = u / 15.;
	u = FRACTION(u);
	v = FRACTION((xyz.z+20.)/15.);

	c = (LONG)(u *(scalar)pbmp->biWidth);
	r = (LONG)(v *(scalar)pbmp->biHeight);
	rgbq = _bmpWood->GetRGB(r,c) ;
	pptx->color.x = (scalar)rgbq.rgbRed/255.;
	pptx->color.y = (scalar)rgbq.rgbGreen/255.;
	pptx->color.z = (scalar)rgbq.rgbBlue/255.;
	return pptx ;
	}

Texture*  WallTexture::proc(Hit& hit,
							Shader const* shader) const {
   
	Position xyz ;
	int r, c;
	RGBQUAD rgbq ;
	Texture* pptx = new Texture(*this) ;

	xyz = hit.ray->point(hit.t) ;
	BITMAPINFOHEADER* pbmp = _bmpWall->GetBMIH() ;
	scalar u, v;

	//Box* wall = new Box(Position(-21,-10,20),Position(-20,20,-100)); 	// Box 0
	//Box* wall = new Box(Position(-50,-10,-21),Position(20,20,-20));	// Box 1
	if (hit.pObject->userdata == 0) {
		u = xyz.z+100.;
		u = u / 120.;
		u = FRACTION(u);
		v = FRACTION((xyz.y+10.)/30.);
		}
	else {
		u = xyz.x+50.;
		u = u / 70.;
		u = FRACTION(u);
		v = FRACTION((xyz.y+10.)/30.);
		}

	c = (LONG)(u *(scalar)pbmp->biWidth);
	r = (LONG)(v *(scalar)pbmp->biHeight);
	rgbq = _bmpWall->GetRGB(r,c) ;
	pptx->color.x = (scalar)rgbq.rgbRed/255.;
	pptx->color.y = (scalar)rgbq.rgbGreen/255.;
	pptx->color.z = (scalar)rgbq.rgbBlue/255.;
	return pptx ;
	}

Texture*  HangingTexture::proc(Hit& hit,
							   Shader const* shader) const {
    
	Position xyz ;
	int r, c;
	RGBQUAD rgbq ;
	Texture* pptx = new Texture(*this) ;

	xyz = hit.ray->point(hit.t) ;
	BITMAPINFOHEADER* pbmp = _bmpHanging->GetBMIH() ;
	scalar u, v;
	//wall = new Box(Position(0,3,-19.25),Position(20,45,-20));
	u = xyz.x;
	u = u / 20.;
	u = FRACTION(u);
	v = FRACTION((xyz.y-3)/42.);

	c = (LONG)(u *(scalar)pbmp->biWidth);
	r = (LONG)(v *(scalar)pbmp->biHeight);
	rgbq = _bmpHanging->GetRGB(r,c) ;
	pptx->color.x = (scalar)rgbq.rgbRed/255.;
	pptx->color.y = (scalar)rgbq.rgbGreen/255.;
	pptx->color.z = (scalar)rgbq.rgbBlue/255.;
	return pptx ;
	}
