#declare EyeTex = texture { 
	pigment { rgb <0,0.1,0> }
//	normal {  hexagon 0.5  rotate x*90 scale 0.01 }
	normal {
		facets size 0.2
		bump_size 0.5
	}

	finish { 
		reflection {
			rgb 0.075
		}
		brilliance 2 specular 1 roughness 0.001 
	}
}

#declare AntTex = texture {
	pigment {
		bozo
		color_map {
			[ 0.5 rgb <0.384619, 0.064057, 0.036820>*0.6 ]
			[ 1 rgb <0.235294, 0.054017, 0.040131>*0.6 ]
		}
		scale <0.3,0.25,0.25>
	}
	#if( Quality > 7 )
	normal {
		bumps 0.75 scale 0.0075
	}
	#end
	finish {
		specular 0.7 roughness 0.01
		irid {
			0.005
			thickness 0.05
			turbulence <0.3, 0.5, 0.3>
		}		
	}
}

#declare LegTex = texture {
	pigment { 
		bozo
		color_map {
			[ 0 rgb <0.153841, 0.090913, 0.096361> ]
			[ 1 rgb <0.257923, 0.203174, 0.197086> ]
		}
		scale <0.045,0.045,0.025>
	 }
	#if( Quality > 7 )
	normal {
		bumps 0.75 scale 0.01
	}
	#end
	finish {
		specular 0.4 roughness 0.01
		irid {
			0.05
			thickness 0.005
			turbulence <0.3, 0.5, 0.3>
		}		
	}
}


#declare Eye = blob {
	threshold 1
	sphere {
		<0,0,0>, 1 strength 2.75
		scale <0.75,0.85,0.6>
	}

	sphere {
		<0,0,0>, 1 strength 2
		scale <0.55,0.75,0.3>
		translate <0.25,-0.35,-0.2>
	}
	sphere {
		<0,0,0>, 1 strength 1
		scale <0.5,0.5,0.2>
		translate <0.125,-0.1725,-0.2>
	}
	sphere {
		<0,0,0>, 1 strength 1.5
		scale <0.6,0.5,0.2>
		translate <0.125,-0.25,-0.25>
	}
	texture { EyeTex }
	
}

#declare JawBase = sphere_sweep {
		b_spline,
		5, 
		<0.0, 0, 0.0>, 0.1
		<0.0, 0, 0.0>, 0.1
		<-0.025,-0.25,0.0125>, 0.075
		<-0.25, -0.5, 0.15>, 0.0
		<-0.25, -0.5, 0.15>, 0.0
		tolerance 1.0e-6	
}
#declare Jaw = union {
	object { JawBase }
	object { JawBase scale <0.97,0.8,0.95> }
	object { JawBase scale <0.94,0.6,0.9> }
	object { JawBase scale <0.89,0.4,0.85> }
	
		texture {
			pigment { 
				bozo
				color_map {
					[ 0 rgb <0.153841, 0.090913, 0.096361>*1.3 ]
					[ 1 rgb <0.257923, 0.203174, 0.197086>*1.3 ]
				}
				scale <0.045,0.045,0.025>
			 }
			normal {
				gradient y
				scallop_wave
				scale 0.075
				bump_size 0.3
			}
			finish { specular 0.2 roughness 0.1 }
		}
}

#declare HeadBase = blob {
	threshold 0.75
	// Main bump
	sphere {
		<0, 0, 0>, 1, strength 2
		scale <1,0.75,0.6>
	}
	// Jaw
	sphere {
		<0, 0, 0>, 1, strength 2
		scale <0.75,1,0.6>
		translate <0,-0.25,0>
	}
	// Sides
	sphere {
		<0, 0, 0>, 1, strength 0.25
		scale <0.5,0.5,0.3>
		translate <-0.5,0.25,0>
	}
	sphere {
		<0, 0, 0>, 1, strength 0.25
		scale <0.5,0.5,0.3>
		translate <0.5,0.25,0>
	}
	// Forehead bump
	sphere {
		<0, 0, 0>, 1, strength 0.25
		scale <0.5,0.6,0.25>
		translate <0,0,-0.4>
	}
	// Bumps
	sphere {
		<0, 0, 0>, 1, strength 2
		scale <0.15,0.2,0.15>
		rotate z*30
		rotate x*-15
		translate <-0.45,0.4,-0.1>
	}	
	sphere {
		<0, 0, 0>, 1, strength -0.75
		scale <0.15,0.1,0.15>
		translate y*0.125
		rotate z*30
		rotate x*-15
		translate <-0.45,0.4,-0.1>
	}	
	sphere {
		<0, 0, 0>, 1, strength 2
		scale <0.15,0.2,0.15>
		rotate z*-30
		rotate x*-15
		translate <0.45,0.4,-0.1>
	}	
	sphere {
		<0, 0, 0>, 1, strength -0.75
		scale <0.15,0.1,0.15>
		translate y*0.125
		rotate z*-30
		rotate x*-15
		translate <0.45,0.4,-0.1>
	}	
	// Antenna stumps
	sphere {
		<0,0,0>, 1 strength 2
		scale <0.125,0.125,0.625>
		rotate x*-30
		rotate y*-15
		translate <-0.25,-0.5,0.1>
	}	
	sphere {
		<0,0,0>, 1 strength 2
		scale <0.125,0.125,0.625>
		rotate x*-30
		rotate y*-15
		translate <-0.25,-0.5,0.1>
		scale <-1,1,1>
	}	
	sturm
}

#macro HeadHair( startPoint, endPoint, controlPoint, hairWidth )

	sphere_sweep {
		b_spline,
		6, 
		startPoint, hairWidth
		startPoint, hairWidth
		<(startPoint.x*0.75+endPoint.x*0.25)/1,
		(startPoint.y*0.75+endPoint.y*0.25)/1,
		(startPoint.z*0.75+endPoint.z*0.25)/1>, hairWidth*3/4
		<(startPoint.x+endPoint.x)/2,(startPoint.y+endPoint.y)/2,(startPoint.z+endPoint.z) /2>, hairWidth/2
		endPoint, 0
		controlPoint, 0
		tolerance 1.0e-6	
}
#end

#declare AntHairTex = texture {
	pigment {
		rgb <0.384619, 0.064057, 0.036820>
	}
	finish {
		specular 0.7 roughness 0.01
	}
}

#declare HeadHairs = union {
	// Top row
	object { HeadHair( <-0.4,0.25,-0.25>, <-0.45,0.6,-0.4>, <-1,1,0>, 0.0125 ) }
	object { HeadHair( <-0.2,0.25,-0.3>, <-0.3,0.5,-0.45>, <-0.5,0.6,-0.5>, 0.0125 ) }
	object { HeadHair( <-0.1,0.25,-0.35>, <-0.05,0.65,-0.25>, <0.1,1,-0.1>, 0.0125 ) }
	object { HeadHair( <0.1,0.25,-0.35>, <0.15,0.65,-0.2>, <0.05,0.8,0.1>, 0.0125 ) }
	object { HeadHair( <0.2,0.25,-0.3>, <0.3,0.6,-0.15>, <0.2,0.6,-0.3>, 0.0125 ) }
	object { HeadHair( <0.4,0.25,-0.25>, <0.4,0.55,-0.45>, <0.5,0.8,-0.5>, 0.0125 ) }
	// Left eye
	object { HeadHair( <-0.3,0.1,-0.4>, <-0.35,0.15,-0.6>, <-0.5,0.2,-1>, 0.0125 ) }
	object { HeadHair( <-0.25,-0.1,-0.45>, <-0.35,0.05,-0.6>, <-0.5,0.2,-1>, 0.0125 ) }
	object { HeadHair( <-0.25,-0.3,-0.4>, <-0.275,-0.4,-0.6>, <-0.5,-0.6,-1>, 0.0125 ) }
	object { HeadHair( <-0.275,-0.5,-0.3>, <-0.35,-0.65,-0.5>, <-0.5,-1,-1>, 0.0125 ) }
	// Right eye
	object { HeadHair( <0.3,0.1,-0.4>, <0.35,0.15,-0.6>, <0.5,0.2,-1>, 0.0125 ) }
	object { HeadHair( <0.25,-0.1,-0.45>, <0.35,0.05,-0.6>, <0.5,0.2,-1>, 0.0125 ) }
	object { HeadHair( <0.25,-0.3,-0.4>, <0.275,-0.4,-0.6>, <0.3,-0.55,-1>, 0.0125 ) }
	object { HeadHair( <0.275,-0.5,-0.3>, <0.35,-0.65,-0.5>, <0.4,-0.9,-0.7>, 0.0125 ) }
	
}

#declare Antenna = sphere_sweep {
	b_spline,
	10, 
	<0,0,0>, 0.02
	<0,0,0>, 0.02
	<-0.3,0.1,0.1>, 0.04
	<-0.5,0.25,0.25>, 0.02
	<-0.55,0.3,0.3>, 0.035
	<-0.55,0.3,0.3>, 0.03
	<-0.575,0.35,0.35>, 0.035
	<-0.575,0.35,0.35>, 0.02
	<-0.6,0.5,0.75>, 0.01
	<-0.6,0.5,0.75>, 0.01
	tolerance 1.0e-6	
	rotate z*-45
	rotate x*-90
	rotate y*30
}



#macro Head()
union {
	object { HeadBase  }
	#if( Quality > 6 )
	object { HeadHairs 
		texture {
			AntHairTex
		}
	}
	#end
	object { Eye scale 0.65 rotate x*-20 translate <-0.45,-0.1,-0.15> }
	object { Eye scale 0.65 rotate x*-20 translate <-0.45,-0.1,-0.15> scale <-1,1,1> }
	sphere { 0, 0.05 translate <-0.1,0.2,-0.425> texture { EyeTex } }
	sphere { 0, 0.05 translate <0.1,0.2,-0.425> texture { EyeTex } }
	sphere { 0, 0.05 translate <0,0.05,-0.475> texture { EyeTex } }
	object { Jaw rotate z*-AntMandibleRot translate <0.3,-0.65,0.075> }
	object { Jaw rotate z*-AntMandibleRot translate <0.3,-0.65,0.075> scale <-1,1,1> }
	object { Antenna scale 1.5 
		rotate x*-AntAntenna1XRot
		rotate y*AntAntenna1YRot 
		translate <-0.15,-0.675,-0.225> 
		texture { AntHairTex }
	}
	object { Antenna scale 1.5 
		rotate x*-AntAntenna2XRot
		rotate y*-AntAntenna2YRot 
		translate <-0.15,-0.675,-0.225> scale <-1,1,1> 
		texture { AntHairTex }
	}
	texture { AntTex }
	rotate x*45
}
#end

#declare Thorax = blob {
	threshold 0.75
	sphere {
		<0,0.25,0.5>, 1 strength 1.5
	}
	sphere {
		<-0.25,0,0>, 0.6 strength 2
	}
	sphere {
		<0.25,0,0>, 0.6 strength 2
	}
	sphere {
		<-0.5,0,0.5>, 0.75 strength 2
	}
	sphere {
		<0.5,0,0.5>, 0.75 strength 2
	}
	sphere {
		<-0.4,0,1>, 0.75 strength 2
	}
	sphere {
		<0.4,0,1>, 0.75 strength 2
	}
	sphere {
		<-0.3,0,1.5>, 0.65 strength 2
	}
	sphere {
		<0.3,0,1.5>, 0.65 strength 2
	}
	sphere {
		<-0.2,0,2>, 0.55 strength 2
	}
	sphere {
		<0.2,0,2>, 0.55 strength 2
	}
	// Legs
	sphere {
		<-1,0,0.25>, 0.2 strength 2
	}
	sphere {
		<-1.1,0,0.25>, 0.2 strength -1.75
	}
	sphere {
		<1,0,0.25>, 0.2 strength 2
	}
	sphere {
		<1.1,0,0.25>, 0.2 strength -1.75
	}
	sphere {
		<-1,0,1>, 0.2 strength 2
	}
	sphere {
		<-1.1,0,1>, 0.2 strength -1.75
	}
	sphere {
		<1,0,1>, 0.2 strength 2
	}
	sphere {
		<1.1,0,1>, 0.2 strength -1.75
	}
	sphere {
		<-0.9,0,1.5>, 0.2 strength 2
	}
	sphere {
		<-1,0,1.5>, 0.2 strength -1.75
	}
	sphere {
		<0.9,0,1.5>, 0.2 strength 2
	}
	sphere {
		<1,0,1.5>, 0.2 strength -1.75
	}
	// Neck
	cylinder {
		<0,0,0>, <0,0.5,-0.5>, 0.35 strength 1.5
	}
	// Back
	cylinder {
		<0,0,2>, <0,0.3,2.7>, 0.4 strength 1.5 
	}
}


#local SlopeNorm = normal {
	gradient z
	1 //amount
	slope_map {
		[ 0.000000, <1.000000, -0.700000> ]
		[ 0.560750, <1.000000, 0.000000> ]
		[ 1.000000, <1.000000, 0.000000> ]
	}
	scale 0.5
}
#local BumpNorm = normal {
		bumps 0.75 scale 0.05			
}

#declare Perse2 = union {
	difference {
		sphere { <0,0,0>, 1 scale <1.15,1.15,0.8> }
		box { <-2,-2,0> <2,2,2> }
	}
	intersection {
		sphere { <0,0,0>, 1 scale <1.15,1.15,2> }
		box { <-2,-2,0> <2,2,4> }
	}
	scale <1,1,1.5>
	texture {
		pigment { rgb 0.2 }
		normal {
			average 
			0.5 //amount
			normal_map {
				[ 0.2 BumpNorm ]
				[ 0.8 SlopeNorm ]
			}
		}
		finish { specular 0.3 roughness 0.1 }
	}
	translate z*0.7
	scale 0.85
	rotate x*-30
}

#declare Perse = blob {
	threshold 0.75
	#local PerseCount = 0;
	#local PerseMax = 15;
	#while( PerseCount < PerseMax )
		#local PerseWidth = sin( pi*(PerseCount/PerseMax) )*1+0.3;
		#local PerseY = sin( pi*(PerseCount/PerseMax) )*0.5-(PerseCount/PerseMax)*0.5;
		#local PerseZ = (PerseCount/PerseMax)*3;
		sphere { <0,0,0>, 1 strength 2 
			scale <PerseWidth,PerseWidth,PerseWidth> 
			translate <0,PerseY,PerseZ>
		}
		#local PerseCount = PerseCount+1;
	#end
	texture {
		pigment { 
			bozo
			color_map {
				[ 0.2 rgb <0.153841, 0.090913, 0.096361>*0.5 ]
				[ 0.8 rgb <0.257923, 0.203174, 0.197086>*0.5 ]
			}
			scale <0.045,0.045,0.025>
		 }
		normal {
			average 
			0.5 //amount
			normal_map {
				[ 0.2 BumpNorm ]
				[ 0.8 SlopeNorm ]
			}
		}
		finish { 
			specular 0.15 roughness 0.1 
			irid {
				0.25
				thickness 0.00005
//				turbulence <1.3, 1.5, 1.3>
			}		
		}
	}
	//translate z*0.7
	//scale 0.85
}

#declare LegSegment1 = blob {
	threshold 0.8
	sphere {
		<0,0,0>, 1 strength 1
		scale <0.5,1,0.5>
	}
	sphere {
		<0,0,0>, 1, strength 1
		scale <0.6,0.6,0.6>
		translate y*-0.4
	}
	scale <0.8,1,0.8>
	translate y*0.7
	texture { LegTex }
}

#declare LegSegment2 = blob {
	threshold 0.95
	sphere {
		<0,0,0>, 1.5 strength 2
		scale <1,1.5,1>
	}
	cylinder {
		<0,0,0>, <0,6,0>, 1.5 strength 1.75
	}
	sphere {
		<0,0,0>, 1.25 strength 1.5
		scale <1,1.2,1>
		translate y*6
	}
	scale <0.8,1,0.8>
	translate y*0.6
	scale <0.175,0.2,0.175>
	texture { LegTex }
}

#declare LegSegment3 = blob {
	threshold 0.95
	sphere {
		<0,0,0>, 1.5 strength 2
		scale <1,1.5,1>
	}
	cylinder {
		<0,0,0>, <0,8,0>, 1.5 strength 1.75
	}
	sphere {
		<0,0,0>, 1.25 strength 1.5
		scale <1,1.2,1>
		translate y*8
	}
	scale <0.8,1,0.8>
	translate y*0.5
	scale <0.125,0.175,0.125>
	texture { LegTex }
}

#declare LegSegment4 = blob {
	threshold 0.95
	sphere {
		<0,0,0>, 1.5 strength 2
		scale <1,1.5,1>
	}
	cylinder {
		<0,0,0>, <0,8,0>, 1.5 strength 1.75
	}
	scale <0.8,1,0.8>
	translate y*0.5
	scale <0.1,0.2,0.1>
	texture { LegTex }
}

#macro Leg( HipAngle, KneeAngle, AnkleAngle )
union {
	object { LegSegment1 }
	union {
		object { LegSegment2 }
		union {
			object { LegSegment3 }
			object { LegSegment4 rotate z*AnkleAngle translate y*1.6 }
			rotate z*-KneeAngle translate y*1.5 
		}
		rotate z*-HipAngle translate y*1.0 
	}
	scale 0.75
	rotate z*-60
}
#end

#macro ResetAnt()
#declare AntMandibleRot = 0;
#declare AntAntenna1XRot = 0;
#declare AntAntenna1YRot = 0;
#declare AntAntenna2XRot = 0;
#declare AntAntenna2YRot = 0;
#declare AntHeadXRot = 0;
#declare AntHeadYRot = 0;
#declare BellyRot = 0;
#declare Leg1XRot = 0;
#declare Leg1YRot = 50;
#declare Leg2XRot = 0;
#declare Leg2YRot = 50;
#declare Leg3XRot = 0;
#declare Leg3YRot = 0;
#declare Leg4XRot = 0;
#declare Leg4YRot = 0;
#declare Leg5XRot = 0;
#declare Leg5YRot = -60;
#declare Leg6XRot = 0;
#declare Leg6YRot = -60;
#declare Leg1JointAngle1 = 30;
#declare Leg1JointAngle2 = 40;
#declare Leg1JointAngle3 = 20;
#declare Leg2JointAngle1 = 30;
#declare Leg2JointAngle2 = 40;
#declare Leg2JointAngle3 = 20;
#declare Leg3JointAngle1 = 30;
#declare Leg3JointAngle2 = 40;
#declare Leg3JointAngle3 = 20;
#declare Leg4JointAngle1 = 30;
#declare Leg4JointAngle2 = 40;
#declare Leg4JointAngle3 = 20;
#declare Leg5JointAngle1 = 30;
#declare Leg5JointAngle2 = 40;
#declare Leg5JointAngle3 = 20;
#declare Leg6JointAngle1 = 30;
#declare Leg6JointAngle2 = 40;
#declare Leg6JointAngle3 = 20;

#end

#macro RandomizeAnt( Seed )
#declare AntRand = seed( Seed );
#declare AntMandibleRot = rand(AntRand)*60-30;
#declare AntAntenna1XRot = rand(AntRand)*40-20;
#declare AntAntenna1YRot = rand(AntRand)*20-10;
#declare AntAntenna2XRot = rand(AntRand)*40-20;
#declare AntAntenna2YRot = rand(AntRand)*20-10;
#declare AntHeadXRot = rand(AntRand)*30-15;
#declare AntHeadYRot = rand(AntRand)*45-22.5;
#declare BellyRot = rand(AntRand)*90-30;
#declare Leg1XRot = rand(AntRand)*40-20;
#declare Leg1YRot = 50+ rand(AntRand)*20-10;
#declare Leg2XRot = rand(AntRand)*40-20;
#declare Leg2YRot = 50+ rand(AntRand)*20-10;
#declare Leg3XRot = rand(AntRand)*40-20;
#declare Leg3YRot = rand(AntRand)*20-10;
#declare Leg4XRot = rand(AntRand)*40-20;
#declare Leg4YRot = rand(AntRand)*20-10;
#declare Leg5XRot = rand(AntRand)*40-20;
#declare Leg5YRot = -60+ rand(AntRand)*20-10;
#declare Leg6XRot = rand(AntRand)*40-20;
#declare Leg6YRot = -60+ rand(AntRand)*20-10;
#declare Leg1JointAngle1 = 30+ rand(AntRand)*20;
#declare Leg1JointAngle2 = 40+ rand(AntRand)*20;
#declare Leg1JointAngle3 = 20-rand(AntRand)*15;
#declare Leg2JointAngle1 = 30+ rand(AntRand)*20;
#declare Leg2JointAngle2 = 40+ rand(AntRand)*20;
#declare Leg2JointAngle3 = 20-rand(AntRand)*15;
#declare Leg3JointAngle1 = 30+ rand(AntRand)*20;
#declare Leg3JointAngle2 = 40+ rand(AntRand)*20;
#declare Leg3JointAngle3 = 20-rand(AntRand)*15;
#declare Leg4JointAngle1 = 30+ rand(AntRand)*20;
#declare Leg4JointAngle2 = 40+ rand(AntRand)*20;
#declare Leg4JointAngle3 = 20-rand(AntRand)*15;
#declare Leg5JointAngle1 = 30+ rand(AntRand)*20;
#declare Leg5JointAngle2 = 40+ rand(AntRand)*20;
#declare Leg5JointAngle3 = 20-rand(AntRand)*15;
#declare Leg6JointAngle1 = 30+ rand(AntRand)*20;
#declare Leg6JointAngle2 = 40+ rand(AntRand)*20;
#declare Leg6JointAngle3 = 20-rand(AntRand)*15;
#end

#ifndef( AntScaleFactor )
	#declare AntScaleFactor = 1.0;
#end

#macro Ant() 
#ifndef( AntHeadXRot )
	ResetAnt()
#end
union {
	object { Thorax }
	object { Head() 
		rotate x*AntHeadXRot 
		rotate y*AntHeadYRot
		translate <0,0.7,-0.7> 
	}
	object {
		Perse 
		rotate x*-BellyRot
		translate <0,0.35,2.7> 
	}
	#local Leg1 = 
	object { Leg( Leg1JointAngle1, Leg1JointAngle2, Leg1JointAngle3 ) 
		rotate z*Leg1XRot
		rotate y*Leg1YRot
		translate <1,0,0.25>
	}
	object { Leg1 }
	#local Leg3 =
	object { Leg( Leg3JointAngle1, Leg3JointAngle2, Leg3JointAngle3 ) 
		rotate z*Leg3XRot
		rotate y*Leg3YRot
		translate <1,0,1> 
	}
	object { Leg3 }
	#local Leg5 =
	object { Leg( Leg5JointAngle1, Leg5JointAngle2, Leg5JointAngle3 ) scale 1.2 
		rotate z*Leg5XRot
		rotate y*Leg5YRot 
		translate <0.9,0,1.5> 
	}
	object { Leg5 }
	#local Leg2 =
	object { Leg( Leg2JointAngle1, Leg2JointAngle2, Leg2JointAngle3 ) 
		rotate z*Leg2XRot
		rotate y*-Leg2YRot rotate y*180 
		translate <-1,0,0.25> 
	}
	object { Leg2 }
	#local Leg4 =
	object { Leg( Leg4JointAngle1, Leg4JointAngle2, Leg4JointAngle3 )  
		rotate z*Leg4XRot 
		rotate y*-Leg4YRot rotate y*180 
		translate <-1,0,1> 
	}
	object { Leg4 }
	#local Leg6 =
	object { Leg( Leg6JointAngle1, Leg6JointAngle2, Leg6JointAngle3 ) scale 1.2 
		rotate z*Leg6XRot 
		rotate y*-Leg6YRot rotate y*180  
		translate <-0.9,0,1.5> 
	}
	object { Leg6 }
	#local MinL1 = min_extent( Leg1 ).y;
	#local MinL2 = min_extent( Leg2 ).y;
	#local MinL3 = min_extent( Leg3 ).y;
	#local MinL4 = min_extent( Leg4 ).y;
	#local MinL5 = min_extent( Leg5 ).y;
	#local MinL6 = min_extent( Leg6 ).y;
	#local MinLeft = MinL1; 
	#local LeftX = max_extent( Leg1 ).x;
	#if( MinL2 < MinLeft )
		#local MinLeft = MinL2;
		#local LeftX = max_extent( Leg2 ).x;
	#end
	#if( MinL3 < MinLeft )
		#local MinLeft = MinL3;
		#local LeftX = max_extent( Leg3 ).x;
	#end

	#local MinRight = MinL2; 
	#local RightX = min_extent( Leg2 ).x;
	#if( MinL4 < MinRight )
		#local MinRight = MinL4;
		#local RightX = min_extent( Leg4 ).x;
	#end
	#if( MinL6 < MinRight )
		#local MinRight = MinL6;
		#local RightX = min_extent( Leg6 ).x;
	#end
	#local MinMin = min( MinLeft, MinRight );
	#local XDiff = abs( RightX-LeftX );
	#if( XDiff > 0 )
		#local YDiff = max( MinLeft, MinRight )-MinMin;
		#if( MinLeft < MinRight )
			#debug "Rotating ant right"
			translate x*RightX
			rotate z*-degrees( atan2( YDiff, XDiff ) )
			translate x*-RightX
		#end
		#if( MinLeft > MinRight )
			#debug concat( "Rotating ant left ", str( YDiff, 1, 3 ), " ", str( XDiff, 1, 3 ), "\n" )
			translate x*-LeftX
			rotate z*degrees( atan2( YDiff, XDiff ) )
			#debug concat( str( degrees( atan2( YDiff, XDiff ) ), 1, 3 ), " degrees \n" )
			translate x*LeftX
		#end
	translate y*-MinMin/2

	#end
	texture { AntTex }
	scale AntScaleFactor
}
#end

