#debug " --- Plant.mcr --- \n"

#ifndef( Quality )
	#declare Quality = 9;
#end

#declare RootPigment = pigment {
	bozo
	color_map {
		[ 0.4 rgb <0.217884, 0.371038, 0.126146> ]
		[ 0.5 rgb <0.217166, 0.253391, 0.065431> ]
		[ 0.6 rgb <0.217884, 0.371038, 0.126146> ]
	}	
	turbulence 0.7
	scale <0.3,0.1,0.1>
}
#declare HighPigment = pigment {
	bozo
	color_map {
		[ 0.4 rgb <0.427955, 0.669688, 0.123018> ]
		[ 0.5	rgb <0.420798, 0.466056, 0.104891> ]
		[ 0.6 rgb <0.427955, 0.669688, 0.123018> ]
	}	
	turbulence 0.7
	scale <0.3,0.1,0.1>
}


#local WrinkleNorm = normal {
		wrinkles 0.6
		bump_size 0.5
		scale <0.3,0.1,0.1>
}

#local BumpNorm = normal {
		bumps 0.75 bump_size 0.2 scale 0.1			
}

#declare WrinklyTex = texture {
	pigment { 
		gradient y
		pigment_map {
			[0 RootPigment ]
			[1 HighPigment ]
		}
	}
	normal {
		average 
			0.5 //amount
			normal_map {
				[ 0.2 BumpNorm ]
				[ 0.8 WrinkleNorm ]
			}
	}
	finish { specular 0.3 roughness 0.1 }
}

#declare SmoothTex = texture {
	pigment { 
		gradient y
		color_map {
			[0 rgb <0,0.35,0> ]
			[1 rgb <0,0.8,0> ]
		}
	}
	finish { specular 0.3 roughness 0.1 }
}

#declare OuterTex = texture { WrinklyTex }

#declare InnerTex = texture {
	pigment {
		bozo
		color_map {
			[0 rgb <0.3,0.1,0> ]
			[1 rgb <0.8,0.5,0> ]
		}
	}
	normal {
		bumps 0.5
	}
	finish {
		specular 0.1 roughness 0.1 
	}
}


// These are quick and dirty, and wrong. But they were good enough for this scene...
#macro GrassBlade( Count, Height, ZDepth, ZOffset)
blob {
	threshold 0.75
	#local BladeCount = 0;
	#local BladeMax = Count;
	#while( BladeCount < BladeMax )
		#local BladeWidth = 0.05+( sin( pi*(0.5+0.5*(BladeCount/BladeMax)) )*0.95);
		#local BladeZ = sin( pi*(BladeCount/BladeMax) )*ZDepth+ZOffset*(BladeCount/BladeMax);
		#local BladeY = (BladeCount/BladeMax)*Height;
//		#debug concat( "Blade width: ", str( BladeWidth, 1, 3 ) )
//		#debug concat( " Blade Z: ", str( BladeZ, 1, 3) )
//		#debug concat( " Height: ", str( BladeY, 1, 3 ), "\n" )
		sphere { <0,0,0>, 1 strength 2 
			translate z*0.25
			scale <2.5*BladeWidth,BladeWidth,BladeWidth> 
			translate <0,BladeY,BladeZ>
		}
		cylinder { <0,-1,0>, <0,1,0>, 1 strength -3 
			translate z*-0.25
			scale <2.5*BladeWidth,1,BladeWidth> 
			translate <0,BladeY,BladeZ-BladeWidth/2>
			texture { InnerTex }
		}
		#local BladeCount = BladeCount+1;
	#end
	texture { OuterTex 
		scale Height+1 
		translate y*-1
	}
	scale <0.25,1,1>
	//translate z*0.7
	//scale 0.85
}
#end


#macro GrassBlade2( Count, Height, ZDepth, ZOffset, Power)
blob {
	threshold 0.75
	#local BladeCount = 0;
	#local BladeMax = Count;
	#while( BladeCount < BladeMax*0.75 )
		#local BladeWidth = 0.05+( pow( sin( pi*(0.35+0.65*(BladeCount/BladeMax)) ), Power )*0.95);
		#local BladeZ = pow( sin( pi*(BladeCount/BladeMax) ), 1 )*ZDepth+ZOffset*(BladeCount/BladeMax);
		#local BladeY = (BladeCount/BladeMax)*Height;
//		#debug concat( "Blade width: ", str( BladeWidth, 1, 3 ) )
//		#debug concat( " Blade Z: ", str( BladeZ, 1, 3) )
//		#debug concat( " Height: ", str( BladeY, 1, 3 ), "\n" )
		sphere { <0,0,0>, 1 strength 2 
			translate z*0.25
			scale <2.5*BladeWidth,BladeWidth,BladeWidth> 
			translate <0,BladeY,3*BladeZ>
		}
		cylinder { <0,-1,0>, <0,1,0>, 1 strength -3 
			translate z*-0.25
			scale <2.5*BladeWidth,1,BladeWidth> 
			translate <0,BladeY,3*(BladeZ-BladeWidth/2)>
			texture { InnerTex }
		}
		#local BladeCount = BladeCount+1;
	#end
	sturm
	texture { OuterTex 
		scale Height+1 
		translate y*-1
		scale 0.75
	}
	scale <0.25,1,1>
	//translate z*0.7
	//scale 0.85
}
#end


#local LightGreenPigment = pigment {
	bozo
	color_map {
		[ 0 rgb <0.468437, 0.873304, 0.270603> ]
		[ 1 rgb <0.648005, 0.800900, 0.381399> ]
	}
	scale <0.1,0.25,0.1>
}

#local GreenPigment = pigment {
	bozo
	color_map {
		[ 0 rgb <0.154009, 0.325795, 0.106966> ]
		[ 1 rgb <0.421012, 0.615381, 0.110292> ]
	}
	scale <0.1,0.25,0.1>
}

#local DarkGreenPigment = pigment {
	bozo
	color_map {
		[ 0 rgb <0.184192, 0.633478, 0.117906>*0.8 ]
		[ 1 rgb <0.244846, 0.325795, 0.102251>*0.8 ]
	}
	scale <0.1,0.25,0.1>
}

#local BrownPigment = pigment {
	bozo
	color_map {
		[ 0 rgb <0.330312, 0.251637, 0.081727> ]
		[ 1 rgb <0.466056, 0.355047, 0.115312> ]
	}
	scale <0.1,0.25,0.1>
}

#local LightBrownPigment = pigment {
	bozo
	color_map {
		[ 0 rgb <0.619913, 0.589807, 0.229297> ]
		[ 1 rgb <0.766796, 0.778286, 0.219257> ]
	}
	scale <0.1,0.25,0.1>
}

#declare NeedleTex = texture {
	pigment { 
		gradient y
		pigment_map {
			[ 0.6 GreenPigment ]
			[ 0.8 BrownPigment ]
		}
	}
	normal {
		average 
			0.5 //amount
			normal_map {
				[ 0.2 BumpNorm ]
				[ 0.8 WrinkleNorm ]
			}
			scale 0.1
	}
	finish { specular 0.3 roughness 0.1 }
}

#declare GrassTex = texture {
	pigment { 
		gradient y
		pigment_map {
			[ 0.15 LightGreenPigment scale 0.2 ]
			[ 0.5 DarkGreenPigment scale 0.2 ]
			[ 0.6 DarkGreenPigment scale 0.2 ]
			[ 0.75 BrownPigment scale 0.2]
		}
	}
	normal {
		average 
			0.5 //amount
			normal_map {
				[ 0.1 BumpNorm ]
				[ 0.7 WrinkleNorm ]
			}
			scale <0.1,0.3,0.1>
	}
	finish { specular 0.3 roughness 0.1 }
}

#declare DriedGrassTex = texture {
	pigment { 
		gradient y
		pigment_map {
			[ 0.1 DarkGreenPigment ]
			[ 0.4 LightBrownPigment ]
			[ 0.6 LightBrownPigment ]
			[ 0.75 BrownPigment ]
		}
	}
	normal {
		average 
			0.5 //amount
			normal_map {
				[ 0.1 BumpNorm ]
				[ 0.7 WrinkleNorm ]
			}
			scale <0.1,0.3,0.1>
	}
	finish { specular 0.3 roughness 0.1 }
}

#declare YoungGrassTex = texture {
	pigment { 
		gradient y
		pigment_map {
			[ 0.15 LightGreenPigment scale 0.075 ]
			[ 0.8 DarkGreenPigment scale 0.075 ]
		}
	}
	normal {
		average 
			0.5 //amount
			normal_map {
				[ 0.1 BumpNorm ]
				[ 0.7 WrinkleNorm ]
			}
			scale <0.1,0.3,0.1>
	}
	finish { specular 0.3 roughness 0.1 }
}


#declare OuterTex = texture { NeedleTex }

#declare TheNeedle = object { GrassBlade( 40, 8, 0.99, -0.75 ) scale <0.35,1,0.25> }

#declare InnerTex = texture {
	pigment {
		bozo
		color_map {
			[0 rgb <0.3,0.1,0> ]
			[1 rgb <0.8,0.5,0> ]
		}
	}
	normal {
		bumps 0.5
	}
	finish {
		specular 0.1 roughness 0.1 
	}
}

#ifndef( GrassBlades )
#declare GrassBlades = 20;
#end

#macro GrassBush( Location, Seed )
	#local GrassCount= 0;
	#local GRand = seed( Seed );
	union {
	#while( GrassCount < GrassBlades )
		object { 
			#if( rand(GRand) < GrassDriedPercent )
				#declare OuterTex = texture { DriedGrassTex }
			#else
				#declare OuterTex = texture { GrassTex }
			#end
			GrassBlade( 40, 6.5+1.75*rand(GRand), 0.9, -0.5-0.1*rand(GRand) ) scale <0.175,1,0.25>
			translate y*0.1*rand(GRand)
			#if( rand(GRand) < 0.125 )
				rotate y*180
			#end
			rotate x*-15 
			scale <0.9+0.1*rand(GRand),0.5+0.5*rand(GRand),0.9+0.1*rand(GRand)>
			rotate x*-(95*pow( rand(GRand), 2 )-20)
			translate y*0.05
			translate z*-0.5
			rotate y*(30*rand(GRand)-15)
			//rotate y*90 
			rotate y*360*(GrassCount/GrassBlades)
			scale GrassScaleFactor
		}
		#local GrassCount = GrassCount+1;
	#end
	#local GrassCount = 0;
	#if( GrassPebbles )
		#while( GrassCount < GrassBlades )
			#local PebbleRand = seed( Seed+GrassCount );
			#if( rand( PebbleRand ) < 0.75 )
				object {
					Pebble( int(rand(PebbleRand)*100000) )
					scale 1.25
					translate <0,0.1*rand(PebbleRand)-0.075,-(0.7+0.75*rand(PebbleRand))>
					rotate y*360*(GrassCount/GrassBlades)
					scale GrassScaleFactor
					texture { GroundTexture translate -Location }
				}
			#end
			#local GrassCount = GrassCount+1;	
		#end
	#end			
	translate Location
	}
#end

#declare OuterTex = texture { WrinklyTex }
#ifndef( PlantScaleFactor )
#declare PlantScaleFactor = 1;
#end


#macro Plant( Location, Seed )
union {
	#local PlantRand = seed( Seed );
	#local Leaves = 4+int( 3*rand( PlantRand ) );
	#local LeafCount = 0;
	#while( LeafCount < Leaves )
		#declare OuterTex = texture { OuterTex translate <10000*rand( PlantRand ),0,10000*rand(PlantRand)> }
		#declare InnerTex = texture { InnerTex  }
		#local XScale = 1.75+0.5*rand( PlantRand );
		#local YScale = 1+0.2*rand( PlantRand );
		#local ZScale = 0.3+0.4*rand( PlantRand );
		#local ZOffset = 0.5*rand( PlantRand )-0.25;
		object { 
			GrassBlade2( 40, 8, 1.5, ZOffset, 4 ) 
			translate y*0.6
			translate z*-0.9
			scale <XScale,YScale,ZScale> 
			translate z*-XScale*0.75
			#local XRot = -(60+25*(1-pow( rand( PlantRand ), 2)) );
			#local YRot = 360*(LeafCount/(Leaves+1))+(15-30*rand(PlantRand));
			rotate x*XRot 
			rotate y*YRot
		}
		#local LeafCount = LeafCount+1;
	#end
	#if( rand( PlantRand ) < 0.5 )
		#declare OuterTex = texture { OuterTex translate <10000*rand( PlantRand ),0,10000*rand(PlantRand)> }
		#local XScale = 1.75+0.5*rand( PlantRand );
		#local YScale = 1+0.2*rand( PlantRand );
		#local ZScale = 0.3+0.4*rand( PlantRand );
		object { 
			GrassBlade( 40, 4, 0.9, 0 ) 
			translate z*-0.9
			scale <XScale,YScale,ZScale> 
			#local XRot = -(15+35*pow( rand( PlantRand ), 2) );
			#local YRot = 360*rand(PlantRand);
			rotate x*XRot 
			rotate y*YRot
		}	
	#end
	translate y*0.5
	scale 0.75+0.5*rand( PlantRand )
	scale PlantScaleFactor
	translate Location
}
#end

#declare Needle = union {
	object { TheNeedle rotate y*90 rotate z*-10 rotate x*2 }
	object { TheNeedle scale <1,0.97,0.9> rotate y*-90 rotate z*5 }
	blob {
		threshold 0.75
		cylinder {
			<0,-1.5,0> <0,0,0>, 1 strength 2
		}
		sphere {
			<0,-0.25,0>, 1 strength 2
		}
		scale <0.3,0.4,0.3>
		texture { 
			pigment { BrownPigment }
			normal {
				bumps 0.5
				scale <0.1,0.075,0.1>
			}
			finish {
				specular 0.1 roughness 0.1 
			}
		}
		translate y*-0.3
	}	
}
