// start with textures used for dandelion

#declare stemf = function {y/12}
#declare stemTex = texture {
    pigment {
        function {stemf(x,y,z)}
        color_map {
            [0.00 color <0.55,0.35,0.35>]
            [0.25 color <0.5,0.55,0.15>]
            [1.00 color <0.60,0.55,0.15>]
        }
    }
    finish {
       ambient 0.3
       diffuse 0.5
       specular 0.05
       roughness 0.15
    }
}

#declare seedTex = texture {
    pigment {
        function {stemf(x,y,z)}
        color_map {
            [0.00 color <0.55,0.5,0.5>]
            [0.25 color <0.60,0.65,0.45>]
            [1.00 color <0.55,0.65,0.45>]
        }
    }
    finish {
       ambient 0.5
       diffuse 0.6
       specular 0.05
       roughness 0.15
    }
    normal {
        bumps 1.0
        scale <10,50,10>
    }
    scale 0.1
}

#declare leafTex = texture {
    pigment {
        bozo
        turbulence 0.5
        color_map {
            [0.00 color <0.3,0.15,0.20>]
            [0.95 color <0.40,0.35,0.05>]
            [0.97 color <0.40,0.35,0.05>]
            [1.00 color <0.3,0.15,0.20>]
        }
    }
    finish {
       ambient 0.3
       diffuse 0.6
    }
    normal {
        bumps 1.0
    }
    scale <1,5,1>
}


#declare filTex = texture {
    pigment {color rgb <1,1,1>}
    finish {
       ambient 0.5
       diffuse 0.6
       specular 0.05
       roughness 0.15
    }
}

#declare seedheadTex = texture {
    pigment {
        granite
        turbulence 1.0
        color_map {
            [0.0 color <0.36,0.4,0.35>]
            [0.5 color <0.55,0.6,0.5>]
            [1.0 color <0.36,0.4,0.35>]
        }
    }
    finish {
       ambient 0.3
       diffuse 0.6
       specular 0.05
       roughness 0.15
    }
    scale 0.1
}
// finished with textures

// start with shapes
#declare stem = sphere_sweep {
    cubic_spline
    6
    <0,-3,-0.2>,0.2
    <0,0,0>,0.12
    <0,3,0.8>,0.08
    <0,6,2.0>,0.06
    <0,9,2.8>,0.03
    <0,12,3.2>,0.001
    translate <0,0.12,0>
    texture {stemTex}
    translate <0,-0.12,0>
}

#declare seedhead = sphere {<0,0,0>,0.15 texture {seedheadTex}}
#declare seedhead = union {
    object {seedhead}
    #declare loopI = 1;
    #while(loopI<=10)
        #declare loopJ = 2;
        #while(loopJ<=10)
                #declare temprot1 = mod(36*loopI+2*pow(loopJ,2),360);
                #declare temprot2 = loopJ*15-7.5;
                object {sphere{<0,0,0>,0.0075} translate y*0.15 rotate <0,0,temprot2> rotate <0,temprot1,0> pigment {color <0.25,0.25,0.25>}}
            #declare loopJ = loopJ+1;
        #end
        #declare loopI = loopI + 1;
    #end
}

#declare seedhead = object {
    seedhead
    scale <1,0.7,1>
}

#declare seedhead = union {
    object {seedhead}
    #declare loopI = 1;
    #while(loopI<=12)
            sphere_sweep {
                cubic_spline
                6
                <rand(R2)/20-0.025,0.15,12+rand(R2)/.2>,0.05 
                <rand(R2)/20-0.025,0,10+rand(R2)/.2>,0.05
                <rand(R2)/20-0.025,-0.15,12+rand(R2)/.2>,0.033
                <rand(R2)/20-0.025,-0.30,12+rand(R2)/.2>,0.017
                <rand(R2)/20-0.025,-0.45,12+rand(R2)/.2>,0.00
                <rand(R2)/20-0.025,-0.60,12+rand(R2)/.2>,0.00
                scale <1,1,0.01>
                translate <0,-0.005,-.02>
                texture {leafTex}
                rotate <0,loopI*30>
            }
        #declare loopI = loopI + 1;
    #end
}
#declare seedhead2 = seedhead
        
#declare loopI = 1;
#while(loopI<=10)
    #declare loopJ = 2;
    #while(loopJ<=10)
        #declare seed1 = union {
            union {
                cone {<0,0,0>,0.007,<0,0.1,0>,0.01}
                sphere {<0,0,0>,0.007}
                sphere {<0,0.1,0>,0.01}
                cylinder {<0,0.1,0>,<0,0.4,0>,0.0035}
                texture {seedTex}
            }
            #declare loopK = 0;
            #while(loopK<=25)
                cylinder { <0,0,0>,<0,0,0.2>,0.001 rotate <-30*rand(R1)-30,0,0> rotate <0,360*rand(R1),0> translate <0,0.4,0> texture {filTex}}
                #declare loopK = loopK + 1;
            #end
            pigment {White}
        }
            #declare temprot1 = mod(36*loopI+2*pow(loopJ,2),360);
            #declare temprot2 = loopJ*15-7.5;
            #if (temprot2 > 60)
                #declare seedhead2 = union {
                    object {seedhead2}
                    object {seed1 translate y*0.075 rotate <0,0,temprot2> rotate <0,temprot1,0> translate -y*cos(temprot2*pi/180)*.3*.075}
                }
            #else
            #end
        #declare loopJ = loopJ+1;
    #end
    #declare loopI = loopI + 1;
#end

#declare dandelion = union {    
    object {
        seedhead2
        rotate <12,0,0>
        translate <0,9,2.8>
    }
    object {stem}
}

#declare loopI = 0;
#while (loopI<=17)
    #declare seed1 = union {
        union {
            cone {<0,0,0>,0.007,<0,0.1,0>,0.01}
            sphere {<0,0,0>,0.007}
            sphere {<0,0.1,0>,0.01}
            cylinder {<0,0.1,0>,<0,0.4,0>,0.0035}
            texture {seedTex}
        }
        #declare loopK = 0;
        #while(loopK<=25)
            cylinder { <0,0,0>,<0,0,0.2>,0.001 rotate <-30*rand(R1)-30,0,0> rotate <0,360*rand(R1),0> translate <0,0.4,0> texture {filTex}}
            #declare loopK = loopK + 1;
        #end
    }
    #declare dandelion = union {
        object {dandelion}
        object {seed1 rotate <30+100*rand(R1),0,180*rand(R1)-90> translate z*(1+11*rand(R1)) rotate x*(-20*rand(R1)) rotate y*(20*rand(R1)-10) translate <0,9,2.8>}
    }
    #declare loopI = loopI + 1;
#end

object {dandelion translate <-30,0,-8.5> }

//next ones
#declare seedhead2 = seedhead
#declare loopI = 1;
#while(loopI<=10)
    #declare loopJ = 2;
    #while(loopJ<=10)
        #declare seed1 = union {
            union {
                cone {<0,0,0>,0.007,<0,0.1,0>,0.01}
                sphere {<0,0,0>,0.007}
                sphere {<0,0.1,0>,0.01}
                cylinder {<0,0.1,0>,<0,0.4,0>,0.0035}
                texture {seedTex}
            }
            #declare loopK = 0;
            #while(loopK<=25)
                cylinder { <0,0,0>,<0,0,0.2>,0.001 rotate <-30*rand(R1)-30,0,0> rotate <0,360*rand(R1),0> translate <0,0.4,0> texture {filTex}}
                #declare loopK = loopK + 1;
            #end
            pigment {White}
        }
            #declare temprot1 = mod(36*loopI+2*pow(loopJ,2),360);
            #declare temprot2 = loopJ*15-7.5;
            #if (temprot2 > 0)
                #declare seedhead2 = union {
                    object {seedhead2}
                    object {seed1 translate y*0.075 rotate <0,0,temprot2> rotate <0,temprot1,0> translate -y*cos(temprot2*pi/180)*.3*.075}
                }
            #else
            #end
        #declare loopJ = loopJ+1;
    #end
    #declare loopI = loopI + 1;
#end

#declare dandelion2 = union {    
    object {
        seedhead2
        rotate <12,0,0>
        translate <0,9,2.8>
    }
    object {stem}
    rotate <0,30,0>
}
object {dandelion2 rotate <20,0,0> translate <-29,-1,-9> }
object {dandelion2 rotate <0,90,0> translate <-45,0,9> }

//bare ones
#declare dandelion3 = union {    
    object {seedhead
        rotate <12,0,0>
        translate <0,9,2.8>
    }
    object {stem}
}
object {dandelion3 rotate <0,80,0> translate <-55,0,-3.8>}
object {dandelion3 rotate <0,240,0> translate <-55.5,0,-3.3>}

//finished with dandelions
