#include "colors.inc"  

global_settings {
    max_trace_level 5
    ambient_light color<1,1,1>    
}

camera {
    location <-20,6,0>
    look_at <-30,7,0>
    up y
    right x*1.33
}

background {color <0.6,0.6,1>}
sphere {
    <0,0,0>,10000
    pigment {
        bozo
        turbulence 0.65
        octaves 6
        omega 0.7
        lambda 2
        color_map {
            [0.0 0.1 color rgb <0.85,0.85,0.85>
                     color rgb <0.75,0.75,0.75>]
            [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                     color rgbt <1,1,1,1>]
            [0.5 1.0 color rgbt <1,1,1,1>
                     color rgbt <1,1,1,1>]
        }
        scale <2,1,2>*800
    }
    finish {
        ambient 1.0
        diffuse 1.0
    }
    no_shadow
}        


light_source {
    <80000,80000,80000>
    color White
    area_light <1000,0,0>,<0,0,1000>,4,4
    jitter
}

// Begin Dandelion
#declare R1 = seed(1);
#declare R2 = seed(2);
#declare R3 = seed(3);
#include "dandelion.inc"
// Dandelion done


// Begin Grass
#declare R1 = seed(1);
#declare R2 = seed(1);
#declare R3 = seed(1);
#include "grass.inc"
// Grass done

// Flying Ant
#include "ant.inc"
#declare seed2 = union {
    union {
        cone {<0,0,0>,0.007,<0,0.1,0>,0.01}
        sphere {<0,0,0>,0.007}
        sphere {<0,0.1,0>,0.01}
        cylinder {<0,0.1,0>,<0,0.4,0>,0.0035}
        texture {seedTex}
    }
    #declare loopK = 0;
    #while(loopK<=25)
        cylinder { <0,0,0>,<0,0,0.2>,0.001 rotate <-30*rand(R1)-30,0,0> rotate <0,360*rand(R1),0> translate <0,0.4,0> texture {filTex}}
        #declare loopK = loopK + 1;
    #end
}

#declare flyingAnt = union {
    object {seed2}
    object {ant scale 0.0002 translate <0,0,0.03> translate <0,0.15,0>}
    rotate <30,0,0> translate <-29,9,0>
}
flyingAnt
// Flying Ant done
