#include "palmen.inc"

global_settings {
   adc_bailout 0.0039216
   assumed_gamma 2
}

#declare Gold = texture {
   pigment {
      color rgb <0.984314, 0.890196, 0.635294>
   }
   
   finish {
      ambient rgb <0.160784, 0.14902, 0.0745098>
      diffuse 0.9
      brilliance 2
      phong 1
      metallic 1
      specular 0.5
      reflection rgb <0.184314, 0.164706, 0.121569>
      irid { 0
      thickness 0
      turbulence 0 } 
   }
}

texture {
   pigment {
      granite
      turbulence <0.6, 0.6, 0.6>
      
      color_map {
         [ 0 color rgbt <1, 0.99216, 0.98039, 1>
         ]
         [ 0.7 color rgbt <0.97255, 0.98431, 0.84706, 0.9>
         ]
         [ 0.8 color rgbt <0.71765, 0.64314, 0.51372, 0.95>
         ]
         [ 0.95 color rgbt <0.18039, 0.16471, 0.11373, 0.9>
         ]
         [ 1 color rgbt <0.18039, 0.22353, 0.18431, 1>
         ]
      }
      scale 2
   }
}

#declare Stahl = texture {
   pigment {
      color rgb <0.74902, 0.741176, 0.72549>
   }
   
   finish {
      ambient rgb <0.160784, 0.14902, 0.0745098>
      diffuse 0.9
      brilliance 2
      phong 1
      metallic 1
      specular 0.5
      reflection rgb <0.184314, 0.164706, 0.121569>
      irid { 0
      thickness 0
      turbulence 0 } 
   }
}

#declare Ziegel = texture {
   normal {
      agate
      0.16
      agate_turb 0.5
      turbulence <0.4, 0.4, 0.4>
      scale 0.2
   }
   
   finish {
      ambient rgb <0.027451, 0.027451, 0.027451>
      diffuse 1.5
      brilliance 1
   }
   
   pigment {
      wrinkles
      turbulence <0.6, 0.6, 0.6>
      
      color_map {
         [ 0 color rgb <1, 0.992157, 0.980392>
         ]
         [ 0.7 color rgb <0.972549, 0.984314, 0.847059>
         ]
         [ 0.8 color rgb <0.717647, 0.643137, 0.513725>
         ]
         [ 0.95 color rgb <0.286275, 0.262745, 0.180392>
         ]
         [ 1 color rgb <0.286275, 0.352941, 0.290196>
         ]
      }
      scale 1
   }
}

#declare Steinmauer = texture {
   brick
   
   texture {
      finish {
      }
      
      pigment {
         color rgb <0.372549, 0.345098, 0.305882>
      }
   }
   
   texture {
      Ziegel
   }
   brick_size <0.42, 0.15, 0.42>
   mortar 0.02
   translate z*(-0.14)
}

#declare weisse_Mauer = texture {
   normal {
      granite
      0.02
   }
   
   pigment {
      wrinkles
      turbulence <0.6, 0.6, 0.6>
      
      color_map {
         [ 0 color rgb <1, 0.992157, 0.980392>
         ]
         [ 0.7 color rgb <0.972549, 0.984314, 0.847059>
         ]
         [ 0.8 color rgb <0.898039, 0.803922, 0.643137>
         ]
         [ 0.95 color rgb <0.686275, 0.627451, 0.431373>
         ]
         [ 1 color rgb <0.541176, 0.67451, 0.556863>
         ]
      }
      scale 1
   }
   
   finish {
      ambient rgb <0.0901961, 0.0901961, 0.0901961>
      diffuse 1.5
      brilliance 1
      crand 0.05
   }
   scale 4
}

#declare weisse_Mauer_innen = texture {
   pigment {
      color rgb <0.929412, 0.929412, 0.929412>
   }
   
   finish {
      ambient rgb <0.0352941, 0.0352941, 0.0352941>
      diffuse 0.8
      brilliance 1
      crand 0.05
   }
}

#declare Zylinderdach = texture {
   normal {
      granite
      0.02
   }
   
   pigment {
      wrinkles
      turbulence <0.6, 0.6, 0.6>
      
      color_map {
         [ 0 color rgb <1, 0.988235, 0.913725>
         ]
         [ 0.7 color rgb <0.972549, 0.984314, 0.847059>
         ]
         [ 0.8 color rgb <0.717647, 0.643137, 0.513725>
         ]
         [ 0.95 color rgb <0.180392, 0.164706, 0.113725>
         ]
         [ 1 color rgb <0.180392, 0.223529, 0.184314>
         ]
      }
      scale 1
   }
   
   finish {
      ambient rgb <0.0901961, 0.0901961, 0.0901961>
      diffuse 1.5
      brilliance 1
      crand 0.05
   }
   scale 4
}

#declare Bordure = texture {
   normal {
      granite
      0.02
   }
   
   pigment {
      spiral2 0
      
      color_map {
         [ 0 color rgbt <1, 0.21961, 0.21961, 0.6>
         ]
         [ 0.3 color rgbt <1, 0.41961, 0.41961, 0.6>
         ]
         [ 0.4 color rgbt <0.52549, 0.60784, 0.78039, 0.6>
         ]
         [ 0.5 color rgbt <0.52549, 0.60784, 0.78039, 1>
         ]
         [ 0.8 color rgbt <1, 1, 1, 1>
         ]
         [ 1 color rgbt <1, 1, 1, 1>
         ]
      }
      scale 0.05
      rotate y*45
   }
   
   finish {
      ambient rgb <0.0901961, 0.0901961, 0.0901961>
      diffuse 1
      brilliance 1
      crand 0.05
   }
   scale 4
}

#declare Strassenpflaster = texture {
   pigment {
      crackle
      
      color_map {
         [ 0 color rgb <0.180392, 0.172549, 0.0313725>
         ]
         [ 0.1 color rgb <0.615686, 0.501961, 0.396078>
         ]
      }
   }
   
   normal {
      crackle
      0.5
   }
}

#declare Tuer_rund = union {
   box {
      //*PMName Tr
      <-0.4, -0.5, -0.31>, <0.4, 1.5, 0.31>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      //*PMName Trbogen
      <0, 1.5, -0.31>, <0, 1.5, 0.31>, 0.4
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare Tuerbogen = union {
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.8
      rotate <0, 0, 0>
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.8
      rotate z*10
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.8
      rotate z*20
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.8
      rotate z*30
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.8
      rotate z*(-10)
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.8
      rotate z*(-20)
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.8
      rotate z*(-30)
   }
   translate <0, 1.06, -0.05>
   
   texture {
      Ziegel
   }
}

#declare Tuerstufen = union {
   box {
      <-0.5, -0.5, -0.7>, <0.5, -0.2, 0.3>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.4, -0.2, -0.3>, <0.4, 0.1, 0.3>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      weisse_Mauer
   }
}

#declare Fenster_rund = union {
   box {
      //*PMName Fenster
      <-0.25, 1.2, -0.3>, <0.25, 1.75, 0.3>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      //*PMName Fensterbogen
      <0, 1.75, -0.3>, <0, 1.75, 0.3>, 0.25
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare Fensterbogen = union {
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.5
      rotate <0, 0, 0>
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.5
      rotate z*15
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.5
      rotate z*30
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.5
      rotate z*(-15)
   }
   
   box {
      //*PMName Ziegel
      <-0.075, 0, 0>, <0.075, 0.42, 0.42>
      scale 1
      translate y*0.5
      rotate z*(-30)
   }
   translate <0, 1.46, -0.05>
   
   texture {
      Ziegel
   }
}

#declare Fensterbrett = box {
   <-0.3, 1.05, 0.3>, <0.3, 1.21, -0.35>
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
   
   texture {
      weisse_Mauer
   }
}

#declare Treppe = union {
   //*PMName Treppe
   
   box {
      <0, -0.5, 0>, <5.5, -0.2, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, -0.2, 0>, <5, 0, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 0, 0>, <4.6, 0.2, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 0.2, 0>, <4.2, 0.4, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 0.4, 0>, <3.8, 0.6, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 0.6, 0>, <3.4, 0.8, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 0.8, 0>, <3, 1, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 1, 0>, <2.6, 1.2, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 1.2, 0>, <2.2, 1.4, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 1.4, 0>, <1.8, 1.62, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 1.62, 0>, <1.4, 1.87, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 1.87, 0>, <1, 2.05, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0, 2.05, 0>, <0.6, 2.3, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   texture {
      weisse_Mauer
   }
}

#declare Haus_5_unten = difference {
   box {
      <0, -0.5, 0>, <5, 2.5, 5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <0.4, -0.1, 0.4>, <4.6, 2.1, 4.6>
      
      texture {
         weisse_Mauer_innen
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      //*PMName Fenster 1
      Fenster_rund
      scale 1
      rotate <0, 0, 0>
      translate <1.5, 0, 0.2>
   }
   
   object {
      //*PMName Fenster 2
      Fenster_rund
      scale 1
      rotate <0, 0, 0>
      translate <3.5, 0, 0.2>
   }
   
   texture {
      weisse_Mauer
   }
}

#declare Haus_10_zyl = union {
   difference {
      //*PMName Etage
      
      box {
         <0, -0.5, 0>, <10, 2.5, 5>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      box {
         <0.4, -0.1, 0.4>, <9.6, 2.1, 4.6>
         
         texture {
            weisse_Mauer_innen
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Fenster 1
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0, 0.2>
      }
      
      object {
         //*PMName Fenster 2
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <3.5, 0, 0.2>
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale 1
         rotate <0, 0, 0>
         translate <6, 0, 0.2>
      }
      
      object {
         //*PMName Fenster 3
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <8.5, 0, 0.2>
      }
      
      object {
         //*PMName Fenster h1
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0, 4.8>
      }
      
      object {
         //*PMName Fenster h2
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <3.5, 0, 4.8>
      }
      
      object {
         //*PMName Fenster h3
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <6.5, 0, 4.8>
      }
      
      object {
         //*PMName Fenster h4
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <8.5, 0, 4.8>
      }
      
      texture {
         weisse_Mauer
      }
   }
   
   difference {
      intersection {
         //*PMName Dach
         
         cylinder {
            <-1, 0, 2.5>, <11, 0, 2.5>, 2.2
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <5, 0, -1>, <5, 0, 6>, 4.7
            scale <1, 0.6, 1>
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.1, 0, -0.1>, <10.1, 2.7, 5.1>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         texture {
            Zylinderdach
         }
      }
      
      cylinder {
         <2.2, 0, 2.5>, <7.8, 0, 2.5>, 1.9
         
         texture {
            weisse_Mauer_innen
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Dachfenster
         Fenster_rund
         scale <0.5, 0.5, 1>
         rotate <0, 0, 0>
         translate <3.5, -0.6, 4.6>
      }
      
      object {
         //*PMName Dachfenster
         Fenster_rund
         scale <0.5, 0.5, 1>
         rotate <0, 0, 0>
         translate <6.5, -0.6, 4.6>
      }
      
      object {
         //*PMName Dachfenster
         Fenster_rund
         scale <0.5, 0.5, 1>
         rotate <0, 0, 0>
         translate <3.5, -0.6, 0.4>
      }
      
      object {
         //*PMName Dachfenster
         Fenster_rund
         scale <0.5, 0.5, 1>
         rotate <0, 0, 0>
         translate <6, -0.6, 0.4>
      }
      scale <1, 0.75, 1>
      translate y*2.5
   }
   
   box {
      //*PMName Bordure
      <-0.001, 2.2, -0.001>, <10.001, 2.4, 5.001>
      
      texture {
         Bordure
      }
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      //*PMName Trstufen
      Tuerstufen
      scale 1
      rotate <0, 0, 0>
      translate <6, 0, 0.2>
   }
   
   object {
      //*PMName Fensterbrett 1
      Fensterbrett
      scale 1
      rotate <0, 0, 0>
      translate <1.5, 0, 0.2>
   }
   
   object {
      //*PMName Fensterbrett 2
      Fensterbrett
      scale 1
      rotate <0, 0, 0>
      translate <3.5, 0, 0.2>
   }
   
   object {
      //*PMName Fensterbrett 3
      Fensterbrett
      scale 1
      rotate <0, 0, 0>
      translate <8.5, 0, 0.2>
   }
   
   object {
      //*PMName Fensterbrett h1
      Fensterbrett
      scale 1
      rotate y*180
      translate <1.5, 0, 4.8>
   }
   
   object {
      //*PMName Fensterbrett h2
      Fensterbrett
      scale 1
      rotate y*180
      translate <3.5, 0, 4.8>
   }
   
   object {
      //*PMName Fensterbrett h3
      Fensterbrett
      scale 1
      rotate y*180
      translate <6.5, 0, 4.8>
   }
   
   object {
      //*PMName Fensterbrett h4
      Fensterbrett
      scale 1
      rotate y*180
      translate <8.5, 0, 4.8>
   }
   
   texture {
      Steinmauer
   }
}

#declare Haus_15_stufig = union {
   union {
      //*PMName Teil 1
      
      difference {
         //*PMName Dach
         
         box {
            //*PMName auen
            <0, 3.5, 0>, <5, 4, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName innen
            <0.4, 3.5, 0.4>, <4.6, 4.1, 4.6>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Durchgang
            <5.1, 3.5, 2.1>, <4.5, 4.1, 2.9>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      difference {
         //*PMName Basis
         
         box {
            //*PMName auen
            <0, -0.5, 0>, <5, 3.5, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName innen
            <0.4, -0.1, 0.4>, <4.6, 3.1, 4.6>
            
            texture {
               weisse_Mauer_innen
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Kerbe
            <0, 0, 0>, <0.42, 0.15, 0.42>
            scale 1
            rotate <0, 0, 0>
            translate <-0.21, 1.03, -0.05>
         }
         
         box {
            //*PMName Kerbe
            <0, 0, 0>, <0.43, 0.16, 0.43>
            scale 1
            rotate <0, 0, 0>
            translate <-0.01, 2.08, -0.21>
         }
         
         object {
            //*PMName Fenster 1
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <1.5, 0, 0.2>
         }
         
         object {
            //*PMName Fenster 2
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <3.5, 0, 0.2>
         }
      }
      
      object {
         //*PMName Fensterbrett 1
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen 1
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*1.5
      }
      
      object {
         //*PMName Fensterbrett 2
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <3.5, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen 2
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*3.5
      }
      translate z*(-0.5)
   }
   
   union {
      //*PMName Teil 2
      
      difference {
         //*PMName Dach
         
         box {
            <0, 3, 0>, <5, 3.5, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.4, 3, 0.4>, <4.6, 3.6, 4.6>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.1, 3, 2.1>, <0.5, 3.25, 2.9>
            scale 1
            rotate <0, 0, 0>
            translate z*(-0.5)
         }
         
         box {
            <4.5, 3, 2.1>, <5.1, 3.6, 2.9>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      difference {
         //*PMName Basis
         
         box {
            <0, -0.5, 0>, <5, 3, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.4, -0.1, 0.4>, <4.6, 2.6, 4.6>
            
            texture {
               weisse_Mauer_innen
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            //*PMName Fenster 1
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <1.5, 0, 0.2>
         }
         
         object {
            //*PMName Tr
            Tuer_rund
            scale 1
            rotate <0, 0, 0>
            translate <3.5, 0, 0.2>
         }
      }
      
      object {
         //*PMName Fensterbrett
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*1.5
      }
      
      object {
         //*PMName Trstufen
         Tuerstufen
         scale 1
         rotate <0, 0, 0>
         translate <3.5, 0, 0.2>
      }
      
      object {
         //*PMName Trbogen
         Tuerbogen
         scale 1
         rotate <0, 0, 0>
         translate x*3.5
      }
      translate x*5
   }
   
   union {
      //*PMName Teil 3
      
      difference {
         //*PMName Dach
         
         box {
            <0, 2.5, 0>, <5, 3, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.4, 2.5, 0.4>, <4.6, 3.1, 4.62>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <-0.1, 2.25, 2.1>, <0.5, 3.1, 2.9>
            scale 1
            rotate <0, 0, 0>
            translate z*(-0.5)
         }
         
         box {
            <4.5, 2.5, 3.8>, <5.1, 3.1, 4.62>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      difference {
         //*PMName Basis
         
         box {
            <0, -0.5, 0>, <5, 2.5, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.4, -0.1, 0.4>, <4.6, 2.1, 4.6>
            
            texture {
               weisse_Mauer_innen
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            //*PMName Fenster 1
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <1.52, 0, 0.2>
         }
         
         object {
            //*PMName Fenster 2
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <3.54, 0, 0.2>
         }
      }
      
      object {
         //*PMName Fensterbrett 1
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <1.52, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen 1
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*1.52
      }
      
      object {
         //*PMName Fensterbrett 2
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <3.54, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen 2
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*3.54
      }
      translate <10, 0, 0.5>
   }
   
   object {
      //*PMName Treppe zum Dach
      Treppe
      scale 1
      rotate y*90
      translate <15, 0, 5>
   }
   
   texture {
      Steinmauer
   }
}

#declare Haus_16_stufig = union {
   union {
      //*PMName Teil 1
      
      difference {
         //*PMName Dach
         
         box {
            //*PMName auen
            <0, 3.5, 0>, <5, 4, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName innen
            <0.4, 3.5, 0.4>, <4.6, 4.1, 4.6>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Durchgang
            <5.1, 3.5, 3.8>, <4.5, 4.1, 4.6>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      difference {
         //*PMName Basis
         
         box {
            //*PMName auen
            <0, -0.5, 0>, <5, 3.5, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName innen
            <0.4, -0.1, 0.4>, <4.6, 3.1, 4.6>
            
            texture {
               weisse_Mauer_innen
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Kerbe
            <0, 0, 0>, <0.42, 0.15, 0.42>
            scale 1
            rotate <0, 0, 0>
            translate <-0.21, 1.03, -0.05>
         }
         
         box {
            //*PMName Kerbe
            <0, 0, 0>, <0.43, 0.16, 0.43>
            scale 1
            rotate <0, 0, 0>
            translate <-0.01, 2.08, -0.21>
         }
         
         object {
            //*PMName Tr
            Tuer_rund
            scale 1
            rotate <0, 0, 0>
            translate <1.5, 0, 0.2>
         }
         
         object {
            //*PMName Fenster 1
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <3.5, 0, 0.2>
         }
      }
      
      object {
         //*PMName Trstufen
         Tuerstufen
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0, 0.2>
      }
      
      object {
         //*PMName Trbogen
         Tuerbogen
         scale 1
         rotate <0, 0, 0>
         translate x*1.5
      }
      
      object {
         //*PMName Fensterbrett 1
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <3.5, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen 1
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*3.5
      }
      translate z*(-0.5)
   }
   
   union {
      //*PMName Teil 2
      
      difference {
         //*PMName Dach
         
         box {
            //*PMName auen
            <0, 3.5, 0>, <5, 4, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName innen
            <0.4, 3.5, 0.4>, <4.6, 4.1, 4.6>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Durchgang links
            <-0.1, 3.5, 3.3>, <0.5, 4.1, 4.1>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Durchgang rechts
            <4.5, 3.25, 2.1>, <5.1, 4.1, 2.9>
            scale 1
            rotate <0, 0, 0>
            translate z*(-0.5)
         }
      }
      
      difference {
         //*PMName Basis
         
         box {
            //*PMName auen
            <0, -0.5, 0>, <5, 3.5, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName innen
            <0.4, -0.1, 0.4>, <4.6, 3.1, 4.6>
            
            texture {
               weisse_Mauer_innen
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName Durchgang rechts
            <4.5, 3.25, 2.1>, <5.1, 4.1, 2.9>
            scale 1
            rotate <0, 0, 0>
            translate z*(-0.5)
         }
         
         object {
            //*PMName Fenster 1
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <1.5, 0, 0.2>
         }
         
         object {
            //*PMName Tr
            Tuer_rund
            scale 1
            rotate <0, 0, 0>
            translate <3.5, 0, 0.2>
         }
      }
      
      object {
         //*PMName Fensterbrett
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <1.5, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*1.5
      }
      
      object {
         //*PMName Trstufen
         Tuerstufen
         scale 1
         rotate <0, 0, 0>
         translate <3.5, 0, 0.2>
      }
      
      object {
         //*PMName Trbogen
         Tuerbogen
         scale 1
         rotate <0, 0, 0>
         translate x*3.5
      }
      translate x*6
   }
   
   union {
      //*PMName Teil 3
      
      difference {
         //*PMName Dach
         
         box {
            //*PMName auen
            <0, 2.5, 0>, <5, 2.95, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            //*PMName innen
            <0.4, 2.5, 0.4>, <4.6, 3.1, 4.6>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
      }
      
      box {
         //*PMName Stufe Durchgang
         <0.4, 2.5, 2.1>, <0.8, 2.75, 2.9>
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      difference {
         //*PMName Basis
         
         box {
            <0, -0.5, 0>, <5, 2.5, 5>
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         box {
            <0.4, -0.1, 0.4>, <4.6, 2.1, 4.6>
            
            texture {
               weisse_Mauer_innen
            }
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         object {
            //*PMName Fenster 1
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <1.52, 0, 0.2>
         }
         
         object {
            //*PMName Fenster 2
            Fenster_rund
            scale 1
            rotate <0, 0, 0>
            translate <3.54, 0, 0.2>
         }
      }
      
      object {
         //*PMName Fensterbrett 1
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <1.52, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen 1
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*1.52
      }
      
      object {
         //*PMName Fensterbrett 2
         Fensterbrett
         scale 1
         rotate <0, 0, 0>
         translate <3.54, 0, 0.2>
      }
      
      object {
         //*PMName Fensterbogen 2
         Fensterbogen
         scale 1
         rotate <0, 0, 0>
         translate x*3.54
      }
      translate <11, 0, -0.5>
   }
   
   object {
      //*PMName Treppe zum Dach
      Treppe
      scale <1, 1.5, 2>
      rotate y*90
      translate <5, 0, 4>
   }
   
   texture {
      Steinmauer
   }
}

#declare Halbmond = union {
   cylinder {
      <0, 0, 0>, <0, 1.5, 0>, 0.1
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   sphere {
      <0, 0.5, 0>, 0.2
      scale <1, 0.8, 1>
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   difference {
      cylinder {
         <0, 0, -0.1>, <0, 0, 0.1>, 0.5
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.16, -0.2>, <0, 0.16, 0.2>, 0.35
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      translate y*1.99
   }
   
   texture {
      Gold
   }
   scale 0.7
}

#declare Turmdach = union {
   triangle {
      <0.447, 0, 0.894>, <1, 0, 0>, <0, 1, 0>
   }
   
   cylinder {
      <0.447, 0, 0.894>, <1, 0, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   triangle {
      <1, 0, 0>, <0.447, 0, -0.894>, <0, 1, 0>
   }
   
   cylinder {
      <0.447, 0, -0.894>, <1, 0, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   triangle {
      <0.447, 0, -0.894>, <-0.447, 0, -0.894>, <0, 1, 0>
   }
   
   cylinder {
      <0.447, 0, -0.894>, <-0.447, 0, -0.894>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   triangle {
      <-0.447, 0, -0.894>, <-1, 0, 0>, <0, 1, 0>
   }
   
   cylinder {
      <-0.447, 0, -0.894>, <-1, 0, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   triangle {
      <-1, 0, 0>, <-0.447, 0, 0.894>, <0, 1, 0>
   }
   
   cylinder {
      <-0.447, 0, 0.894>, <-1, 0, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   triangle {
      <-0.447, 0, 0.894>, <0.447, 0, 0.894>, <0, 1, 0>
   }
   
   cylinder {
      <0.447, 0, 0.894>, <-0.447, 0, 0.894>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare Balkonstangen = union {
   cylinder {
      //*PMName Stange
      <0, 0, 0>, <0, 1.4, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
      translate z*(-1.85)
   }
   
   cylinder {
      //*PMName Stange
      <0, 0, 0>, <0, 1.4, 0>, 0.02
      scale 1
      translate z*(-1.85)
      rotate y*5
   }
   
   cylinder {
      //*PMName Stange
      <0, 0, 0>, <0, 1.4, 0>, 0.02
      scale 1
      translate z*(-1.85)
      rotate y*10
   }
   
   cylinder {
      //*PMName Stange
      <0, 0, 0>, <0, 1.4, 0>, 0.02
      scale 1
      translate z*(-1.85)
      rotate y*15
   }
   
   cylinder {
      //*PMName Stange
      <0, 0, 0>, <0, 1.4, 0>, 0.02
      scale 1
      translate z*(-1.85)
      rotate y*20
   }
}

#declare Moscheeturm = union {
   difference {
      //*PMName Turm
      
      cylinder {
         <0, 0.5, 0>, <0, 20, 0>, 1.5
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 0.5, 0>, <0, 20, 0>, 1.1
         
         texture {
            weisse_Mauer_innen
         }
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Balkontr
         Tuer_rund
         scale <1, 1.5, 1>
         translate <0, 16, -1.26>
         rotate <0, 0, 0>
      }
      
      object {
         //*PMName Balkontr
         Tuer_rund
         scale <1, 1.5, 1>
         translate <0, 16, -1.26>
         rotate y*60
      }
      
      object {
         //*PMName Balkontr
         Tuer_rund
         scale <1, 1.5, 1>
         translate <0, 16, -1.26>
         rotate y*120
      }
      
      object {
         //*PMName Balkontr
         Tuer_rund
         scale <1, 1.5, 1>
         translate <0, 16, -1.26>
         rotate y*180
      }
      
      object {
         //*PMName Balkontr
         Tuer_rund
         scale <1, 1.5, 1>
         translate <0, 16, -1.26>
         rotate y*240
      }
      
      object {
         //*PMName Balkontr
         Tuer_rund
         scale <1, 1.5, 1>
         translate <0, 16, -1.26>
         rotate y*300
      }
      
      object {
         //*PMName Fenster unten
         Fenster_rund
         scale 1
         translate <0, 2, -1.26>
         rotate y*60
      }
      
      object {
         //*PMName Fenster Mitte
         Fenster_rund
         scale 1
         translate <0, 6, -1.26>
         rotate <0, 0, 0>
      }
      
      object {
         //*PMName Fenster oben
         Fenster_rund
         scale 1
         translate <0, 10, -1.26>
         rotate y*(-60)
      }
   }
   
   cylinder {
      //*PMName Bordure
      <0, -0.15, 0>, <0, 0.4, 0>, 1.5001
      
      texture {
         Bordure
      }
      scale 1
      rotate <0, 0, 0>
      translate y*19.3
   }
   
   cylinder {
      //*PMName Bordure
      <0, -0.445, 0>, <0, 0.45, 0>, 1.5001
      
      texture {
         Bordure
      }
      scale 1
      rotate y*30
      translate y*13
   }
   
   union {
      //*PMName Balkongelnder
      
      cylinder {
         <0, 0, 0>, <0, 0.1, 0>, 2
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      torus {
         1.9, 0.04
         scale 1
         rotate <0, 0, 0>
         translate y*1.4
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*25
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*50
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*75
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*100
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*125
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*150
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*175
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*200
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*225
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*250
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*275
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*300
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*325
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Stangen
         Balkonstangen
         scale 1
         rotate y*350
         translate <0, 0, 0>
      }
      translate y*15
      
      texture {
         Stahl
      }
   }
   
   difference {
      //*PMName Balkonunterseite
      
      cone {
         <0, 0, 0>, 2,
         <0, -1.5, 0>, 1.5
         scale 1
         rotate <0, 0, 0>
         translate y*15
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*15
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*45
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*75
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*105
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*135
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*165
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*195
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*225
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*255
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*285
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*315
      }
      
      object {
         //*PMName Bogen
         Tuer_rund
         scale <0.5, 0.5, 1>
         translate <0, 13.75, -1.8>
         rotate y*345
      }
   }
   
   object {
      //*PMName Dach
      Turmdach
      scale <1.8, 5, 1.8>
      rotate <0, 0, 0>
      translate y*20
      
      texture {
         Gold
      }
   }
   
   object {
      //*PMName Halmond
      Halbmond
      scale 1
      rotate <0, 0, 0>
      translate y*24.7
   }
   
   texture {
      weisse_Mauer
   }
}

#declare Moscheehalle = union {
   //*PMName Moscheehalle
   
   difference {
      //*PMName untere Etage
      
      cylinder {
         <0, -0.5, 0>, <0, 4.6, 0>, 5.5
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, -0.5, 0>, <0, 5, 0>, 5
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate <0, 0, 0>
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*22.5
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*45
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*67.5
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*90
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*112.5
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*135
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*157.5
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*180
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*202.5
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*225
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*247.5
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*270
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*292.5
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*315
      }
      
      object {
         //*PMName Tr
         Tuer_rund
         scale <1.5, 2, 1.5>
         translate z*(-5.2)
         rotate y*337.5
      }
   }
   
   cylinder {
      //*PMName Bordure
      <0, 4, 0>, <0, 4.4, 0>, 5.5001
      
      texture {
         Bordure
      }
      scale 1
      rotate y*90
      translate <0, 0, 0>
   }
   
   cone {
      <0, 4.6, 0>, 5.5,
      <0, 5.2, 0>, 4.6
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
      
      texture {
         Gold
      }
   }
   
   difference {
      //*PMName obere Etage
      
      prism {
         //*PMName auen
         linear_spline
         linear_sweep
         0, 1,
         9,
         <-1, 0>, <-0.707, 0.707>, <0, 1>, <0.707, 0.707>, <1, 0>, <0.707, -0.707>, <0, -1>, <-0.707, -0.707>, <-1, 0>
         scale <5, 2, 5>
         rotate y*22.5
      }
      
      prism {
         //*PMName innen
         linear_spline
         linear_sweep
         0, 1,
         9,
         <-1, 0>, <-0.707, 0.707>, <0, 1>, <0.707, 0.707>, <1, 0>, <0.707, -0.707>, <0, -1>, <-0.707, -0.707>, <-1, 0>
         scale <4.6, 2, 4.6>
         rotate y*22.5
      }
      
      object {
         //*PMName Fenster
         Fenster_rund
         scale 1
         translate <0, -0.8, -4.4>
         rotate y*180
      }
      
      object {
         //*PMName Fenster
         Fenster_rund
         scale 1
         translate <0.8, -0.8, -4.4>
         rotate y*180
      }
      
      object {
         //*PMName Fenster
         Fenster_rund
         scale 1
         translate <-0.8, -0.8, -4.4>
         rotate y*180
      }
      
      object {
         //*PMName Fenster
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <0, -0.8, -4.4>
      }
      
      object {
         //*PMName Fenster
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <0.8, -0.8, -4.4>
      }
      
      object {
         //*PMName Fenster
         Fenster_rund
         scale 1
         rotate <0, 0, 0>
         translate <-0.8, -0.8, -4.4>
      }
      translate y*5
   }
   
   box {
      //*PMName Verzierung
      <-0.1, -0.5, -1>, <0.121, 0.5, 1>
      
      texture {
         Bordure
      }
      scale 1
      translate <4.5, 6, 0>
      rotate y*45
   }
   
   box {
      //*PMName Verzierung
      <-0.1, -0.5, -1>, <0.121, 0.5, 1>
      
      texture {
         Bordure
      }
      scale 1
      translate <4.5, 6, 0>
      rotate y*135
   }
   
   difference {
      //*PMName Kuppeldach
      
      sor {
         //*PMName Kuppel
         5,
         <0, -0.5>, <0.45, 0>, <0.07, 0.55>, <0, 0.9>, <0, 1>
         sturm
         scale <10, 8, 10>
         rotate <0, 0, 0>
         
         texture {
            Gold
         }
         hollow false
      }
      
      sphere {
         <0, 0, 0>, 4
         scale <1, 0.8, 1>
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      object {
         //*PMName Dachfenster
         Tuer_rund
         scale <0.5, 0.3, 2>
         translate <0, 0.5, -4>
         rotate <0, 0, 0>
      }
      
      object {
         //*PMName Dachfenster
         Tuer_rund
         scale <0.5, 0.3, 2>
         translate <0, 0.5, -4>
         rotate y*45
      }
      
      object {
         //*PMName Dachfenster
         Tuer_rund
         scale <0.5, 0.3, 2>
         translate <0, 0.5, -4>
         rotate y*90
      }
      
      object {
         //*PMName Dachfenster
         Tuer_rund
         scale <0.5, 0.3, 2>
         translate <0, 0.5, -4>
         rotate y*135
      }
      
      object {
         //*PMName Dachfenster
         Tuer_rund
         scale <0.5, 0.3, 2>
         translate <0, 0.5, -4>
         rotate y*180
      }
      
      object {
         //*PMName Dachfenster
         Tuer_rund
         scale <0.5, 0.3, 2>
         translate <0, 0.5, -4>
         rotate y*225
      }
      
      object {
         //*PMName Dachfenster
         Tuer_rund
         scale <0.5, 0.3, 2>
         translate <0, 0.5, -4>
         rotate y*270
      }
      
      object {
         //*PMName Dachfenster
         Tuer_rund
         scale <0.5, 0.3, 2>
         translate <0, 0.5, -4>
         rotate y*315
      }
      translate y*7
   }
   
   object {
      //*PMName Halbmond
      Halbmond
      scale 1
      rotate <0, 0, 0>
      translate y*12.3
   }
   
   texture {
      weisse_Mauer
   }
}

#declare Sauele = union {
   cylinder {
      <0, -0.5, 0>, <0, 4, 0>, 0.2
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      //*PMName Sockel
      <0, 0.5, 0>, <0, -0.5, 0>, 0.25
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.5, 4, -0.5>, <0.5, 3.7, 0.5>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
}

#declare Palast = union {
   //*PMName Palast
   
   object {
      //*PMName Haus 10 hinten
      Haus_10_zyl
      rotate y*(-90)
      translate z*7
      scale 1
   }
   
   object {
      //*PMName Haus 10 vorn
      Haus_10_zyl
      scale 1
      rotate <0, 0, 0>
      translate <7, 0, -5>
   }
   
   difference {
      //*PMName Rondell
      
      cylinder {
         <0, 4, 0>, <0, -0.5, 0>, 20
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      cylinder {
         <0, 4.1, 0>, <0, -0.6, 0>, 15
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      plane {
         <1, 0, 0>, 0
         scale 3
         rotate <0, 0, 0>
         translate z*17.5
      }
      
      plane {
         <0, 0, 1>, 0
         scale 3
         rotate <0, 0, 0>
         translate x*17.5
      }
      
      difference {
         //*PMName Innenraum
         
         cylinder {
            <0, 4, 0>, <0, -0.5, 0>, 19.6
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         cylinder {
            <0, 4.1, 0>, <0, -0.6, 0>, 15.4
            scale 1
            rotate <0, 0, 0>
            translate <0, 0, 0>
         }
         
         plane {
            <1, 0, 0>, 0.13
            scale 3
            rotate <0, 0, 0>
            translate z*17.5
         }
         
         plane {
            <0, 0, 1>, 0.13
            scale 3
            rotate <0, 0, 0>
            translate x*17.5
         }
      }
      
      object {
         //*PMName Fenster auen
         Fenster_rund
         scale 1
         rotate y*90
         translate x*19.8
         rotate y*(-5)
      }
      
      object {
         //*PMName Fenster auen
         Fenster_rund
         scale 1
         rotate y*90
         translate x*19.8
         rotate y*(-10)
      }
      
      texture {
         weisse_Mauer
      }
   }
   
   difference {
      //*PMName Dach
      
      torus {
         16, 4
         scale <1, 0.4, 1>
         rotate <0, 0, 0>
         translate y*4
      }
      
      plane {
         //*PMName Begrenzung vorn
         <0, 0, 1>, 0
         scale 3
         rotate <0, 0, 0>
         translate <16, 4, 0>
      }
      
      plane {
         //*PMName Begrenzung hinten
         <1, 0, 0>, 0
         scale 3
         rotate <0, 0, 0>
         translate <0, 4, 16>
      }
      
      difference {
         //*PMName Rundung vorn
         
         cylinder {
            <-8, 0, 0>, <5, 0, 0>, 4
            scale <1, 0.8, 1>
            translate <16, 4, 0>
            inverse
         }
         
         plane {
            <0, 0, -1>, 0
            scale 3
            translate <16, 4, 0>
         }
         rotate <0, 0, 0>
         translate z*4
      }
      
      difference {
         //*PMName Rundung hinten
         
         cylinder {
            <0, 0, -8>, <0, 0, 5>, 4
            scale <1, 0.8, 1>
            translate <0, 4, 16>
            inverse
         }
         
         plane {
            <-1, 0, 0>, 0
            scale 3
            translate <0, 4, 16>
         }
         rotate <0, 0, 0>
         translate x*4
      }
      
      plane {
         //*PMName Begrenzung nach unten
         <0, 1, 0>, 4
         scale 1
         rotate <0, 0, 0>
         translate <0, 0, 0>
      }
      
      texture {
         Gold
      }
   }
   
   union {
      //*PMName Sulen
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-5)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-10)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-15)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-20)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-25)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-30)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-35)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-40)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-45)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-50)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-55)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-60)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-65)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-70)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-75)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-80)
      }
      
      object {
         //*PMName Sule
         Sauele
         scale 1
         translate x*12.5
         rotate y*(-85)
      }
   }
   
   union {
      //*PMName Turm vorn
      
      difference {
         cylinder {
            <0, 7, 0>, <0, -0.5, 0>, 1.5
            scale 1
            rotate <0, 0, 0>
         }
         
         cylinder {
            <0, 7, 0>, <0, -0.5, 0>, 1.1
            
            texture {
               weisse_Mauer_innen
            }
            scale 1
            rotate <0, 0, 0>
         }
         
         object {
            //*PMName Fenster
            Fenster_rund
            scale 1
            translate z*(-1.25)
            rotate <0, 0, 0>
         }
         
         object {
            //*PMName Fenster
            Fenster_rund
            scale 1
            translate <0, 2, -1.25>
            rotate y*(-45)
         }
         
         object {
            //*PMName Fenster
            Fenster_rund
            scale 1
            translate <0, 4, -1.25>
            rotate y*(-90)
         }
      }
      
      object {
         //*PMName Dach
         Turmdach
         scale <1.7, 3, 1.7>
         rotate <0, 0, 0>
         translate y*7
         
         texture {
            Gold
         }
      }
      
      object {
         //*PMName Halbmond
         Halbmond
         scale 1
         rotate <0, 0, 0>
         translate y*9.8
      }
      translate <18.25, 0, -1.15>
      
      texture {
         Steinmauer
      }
   }
   
   union {
      //*PMName Turm hinten
      
      difference {
         cylinder {
            <0, 7, 0>, <0, -0.5, 0>, 1.5
            scale 1
            rotate <0, 0, 0>
         }
         
         cylinder {
            <0, 7, 0>, <0, -0.5, 0>, 1.1
            
            texture {
               weisse_Mauer_innen
            }
            scale 1
            rotate <0, 0, 0>
         }
         
         object {
            //*PMName Fenster
            Fenster_rund
            scale 1
            translate z*(-1.25)
            rotate y*135
         }
         
         object {
            //*PMName Fenster
            Fenster_rund
            scale 1
            translate <0, 2, -1.25>
            rotate y*180
         }
         
         object {
            //*PMName Fenster
            Fenster_rund
            scale 1
            translate <0, 4, -1.25>
            rotate y*225
         }
      }
      
      object {
         //*PMName Dach
         Turmdach
         scale <1.7, 3, 1.7>
         rotate <0, 0, 0>
         translate y*7
         
         texture {
            Gold
         }
      }
      
      object {
         //*PMName Halbmond
         Halbmond
         scale 1
         rotate <0, 0, 0>
         translate y*9.8
      }
      translate <-1, 0, 18>
      
      texture {
         Steinmauer
      }
   }
   
   texture {
      weisse_Mauer
   }
}

#declare Pflanze = union {
   cylinder {
      <0, 0.81356, -0>, <0, -0.5, 0>, 0.02
      scale 1
      rotate <0, 0, 0>
   }
   
   sphere {
      <0, 0.59894, -0>, 0.1
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   triangle {
      <0.951042, 0.13333, -0.46667>, <0, 0, 0>, <0.634367, 0.43333, -1.0333>
   }
   
   triangle {
      <-0.657295, 0.13333, 1.00937>, <0, 0, 0>, <0.1667, 0.4, 1.0667>
   }
   
   triangle {
      <-0.804169, 0.23333, -0.446873>, <0, 0, 0>, <-0.8, 0.43333, -1.2333>
   }
   
   pigment {
      cylindrical
      
      color_map {
         [ 0 color rgbt <1, 0.98039, 0.98039, 1>
         ]
         [ 1 color rgb <0.36078, 0.46667, 0.37647>
         ]
      }
      scale <2, 1, 2>
   }
   rotate <0, 0, 0>
   scale <1, 2, 1>
}

#declare Staude = union {
   object {
      //*PMName Pflanze
      Pflanze
      scale <1, 1.618, 1>
      rotate <-158.2, 72.5, -156.5>
      translate <-0.0216762, 0.498553, 0>
   }
   
   object {
      //*PMName Pflanze
      Pflanze
      scale 1
      rotate <10.9, 30.2, -9>
      translate <0.82429, 0, 0.534539>
   }
   
   object {
      //*PMName Pflanze
      Pflanze
      scale <1, 1.274, 1>
      rotate <10.2, -26.7, -10.8>
      translate <0.935804, 0.130057, -0.538536>
   }
   
   object {
      //*PMName Pflanze
      Pflanze
      scale <1, 1.2, 1>
      rotate <-174.5, 45.8, 176.7>
      translate <0.293747, 0.18377, 0.954195>
   }
   
   object {
      //*PMName Pflanze
      Pflanze
      scale <1, 1.3, 1>
      rotate <8.3, -15.3, -1.4>
      translate <-0.725375, 0.298627, 0.292748>
   }
   
   object {
      //*PMName Pflanze
      Pflanze
      scale <1, 1.35, 1>
      rotate <-85.7, 80.8, -78.8>
      translate <-0.657433, 0.298627, -0.468543>
   }
   
   object {
      //*PMName Pflanze
      Pflanze
      scale 1
      rotate <-11.9, -27, -4.6>
      translate <0.513557, 0, -0.93919>
   }
   
   object {
      //*PMName Pflanze
      Pflanze
      scale 1
      rotate <32.7, 72, 26.7>
      translate <-0.239793, 0, 1.14301>
   }
   
   object {
      //*PMName Pflanze
      Pflanze
      scale 1
      rotate <40.1, 65.2, 38.1>
      translate <-1.28289, 0, 0.323721>
   }
   scale 0.1
}

#declare Stuhl = union {
   //*PMName Stuhl
   
   box {
      <-0.2, 0.42, -0.2>, <0.2, 0.47, 0.2>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.03, -0.5, -0.03>, <0.03, 0.43, 0.03>
      scale 1
      rotate <0, 0, 0>
      translate <0.15, 0, 0.15>
   }
   
   box {
      <-0.03, -0.5, -0.03>, <0.03, 0.43, 0.03>
      scale 1
      rotate <0, 0, 0>
      translate <-0.15, 0, 0.15>
   }
   
   box {
      <-0.03, -0.5, -0.03>, <0.03, 0.43, 0.03>
      scale 1
      rotate <0, 0, 0>
      translate <0.15, 0, -0.15>
   }
   
   box {
      <-0.03, -0.5, -0.03>, <0.03, 0.43, 0.03>
      scale 1
      rotate <0, 0, 0>
      translate <-0.15, 0, -0.15>
   }
   
   pigment {
      agate
      agate_turb 0.5
      
      color_map {
         [ 0 color rgb <0.666667, 0.564706, 0.380392>
         ]
         [ 0.8 color rgb <0.666667, 0.564706, 0.380392>
         ]
         [ 1 color rgb <0.403922, 0.290196, 0.207843>
         ]
      }
      scale 0.03
   }
   rotate y*30
}

#declare Tisch = union {
   //*PMName Tisch
   
   box {
      <-0.75, 0.4, -0.4>, <0.75, 0.45, 0.4>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   box {
      <-0.04, -0.5, -0.04>, <0.04, 0.401, 0.04>
      scale 1
      rotate <0, 0, 0>
      translate <0.65, 0, 0.3>
   }
   
   box {
      <-0.04, -0.5, -0.04>, <0.04, 0.401, 0.04>
      scale 1
      rotate <0, 0, 0>
      translate <-0.65, 0, 0.3>
   }
   
   box {
      <-0.04, -0.5, -0.04>, <0.04, 0.401, 0.04>
      scale 1
      rotate <0, 0, 0>
      translate <0.65, 0, -0.3>
   }
   
   box {
      <-0.04, -0.5, -0.04>, <0.04, 0.401, 0.04>
      scale 1
      rotate <0, 0, 0>
      translate <-0.65, 0, -0.3>
   }
   
   texture {
      finish {
         ambient rgb <0.0352941, 0.0352941, 0.0352941>
         diffuse 0.9
      }
      
      pigment {
         agate
         agate_turb 0.5
         
         color_map {
            [ 0 color rgb <1, 0.85098, 0.568627>
            ]
            [ 0.8 color rgb <0.980392, 0.831373, 0.556863>
            ]
            [ 1 color rgb <0.921569, 0.658824, 0.47451>
            ]
         }
         scale 0.03
      }
   }
}

#declare Gefaess = difference {
   //*PMName Gef
   
   sphere {
      <0, 0, 0>, 0.2
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   cylinder {
      <0, 0.2, 0>, <0, -0.1, 0>, 0.15
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   translate y*0.2
   
   pigment {
      marble
   }
}

#declare Karawane = disc {
   <0, 0, 0>,<0, 0, 1>, 1,0
   
   texture {
      pigment {
         image_map {
            png
            "/home/wolfram/bilder/oase/karawane2.png"
            once
            map_type 0
         }
         translate <-0.5, -0.3, 0>
      }
   }
   scale <12, 5, 1>
   rotate <0, 0, 0>
}

#declare Junge = disc {
   <0, 0.5, 0>,<0, 0, -1>, 1,0
   
   texture {
      finish {
         ambient rgb <0.447059, 0.447059, 0.447059>
      }
      
      pigment {
         image_map {
            png
            "/home/wolfram/bilder/oase/junge.png"
            filter all 1
            once
            map_type 0
         }
      }
      translate <-0.35, -0.35, 0>
      scale 0.75
   }
   scale 1
   rotate <0, 0, 0>
   translate <0, 0, 0>
}

light_source {
   //*PMName Sonne
   <378.289, 220.402, 112.707>, rgb <1,.4,.1> // <1, 0.764706, 0.686275>
}

light_source {
   //*PMName Aufhelllicht rechts
   <242.87, 100, -199.29>, rgb <0.168627, 0.168627, 0.160784>
   shadowless
}

light_source {
   //*PMName Aufhelllicht links
   <-255.33, 100, -85.731>, rgb <0.192157, 0.192157, 0.184314>
   shadowless
}

/* camera {
 
   perspective
   location <6, 2, -66>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0.687641, 7.04576, -9.90818>
}

camera {
 
   perspective
   location <4.1633, 55.878, -13.528>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <5.3185, 7.775, -41.353>
}
*/

camera {
   //*PMName Kamera fern
   perspective
   location <0, 13, -65>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, 10, 0>
   aperture 0.1
   blur_samples 20
   focal_point <0, 0, -30>
   confidence 0.9
   variance 0.004
}

sky_sphere {
   pigment {
      gradient <0, 1, 0>
      
      color_map {
         [ 0 color rgb <1, 0.35, 0>
         ]
         [ .8 color rgb <0,0,0.44> // <0.39, 0.22, 0.44>
         ]
      }
      scale 0.5
//      translate y*(-150)
   }
   rotate 5*x
   rotate y*40
}

plane {
   //*PMName Wolken
   <0, 1, 0>, 0
   scale 10000
   rotate x*2
   translate y*100
   
   texture {
      pigment {
         gradient <0, 0, 1>
         scale <800, 1200, 1200>
         
         pigment_map {
            [ 0 bozo
            turbulence <0.65, 0.65, 0.65>
            omega 0.7
            
            color_map {
               [ 0 color rgbt <0.94902, 0.94902, 0.94902, 0.2>
               ]
               [ 0.1 color rgbt <0.88627, 0.88627, 0.88627, 0.3>
               ]
               [ 0.4 color rgbt <1, 1, 1, 1>
               ]
               [ 1 color rgbt <1, 1, 1, 1>
               ]
            }
            ]
            [ 0.8 color rgbt <1, 1, 1, 1>
            ]
         }
      }
      
      finish {
         ambient rgb <0.686275, 0.686275, 0.686275>
         diffuse 0.9
      }
   }
}

#declare Sand = pigment {
   bumps
   turbulence <0.8, 0, 0.8>
   
   color_map {
      [ 0 color rgb <0.941176, 0.858824, 0.733333>
      ]
      [ 0.05 color rgb <0.984314, 0.94902, 0.768627>
      ]
      [ 0.1 color rgb <0.941176, 0.941176, 0.847059>
      ]
      [ 0.5 color rgb <1, 1, 0.901961>
      ]
   }
}

#declare Sand_transparent = pigment {
   bumps
   turbulence <0.8, 0, 0.8>
   
   color_map {
      [ 0 color rgbt <0.94118, 0.85882, 0.73333, 1>
      ]
      [ 0.05 color rgbt <0.98431, 0.94902, 0.76863, 1>
      ]
      [ 0.1 color rgbt <0.94118, 0.94118, 0.84706, 1>
      ]
      [ 0.5 color rgbt <1, 1, 0.90196, 1>
      ]
   }
}

#declare Sand_bewachsen = pigment {
   wrinkles
   turbulence <0.2, 0.2, 0.2>
   
   color_map {
      [ 0 color rgb <0.941176, 0.858824, 0.733333>
      ]
      [ 0.05 color rgb <0.984314, 0.94902, 0.768627>
      ]
      [ 0.1 color rgb <0.941176, 0.941176, 0.847059>
      ]
      [ 0.3 color rgb <1, 1, 0.901961>
      ]
      [ 0.7 color rgb <0.811765, 0.690196, 0.462745>
      ]
      [ 0.8 color rgb <0.427451, 0.552941, 0.447059>
      ]
      [ 1 color rgb <0.235294, 0.305882, 0.247059>
      ]
   }
}

#declare Orange = texture {
      pigment {
 	 color rgb <1,0.35,0>
      }
      finish {
        ambient 0.5
        reflection 0.5
      }
}

union {
   //*PMName Boden
   
   bicubic_patch {
      //*PMName Baugrund
      type 0
      u_steps 3
      v_steps 3
      <-100, 3, -100>, <-20, 2, -100>, <20, 1, -100>, <100, 0, -100>,
      <-100, 2, -20>, <-20, 1, -20>, <20, 5, -20>, <100, 1, -20>,
      <-100, 6, 20>, <-20, 4, 20>, <20, 5, 20>, <100, 1, 20>,
      <-150, 5, 100>, <-29.6005, 6, 113.201>, <20, 4, 100>, <151.926, 12.0427, 115.601>
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
      
      texture {
         pigment {
            gradient <0, 0, 1>
            
            pigment_map {
               [ 0.5 Sand_bewachsen
               scale <0.003, 1, 0.003>
               ]
               [ 1 Sand
               scale <0.005, 1, 0.005>
               ]
            }
            scale 220
         }
         translate z*(-100)
         
         normal {
            bumps
            0.4
         }
         
         finish {
            ambient rgb <0.105882, 0.0941176, 0.0666667>
            diffuse 0.9
            brilliance 1
         }
      }
   }
   
   bicubic_patch {
      //*PMName Hgel
      type 0
      u_steps 3
      v_steps 3
      <-3, 0, -3>, <-1, 0, -3>, <1, 0, -3>, <4.21727, 0, -2.92623>,
      <-3, 3, -1>, <-1, 6, -1>, <1, 7, -1>, <5.84029, 0, -1.07377>,
      <-3, 0, 1>, <-1, 20, 1>, <1, 30, 1>, <7.64775, 0, 0.889339>,
      <-7.31545, 3.34756, 3>, <0.357037, 5.02134, 3.70085>, <3.43785, -6.69512, 3.59019>, <8.38517, 6.69512, 2.85245>
      
      texture {
         gradient <0, 0, 1>
         
         texture_map {
            [ 0 normal {
               bumps
               0.4
            }
            
            finish {
               ambient rgb <0.105882, 0.0941176, 0.0666667>
               diffuse 0.9
               brilliance 1
            }
            
            pigment {
               Sand
            }
            scale <0.0015, 1, 0.0015>
            ]
            [ 0.9 scale 100
            
            normal {
               bumps
               0.4
            }
            
            finish {
               ambient rgb <0.105882, 0.0941176, 0.0666667>
               diffuse 0.9
               brilliance 1
            }
            
            pigment {
               Sand_transparent
            }
            ]
         }
         scale <7, 1, 7>
         translate z*(-3)
      }
      scale <100, 1, 100>
      rotate <0, 0, 0>
      translate <-100, 0, 400>
   }
   
   plane {
        //*PMName Horizont
        <0, 1, 0>, 0
        scale 1
        rotate <0, 0, 0>
        translate <0, 0, 0>

        normal {
            bumps
            0.4
         }
         
         finish {
            ambient rgb <1, 0.35, 0> * 0.5
            diffuse 0.9
	    reflection 0.3
            brilliance 1
         }
         
         pigment {
            Sand
         }

         scale <4, 1, 4>
   }
}

object {
   //*PMName Karawane
   Karawane
   scale 1
   rotate <0, 0, 0>
   translate <100, 8.7, 110>
}

box {
   //*PMName Strae 1
   <0, -1, 0>, <5, 3.2, -100>
   scale 1
   rotate x*(-1.1)
   rotate y*(-32)
   translate <10, 0, -15>
   
   texture {
      Strassenpflaster
   }
}

box {
   //*PMName Strae 2
   <0, -0.5, 0>, <5, 3.1, -100>
   scale 1
   rotate x*(-0.7)
   rotate y*34
   translate <-4, 0, -13>
   
   texture {
      Strassenpflaster
   }
}

union {
   //*PMName Palmen bei Strae 2
   
   object {
      //*PMName Palme
      Palme_kurz_gerade
      scale 1
      rotate y*(-33)
      translate <-10, 0, 3.6312>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*(-95)
      translate <-0.684371, 0, 6.33748>
   }
   
   object {
      //*PMName Palme
      Palmen_6er
      scale 1
      rotate y*17
      translate <5.79375, 0, 3.62499>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*147
      translate <-2.24063, 0, 1.42812>
   }
   
   object {
      //*PMName Palme
      Palmen_3er
      scale 1
      rotate y*(-126)
      translate <1.90942, 0, 4.00311>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*243
      translate <8.9124, 0, 1.66875>
   }
   
   object {
      //*PMName Palme
      Palmen_6er
      scale 1
      rotate y*123
      translate <13.3219, 0, 4.52186>
   }
   translate <-15, 3.1, -46.841>
}

box {
   //*PMName Strae 3
   <0, -0.5, 0>, <5, 3.6, -100>
   scale 1
   rotate x*1.3
   rotate y*105
   translate <-21, -0.3, 2.5>
   
   texture {
      Strassenpflaster
   }
}

box {
   //*PMName Strae 4
   <0, -0.5, 0>, <5, 3.5, -100>
   scale 1
   rotate x*1
   rotate y*148
   translate <3, 0, 3.5>
   
   texture {
      Strassenpflaster
   }
}

box {
   //*PMName Strae 5
   <0, -0.5, 0>, <5, 3.9, -100>
   scale 1
   rotate x*1.5
   rotate y*235
   translate <20, -0.8, -1>
   
   texture {
      Strassenpflaster
   }
}

cylinder {
   //*PMName Moschee-Platz
   <0, 3.5, 0>, <0, -0.5, 0>, 1
   scale <20, 1, 15>
   rotate <-1.5, 0, -0.5>
   rotate y*20
   translate <-5, 0, -3>
   
   texture {
      Strassenpflaster
   }
}

union {
   //*PMName Palmen Moscheeplatz
   
   object {
      //*PMName Palme
      Palme_kurz_gerade
      scale 1
      rotate y*19
      translate <-1.0375, 0, 12.1906>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*(-83)
      translate <-5.09374, 0, 4.52186>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*55
      translate <6.57187, 0, 2.06874>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*(-357)
      translate <-0.524182, 0, -3.79752>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*99
      translate <14.3594, 0, -10.2625>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*(-84)
      translate <12.0249, 0, -5.33437>
   }
   
   object {
      //*PMName Palme
      Palme_kurz_gerade
      scale 1
      rotate y*73
      translate <8.13438, 0, -8.96562>
   }
   translate <-13.6, 3.1, -3.525>
}

cylinder {
   //*PMName Schloplatz
   <0, 3.2, 0>, <0, -0.5, 0>, 0.5
   scale <24, 1, 24>
   rotate <-1.5, -0, -0.3>
   translate <17, 0.1, -9>
   
   texture {
      Strassenpflaster
   }
}

union {
   //*PMName Palmen Schloplatz
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*(-315)
      translate <2.27335, 0, 4.34835>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*42
      translate <6.31874, 0, 5.04061>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*38
      translate <7.86874, 0, 0.512492>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate <-180, -80.7, 180>
      translate <-2.24063, 0, -7.64999>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*86
      translate <5.54066, 0, -9.22499>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate <-180, -20.8, -180>
      translate <11.5062, 0, -4.81562>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*8
      translate <0.101369, 0, -11.3267>
   }
   translate <12, 3.1, -6.1187>
}

object {
   //*PMName Moscheeturm
   Moscheeturm
   scale 1
   rotate <0, 0, 0>
   translate <-3, 3.5, -4>
}

object {
   //*PMName Moscheehalle
   Moscheehalle
   scale 1
   rotate <0, 0, 0>
   translate <5, 3.5, -5>
}

object {
   //*PMName Palast
   Palast
   scale 1
   rotate y*55
   translate <17, 2.9, -9>
}

union {
   //*PMName Haus A
   
   object {
      //*PMName Haus A
      Haus_16_stufig
      rotate <0, 0, 0>
      scale 1
   }
   
   object {
      //*PMName Tisch
      Tisch
      scale 1
      rotate y*7.1
      translate <14.3, 2.5, 3.1>
   }
   
   object {
      //*PMName Gef
      Gefaess
      scale <1, 1.5, 1>
      rotate <0, 0, 0>
      translate <8.7, 3.95, 0.22>
   }
   
   object {
      //*PMName Gef
      Gefaess
      scale 1
      rotate <0, 0, 0>
      translate <8.2, 3.95, 0.22>
   }
   
   object {
      //*PMName Gef
      Gefaess
      scale <1, 1.2, 1>
      rotate <0, 0, 0>
      translate <14.4, 3.45, 3.0>
   }
   translate <-8.5, 3.1, -31>
}

union {
   //*PMName Grasbueschel vor Haus A
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*(-30)
      translate <1.97593, 2.9, -31.3853>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*(-30)
      translate <-0.908087, 2.9, -31.779>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*(-30)
      translate <0.315195, 2.9, -32.3608>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate <0, 0, 0>
      translate <2.7114, 2.7, -33.763>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <3.0434, 2.7, -34.545>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <3.4078, 2.7, -35.074>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <1.5, 1, 1>
      rotate <0, 0, 0>
      translate <4.66407, 2.55, -38.4341>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate <0, 0, 0>
      translate <3.8145, 2.55, -38.295>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate <0, 0, 0>
      translate <4.15464, 2.55, -36.8616>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1.5, 2>
      rotate <0, 0, 0>
      translate <-2.39217, 2.55, -43.8017>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1.5, 2>
      rotate y*20
      translate <-0.985263, 2.55, -43.498>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 1.5>
      rotate y*20
      translate <-2.04608, 2.55, -42.9674>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1.5, 2>
      rotate y*20
      translate <-1.59265, 2.55, -41.837>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1.5, 2>
      rotate y*90
      translate <-2.70826, 2.55, -42.4939>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1.5
      rotate y*190
      translate <-3.27226, 2.55, -43.1137>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*120
      translate <-3.92824, 2.55, -42.3605>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1.5
      rotate y*190
      translate <-6.5389, 2.7, -34.0648>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1.5
      rotate y*190
      translate <-8.02844, 2.55, -44.889>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1.5
      rotate y*190
      translate <-7.67268, 2.55, -43.5788>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 2
      rotate y*90
      translate <-8.62715, 2.55, -43.6916>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1.5
      rotate y*90
      translate <-9.93737, 2.55, -43.4486>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1.5
      rotate y*90
      translate <-9.00026, 2.55, -44.6894>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*120
      translate <-7.32908, 2.55, -43.1068>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <0.7, 1, 0.7>
      rotate y*45
      translate <-7.04968, 2.55, -43.4348>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*90
      translate <-8.28875, 2.55, -42.4508>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*90
      translate <-15.653, 2.55, -40.5845>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*90
      translate <-13.8494, 2.55, -42.6174>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*90
      translate <-13.1491, 2.55, -42.9211>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*90
      translate <-12.3123, 2.55, -43.3177>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*90
      translate <-11.1566, 2.55, -42.1516>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate <0, 0, 0>
      translate <-10.8893, 2.55, -42.4067>
   }
}

union {
   //*PMName Palmen vor Haus A
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*(-74)
      translate <0.518749, 0, -0.518749>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*184
      translate <-2.5, 0, -3>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate <180, 70.8, 180>
      translate <3.45937, 0, -1.82188>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*(-48)
      translate <2.68749, 0, -6.35312>
   }
   
   object {
      //*PMName Palme
      Palmen_3er
      scale 1
      rotate y*89
      translate <13.0625, 0, -2.22188>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*(-28)
      translate <7.87499, 0, -3.51875>
   }
   
   object {
      //*PMName Palme
      Palme_kurz_krumm
      scale 1
      rotate y*78
      translate <14.6187, 0, -6.37187>
   }
   translate <-10, 3.1, -32.056>
}

object {
   //*PMName Haus B
   Haus_10_zyl
   rotate <0, 0, 0>
   translate <7.75, 2.9, -30.5>
   scale 1
}

union {
   //*PMName Grasbueschel vor Haus B
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*(-30)
      translate <9.3426, 2.9, -31.052>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <7.97593, 2.9, -31.1187>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*90
      translate <7.7426, 2.9, -31.752>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <3, 1, 2>
      rotate <0, 0, 0>
      translate <10.688, 2.7, -37.959>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <9.5659, 2.7, -37.764>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <14.216, 2.8, -35.99>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <14.901, 2.7, -35.903>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <13.608, 2.8, -35.217>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <12.9401, 2.55, -35.2173>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <15.1006, 2.55, -34.714>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate y*(-30)
      translate <16.66, 2.35, -42.3789>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <17.0674, 2.55, -40.4165>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <2, 1, 2>
      rotate <0, 0, 0>
      translate <17.682, 2.65, -35.848>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate <0, 0, 0>
      translate <22.2419, 2.55, -37.6309>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale <1, 3, 1>
      rotate <0, 0, 0>
      translate <28.1081, 2.55, -25.4927>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate <0, 0, 0>
      translate <28.9758, 2.55, -25.2637>
   }
   
   object {
      //*PMName Bschel
      Staude
      scale 1
      rotate <0, 0, 0>
      translate <28.7311, 2.55, -25.8052>
   }
}

union {
   //*PMName Palmen vor Haus B
   
   object {
      //*PMName Palme
      Palmen_6er
      scale 1
      rotate <0, 0, 0>
      translate <-0.915448, 0, -0.698024>
   }
   
   object {
      //*PMName Palme
      Palmen_3er
      scale 1
      rotate y*217
      translate <-3.9342, 0, -3.7171>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*(-46)
      translate <3.45937, 0, -1.82188>
   }
   
   object {
      //*PMName Palme
      Palme_kurz_krumm
      scale 1
      rotate y*(-113)
      translate <2.68749, 0, -6.35312>
   }
   
   object {
      //*PMName Palme
      Palme_kurz_gerade
      scale 1
      rotate y*77
      translate <13.5812, 0, -0.146883>
   }
   
   object {
      //*PMName Palme
      Palme_kurz_krumm
      scale 1
      rotate y*20
      translate <7.87499, 0, -3.51875>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*(-167)
      translate <12.2843, 0, 4.00312>
   }
   translate <14.3968, 3.1, -33.872>
}

union {
   //*PMName Haus C
   
   union {
      object {
         //*PMName Haus 5 links
         Haus_5_unten
         scale <1, 0.8, 1>
         rotate <0, 0, 0>
      }
      
      difference {
         box {
            <0, 2, 0>, <5, 2.5, 5>
            scale 1
         }
         
         box {
            <0.4, 2, 0.4>, <4.6, 2.6, 4.6>
            scale 1
         }
      }
      translate z*(-5)
      rotate y*220
      translate x*8
   }
   
   union {
      object {
         //*PMName Haus 5 rechts
         Haus_5_unten
         scale <1, 0.8, 1>
      }
      
      difference {
         box {
            <0, 2, 0>, <5, 2.5, 5>
            scale 1
         }
         
         box {
            <0.4, 2, 0.4>, <4.6, 2.6, 4.6>
            scale 1
         }
      }
      translate <-5, 0, -5>
      rotate y*(-220)
   }
   
   object {
      //*PMName Haus 10 mitte
      Haus_10_zyl
      scale <0.8, 1, 1>
      translate <0, 0, 0>
      rotate <0, 0, 0>
   }
   rotate y*180
   translate <9, 3, -15>
   
   texture {
      weisse_Mauer
   }
}

union {
   //*PMName Haus D
   
   object {
      //*PMName Haus 10
      Haus_10_zyl
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      //*PMName Haus 15
      Haus_15_stufig
      scale 1
      translate <-22, -0.5, -1>
      rotate y*100
   }
   
   object {
      //*PMName Tisch
      Tisch
      scale 1
      rotate y*90
      translate <4.5166, 2.5, 14.407>
   }
   
   object {
      //*PMName Schale
      Gefaess
      scale <1, 0.3, 1>
      translate y*0.45
      rotate <0, 0, 0>
      translate <4.47226, 2.5, 14.1505>
   }
   
   object {
      //*PMName Gef
      Gefaess
      scale <0.9, 1.5, 0.9>
      translate y*(-0.03)
      rotate <0, 0, 0>
      translate <5.67756, 3.5, 16.4629>
   }
   
   object {
      //*PMName Gef
      Gefaess
      scale <0.8, 1, 0.8>
      translate y*(-0.02)
      rotate <0, 0, 0>
      translate <5.01121, 3.5, 16.617>
   }
   
   object {
      //*PMName Gef
      Gefaess
      scale 1
      rotate <0, 0, 0>
      translate <5.85295, 3, 17.3795>
   }
   rotate y*(-150)
   translate <-5, 3.5, -15>
   
   texture {
      Steinmauer
   }
}

object {
   //*PMName Junge bei Haus A
   Junge
   scale <1.2,1.5,1.2>
//   rotate <5, -10, 0>
   translate <-7.2, 3.1, -32.1>
}

union {
   //*PMName Palmen bei Haus D
   
   object {
      //*PMName Palme
      Palme_kurz_krumm
      scale 1
      rotate y*177
      translate <0.518749, 0, -0.518749>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*(-23)
      translate <1.64999, 0, 2.96562>
   }
   
   object {
      //*PMName Palme
      Palmen_3er
      scale 1
      rotate y*5.8
      translate <3.45937, 0, -1.82188>
   }
   
   object {
      //*PMName Palme
      Palmen_3er
      scale 1
      rotate y*88
      translate <5.54061, 0, -5.575>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*(-12)
      translate <8.13438, 0, 0.631241>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*97
      translate <10.7281, 0, -8.70624>
   }
   
   object {
      //*PMName Palme
      Palme_kurz_gerade
      scale 1
      rotate y*5
      translate <6.57809, 0, -14.1531>
   }
   translate <-29.437, 3.1, -25.053>
}

object {
   //*PMName Haus E
   Haus_16_stufig
   scale 1
   rotate y*45
   translate <-35, 3, -10>
}

object {
   //*PMName Haus F
   Haus_10_zyl
   scale 1
   rotate y*42
   translate <-26, 3.5, -6.5>
}

object {
   //*PMName Haus G
   Haus_15_stufig
   scale 1
   rotate y*15
   translate <-42, 3.8, -2>
}

object {
   //*PMName Haus H
   Haus_10_zyl
   scale 1
   rotate y*15
   translate <-43, 3.8, 8.5>
}

object {
   //*PMName Haus I
   Haus_10_zyl
   scale 1
   rotate y*15
   translate <-30, 3.6, 5>
}

object {
   //*PMName Haus J
   Haus_16_stufig
   scale 1
   rotate y*(-20)
   translate <-39, 5, 17>
}

union {
   //*PMName Haus K
   
   object {
      //*PMName Haus 10
      Haus_10_zyl
      scale 1
      translate x*(-10)
      rotate y*45
   }
   
   object {
      //*PMName Haus 15
      Haus_15_stufig
      scale 1
      translate z*3.5
      rotate y*90
   }
   rotate y*(-30)
   translate <-17, 4, 12>
   
   texture {
      Steinmauer
   }
}

union {
   //*PMName Haus L
   
   object {
      //*PMName Haus 5
      Haus_5_unten
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   
   object {
      //*PMName Haus 10
      Haus_10_zyl
      scale 1
      translate z*(-5)
      rotate y*(-130)
   }
   rotate y*10
   translate <3, 3.5, 3>
   
   texture {
      Steinmauer
   }
}

union {
   //*PMName Haus M
   
   object {
      //*PMName Haus 5
      Haus_5_unten
      scale 1
      rotate y*(-40)
      translate <0, 0, 0>
   }
   
   object {
      //*PMName Haus 10
      Haus_10_zyl
      scale 1
      rotate <0, 0, 0>
      translate <0, 0, 0>
   }
   rotate y*(-35)
   translate <15, 3, 0>
   
   texture {
      Steinmauer
   }
}

union {
   //*PMName Haus N
   
   object {
      //*PMName linker Teil
      Haus_10_zyl
      scale 1
      rotate y*20
   }
   
   object {
      //*PMName rechter Teil
      Haus_16_stufig
      scale 1
      translate <10, 0, 1>
      rotate y*20
   }
   translate <0, 3.5, 18>
}

union {
   //*PMName Palmen bei Haus N
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate y*5
      translate <-5.44687, 0, -5.18749>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*(-99)
      translate <0.353117, 0, 0.371873>
   }
   
   object {
      //*PMName Palme
      Palme_lang_krumm
      scale 1
      rotate <0, 0, 0>
      translate <28.1, 0, -5.7125>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*(-39)
      translate <21.1031, 0, -4.5375>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*28
      translate <10.2094, 0, -2.22188>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*113
      translate <7.35624, 0, -10.0031>
   }
   
   object {
      //*PMName Palme
      Palme_lang_gerade
      scale 1
      rotate y*67
      translate <16.6937, 0, -13.375>
   }
   translate <-10.244, 3.1, 26.303>
}