#include "colors.inc"
#include "bamboo.inc"


#local r1 = seed(1837);
#local r2 = seed(1721);

// --------------- SAND -------

#declare sand = blob {
  threshold .75
// Kreis mit leichter Sinusverkruemmung
  #declare blv1 = -50;
  #while (blv1 < 50 )
    #declare blv2 = -50;
    #while (blv2 < 50  )     
      #declare entf = sqrt( pow(blv1, 2) + pow(blv2, 2));
      #if ( sqrt( pow(blv1, 2) + pow(blv2, 2) ) < 50 )
        sphere { <blv1, (rand(r1)*.1+sin(blv1*.2)*cos(blv2*.175)*1.5+1)*cos(entf/90*pi)-.4, blv2> .75 1 } 
        #end
      #declare blv2 = blv2+.35;
    #end
  #declare blv1 = blv1+.35;
  #end          
  sphere { <30, -2, 0> 5 strength -5 }
  sphere { <30, -2, -3> 5 strength -5 }
  sphere { <33, -2, -2> 5 strength -5 }
  sphere { <33, -4, -4> 5 strength -5 }
  sphere { <31, -6, -2> 8 strength -5 }
  pigment { Goldenrod }
  normal { bumps .25 scale 10}
  bounded_by { box { <-55, -20, -55> <55, 10, 55> }}
} 

                                       
// -------------- TEICH ---------

#declare teich = cylinder { 
  <32, -7, -2> <32, .25, -2> 7 
  pigment { DarkSlateGray } 
  normal { crackle .1 turbulence .25 scale .75 }
  finish { ambient .45 brilliance 6 
          phong .4 phong_size 90
          reflection .85 conserve_energy}
} 

// -------------- GRAS ---------

#local norm = <1, 1, 1>;

#macro gras1(xk,zk)
#local inter=trace(sand, <xk, 20, zk>, <0, -1, 0>, norm);
object { d_bueschel(5) 
          scale (rand(r1)*.2+.3)
          Point_At_Trans(norm)
          translate <xk, inter.y, zk> 
          bounded_by { box { <xk-2, inter.y-.5, zk-2> <xk+2, inter.y+2, zk+2> } }
       }
#end

#declare teichgras = union {
  gras1(23, -2)
  gras1(23, 1) 
  gras1(23, 4)
  gras1(24, 5)                        
  gras1(24, -5)
  gras1(25, 3) 
  gras1(25, -6)
  gras1(27, -7)
  gras1(28, 4)
  gras1(28, -5) 
  gras1(29, 7) 
  gras1(29, -6)
  gras1(30, -7)
  gras1(31, 3) 
  gras1(31, -6)
  gras1(32, -7)
  gras1(33, -8)
  gras1(34, 0) 
  gras1(34, -6)
  gras1(35, -2)
  gras1(35, -5)
  gras1(36, 0)
  gras1(36, -2) 
}
                                                                                                                   
// -------------- PALMEN --------------

#declare palmseg = merge {
  cone { 0 .4 <0, 1, 0> .75 }
  torus { .65 .1 translate y*1 }
  cylinder { <0, 1, 0> <0, 1.1, 0> .65 }
}               

#macro palmtex ()
  texture {
    pigment { 
      bozo 
      turbulence .25
      color_map {
        [0.0 LimeGreen ]
        [0.2 LimeGreen ]
        [0.5 LimeGreen*.75 ]
        [0.7 LimeGreen*.75 ]
        [1.0 LimeGreen*.6 ]
      }                    
      scale .25
    }             
  }
#end

#macro stammtex()
  texture {
    pigment {
      agate
      turbulence .25
      color_map {
        [0.0 BakersChoc ]
        [0.3 BakersChoc ]
        [0.5 SemiSweetChoc ]
        [0.8 SemiSweetChoc ]
        [0.85 SemiSweetChoc*1.25 ]
        [1.0 SemiSweetChoc*1.25 ]
      }
      translate <rand(r1)*5, rand(r1)*5, rand(r1)*5>
      scale <1, 3, 1>
    }     
  }
#end
                          
#declare plv = 0;                          

#macro palme()
merge {
  #while (plv < 30 )
    object { 
      palmseg 
      scale <pow(.98,plv), 1, pow(.98,plv)>
      translate y*plv
      stammtex() 
    }  
    #declare plv = plv+1;
  #end

#declare plv = 0;
  #while (plv < 4)
    object { 
      aderblatt(13) 
      scale <rand(r1)*1+2, rand(r1)*.5+1, rand(r1)*2+3>
      rotate z*(rand(r1)*10-10)
      translate <.5, 30, 0> 
      rotate y*(plv*85+rand(r1)*10)
      palmtex()
    }                    
    #declare plv = plv+1;
  #end

#declare plv = 0;
  #while (plv < 4)
    object { 
      aderblatt(13) 
      scale <rand(r1)*1+2.5, rand(r1)*.5+1.25, rand(r1)*2+4>
      rotate z*(rand(r1)*10+5)
      translate <.5, 30, 0> 
      rotate y*(plv*85+rand(r1)*10+45)
      palmtex()
    }                    
    #declare plv = plv+1;
  #end                       
  
#declare plv = 0;
  #while (plv < 4)
    object { 
      blatt2() 
      scale <rand(r1)+2, rand(r1)*.5+1, rand(r1)*2+3>
      rotate z*(rand(r1)*10+5)
      translate <.5, 30, 0> 
      rotate y*(plv*85+rand(r1)*10+22)
      palmtex()
    }                    
    #declare plv = plv+1;
  #end                       
}             
#end                                        

#declare palmgruppe1 = union {
    object { 
      palme() 
      scale <(rand(r1)*.15+.45), (rand(r1)*.1+.35), (rand(r1)*.15+.45)> 
      rotate <0, rand(r1)*360, rand(r1)*15-7.5>
      translate <20, -7.5+rand(r1), 3> 
      bounded_by { box { <16, -5, -1> <24, 12, 7> }}} 
    object { 
      palme() 
      scale <(rand(r1)*.15+.45), (rand(r1)*.1+.35), (rand(r1)*.15+.45)> 
      rotate <0, rand(r1)*360, rand(r1)*15-7.5>
      translate <23, -7.5+rand(r1), 6> 
      bounded_by { box { <19, -5, 2> <27, 12, 10> }}} 
    object { 
      palme() 
      scale <(rand(r1)*.15+.45), (rand(r1)*.1+.35), (rand(r1)*.15+.45)> 
      rotate <0, rand(r1)*360, rand(r1)*15-7.5>
      translate <28, -7+rand(r1), 5> 
      bounded_by { box { <24, -5, 1> <32, 12, 9> }}} 
    object { 
      palme() 
      scale <(rand(r1)*.15+.45), (rand(r1)*.1+.35), (rand(r1)*.15+.45)> 
      rotate <0, rand(r1)*360, rand(r1)*15-7.5>
      translate <30, -8+rand(r1), -7> 
      bounded_by { box { <26, -5, -11> <34, 12, -3> }}}       
    object { 
      palme() 
      scale <(rand(r1)*.15+.45), (rand(r1)*.1+.35), (rand(r1)*.15+.45)> 
      rotate <0, rand(r1)*360, rand(r1)*15-7.5>
      translate <31, -7+rand(r1), 12> 
      bounded_by { box { <27, -5, 8> <35, 12, 16> }}}       
    object { 
      palme() 
      scale <(rand(r1)*.15+.45), (rand(r1)*.1+.35), (rand(r1)*.15+.45)> 
      rotate <0, rand(r1)*360, rand(r1)*15-7.5>
      translate <32, -7+rand(r1), 5> 
      bounded_by { box { <28, -5, 1> <36, 12, 9> }}}       
}                  

// -------------   FELSEN - ROCKS ----------------

#declare felstex = material {
  texture { 
    pigment { 
      bozo
      color_map {
        [0.0 rgb .30 ]
        [0.2 rgb .32 ]
        [0.4 rgb .33 ]
        [0.5 rgb .35 ]
        [1.0 rgb .35 ]
      }
    } 
    normal { 
      average 
      normal_map {
        [bozo .5 turbulence .25 scale 21.5]
        [wrinkles .25 turbulence .25 scale .5 ]        
      }
    }
  }  
  texture { 
    pigment {
      granite
      turbulence .5
      color_map {
        [0.0 Gray20 ]
        [0.125 Gray25 ]
        [0.25 transmit 1 ]
        [1.0 transmit 1 ]
      }     
      rotate z*-90
      scale <10, 10, 7>
    }
  }
}
  
#declare fels1 = difference {
  blob {
    threshold .75
    cylinder { <0, -2, 0> <0, 2, 0> 4 1 }
    cylinder { <0, -2, 2> <0, 2, 2> 4 1 }
    cylinder { <2, -2, -1> <2, 1.5, -1> 4 1 }
    sphere { <-1, 0, -1> 4 1  }
    sphere { <-1, 0, 1> 4 1  }
    sphere { <1, 0, 1> 4 1  }
    sphere { <2, 0, -1> 4 1 }
    sphere { <3, 0, -2> 3 1 }
    sphere { <2.5, 0, -1.5> 4 1 }  
  }                                        
  box { -20 <20, 0, 20> }
  scale <3, 2, 2>      
  material { felstex }
  finish { diffuse .4 ambient .1 conserve_energy}
}                  

#declare fels2 = difference {
  blob {
    threshold .75 
    sphere { 0 4 1 scale <1, .75, 1> }
    sphere { 0 3 1 scale <1, .5, 1> }
    bounded_by { box { -4 4 } }
  }
  box { <-4, -4, -4> <4, 0, 4> }
  scale <1.5, 2, 2.25>
  material { felstex }
  finish { diffuse .4 ambient .1 conserve_energy}
}  

#declare fels3 = difference {
  blob {
    threshold .75 
    sphere { 0 4 1 }
    sphere { <2, 0, 0> 3 1 }
    bounded_by { box { -4 4 } }
  }
  box { <-4, -4, -4> <4, 0, 4> }
  material { felstex }
  finish { diffuse .4 ambient .1 conserve_energy}
}          
                   
                   
// ------------------ Dornenranken ------------

#declare rankentex =  texture {
  pigment { 
    agate
    turbulence .5
    color_map {
      [0.0 NewTan*.7 ]
      [0.4 NewTan*.6 ]
      [0.95 DarkTan*.8 ]
      [0.9975 DarkTan*.4 ]                           
      [1.00 DarkTan*.05 ]
    }                      
  }                 
  normal { agate .2 turbulence .5 scale .75}
}

#macro dorn(objekt, start, ziel)
#local norm = <1, 1, 1>;
#local pos = trace(objekt, start, ziel-start, norm);  
cone {
  0, (rand(r2)*.1+.1), <0, (rand(r2)*.05+.05), 0>, 0
  scale <1.25, 5, .75>
  Point_At_Trans(norm)
  translate pos                     
  pigment { agate color_map { [0.0 DarkTan] [0.3 DarkTan] [0.5 DarkTan*.8] [0.8 DarkTan*.6] [0.995 DarkTan*.4] [1.0 DarkTan*.05] } }
}


#end

#declare ranke1_ = sphere_sweep{
  cubic_spline
  12    
  <0, -4, 0>, .5,
  <0, -1, 0>, .5,
  <.6, 1.7, 0>, .5,
  <1, 2.3, 0>, .5,
  <2, 2.5, .5>, .5,
  <3.5, 2.3, 1>, .4,
  <5, 2.4, -.5>, .4,
  <6, 2.3, -1.5>, .3,
  <7.5, 2.2, -2>, .3,
  <8, 2.3, -3>, .2,
  <8.5, 1.4, -3.5>, .05,
  <10, 1.5, -3.5>, 0    
  texture { rankentex }
}                                  

#declare ranke1 = merge{                                      
  object { ranke1_ }                                          
  object { dorn(ranke1_, <0, 1, -1>, <0, 1, 0>) }
  object { dorn(ranke1_, <1, 3, 2>, <1, 2.3, 0>) }    
  object { dorn(ranke1_, <2, 4, -2>, <2, 2.5, .5>) }
  object { dorn(ranke1_, <3.5, 1, 0>, <3.5, 2.3, 1>) }
  object { dorn(ranke1_, <5, 4, -3>, <5, 2.4, -.5>) }
  object { dorn(ranke1_, <6, 1, -1.5>, <6, 2.3, -1.5>) }
  object { dorn(ranke1_, <7.5, 3, -3>, <7.5, 2.2, -2>) }   
}                                                       

#declare ranke2_ = sphere_sweep{
  cubic_spline
  7  
  <-.75, -4, 0>, .6,
  <-1.75, -1, 0>, .5,
  <-2.25, 2, 0>, .45,
  <-4, 4, .25>, .4,
  <-6, 4.25, .25>, .3,
  <-9, 6.5, .4>, .15,
  <-11, 9, 0>, 0
  
  texture { rankentex }
}

#declare ranke2 = merge {
  object { ranke2_ }                 
  object { dorn(ranke2_, <0, 1, -1>, <-2, 1, 0>) }
  object { dorn(ranke2_, <-2.25, 5, 0>, <-2.25, 2, 0>) }
  object { dorn(ranke2_, <-3.5, 3, -2>, <-3.5, 3.5, 0>) }
  object { dorn(ranke2_, <-4, 6, -.5>, <-4, 4, .25>) }
  object { dorn(ranke2_, <-6, 5, -1>, <-6, 4.25, .25>) }
  object { dorn(ranke2_, <-7, 10, .3>, <-7, 5, .3>) }
}

#declare ranke3_ = sphere_sweep {
  cubic_spline      
  12  
  <-1.25, -3, 0>, .5,
  <-1.25, -1, 0>, .5,
  <-1.5, 2, 0>, .5,
  <-2, 2.5, 0>, .4,
  <-2, 3, 0>, .4,
  <-1.5, 3.5, -.25>, .4,
  <-.5, 3.5, -.4>, .3,
  <0, 3.5, -.5>, .3,
  <2, 3.25, -1>, .25,
  <4, 2.75, -2>, .2,
  <4.75, 2.5, -3.5>, .1,
  <6, 2.5, -5>, 0  
  texture { rankentex }
}   

#declare ranke3 = merge {
  object { ranke3_ }        
  object { dorn(ranke3_, <0, 1.5, -1>, <-1.5, 1.5, 0>) }
  object { dorn(ranke3_, <-2, 2.5, -2>, <-2, 2.5, 0>) }
  object { dorn(ranke3_, <-1.5, 5, -1>, <-1.5, 3.5, -.25>) }
  object { dorn(ranke3_, <-.5, 5, -.4>, <.4, 3.5, -.4>) }
  object { dorn(ranke3_, <0, 3.5, -2>, <0, 3.5, -.5>) }
  object { dorn(ranke3_, <2, 4, -.5>, <2, 3.25, -1>) }
  object { dorn(ranke3_, <3, 4, -1.5>, <3, 3, -1.5>) }
  object { dorn(ranke3_, <4, 2, -3>, <4, 2.75, -2>) }
}
                                                                                      
              
#declare geranke1 = merge {
  object { ranke1 }  
  object { ranke2 rotate y*-45 }                                        
  object { ranke3 rotate y*40 }
  rotate y*-90       
  #local inter=trace(sand, <-15, 20, -30>, <0, -1, 0>);
  translate <-15, inter.y-1, -30> 
}             

#declare geranke2 = object {
  ranke3
  rotate y
  #local inter=trace(sand, <10, 20, 20>, <0, -1, 0>);
  translate <10, inter.y-2, 20>
}   