#include "colors.inc"

#declare r1 = seed(128);

#declare lv = 0;

#declare obj1 = sphere_sweep {
  cubic_spline
  45,
  #while ( lv < 30 )
    <cos(radians(45*lv))*.525, lv*.35, sin(radians(45*lv))*.525>, .525
    #declare lv = lv + 1;
  #end                                          
  #declare lv = 30;
  #while (lv < 45 )
    <cos(radians(45*lv))*.525/pow(1.2, lv-29) , lv*.35, sin(radians(45*lv))*.525/pow(1.2, lv-29) >, .525/pow(1.2, lv-29)   
    #declare lv = lv + 1;
  #end
  tolerance 1.0e-4  
  bounded_by { box { <-3.5, -3, -3.5> <3.5, 35, 3.5> } }   
}                 

#declare saeulentex = texture {
  pigment {      
    granite
    turbulence .25
    color_map {
      [0.0 OldGold*1.25 ]
      [0.5 OldGold ]
      [1.0 OldGold*.85 ]
    }  
  }                     
  normal {
    granite .2 
    scale 5
  }          
}



#declare tor = merge {
  object { obj1 texture { saeulentex } }
  object { obj1 scale <-1, 1, -1> texture { saeulentex } }
  object { obj1 texture { saeulentex }  translate <0, 0, -10> }
  object { obj1 scale <-1, 1, -1> texture { saeulentex }  translate <0, 0, -10> }
  superellipsoid { .1 scale <4.45, .151, 12.25>translate <0, -.2, -5>  texture { saeulentex } }
  superellipsoid { .1 scale <4.1,  .151, 11.5> translate <0, -.075, -5>  texture { saeulentex } }
  superellipsoid { .1 scale <3.75, .151, 10.75>translate <0, .35, -5>   texture { saeulentex } }
  superellipsoid { .1 scale <3.4,  .151, 10>   translate <0, .625, -5>   texture { saeulentex } }
  superellipsoid { .1 scale <3.05, .151, 9.25> translate <0, .9, -5>   texture { saeulentex } }
  superellipsoid { .1 scale <2.7,  .151, 8.5>  translate <0, 1.175, -5>  texture { saeulentex } }
  superellipsoid { .1 scale <2.35, .151, 7.75> translate <0, 1.45, -5>  texture { saeulentex } }
  superellipsoid { .1 scale <2,    .151, 7>    translate <0, 1.725, -5>  texture { saeulentex } }
//  box { <0, 0, -10> <.001, 15, 0> pigment { Red } no_image }
}

#declare himtex = material {
  texture {
    pigment { 
      bozo      
      turbulence .5
      color_map {
        [0.0 White ]
        [0.3 White ]
        [0.45 SkyBlue ]
        [1.0 SkyBlue ]
      }
      scale 1.5
    }
    finish { ambient .6 }
  }
  texture {
    pigment {
      gradient x 
      turbulence .5
      color_map {  
        [0.0 White ]
        [0.25 White ]
        [1.0 White transmit 1 ]
      }                        
      scale 40
    }
    finish { ambient .7 }
  }  
}                 

#declare hintertex = texture {
  pigment { 
    White   
  }
  finish { ambient .7 }
}                  

#declare wassertex = texture {
  pigment { SlateBlue }
  normal { crackle .25 turbulence .25 scale 2.5 }
  finish { ambient .25 diffuse .2 brilliance 6 
          phong .3 phong_size 90
          reflection .95 conserve_energy}
}

#declare raum1 = merge {
  #declare dist = 30;
  box { <-dist-.1, 1.25, -55+(45/60)*(60+dist)> <-dist, 3, -55+(55/60)*(60+dist)> texture { hintertex } }
  prism { 
    linear_spline linear_sweep 0, .1, 5
    <0, -10>, <0, 0>, <-33, -55+(55/60)*(60+dist)>, <-33, -55+(45/60)*(60+dist)>, <0, -10>
    rotate z*(degrees(atan2(12,30)))  
    translate y*15
    material { himtex }
  }                                
 
  light_group {
    prism {
      linear_spline linear_sweep 0, .1, 5
      <0, -10>, <0, 0>, <-dist-.1, -55+(55/60)*(60+dist)>, <-dist-.1, -55+(45/60)*(60+dist)>, <0, -10>
      texture { wassertex } 
      translate y*1.91 
    }                                                   
    light_source { <-2, 10, -5> White fade_distance 20}
  }
no_shadow
}

#macro _effekt()
#local efrad = rand(r1)*.25+.5;
sphere {
  0, efrad 
  pigment { transmit 1 }
  hollow
  interior {
    media {
      emission <rand(r1), rand(r1)*.75, rand(r1)>
      density { spherical scale efrad } 
      density { bozo scale .25 }
    }
  }    
}
#end


#declare eflv = 0;

#macro effekt1()
#declare eflv = 0;
  union {
    #while ( eflv < 10 )
      #local xpos = rand(r1)*6-3;
      #local ypos = rand(r1)*3+16;
      #local zpos = rand(r1)*6-3;
      object { _effekt() translate <xpos, ypos, zpos> }
      #declare eflv = eflv + 1;
    #end
  #declare eflv = 0;
    #while ( eflv < 30 )
      #local xpos = rand(r1)*8-4;
      #local ypos = rand(r1)*7+8;
      #local zpos = rand(r1)*8-4;
      #if ( (xpos > .8) | (zpos >.8) )
        object { _effekt() translate <xpos, ypos, zpos> }
      #end
      #declare eflv = eflv + 1;
    #end 
  #declare eflv = 0;
    #while ( eflv < 30 )
      #local xpos = rand(r1)*10-5;
      #local ypos = rand(r1)*5+3;
      #local zpos = rand(r1)*10-4;
      #if ( (xpos > .8) | (zpos >.8) )
        object { _effekt() translate <xpos, ypos, zpos> }
      #end
      #declare eflv = eflv + 1;
    #end 
  }

#end
