/*/////////////////////////////////////////////////////
Hey, thanks for downloading my file.

I must warn you though, the coding for this image
is extremely sloppy, lots of unnecessary intersections
and merges, etc...  But time was working against me
so I had to worry about the image first and the
coding second.

Lastly, in order to make downloading this file less
painful, I've compressed some of the .bmp formatted
textures.  It kind of seems excessive to download
a 11 Mb wood texture.  Anyway, any information
you can harvest from this picture (if any) probably 
won't be hindered by blurry textures.

-Ian McNamara
*//////////////////////////////////////////////////////

#include "functions.inc"

// Controls //////////////////////

#declare Plate          = 1;
#declare Frosting       = 1;
#declare Cake           = 1;
#declare Crumbs         = 1;
#declare Cactus         = 1;
#declare Sun            = 1;
#declare Table          = 1;
#declare Radiosity_Full = 1;

//////////////////////////////////

camera { 
        location <-4,12,-10>
        look_at <1,0,0>
        }

//////////////////////////////////

#if (Radiosity_Full)
        
global_settings {
        max_trace_level 4
        radiosity {
                pretrace_start 0.08
                pretrace_end   0.01  
                count 400      

                nearest_count 10 
                error_bound 1 
                recursion_limit 2.5

                low_error_factor 1 
                gray_threshold 0
                minimum_reuse 0.015 
                brightness 1

                adc_bailout 0.01/2
                } 
        noise_generator 2        
        }

#else

global_settings {
        max_trace_level 4
        radiosity {
                pretrace_start 0.08
                pretrace_end   0.04  
                count 5      

                nearest_count 10 
                error_bound 1 
                recursion_limit 2.5

                low_error_factor 1 
                gray_threshold 0
                minimum_reuse 0.015 
                brightness 1

                adc_bailout 0.01/2
                } 
        noise_generator 2        
        }
                
#end 

box {
        <-100,0,-100>, <100,1,100>
        pigment { rgb <1,1,1> }
        finish { ambient 1.5 }
        translate <0,15,0>
        no_shadow
        }
        
////////////////////////////////////////////////////////////

#if (Table)
        
box {
        <-10,-1,-20>, <35,0.1,30>
        pigment { 
                image_map { sys "d_wood.bmp" } 
                rotate x*90 
                scale 50 
                translate <-10,0,-20>
                }
        finish { ambient 0.1 reflection 0.02 metallic}
        } 

#else

plane {
        y,0.1
        pigment { rgb <1,1,1> }
        finish { ambient 0 }
        }
        
#end

///////////////////////////////////////////////////////////

#if (Sun)
                
light_group {
        light_source {
                <0,10,0>
                rgb 1.5 
                }                       
        box {
                <-1,0,0>, <1,2,0.0001>
                pigment {
                        image_map { png "d_sun.png" }      
                        scale 2     
                        translate <-1,0,0>
                        }       
                finish { ambient 0 }
                no_shadow 
                no_reflection
                rotate y*-15 
                translate <0,3.6,7.7>
                rotate y*55
                translate <-3,0,-3>        
                } 
        global_lights on 
        }                      

#else
#end
                
/////////////////////////////////////

#if ( Plate )

#declare Plate_Texture = 
        texture {
                pigment {
                        ripples 
                        turbulence 1
                        color_map {
                                [ 0 rgb <1.2,1.2,1.2> ]
                                [ 0.8 rgb <0.3,0.3,0.9> ]
                                [ 1 rgb <0.3,0.3,0.9> ]
                                }
                        scale 6                
                        }
                finish { 
                        ambient 0
                        reflection 0.05
                        }
                }
                       
lathe { 
        cubic_spline
        17,
        <-5,0.95>, <0,0.95>,<1,0.95>,<2,0.95>,<3,1>,
        <6,1.1>, <8.1,2>, <8,1.65>, <7,1.1>,
        <6.2,0.5>, <6,0>, <5.8,0>, <5,0.5>, <2,0.5>, <0,0.5>,
        <0,0.5>, <-5,0.5>
        texture { Plate_Texture } 
        translate <1.5,0.1,1.25>
        no_shadow
        } 
#else
#end

////////////////////////////////////////

#if ( Frosting )

#declare Sand_Tex = 
        texture {
                pigment { image_map { "d_sand.bmp" } scale 4 }
                finish { ambient 0.1 }
                rotate x*90
                }
                
#declare Top_Sand_Function = 
        function {
                pigment {
                        ripples
                        turbulence 0.45 //0.4
                        color_map {
                                [0 color rgb 0.2] 
                                [0.3 color rgb 0.25]
                                [1 color rgb 1]
                                }
                        scale 4.5  //3
                        rotate y*-32   //-30
                        translate <-60,0,-40> // <-60,0,-40>
                        }
                }
                
#declare Bottom_Sand_Function = 
        function {
                pigment {
                        ripples
                        turbulence 0.4
                        color_map {
                                [0 color rgb 0.1] 
                                [0.3 color rgb 0.15]
                                [1 color rgb 1]
                                }
                        scale 2
                        rotate y*-30
                        translate <-60,0,-20>
                        }
                } 
#declare Side_Sand_Function = 
        function {
                pigment {
                        ripples
                        turbulence 0.34 //0.3
                        color_map {
                                [0 color rgb 0] 
                                //[0.3 color rgb 0.15]
                                [1 color rgb 0.7]
                                }
                        scale <10,0.4,1>      //10,0.3,1
                        //rotate x*90
                        translate <4,0,-12.9>      //4,0,-10
                        }
                }
#declare Outside_Sand_Function = 
        function {
                pigment {
                        ripples
                        turbulence 0.4
                        color_map {
                                [0 color rgb 0] 
                                //[0.3 color rgb 0.15]
                                [1 color rgb 0.7]
                                }
                        scale <10,0.5,1>
                        //rotate x*90
                        translate <4,0,-10>
                        }
                }                                
#declare Frosting_Top = 
        function { (y-3.9)-(Top_Sand_Function(x,y,z).gray*0.7) }                                   
#declare Frosting_Bottom = 
        function { (-y+4)-(Bottom_Sand_Function(x,y,z).gray*0.15) } 
#declare Frosting_Top_Bottom =  
        function { max( Frosting_Top(x,y,z), Frosting_Bottom(x,y,z)) }
#declare Frosting_Side = 
        function { (z+0.01)-Side_Sand_Function(x,y,z).gray*0.2 }        
#declare Frosting_Top_Bottom_Side =  
        function { max( Frosting_Top_Bottom(x,y,z), -Frosting_Side(x,y,z)) }
#declare Frosting_Outside_Out =                         
        function { (sqrt(pow(x,2) + pow(z,2)) - 7.55)+Outside_Sand_Function(x,y,z).gray*0.2 }
#declare Frosting_Outside = 
        function { max( Frosting_Outside_Out(x,y,z), -Frosting_Side(x,y,z)) }

#declare Top_Frosting_Unshaped =         
        isosurface { //This is the final piece of Sand Frosting, unshaped...
                function { Frosting_Top_Bottom_Side(x,y,z) } 
                max_gradient 2
                contained_by {
                        box {
                                <-0.01,3.79,-0.01>, <7.51,4.61,6>
                                }
                        }        
                texture { Sand_Tex }
                
                }
#declare Outside_Frosting_Unshaped =                                 
        isosurface { //This is the Sand around the outside of the cake
                function { Frosting_Outside(x,y,z) } 
                max_gradient 2
                contained_by {
                        box {
                                <4,0.9,-0.01>, <7.51,4,6>
                                }
                        }        
                texture { Sand_Tex }
                }
                                
#declare Final_Sand_1 =
intersection {
        object {
                Top_Frosting_Unshaped
                }
        cylinder {
                <0,3.8,0>, <0,4.61,0>, 7.51
                texture { Sand_Tex }
                }
        plane {
                -x,0
                rotate y*40
                texture { Sand_Tex }
                }
        }                                          

#declare Final_Sand_2 =
#intersection {
        object { Outside_Frosting_Unshaped }
        difference {
                cylinder {
                        <0,0,0>, <0,5,0>, 7.51
                        texture { Sand_Tex }
                        }
                cylinder {
                        <0,-0.1,0>, <0,5.1,0>, 7.2
                        texture { Sand_Tex }
                        }
                }
        plane {
                -x,0
                rotate y*40
                texture { Sand_Tex }
                }        
        }                           

object {
        Final_Sand_1
        rotate y*-10
        translate <-3,0,-3>
        }
object {
        Final_Sand_2
        rotate y*-10
        translate <-3,0,-3>
        }
                                                        
#else
#end        

/////////////////////////////////////////  

#declare Dirt_Tex = 
        texture {
                pigment { image_map { "d_dirt.bmp" } }
                finish { ambient 0.1 specular 0.2 }
                
                } 
#if (Cake)

               
#declare Dirt_Function = 
        function {
                pigment {
                        agate 
                        turbulence 0.3
                        color_map {
                                [0 color rgb 0.1]
                                //[0.9 color rgb 0.3] 
                                [1 color rgb 0.6]
                                }
                        scale <2,0.5,1> 
                        translate <3,-20,0>
                        }
                }
#declare Top_Dirt_Function = 
        function {
                pigment {
                        ripples
                        turbulence 0.4
                        color_map {
                                [0 color rgb 0.1] 
                                [0.3 color rgb 0.15]
                                [1 color rgb 1]
                                }
                        scale 2
                        rotate y*-30
                        translate <-60,0,-20>
                        }
                }

#declare Cake =                
intersection {          
        cylinder {
                <0,0.89,0>, <0,4,0>, 7.15
                texture { Dirt_Tex }
                }
        plane {
                -x,0
                rotate y*40
                texture { Dirt_Tex }
                }                        
        merge { // The cake itself
                box {
                        <0,0.9,0.11>, <7.21,3.95,5>
                        texture { Dirt_Tex }
                        }
                isosurface {  // -z face // The holes in the cake
                        function { (f_noise3d(x*12,y*12,z*12)-0.55) }
                        max_gradient 100
                        contained_by {
                                box {
                                        <0.08,0.9,-0.11>, <7.21,3.95,0.11>   //0.1
                                        }
                                }
                        texture { Dirt_Tex }
                        }  
                }
        isosurface { // adds waves to the large side of the cake
                function { -z+Dirt_Function(x,y,z).gray*0.2 }
                max_gradient 15
                contained_by {
                        box {
                                <-0.1,0.87,6.2>, <7.5,4,0>
                                }
                        }
                texture { Dirt_Tex }
                translate <0,0,-0.1>
                } 
        isosurface { // Smoothes pointy edge of cake
                //function { -x+Dirt_Function(x,y,z).gray*0.1 }
                function { -x+(f_noise3d(x*10,y*10,z*10)-0.55) }
                max_gradient 15
                contained_by {
                        box {
                                <-0.1,0.86,2>, <9,4.1,-2>
                                }
                        }
                texture { Dirt_Tex } 
                rotate y*-5
                translate <0.12,0,0>    //0.1
                }
        plane { // Removes flakes of cake from where it meets the icing on the right
                //function { -x+Dirt_Function(x,y,z).gray*0.1 }
                x,0
                texture { Dirt_Tex } 
                rotate y*45
                translate <7.2,0,0.1>    //0.1
                }
        plane { // Removes flakes of cake from where it meets the icing on the right     /////////////////////////////////
                //function { -x+Dirt_Function(x,y,z).gray*0.1 }
                -z,0
                texture { Dirt_Tex } 
                rotate x*-50
                translate <7.2,1,0.2>    //0.1
                }                                  
        isosurface { // matches top of cake to bottom of icing
                function { (y-4)+(Top_Dirt_Function(x,y,z).gray*0.15) }
                max_gradient 15
                contained_by {
                        box {
                                <-0.1,0.86,6.2>, <7.5,4.1,-0.11>
                                }
                        }
                texture { Dirt_Tex }
                translate <0.1,0,0>
                }                                 
        }          

#declare Cake_2 = 
intersection {          
        cylinder {
                <0,0.89,0>, <0,4,0>, 7.2
                texture { Dirt_Tex }
                }
        plane {
                -x,0
                rotate y*40
                texture { Dirt_Tex }
                }
        box {
                <0,0,0.11>, <7.5,4,6>
                texture { Dirt_Tex }
                }
        }
#declare Cake_3 = 
intersection {          
        cylinder {
                <0,0.89,0>, <0,4,0>, 7.2
                texture { Dirt_Tex }
                }
        plane {
                -x,0
                rotate y*40
                texture { Dirt_Tex }
                }
        box {
                <0.1,0,-0.11>, <7.5,1,0.11>
                texture { Dirt_Tex }
                }
        }        
light_group {
        light_source {
                <0,10,-10>
                rgb 0.4 
                }                                            
        object {
                Cake
                rotate y*-10
                translate <-3,0,-3>
                } 
        object {
                Cake_2
                rotate y*-10
                translate <-3,0,-3>
                }
        object {
                Cake_3
                rotate y*-10
                translate <-3,0,-3>
                } 
        global_lights on
        }
box {
        <0.1,1.15,0.05>, < 7.2,1,0.2>
        texture { Dirt_Tex }
        rotate y*-10
        translate <-3,0,-3>
        }                                                                                      
#else
#end

///////////////////////////////////////////////////////////////////////////////////////////////

#if (Cactus) 

light_source {
        <20,20,15>
        rgb 0.2 
        spotlight
        point_at <2,5,0>
        radius 2.5
        falloff 4
        area_light 
        <0,0,0.2>, <0,0.2,0>, 4,4
        } 
        
#declare Cactus_Tex = 
        texture {
                pigment {
                        wood
                        turbulence 0.1
                        color_map {
                                [0 color rgb <0.6,0.8,0.6> ]
                                [0.4 color rgb <0.55,0.75,0.55> ]
                                [1 color rgb <0.6,0.8,0.6> ]
                                }
                        scale <1.5,2,1.5>
                        rotate z*90         
                        }
                finish { ambient 0 specular 0 }            
                }
                 

#declare Cactus = 
        merge {                
//////////////////
        cylinder {
                <0,0,0>, <0,20,0>, 0.5
                texture { Cactus_Tex }
                }
        sphere {
                <0,0,0>, 0.5
                scale <1,1.5,1>
                translate <0,20,0>
                texture { Cactus_Tex }
                }
////////////////////        
        intersection {
        torus {
                1.2, 0.45 
                texture { Cactus_Tex }
                rotate x*90 
                scale <1,1.5,1>
                translate <0.1,6,0>
                }
        box {
                <-1.66,3,-0.46>, <0,6,0.46>
                texture { Cactus_Tex }
                }
        }
        cone {
                <-1.1,5.95,0>, 0.45
                <-1.4,14,0>, 0.4
                texture { Cactus_Tex }
                }
        intersection {
        sphere {
                <0,0,0>, 0.4
                scale <1,1.5,1>
                texture { Cactus_Tex }
                translate <-1.4,14,0>
                }
        box {
                <-1.81,14,-0.41>, <0.79,16,0.41>
                texture { Cactus_Tex }
                }
        } 
///////////////////////
        intersection {
        torus {
                1.3, 0.45
                texture { Cactus_Tex }
                rotate z*90 
                scale <1,1.5,1>
                translate <0,8.5,-0.1>
                rotate y*110
                } 
        box {
                <-0.5,6,0>, <0.5,8.5,1.7>
                texture { Cactus_Tex }
                rotate y*110
                }
        }        
        cone {
                <0,8.5,1.2>, 0.45
                <0.3,17,1.3>, 0.4
                texture { Cactus_Tex }
                rotate y*110
                }
        intersection {
        sphere {
                <0,0,0>, 0.4
                scale <1,1.5,1>
                texture { Cactus_Tex }
                translate <0.3,17,1.3>
                rotate y*110
                }
        box {
                <-0.8,16.9,0.8>, <1,18,1.9>
                texture { Cactus_Tex }
                rotate y*110
                }
        }        
///////////////////////
        }

object {
        Cactus
        scale 0.075 
        rotate y*195
        translate <0.7,4.15,0>
        }
                                                                                                                                                                             
#else
#end 

/////////////////////////////////////////////////////////////////////////////////////////////// 

#if (Crumbs)

#declare Sphere = function {(x*x)+(y*y)+(z*z)}

#declare Crumb =
        isosurface {
                function {Sphere(x,y,z) + f_noise3d(x*2,y*2,z*2)*1.2} 
                contained_by {
                        box {
                                <-1,-1,-1>, <1,1,1> 
                                }
                        }        
                threshold 1
                max_gradient 3.9
                accuracy 0.01
                scale 0.5
                no_reflection 
                no_shadow
                }

#declare R1 = seed(0);
   
#declare Index = 0;
#while ( Index < 40 )
        object {
                Crumb
                rotate rand(R1)*360
                scale (0.15+rand(R1)*0.3)/2
                translate <rand(R1)*8,0,rand(R1)*4>
                texture { Dirt_Tex }
                translate <-0.5,1.1,-2>
                rotate y*-15
                translate <-3,0,-3>
                }
        object {
                Crumb
                rotate rand(R1)*360
                scale (0.1+rand(R1)*0.15)/2
                translate <rand(R1)*8,0,rand(R1)*5> 
                translate <0,0,-1>
                texture { Dirt_Tex } 
                translate <-0.5,1.1,-2.5>
                rotate y*-15
                translate <-3,0,-3>
                } 
#declare Index = Index+1;
#end  

#declare R1 = seed(0);
   
#declare Index = 0;
#while ( Index < 40 )
        object {
                Crumb
                rotate rand(R1)*360
                scale (0.15+rand(R1)*0.3)/2
                translate <rand(R1)*8,0,rand(R1)*4>
                texture { Dirt_Tex }
                translate <-1,1.2,-2>
                rotate y*-20  
                rotate z*-10
                translate <-2.5,0,-3>
                }
        object {
                Crumb
                rotate rand(R1)*360
                scale (0.1+rand(R1)*0.15)/2
                translate <rand(R1)*8,0,rand(R1)*5> 
                translate <0,0,-1>
                texture { Dirt_Tex } 
                translate <-1,1.2,-2.5>
                rotate y*-20 
                rotate z*-10
                translate <-2.5,0,-3>
                } 
#declare Index = Index+1;
#end 
       
#else
#end 

//////////////////////////////////////////////////////////////////////                     