// Copyright (c) Duncan Gray, 2k4

// Standard stuff I seem to be pasting in the top of all my POV's these days ...
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "functions.inc"

#declare f_fullrender=on;     // comment any or all of these
//#declare f_interior=on;       // out to turn off
//#declare f_photons=on;        // n.b. DO NOT set to OFF (or off)
#declare f_arealight=on;      // test is if they are declared
//#declare f_spotlight=on;      // or not, not if they are on/off

global_settings {
  assumed_gamma 1.8
  max_intersections 350
  max_trace_level 256
  #ifdef(f_photons)
  photons {
    count 3000000
    media 100
    autostop 0
    jitter .3
    load_file "photonmap.ptm"
  }
  #end
  #ifdef(f_radiosity)
  radiosity {
    adc_bailout 0.01 
    always_sample on 
    brightness 1  
    count 35 
    error_bound 1.8
    gray_threshold .3
    low_error_factor .6
    max_sample -1 
    media on 
    minimum_reuse .015 
    nearest_count 5
    normal on 
    pretrace_end .04 
    pretrace_start .08 
    recursion_limit 3  
    load_file "radiomap.rad"
  }
  #end
}


#declare amb_light=.1;

#include "desert2_iso.inc"
object { dunes }
object { rocks translate <0,-1.25,0> }

//#declare cam_loc=trace(dunes,<5,103.2,58>,<0,-1,0>)+y*1.6;
//#declare cam_loc=trace(dunes,<28,100,80>,<0,-1,0>)+y*1.6;
//#declare cam_loc=trace(dunes,<75,100,95>,<0,-1,0>)+y*1.6;
#declare cam_loc=trace(dunes,<-1.5,100,2.65>,<0,-1,0>)+y*1.6;
//#declare cam_loc=<0,2,2>;
#declare cam_tgt=cam_loc+<-1,-.8,4>;   

//union { sphere { 0,.2 } cylinder { <0,-1.6,0>,<0,.2,0>,.05 } translate cam_loc pigment { color rgb<1,.3,.3> } }
//cylinder { <0,-1.6,0>,<0,.2,0>,.05 translate cam_loc+<-1.5,0,8> pigment { color rgb<.3,.7,.3> } }
//#declare cam_loc=cam_loc+<0,4,-25>;

#render concat("cam_tgt=<",str(cam_tgt.x,7,2),",",str(cam_tgt.y,7,2),",",str(cam_tgt.z,7,2),">\n")

#declare lamp1_tgt=cam_tgt;//<0,0,0>;
#declare lamp1_pwr=.7;
#declare lamp1_pos=vnormalize(<.35,.8,-.35>)*30000+lamp1_tgt;
#declare pen_light=.1;    
#declare pen_pos=lamp1_pos;
#declare fil_pwr1=.0;    
#declare fil_pos1=vnormalize(<1,-1,-1>)*30000+lamp1_tgt;
#declare fil_pwr2=.1;    
#declare fil_pos2=vnormalize(<-1,1,-1>)*30000+lamp1_tgt;



#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;

  #if ( ( current_clock >= start_clock ) & ( current_clock <= end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #else
    #if ( current_clock <= start_clock )
      (start_position)
    #else
      (end_position)
    #end
  #end
#end        

//background sky sphere
#declare sky_color=
  texture {
    pigment {
      cylindrical
      color_map {
        [ 0 color <.18,.2,.4> ]
        [ 1 color <.25,.3,.7>*.6 ] 
      }
    }
    finish {
      ambient 1
      diffuse 0
    }
  }
#declare sky_cloud=
  texture {
    pigment {
      bozo
      turbulence .2
      lambda 1.5
      omega .85
      octaves 11
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ 0.4 color rgbt<1,1,1,1> ]
        [ 0.8 color rgbt<1,1,1,.5> ]
        [ 2 color rgbt<1,1,1,0> ]
      }
    }
    finish {
      ambient 1
      diffuse 0
    }
    scale <.5,.05,.5>
    scale .25
    rotate <0,-40,0>
  }
object {
  sphere { <0,0,0> 1 inverse  }
  texture { sky_color }
  texture { sky_cloud translate <0,-.006,0> }
  translate <0,-.98,0>
  scale 10000
  hollow
  no_shadow
}                
// camera and lights and caption

camera
{           
  location cam_loc  
  
  direction <0,0,1.43>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
  
}

light_source { 
  lamp1_pos
  color 1
  #ifdef(f_arealight)
  area_light <1000,0,0>,<0,0,1000>,3,3
  adaptive 1
  jitter
  #end
  #ifdef(f_spotlight) 
  spotlight
  radius 2.5
  falloff 4
  point_at lamp1_tgt
  fade_distance 30
  fade_power 3
  #end
  #ifdef(f_photons)
    photons {
     refraction on
     reflection on
    }
  #end
}
light_source { pen_pos color pen_light shadowless }
light_source { fil_pos1 color fil_pwr1 shadowless }
light_source { fil_pos2 color fil_pwr2 shadowless }

// this next calculates the rotation and position required for
// the Gray message in the bottom right corner
  #declare cam_dir=vnormalize(cam_tgt-cam_loc);
  #declare cam_head=180*atan2(cam_dir.x,cam_dir.z)/pi;
  #declare cam_dir=vrotate(cam_dir,<0,-cam_head,0>);
  #declare cam_ang=-180*atan2(cam_dir.y,cam_dir.z)/pi;
  #declare dimmer=.8;
                     
  #declare t2dim=.7;
  union {
    box { <-.1,-.025,0.001>,<.1,.025,0.002>
      texture { 
        pigment { 
          rgbf <1,1,1,dimmer>
        }
        finish {
          ambient 0
          diffuse 0
        }
      }
    }  
    object {
      text {
        ttf "comic.ttf"
        "Duncan Gray."
        1,0                      
        translate <-3,-.4,0>
        scale <.025,.025,.00001>
      }
      texture { 
        pigment { 
          rgbf <1,1,1,t2dim>
        }
        finish {
          ambient 1
          diffuse 0
        }
      }
    }  
    scale .5            
    translate <.22,-.19,.5>
    translate <0,0,.12>
    rotate <cam_ang,cam_head,0>
    translate cam_loc 
    no_shadow
  }

// end of std stuff - here's the desert scene ...

#include "sign.inc"
#declare sign_pos=trace( dunes , cam_tgt+<-.54,30,-1.3> , <0,-1,0> );
object { sign rotate <0,-8,-9> translate sign_pos }

#include "plant.inc"
#declare plant_pos=trace( dunes , cam_tgt+<-.35,30,-1.38> , <0,-1,0> );
object { plant2(<0,0,0>,<0,1,0>,1,317) rotate <0,215,0> translate plant_pos }


#macro isinview(pos,cam_pos,cam_tgt)
// assuming 'normal' aspect ration - this funtion will return 1
// if the position pos is within the view-field of the camera (ish)
  #declare crot=<0,0,0>+x*degrees(atan2(cam_tgt.y-cam_pos.y,vlength(cam_tgt-cam_pos)));
  #declare crot=crot+y*degrees(atan2(cam_tgt.x-cam_pos.x,cam_tgt.z-cam_pos.z));
  
  #declare orot=<0,0,0>+x*degrees(atan2(pos.y-cam_pos.y,vlength(pos-cam_pos)));
  #declare orot=orot+y*degrees(atan2(pos.x-cam_pos.x,pos.z-cam_pos.z));                                     
  
  #if (abs(orot.y-crot.y)>28)
    0;
  #else
    1;
  #end
#end

// this routing creates 10 plants of type 1, and seeds thesse 10 plants all over the place.
// general rule for seeding is that routine will look for a place where tracing the rock
// function returns a higher y than the result of tracing the dune function
// (ie rock is prominent above sand)
// it then rtackseast-by south east (ish) until it hits sand.
// this is to reflect there being a greater probability of a seed taking root
// immediately downwind of a rock.
#declare seedpos=seed(100);
#local np=0;
#local pv=10;
#local plant_t2=array[pv];
#while (np<pv)  // build a range of plants
  #local plant_t2[np]=plant2(<0,0,0>,<0,1,0>,.2+.8*(np/10),rand(seedpos)*65535);
  #local np=np+1;
#end
#local np=0;
#while (np<350)    
  #local ppos=<50-rand(seedpos)*100,0,rand(seedpos)*100+1 >;
  #local inview=isinview(ppos,cam_loc,cam_tgt)
  #if ( inview!=0 )
    #local rock_alt=trace(rocks,ppos+y*100,<0,-1,0>);
    #local dune_alt=trace(dunes,ppos+y*100,<0,-1,0>);
    #if (dune_alt.y<rock_alt.y-1.25) // if landed on (or near) rock
      #debug "oooo, seed type 1 found a rock, searching for some sand\n"
      #while  (dune_alt.y<rock_alt.y-1.25) //while still on (or near) rock
        #local ppos=ppos+<.1,0,-.05>;
        #local rock_alt=trace(rocks,ppos+y*100,<0,-1,0>);
        #local dune_alt=trace(dunes,ppos+y*100,<0,-1,0>);
        #debug "."
      #end
      #debug "yay, seed has found somewhere to grow - "
      #local ppos=dune_alt;
      object { plant_t2[int(rand(seedpos)*pv)] rotate <0,360*rand(seedpos),0> translate ppos }
      #debug concat("Planted seed ",str(np.x,7,2)," @ <",str(ppos.x,7,2),",",str(ppos.y,7,2),",",str(ppos.z,7,2),">\n")
      #local np=np+1;
    #end    
  #end
  //#local np=np+1;  
#end
              
// same idea - 10 sample plants created for scattering.
// this time seeding function looks for sand rather than rocks, but it will randomly
// select 10 locations for the plant, of these 10 positions, it will go for the one
// with thelowest y result from a trace (ie the lowest altitude)
// this reflects this plant type being more sucessfull in hollows rather than on top of dunes.              
#declare seedpos=seed(100);
#local np=0;
#local pv=10;
#local plant_t1=array[pv];
#while (np<pv)  // build a range of plants
  #local plant_t1[np]=plant1(<0,0,0>,5+15*(np/10));
  #local np=np+1;
#end
#local np=0;
#while (np<500)    
  #local ntries=10;

  #declare best_pos=<0,200,0>; // very bad position - certainly randomly betterable.
  #while (ntries>0 | best_pos.y>100)
    #local ppos=<rand(seedpos)*100-50,0,rand(seedpos)*100+1 >;
    #local inview=isinview(ppos,cam_loc,cam_tgt)
    #if ( inview!=0 )
      #local rock_alt=trace(rocks,ppos+y*100,<0,-1,0>);
      #local dune_alt=trace(dunes,ppos+y*100,<0,-1,0>);
      #if (dune_alt.y>rock_alt.y-1.25) // if landed on sand
        #if (dune_alt.y<best_pos.y)
          #local best_pos=dune_alt;
        #end
      #end
    #end
    #declare ntries=ntries-1;
  #end
  
  #local ppos=best_pos;
    object { plant_t1[int(rand(seedpos)*pv)] scale 5 rotate <0,360*rand(seedpos),0> translate ppos }
  #debug concat("Planted seed ",str(np.x,7,2)," @ <",str(ppos.x,7,2),",",str(ppos.y,7,2),",",str(ppos.z,7,2),">\n")
  #local np=np+1;
#end
//#include "plant.inc"
//object { plant1(sign_pos+<+.15,0,.05>,45) }
//object { plant1(sign_pos+<+.05,0,.05>,15) }

fog {
    distance 400
    color rgbt<0.80, 0.85, 0.9,.6>
    fog_type 2
    fog_offset 5
    fog_alt 50
  }

