// Copyright (c) Duncan Gray, 2k4
#declare dune_tex=
  texture {
    pigment {
      color rgb<122,96,48>/200
    }
    finish { 
      ambient amb_light
      diffuse .6
      roughness .5
      specular .25
    }
    normal {
      bumps .2
      scale .001
    }
  }

#declare rock_tex=
  texture {
    pigment {
      //color rgb<93/255,48/255,19/255>
      bozo
      scale 16
      color_map {                                   
        [ 0 color rgb<96/255,96/255,74/255>*.1 ]   
        //[ 1 color rgb<96/255,74/255,58/255>*.8 ]
        //[ 0 color rgb<122,96,48>/300 ]
        [ 1 color rgb<122,96,48>/300+<0,0,.1> ]
      }
    }
    finish { 
      ambient amb_light
      diffuse .6
      roughness .1
      specular .05
    }
    normal {
      bumps .2
      scale .001
    } 
  }










#declare base_large_und=
  function (x,y,z) {
    
    +f_noise3d( x/4,0,z/4)*.06
    +f_noise3d( x/32-1.4,0,z/32-.1)*.6
    
  }
#declare dune_undulations=
  function (x,y,z) {
    +pow(base_large_und(x,y,z),1.2)*30
  }


#declare pig_crackle=
  function {
    pigment {
      crackle
      color_map {
        [ 0 color rgb<0,0,0> ]
        [ 1 color rgb<1,1,1> ]
      }
    }
  }

#declare fn_crackle=
  function (x,y,z) {
    +pig_crackle(x/2-.3,y/2,z/2+.1).x

  }
#declare pig_granite=
  function {
    pigment {
      granite
      color_map {
        [ 0 color rgb<0,0,0> ]
        [ 1 color rgb<1,1,1> ]
      }
    }
  }

#declare fn_granite=
  function (x,y,z) {
    +pig_granite(x/2,y/2,z/2).x/25
  }


#declare fn_sphere=
  function (x,y,z) {
    max(2-pow(x*x+y*y+z*z,1/3),0)
  }
#declare fn_spike1=
  function (x,y,z) {
    fn_sphere(x+y/4,y/3-1,z)
  }
#declare fn_spike2=
  function (x,y,z) {
    fn_sphere(x*1.5+y/4,y/1.5,z*1.5)
  }
#declare fn_spikes=
  function (x,y,z) {
    +fn_spike1(x,y,z)
    +fn_spike2(x+2.5,y-.5,z)
    +fn_spike2(x+1,y,z+1)
  }
  
#declare fn_rocks=
  function (x,y,z) {
    y
    -dune_undulations(x+.5,y,z-.5)/.92
    
    //-max(fn_crackle(x,y,z),.15+fn_crackle(x*4,y*4,z*4)/4)
    //-max(fn_crackle(x,y,z),(.1+fn_crackle(x*4,y*4,z*4)*.4)+(.3+fn_crackle(x*16,y*16,z*16)*.05))
    -max( (fn_crackle(x,y,z)*.9)+pow(.04*sin(256*y)*f_noise3d(x*8,y*8,z*8),2),(.1+fn_crackle(x*4,y*4,z*4)*.3)+(.2+fn_crackle(x*16,y*16,z*16)*.05) )
    
    -f_noise3d(x*5,y*5,z*5)/12
    +(fn_granite(x+1,y,z)*3)
    //-fn_spikes(x-2,y-7,z-30)*2
    
    //horizontal slate effect 
    
    
    
    -pow(f_noise3d(x*160,y*160,z*160),.4)/160
  }

#declare dune_waves=
  function {
    (
    (1-
    sin(
      x*64
      +f_noise3d(x*5,y*5,z*5)*10
    ) /2) /128
    * min(1,
      max(0,
       (1-(pow( pow(z/20,2)+pow(x/20,2),1)) )
      )
      )
    )
  }

#declare dune_ripples=
  function (x,y,z) {
    
    //height of base at this point
    pow((abs(.65-base_large_und(x-.001,y,z))),2)
    // and multiply by the ripple pattern
    *pow(f_noise3d((x-z/4)*9+y,0,z*3),2)
    //still a bit big
    /5

  } 

#declare dune_2ndwave=
  function {
    
    (1-sin(
      (x-z/4)*64
      +f_noise3d(x*5,y*5,z*5)*10
          )/2)
    /128
    
    *pow(f_noise3d(x+20,y,z),1.25)
  }
  
#declare fn_dunes=
function(x,y,z) {
  y
  -dune_undulations(x,y,z)
  //-dune_ripples(x,y,z)            // decides it's better without
  //-dune_waves(x,y,z)
  -dune_2ndwave(x,y,z)
  +fn_granite(x,y,z/2)
}
#declare dunes=
  isosurface {
    function { fn_dunes(x,y,z) }
    threshold .2
    accuracy 0.0001
    max_gradient 10
    contained_by { box { <-100,-1,-3>,<100,40,200> } } 
    texture { dune_tex }
  }              
  

#declare rocks=
  isosurface {
    function { fn_rocks(x,y,z) }
    threshold .2
    accuracy 0.0001
    max_gradient 10
    contained_by { box { <-100,-1,-3>,<100,40,200> } } 
    texture { rock_tex }
  }              
  
  
  
  
  
  
  
  
  
  
  
  
  
  