// Copyright (c) Duncan Gray, 2k4
#macro plant1(pos,age)
  union {
    
    #local plant_seed=mod(pos.x*1007+pos.y*131+pos.z*13+pos.x,1997);   //      pseudo-random enough, but position based
    #local rnd=seed(plant_seed);
    #local p_ang=<rand(rnd)*5,rand(rnd)*360,0>;

    #local lstalks=0;
    #while (lstalks<age)
      
      //#local stalk_vect=<lstalks,rand(rnd)*360,0>;
      //#local stalk_offs=vrotate(<0,0,.001*lstalks>,<lstalks,0,0>);
      #local f_ang=rand(rnd)*360;

      #local ltp=<0,0,.001*lstalks>;
      #local llp=<0,0,.001*lstalks>;
      
      #local ltr=.005*(1-(lstalks/45)+.5)*age/60;
      #local llr=ltr;
      #local ltl=.01*(1-(lstalks/45)+.5)*age/40;
      #local lll=ltl;
      
      #local lp=0;
      #while (lp<1)
        
        #local ltl=ltl*.95;
        #local ltp=ltp+vrotate(<0,ltl,0>,<10*lstalks*pow(lp,.5),0,0>);
        #local ltr=ltr*.96;
        
        
        cone { llp,llr,ltp,ltr rotate <0,f_ang,0> }
        sphere { ltp,ltr rotate <0,f_ang,0> }
        
        #local ltl=ltl;
        #local llr=ltr;               
        #local llp=ltp;
        #local lp=lp+.02;
      #end
      
      #local lstalks=lstalks+1;
    #end
    texture { 
      pigment {
        color rgb<.1,.3,.1> 
      }
      finish {
        ambient amb_light
        diffuse .9
        roughness 1
        specular .2
      }
    }
    rotate p_ang
    translate pos
  }
#end

// ok, 'proper' plant now - stalk, leaves, etc.
// needs to be tangle, knarled. small leaves and thin branches

#macro fn_attage(p_age) // tendency fo branches to grow up - regardless of node angle for a particular age node
 (<0,1,0>/5/pow(1.07,p_age)) 
#end

#macro fn_lenage(p_age) // length of limb for node of specified age
  ( .036*pow(1.12,p_age) )
#end

#macro fn_radage(p_age) // radius of limb for node of specified age
  ( .003*pow(1.16,p_age))
#end

#macro fn_angage(p_age) // angle between nodes for a branch of stated age
  ( 20*pow(1.15,p_age) )
#end

#declare leafball_size=.025;
  #declare stick_tex=
    texture {
      pigment {
        bumps 
        scale .001
        pigment_map {
          [ 0 color rgb<.35,.28,.13>*.9 ]
          [ 1 color rgb<.35,.28,.13>*.1 ]
        }
      }
      finish {
        ambient amb_light
        diffuse .58
        roughness .3
        specular .05
      }
      normal {
        radial .02
        frequency 10  
        sine_wave
      }
    }
  #declare leaf_tex=
    texture { 
      pigment { rgb<.35,.37,.11> } 
      finish { ambient amb_light diffuse .6 roughness .1 specular .2 } 
    }
  #declare null_tex=
    texture { 
      pigment { color rgbf<1,1,1,1> } 
      finish { ambient 0 diffuse 0 roughness 0 specular 0 } 
    }
  #declare leafball_tex=
    texture {
      crackle
      scale .02
      texture_map { 
        [ 0 null_tex ]
        [ .2 null_tex ]
        [ .2000001 leaf_tex ]
        [ 1 leaf_tex ]
      }
    }
#declare str_leaf_half=
  union {
    smooth_triangle { <.2,.4,.5>,<.15,1,0>,<0,.3,.5>,<-.1,.9,0>,<0,0,0>,<0,0,-1> }
    smooth_triangle { <.2,.4,.5>,<.15,1,0>,<0,.3,.5>,<-.1,.9,0>,<0,.45,1>,<0,.7,.7> }
  }
#declare str_leaf=
  union {
    object { str_leaf_half }
    object { str_leaf_half scale <-1,1,1> }
    texture { leaf_tex }
  }
#declare leaf_pair=
  union {
    object { str_leaf rotate <20,0,0> }
    object { str_leaf rotate <20,0,0> rotate <0,180,0> }

  }
#declare leaf_ball=
  union {
    object { str_leaf rotate<0,45,0> rotate <0,180,0> }
    object { str_leaf rotate<0,45,0> rotate <10,0,0> scale 1.1 rotate <0,180,0> rotate <0,-90,0> translate <0,-.25,0> }
    //object { str_leaf rotate <15,0,0> scale 1.2 rotate <0,180,0> rotate <0,-60,0> translate <0,-.5,0> }
    object { str_leaf rotate<0,45,0> }
    object { str_leaf rotate<0,45,0> rotate <10,0,0> scale 1.1 rotate <0,-90,0> translate <0,-.25,0> }
    //object { str_leaf rotate <15,0,0> scale 1.2 rotate <0,-60,0> translate <0,-.5,0> }
  }
#macro plant2_node(p_pos,p_dir,p_age)
  #local n_pos=p_pos+p_dir*fn_lenage(p_age);
  
  #local l_wfact=1+rand(rnd)/2; // limb pair +-50 %
  #local y_rot=360*rand(rnd);               
  // ok, I'm sure there are some splendidly clever ways to 
  // do this next bit with cross products and dot products 
  // and the like. Me, I'm a pythagorous addict.
  #local limb_ang=<0,0,0>;
  #local newvect=p_dir;
  #if (newvect.x!=0 | newvect.z!=0)
    #local limb_ang=limb_ang+y*degrees(atan2(newvect.x,newvect.z));
    #local newvect=vrotate(newvect,-limb_ang);
  #end
  #if (newvect.y!=0 | newvect.z!=0)
    #local limb_ang=limb_ang+x*degrees(atan2(newvect.z,newvect.y));
    #local newvect=vrotate(newvect,<-limb_ang.x,0,0>);
  #end
  // sanity check - the newvect should now be <0,1,0> ....
  // one wonders why I am calculating something I intend should always equal <0,1,0>
  // ans: I was calculating limb_ang, newvect is to verify vrotate(p_dir,limb_ang) is <0,1,0>
  // #debug concat("newvect=<",str(newvect.x,7,2),",",str(newvect.y,7,2),",",str(newvect.z,7,2),">\n")
  union { 
    cone { 0,fn_radage(p_age),<0,vlength(n_pos-p_pos),0>,fn_radage(p_age-1) }
    sphere { <0,vlength(n_pos-p_pos),0>,fn_radage(p_age-1) }//n_pos,fn_radage(p_age-1) }
    texture { stick_tex }
    rotate limb_ang
    translate p_pos 
  }
  #if (p_age<5.9)
    object { leaf_pair rotate <0,90,0> scale ((p_age+4)/4)*leafball_size rotate limb_ang translate n_pos }
  #end  
  #if (p_age<1.9)
    //sphere { n_pos,p_age*leafball_size texture { leafball_tex } }
    object { leaf_ball scale p_age*leafball_size rotate limb_ang translate n_pos }
  #else
    #local stalk1=vnormalize(fn_attage(p_age)+vrotate(vrotate (<0,1,0>*l_wfact,<fn_angage(p_age-1)/l_wfact,y_rot,0> ),limb_ang));
    #local stalk2=vnormalize(fn_attage(p_age)+vrotate(vrotate (<0,1,0>/l_wfact,<-fn_angage(p_age-1)*l_wfact,y_rot,0> ),limb_ang));
    plant2_node(n_pos,stalk1,p_age-1*l_wfact)
    plant2_node(n_pos,stalk2,p_age-1/l_wfact)
  #end
#end

#macro plant2(p_pos,p_dir,p_age,p_seed)
  union {
    #local rnd=seed(p_seed);
    #local l_age=2+p_age*5.7;
    plant2_node(p_pos,p_dir,l_age)
    
  }
#end