// Copyright (c) Duncan Gray, 2k4
#declare sign_tex=
  texture {
    pigment {
      color rgb<.4,.35,.27>*1.2//85
    }
    finish { 
      ambient amb_light
      diffuse .6
      roughness .1
      specular .1
    } 
    /*normal {
      bumps .2
      scale .001
    } */
  }
#declare nf_text=
  texture {
    pigment {
      image_map {
        tga "nofishing.tga"
        once
        filter all 1
      }
    }
    
    translate <-.5,-.5,0>
    scale <1,-1,1>
  }
    

#declare plank1=
  function (x,y,z) {
    max (
      z+.9,
      -z+.9,
      y+.5,
      -y+.5,
      x/6+.72-f_noise3d(35*x/4,35*y,35*z)/55,
      -x/6+.72-f_noise3d(35*x/4,35*y,35*z)/55
    )
    -pow(f_noise3d(50*x/4,50*y,50*z),.5)/100
    -f_noise3d(5*x/4,5*y,5*z)/30
  }

#declare post=
function (x,y,z) {
    max (
      z+.7,
      -z+.7,
      y/5-.25-f_noise3d(5*x,5*y/4,5*z)/5
             -f_noise3d(25*x,25*y/4,25*z)/25,
      -y,
      x+.7,
      -x+.7
    )
    -pow(f_noise3d(40*x,40*y/6,40*z),.5)/40
    -f_noise3d(5*x,5*y/4,5*z)/30
  }
#declare nail=
union {
  cylinder { <0,0,0>,<0,0,.025>,.03 }
  cylinder { <0,0,.04>,<0,0,.3>,.02 }
  texture { T_Chrome_2B }
}
#declare sign=    
union {
isosurface {
  function { plank1(x,y,z) }
    threshold 1
    accuracy 0.0001
    max_gradient 10
    contained_by { box { <-4,-1,-1>,<4,1,1> } } 
    
    texture { sign_tex }
    texture {
      nf_text
      scale <4,1,1>
    }
    
    rotate <180,0,3>
    translate <0,6,-.45>
  }
object { nail translate <-.1,6.45,-.6> }
object { nail rotate <5,0,0> translate <0,5.6,-.65> }
isosurface {
  function { post(x,y,z) }
    threshold 1
    accuracy 0.0001
    max_gradient 10
    contained_by { box { <-1,-1,-1>,<1,8,1> } } 
    texture { 
      sign_tex
    }
    rotate <0,90,0>
  } 
  translate <0,-1,0>
  scale 1/5
}