// **************************************
// **           City of Hope           **
// **                                  **
// **           emkaah 2004            **
// **                                  **
// **  IRTC july 2004 -topic 'Desert'- **
// **************************************

// +W1024 +H768 +AM1 +A0.3 //higher antialiasing losses the sand texture

#include "colors.inc"	 
#include "textures.inc"	
#include "functions.inc" 
#include "shapes.inc"   

#include "screen.inc"
 
#version 3.6;

#declare WriteFile = true;
#declare Pyramids = true;
#declare Pyramids2 = true;

 global_settings {
   radiosity {
     pretrace_start 0.08
     pretrace_end   0.005
     count 100
     nearest_count 4
     error_bound 0.4
     recursion_limit 1      
     low_error_factor 0.8
     gray_threshold 0
     minimum_reuse 0.015
     brightness .6
     adc_bailout 0.01/2
   }
 }

#declare locCam = <-950,-25,-1700>; 
#declare lookCam = <-174,50,5>;
#declare aspCam = 1.45;
#declare angleCam = 20.5;

Set_Camera(locCam, lookCam, angleCam)
Set_Camera_Aspect_Ratio(aspCam)

#declare Sig = text{
     ttf "arial.ttf" "Emkaah  2004" .4, 0 no_shadow no_reflection
     pigment { rgb<169,128, 80>/255*.85} normal{bumps .06 scale <.05,1,.5>*.5} finish{ambient 1 diffuse 0}
     scale .015
    }

Screen_Object (Sig, <0,0>, <0.02,0.02>, true, 0.02)

light_source {<10000,10000,-10000> rgb <.97,.95,.90>*1.025 } 

fog {
  fog_type   2
  distance   10000
  color      rgb<180/255,145/255,115/255>
  fog_offset 0
  fog_alt    10
  turbulence 2 
}

sphere {
  <0, 0, 0>, 1
  texture {
   pigment {
     gradient y
     color_map {
       [0.0 color rgb < 128/255, 146/255, 166/255 >]
       [0.2 color rgb <  71/255, 108/255, 153/255 >]
       [1.0 color rgb < 128/255, 146/255, 166/255 >]
     } 
     turbulence .2
   }
   finish { diffuse 0 ambient 1 }
  }
  hollow on
  no_shadow
  scale <1,1,-1>*30000
}

#declare PigR1 = pigment{ bumps
        pigment_map{
                [  0,rgb<183/255,145/255,106/255>*1.1]
                [.50,rgb<183/255,145/255,106/255>*1.1]
                [.75,rgb<183/255,145/255,106/255>*1.17]
                [  1,rgb<183/255,145/255,106/255>*1.25]
                }
       scale .5 turbulence .5
       }

#declare PigR2 = pigment{ bumps
        pigment_map{
                [  0,rgb<188,153,124>/255*1.2]
                [.50,rgb<188,153,124>/255*1.2]
                [.75,rgb<188,153,124>/255*1.27]
                [  1,rgb<188,153,124>/255*1.35]
                }
       scale .5 turbulence .5
       }

#declare Brick1 = superellipsoid{<.35,.35> scale<1,.5,1> 
                                pigment{rgb<193/255,158/255,128/255>} 
                                }  
#declare Brick1a = isosurface {
    #local fnBrick = function { -f_superellipsoid(x*2,y*2,z*2, .8, .5) }
    #local fnNoise = function { pigment {granite color_map {[0 rgb 0.0][1 rgb 0.5]} scale 5 warp {turbulence 0.4} scale 0.1 }}
    function{fnBrick(x,y*1.5,z)-fnNoise(x/8,y/8,z/8).grey*3.25} 
    contained_by { box { <-3,-2,-2>, <3,2,2> } } max_gradient 10 threshold 0 rotate x*-90
}
#declare Brick1b = isosurface {
    #local fnBrickb = function { -f_superellipsoid(x*2,y*2,z*2, .8, .5) }
    #local fnNoiseb = function { pigment {granite color_map {[0 rgb 0.0][1 rgb 0.5]} scale 5 warp {turbulence 0.4} scale 0.1 }}
    function{fnBrickb(x,y*1.5,z)-fnNoiseb(x/8,y/8,z/8).grey*2} 
    contained_by { box { <-3,-2,-2>, <3,2,2> } } max_gradient 10 threshold 0 rotate x*-90
}

#declare Brick2 = isosurface {
    function{max((y*y*4-1),(x*x-1),(z*z-1))-f_noise3d(x*7,y*7,z*7)*1} 
    contained_by { box { -2, 2 } } 
    max_gradient 10
    threshold 0.001
}

#if (WriteFile)
//--pyramid1 write
 #fopen filehandle "Pyr1.inc" write  

 #declare cnt1 = 0;
 #declare cnt2 = 0;               
 #declare slp =.87;//slope
 #write(filehandle,"#declare P1Side = union{\n")
  #while(cnt2<220)//225)
   #while (cnt1<(200-cnt2*slp))
   #if (cnt1 = 5+(220-cnt2)/2) #declare bla = .3; #else #declare bla = 0; #end
   #if (cnt2 = 200 | cnt2 = 175 | cnt2 = 176 | cnt2 = 120 | cnt2 = 121) #declare bla2 = 1.75; #else #declare bla2 = 1; #end
   #declare rnd2 = rand(seed(int(33333333/(cnt2*cnt1+1))));
   #declare rnd = rand(seed(cnt1*cnt2));
   #write(filehandle,"#declare Brick = object{Brick1 scale <",4-1*rnd,",",2.2+.5*rnd,",",2+bla*rnd2,"> rotate x*39 pigment{rgb<171/255*(1-.05*",rnd,"),139/255*(1-.05*",rnd2,"),114/255*(1-.025*",rnd,")>*(1+.15*",bla2*rnd2,")} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]} rotate y*",360*rnd,"} finish{ambient 0 diffuse 1}}\n")
   #write(filehandle,"object{Brick translate <",-200+slp*cnt2+2.1*cnt1,",",cnt2*1.1,",",cnt2*slp,">}\n")
   #write(filehandle,"object{Brick rotate y*90 translate <",-192+cnt2*slp-.5*rnd,",",cnt2*1.1,","slp*cnt2+2.1*cnt1,">}\n")
    #declare cnt1 = cnt1+1;
   #end
   #declare cnt1=1;
   #declare cnt2 =cnt2+1;
  #end
 #write(filehandle,"}\n")

 #fclose filehandle
#end


//--pyramid2
#if (WriteFile)
//--pyramid2bottom write
 #fopen filehandle "Pyr2a.inc" write  

 #declare cnt1 = 0;
 #declare cnt2 = 0;               
 #declare slp =.87*2;//slope  2.2
 #write(filehandle,"#declare P2Side1 = union{\n")
  #while(cnt2<90)//115)
   #while (cnt1<(100-cnt2*slp/2))
   #declare rnd2 = rand(seed(int(3333333/(cnt2*cnt1+1))));
   #declare rnd = rand(seed(cnt1*cnt2));
    #if (cnt2<64)
     #write(filehandle,"#declare Brick = object{Brick1 scale <4-2*",rnd,",3.4+1*",rnd,",2.5+.5*",rnd2,"> rotate x*39 pigment{rgb<180/255*(1-.05*",rnd,"),145/255*(1-.05*",rnd2,"),117/255*(1-.025*",rnd,")>*(1+.15*",rnd,")} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]} rotate y*360*",rnd"} finish{ambient 0 diffuse 1} }\n")
    #else
     #write(filehandle,"#declare Brick = object{Brick1b scale <6-2*",rnd,",3.4+2*",rnd,",2+1*",rnd2,"> rotate x*39 pigment{rgb<180/255*(1-.05*",rnd,"),145/255*(1-.05*",rnd2,"),117/255*(1-.025*",rnd,")>*(1+.175*",rnd,")} finish{ambient 0 diffuse 1} }\n")
    #end
     #if (cnt2<64 | (cnt2=64 & (cnt1 < 20 | cnt1 >25))
                  | (cnt2=65 & (cnt1 < 15 | cnt1 >30))
                  | (cnt2=66 & (cnt1 < 10 | cnt1 >40))
         )
      #write(filehandle,"object{Brick translate <-200+",slp,"*",cnt2,"+4.2*",cnt1,",",cnt2,"*2.2,",cnt2*slp">}\n")
      #write(filehandle,"object{Brick rotate y*90 translate <-197+",cnt2,"*",slp,"-.5*",rnd,",",cnt2,"*2.2,",slp*cnt2,"+4.2*",cnt1">}\n")
     #end
    #declare cnt1 = cnt1+1;
   #end
   #declare cnt1=1;
   #declare cnt2 =cnt2+1;

  #end
  #write(filehandle,"}\n")
 #fclose filehandle
#end

//middle
#if (WriteFile)
//--pyramid2middle write
 #fopen filehandle "Pyr2b.inc" write  

 #declare cnt2 = 64;               
 #declare slp =.87*2;//slope  2.2
 #declare cnt1 = (97.5-cnt2*slp/2);
 #write(filehandle,"#declare P2Side2 = union{\n")
  #while(cnt2<90)//115)
   #while (cnt1>0)
   #declare rnd2 = rand(seed(int(333333/(cnt2*cnt1+1))));                                                                      //188,153,124
   #declare rnd = rand(seed(cnt1*cnt2));
     #write(filehandle,"#declare Brick = object{Brick1 scale <4-2*",rnd,",3.4+1*",rnd,",2+0*",rnd2,"> rotate x*39 pigment{rgb<180/255*(1-.01*",rnd,"),145/255*(1-.05*",rnd2,"),117/255*(1-.025*",rnd,")>*(1.05+.15*",rnd,")} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]} rotate y*360*",rnd,"} finish{ambient 0 diffuse 1} }\n")
      #write(filehandle,"object{Brick translate <-195+",slp*cnt2,"+4.2*",cnt1,",",cnt2,"*2.2,",cnt2*slp,"+2.5>}\n")
      #write(filehandle,"object{Brick rotate y*90 translate <-195+",cnt2*slp,",",cnt2,"*2.2,",slp*cnt2+4.2*cnt1,"+2>}\n")
    #declare cnt1 = cnt1-1;                                                                                                      
   #end
   #declare cnt1=(97.5-cnt2*slp/2);
   #declare cnt2 =cnt2+1;
  #end
  #write(filehandle,"}\n")
 #fclose filehandle
#end

//top
#if (WriteFile)
//--pyramid2top write
 #fopen filehandle "Pyr2c.inc" write 

 #declare cnt2 = 80; //90 were it stops              
 #declare slp =.87*2;//slope 0.87
 #declare cnt1 = int(100.5-cnt2*slp/2);
 #write(filehandle,"#declare P2Side3 = union{\n")
  #while(cnt2<115)//115)
   #while (cnt1>0)
   #declare rnd2 = rand(seed(int(333333/(cnt2*cnt1+1))));
   #declare rnd = rand(seed(cnt1*cnt2));
   #if (          (cnt2=81 & int(cnt1) = 21)
                | (cnt2=82 & int(cnt1) = 21)
                | (cnt2=83 & int(cnt1) = 19)
                | (cnt2=84 & int(cnt1) = 17)
                | (cnt2=85 & int(cnt1) = 13)
                | (cnt2=86 & int(cnt1) = 11)
                | (cnt2=87 & int(cnt1) =  8)
                | (cnt2=88 & int(cnt1) =  4)
                | (cnt2=89 & int(cnt1) =  3)                                                                                                  //cool top color 179,144,116
       )
     #if (rnd2<0.5) #declare tst = 1; #else #declare tst = -1; #end
     #write(filehandle,"#declare Brick = object{Brick1a scale <",tst,"*(10+5*",rnd,"),5+2*",rnd,",3.0+.5*",rnd2,"> rotate x*10 pigment{rgb<179/255*(1+.05*",rnd,"),144/255*(1+.05*",rnd2,"),116/255*(1+.025*",rnd,")>*(1.1+.15*",rnd,")} finish{ambient 0 diffuse 1}}\n")
    #else
     #write(filehandle,"#declare Brick = object{Brick1 scale <4-1*",rnd2,",3.4+1*",rnd,",2.8+0*",rnd2,"> rotate x*39 pigment{rgb<179/255*(1+.05*",rnd,"),144/255*(1+.05*",rnd2,"),116/255*(1+.025*",rnd,")>*(1+.15*",rnd,")} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]} rotate y*360*",rnd,"} finish{ambient 0 diffuse 1} }\n")
    #end
     #if (cnt2>89 | (cnt2=81 & (int(cnt1) > 21 & int(cnt1) <22))
                  | (cnt2=82 & (int(cnt1) > 20 & int(cnt1) <23))
                  | (cnt2=83 & (int(cnt1) > 18 & int(cnt1) <23))
                  | (cnt2=84 & (int(cnt1) > 16 & int(cnt1) <23))
                  | (cnt2=85 & (int(cnt1) > 12 & int(cnt1) <23))
                  | (cnt2=86 & (int(cnt1) > 10 & int(cnt1) <22))
                  | (cnt2=87 & (int(cnt1) >  7 & int(cnt1) <22))
                  | (cnt2=88 & (int(cnt1) >  5 & int(cnt1) <22))
                  | (cnt2=89 & (int(cnt1) >  2 & int(cnt1) <22))
         )
  
      #write(filehandle,"object{Brick translate <-200+",slp,"*",cnt2,"+4.2*",cnt1,",",cnt2,"*2.2,",cnt2*slp,">}\n")
      #write(filehandle,"object{Brick rotate y*90 translate <-200+",cnt2,"*",slp,",",cnt2,"*2.2,",slp*cnt2,"+4.2*",cnt1,">}\n")
     #end
    #declare cnt1 = cnt1-1;
   #end
   #declare cnt1=(100-cnt2*slp/2);
   #declare cnt2 =cnt2+1;
  #end
  #write(filehandle,"}\n")
 #fclose filehandle
#end
 
//pyr2  
#declare BrickWall = isosurface {
    #declare rnd2 = rand(seed(333333));
    #declare rnd = rand(seed(123));
    #local fnNoise1 = function {pigment {granite color_map {[0 rgb 0.0][1 rgb 0.27]} scale 5 warp {turbulence 0.4} scale 0.1 }}
    function{y+1-fnNoise1(x/5,y/5,z/10).grey*5} 
    contained_by { box { <-3,-.2,-5>, <3,2,6.25> }} max_gradient 10 threshold 0
    pigment{gradient x color_map { [0 rgb <179/255,144/255,116/255>]
                        [4 rgb<179/255*(1+.05*rnd),144/255*(1+.05*rnd2),116/255*(1+.025*rnd)>*(1+.15*rnd)] 
                        [8 rgb<179/255*(1+.05*rnd2),144/255*(1+.05*rnd2),116/255*(1+.025*rnd)>*(1+.15*rnd)] 
                        [1 rgb<179/255*(1+.05*rnd),144/255*(1+.05*rnd),116/255*(1+.025*rnd2)>*(1+.15*rnd)] }
            scale 5
            warp { turbulence 0.4 }
            }
    finish{ambient 0 diffuse 1}
}
#declare BrickWall1 = isosurface {
    #declare rnd2 = rand(seed(333333));
    #declare rnd = rand(seed(123));
    #local fnNoise11 = function {pigment {granite color_map {[0 rgb 0.0][1 rgb 0.27]} scale 5 warp {turbulence 0.4} scale 0.1 }}
    function{y+1-fnNoise1(x/2,y/5,z/10).grey*1} 
    contained_by { box { <-5,-.85,-5>, <10,2,6.25> }} max_gradient 10 threshold 0
    pigment{gradient x color_map { [0 rgb <179/255,144/255,116/255>]
                        [4 rgb<179/255*(1+.05*rnd),144/255*(1+.05*rnd2),116/255*(1+.025*rnd)>*(1+.15*rnd)] 
                        [8 rgb<179/255*(1+.05*rnd2),144/255*(1+.05*rnd2),116/255*(1+.025*rnd)>*(1+.15*rnd)] 
                        [1 rgb<179/255*(1+.05*rnd),144/255*(1+.05*rnd),116/255*(1+.025*rnd2)>*(1+.15*rnd)] }
            scale 5
            warp { turbulence 0.4 }
            }
    finish{ambient 0 diffuse 1}
}
#if (Pyramids2)
 #include "Pyr2a.inc"
 #include "Pyr2b.inc"
 #include "Pyr2c.inc"

 #declare P2Side = union{
  superellipsoid{<.3,.3> scale<1,17,1>*2 rotate x*33 rotate z*-39 translate<-18,230,180> pigment{rgb<179*1.05,144*1.05,116*1.025>/255*1.3} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]}} finish{ambient 0}}
  object{P2Side1} 
  object{P2Side2} 
  object{P2Side3 scale .995 translate <-0,0,-1>} 
  object{BrickWall rotate x*-90 scale<5,-12,5> rotate x*38 translate <80,10,4.5>}
  object{BrickWall rotate x*-90 scale<-5,-12,-5> rotate x*38 translate <120,10,5.25>}
  difference{
   union{
    object{BrickWall1 rotate x*-90 scale<15,-14,5> rotate x*38.5 translate <60,10,-1.2>}
    object{BrickWall1 rotate x*-90 scale<15,-5,5> rotate x*38.5 translate <0,100,70.2>}
   }
   box{0,<100,400,400> rotate z*51 translate <232,0,-50> pigment{Black}}
  }
 }
#end 
//--pyramid3 write
#declare P3Rocks = isosurface 
{
   function{-f_superellipsoid(x*1,y*1,z*2,.7,.3)+f_ridge(x*10,y*5,z*7, 1, 1, 1, .5, -1, 1)*.5}
    contained_by { box { <-2,-2,-3>, <2,2,3> } } 
    max_gradient 10
    threshold 0.001
    scale<2,1,1>  
    pigment{PigR1} normal{average normal_map {[.5,bumps 5 scale .075][1,dents 4 scale .25]}}
    finish{ambient 0 diffuse 1}
}  

#if (WriteFile)
 #fopen filehandle "Pyr3.inc" write  

 #declare cnt1 = 1;
 #declare cnt2 = 1;               
 #declare slp =.95;//slope   2.2
 #write(filehandle,"#declare P3Side = union{\n")
  #while(cnt2<109)//225)
   #while (cnt1<(100-cnt2*.9))
    #declare rnd2 = rand(seed(int(3333333/(cnt2*cnt1+1))));
    #declare rnd = rand(seed(cnt1*cnt2));
    #write(filehandle,"#declare Pigm3 = pigment{gradient y color_map{")
    #write(filehandle,"[0 rgb<188,153,124>/255*(1.1+.20*",rnd2,")][0.1 rgb<188,153,124>/255*(1.1+.20*",rnd2,")][0.3+.2*",rnd," rgb<176,138,106>/255*(1.10+.20*",rnd,")][1 rgb<176,138,106>/255*(1.10+.20*",rnd,")]} ") 
    #write(filehandle,"scale 2 rotate z*0 translate y*1.5 }\n")
    #write(filehandle,"#declare Brickk = object{Brick1 scale <2-1*",rnd,",2,1+(20*(",(sin((cnt1/(100-cnt2*.9))*2*pi+1.25)/12)+(cos((cnt1/(100-cnt2*.9))*10*pi)/75),")*",rnd2,")+.5*",rnd,"> pigment{Pigm3}}\n")
    #write(filehandle,"#declare Brick = object{Brickk rotate x*20 normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]} rotate y*360*",rnd,"} finish{ambient 0 diffuse 1} }\n")
    #write(filehandle,"object{Brick translate <-100+",slp*cnt2,"+2.1*",cnt1,",",cnt2,"*1.1,",cnt2*slp">}\n")
    #write(filehandle,"object{Brick rotate y*90 translate <-97+",cnt2*slp,"-.5*",rnd,",",cnt2,"*1.1,",slp*cnt2+2.1*cnt1,">}\n")
    #declare cnt1 = cnt1+1;
   #end
   #declare cnt1=1;
   #declare cnt2 =cnt2+1;
  #end
 #write(filehandle,"}\n")
 #fclose filehandle
#end

#if (Pyramids) #include "Pyr3.inc"

#declare EntrWall = union{
 #declare TT=0; #while (TT<4) #declare RRnd = rand(seed(TT));
  object{Brick2 scale <2+.5*RRnd,2,1> rotate z*5 translate <TT*5,0,0> pigment{rgb<188,153,124>/255*(1.3+.5*RRnd)} finish{ambient 0 diffuse 1}}
  #if (TT<3) object{Brick2 scale <2+.5*RRnd,2,1> rotate z*5 translate <2.2+TT*5,2,0> pigment{rgb<188,153,124>/255*(1.3+.5*RRnd)} finish{ambient 0 diffuse 1}} #end
  #declare TT=TT+1;
 #end
}
#declare Pyramide3 = union
{
 object{P3Side}
 object{P3Rocks scale 10 rotate z*5 translate <-100,12,35>}
 object{P3Rocks scale <10,-10,20> rotate z*20 translate <-100,10,70>}
 object{P3Rocks scale <20,10,5>*-1 rotate x*38 translate <1,10,5>}
 object{P3Rocks scale <-10,10,10> rotate z*5 translate <110,8,35>}
 object{P3Rocks scale <10,10,10> rotate z*5 translate <135,6,35>}
 object{P3Rocks scale <-10,10,10> rotate z*5 translate <165,5,35>}
 object{EntrWall translate<195,12,35>}
 object{EntrWall scale<.5,1,1> rotate y*-90 translate<217.5,12,35>}
}
#end

//----****Small Pyramids****----
//smallpyr                                                     
#declare BrickWall2 = isosurface {
    #declare rnd2 = rand(seed(333333));
    #declare rnd = rand(seed(123));
    #local fnNoise1a = function {pigment {granite color_map {[0 rgb 0.0][1 rgb 0.27]} scale 5 warp {turbulence 0.4} scale 0.1 }}
    function{y+1-fnNoise1a(x/5,y/5,z/5).grey*5} 
    contained_by { box { <-4,-.3,-4>, <4,2,6.25> }} max_gradient 10 threshold 0
    pigment{gradient x color_map { [0 rgb <176/255,140/255,94/255>*1.1]
                        [4 rgb<176/255*(1+.05*rnd),140/255*(1+.05*rnd2),104/255*(1+.025*rnd)>*(1.1+.20*rnd)] 
                        [8 rgb<176/255*(1+.05*rnd2),140/255*(1+.05*rnd2),104/255*(1+.025*rnd)>*(1.1+.20*rnd)] 
                        [1 rgb<176/255*(1+.05*rnd),140/255*(1+.05*rnd),104/255*(1+.025*rnd2)>*(1.1+.20*rnd)] }
            scale 5
            warp { turbulence 0.4 }
            }
    finish{ambient 0 diffuse 1}
}
//--SmalPyr1
#declare SP1BW = difference
{
 object{BrickWall2 rotate x*-90 scale<7,-7,2>} 
 box{<-30,0,-20><0,50,10> rotate z*-28 translate <-25,-10,5> pigment{rgb 0}}
}
 #declare Pscale = .375;
 #declare PsT = 1;
 #declare cnt1 = 1;
 #declare cnt2 = 1;               
 #declare slpc =.95;
 #declare slp =slpc;
 #local fnBrick3a = function { -f_superellipsoid(x*3,y*3,z*3, .35, .35) }
 #local fnNoise3a = function { pigment {granite color_map {[0 rgb 0.0][1 rgb 0.5]} scale <1,1,1> warp {turbulence 0.2} scale 0.5 }}
 #declare SP1Side = union{
  #while(cnt2<109*Pscale)//225)
   #while (cnt1<(100*Pscale-cnt2*.9))
    #if (cnt2 > 4) #declare Pscale = .365; #declare PsT = 1.375-Pscale-2; #declare slp=slpc*(.375/Pscale);#end
    #if (cnt2 > 7) #declare Pscale = .370; #declare PsT = 1.375-Pscale; #declare slp=slpc*(.375/Pscale);#end
    #if (cnt2 > 8) #declare Pscale = .372; #declare PsT = 1.375-Pscale; #declare slp=slpc*(.375/Pscale);#end
    #if (cnt2 > 9) #declare Pscale = .375; #declare PsT = 1.375-Pscale; #declare slp=slpc*(.375/Pscale);#end
    #if (cnt2 > 15) #declare Pscale = .360; #declare PsT = 1.375-Pscale-2; #declare slp=slpc/(.375/Pscale); #end
    #if (cnt2 > 19) #declare Pscale = .375; #declare PsT = 1.375-Pscale; #declare slp=slpc*(.375/Pscale); #end
    #if (cnt2 > 28) #declare Pscale = .365; #declare PsT = 1.375-Pscale; #end
    #declare rnd2 = rand(seed(int(3333333/(cnt2*cnt1+1))));
    #declare rnd = rand(seed(cnt1*cnt2));
    #if (rnd < .5) #declare TtT = 1; #declare TtTt = -1; #else #declare TtT = -1; #declare TtTt = 1; #end 
    #declare Brick3a = isosurface{ function{fnBrick3a(x,y*1.5,z)-fnNoise3a(x/(2*rnd2+1),y/(2+1*rnd+1),z/(2+2*rnd+1)).grey} contained_by { box { -.6,.6 } } max_gradient 10 threshold 0 pigment{rgb<180/255,145/255,115/255>} scale 1.65 rotate y*-90}
    #declare Brick = object{Brick3a scale <(3-1*rnd)*TtTt,(3.2+.5*rnd)*TtT,.5+.5*rnd+(20*((sin((cnt1/(100*Pscale-cnt2*.9))*2*pi+1.5)/12)+(cos((cnt1/(100*Pscale-cnt2*.9))*10*pi)/75))*rnd2)+1*rnd>*1.1 rotate x*20 pigment{rgb<176/255,140/255,104/255>*(1.1+.20*rnd)} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]} rotate y*360*rnd} finish{ambient 0 diffuse 1} }
    object{Brick translate <-100*Pscale+slp*cnt2+2.1*cnt1,cnt2*1.1,cnt2*slp-PsT>}
    object{Brick rotate y*90 translate <-92.5*Pscale+cnt2*slp-.5*rnd,cnt2*1.1,slp*cnt2+2.1*cnt1>}
    #declare cnt1 = cnt1+1;
   #end
   #declare cnt1=1;
   #declare cnt2 =cnt2+1;
  #end

 object{SP1BW rotate x*39 scale <.8,1,1> translate <-10,7,3>}
 }


//--SmalPyr2
//rocks rubble
#declare FPR=function{pigment{
  crackle 
  turbulence 0.25
  color_map { [0 rgb 1] [1 rgb 0] }
  scale 0.5
  }
}

#declare rubbleSP = isosurface {
   function{f_sphere(x*1,y*1,z*2,1)+FPR(x*2,y*2,z*2).grey*.4}
    contained_by { box { <-2,-2,-2>, <2,2,2> } } 
    max_gradient 10
    threshold 0.001
    pigment{PigR1} finish{ambient 0 diffuse 1}
}  
//sand on pyr
#declare SPPlat = isosurface {
   function{-f_superellipsoid(x*.5,y*4+.5,z*.5,.3,.3)+f_bumps(x*2,y,z*1.2)*.20}
    contained_by { box { <-2,0,-2>, <2,.2,2> } } 
    max_gradient 10
    threshold 0.001
    pigment{rgb<188,153,124>/255*1.1} finish{ambient 0 diffuse 1}
    normal{bumps 1 scale .00005}
    rotate y*90
}                           
//top of small pyramids
#declare SPTop =  isosurface 
{
    function {-f_superellipsoid(x,y,z,0.3,0.3)+FPR(x*1.5, y*1.5, z*1.5).grey*.25 } 
    contained_by { box {-2,2} } 
    max_gradient 6
    threshold 0
    pigment{rgb<183,145,106>/255*1.25} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]}} finish{ambient 0 diffuse 1} 
} 

//pyr2&3
#local fnBrick3 = function { -f_superellipsoid(x*3,y*3,z*2, .35, .35) }
#local fnNoise3 = function { pigment {granite color_map {[0 rgb 0.0][1 rgb 0.5]} scale <1,5,1> warp {turbulence 0.2} scale 0.5 }}
#macro MSPyr(tx,ty,tz,SRow,ERow,seed1,seed2,scaleo) 
 #declare cnt1 = 1;
 #declare cnt2 = 1+SRow;               
 #declare slp =2.75;
 union{
  #while(cnt2<1+ERow)//225)
   #while (cnt1<(20-cnt2*1.275))
    #declare rnd2 = rand(seed(int(seed1/(cnt2*cnt1+1))));
    #declare rnd3 = rand(seed(int(seed2/(cnt2*cnt1+1))));
    #declare rnd = rand(seed(cnt1*cnt2));          
    #declare Brick3 = isosurface{ function{fnBrick3(x,y*1.5,z)-fnNoise3(x/(7*rnd2+1),y/(5+3*rnd3+1),z/(3+5*rnd3+1)).grey*.75} contained_by { box { -.6,.6 } } max_gradient 10 threshold 0 pigment{rgb<180/255,145/255,115/255>} scale 1.65 rotate y*-90}
                                  //3
    #declare Brick = object{Brick3 scale <5-1*rnd3,5.5+.5*rnd3,4+1*rnd3> rotate x*20 pigment{rgb<183/255,145/255,106/255>*(1.1+.15*rnd)} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]} rotate y*360*rnd3} finish{ambient 0 diffuse 1} }
    object{Brick translate <-35+slp*cnt2+5.1*cnt1,cnt2*3.5,cnt2*slp>}
    object{Brick rotate y*90 translate <-30+cnt2*slp-3.5*rnd2,cnt2*3.5,(slp*cnt2+5.1*cnt1)-4.5>}
    #declare cnt1 = cnt1+1;
   #end
   #declare cnt1=1;
   #declare cnt2 =cnt2+1;
  #end
 translate<tx,ty,tz> scale scaleo
 }
#end
//MSPyr(x,y,z,Start row, end row, seed, seed, scale)
#declare SP2Side = union {
  MSPyr(0,0,0,0,3,3333333,123456,1)
  MSPyr(2.5,0,5,3,7,3333153,654321,<.95,1,.95>)
  MSPyr(3.75,0,7.5,7,11,3123333,162534,<.90,1,.90>)
  object {SPPlat scale <2.1,1.75,2>*12 translate <19,13,49.2>}
  object {SPPlat scale <-2.0,3,2>*8 translate <17,27.4,50>}
  object {SPTop scale 12 rotate y*90 translate <13,34,45>}
}

#declare SP3Side = union {
  MSPyr(0,0,0,0,3,4455667,654789,<1,1.06,1>)
  MSPyr(2.5,1,5,3,7,1245153,852697,<.95,1,.95>)
  difference{
   MSPyr(3.75,1,7.5,7,10,3126984,562534,<.90,1,.90>)
   union{
    superellipsoid{<.1,.1> scale <5,2.5,10>*2.5 translate<-10,26,6> }
    superellipsoid{<.1,.1> scale <5,2.5,10>*2.2 translate<-10,30,7> }
    pigment{rgb<183,145,106>/255*.9} normal{average normal_map {[.5,bumps 1 scale .075][1,dents 4 scale .25]}} finish{ambient 0 diffuse 1} 
   }
  }
  object {SPPlat scale <2.1,1.75,2>*12 translate <19,13.9,49.22>} 
  object {SPPlat scale <-2.0,3,1.95>*8 translate <17,28.35,49.95>}
  object {SPPlat scale <-2.0,7,1.95>*4.75 translate <17,38,49.75>}
  object {SPTop scale 17 rotate y*-90 translate <15,27,45>}
}

#declare SPyramide3 = union{
  object{SP3Side}
  object{rubbleSP scale<1,2,1>*10 rotate z*-24 translate<-23,12,40> }
  object{rubbleSP scale<3,-1,-2>*10 rotate z*10 translate<-32,10,35> }
}

#if (Pyramids)
 #include "Pyr1.inc"

 object{P1Side translate<600,0,700> }
 object{P2Side }
 object{Pyramide3 translate<-500,0,-700> }
                                          //3.5
 object{SP1Side rotate y*0 scale 1.025 translate<-500,-5,-850> }
 object{SP2Side rotate y*0 scale<.7,.85,.7> translate<-607,-4,-850> }
 object{SPyramide3 rotate y*0 scale<.7,.85,.7> translate<-702,-6,-850> }

#end

#declare Corr = union{
 superellipsoid{<0,.1> scale<30,1,1>}
 #declare TT = 0; #while (TT< 9) #declare TT = TT + 1; 
  superellipsoid{<.2,.2> scale<1,1.1,1.2> translate x*(-37+7.5*TT)}
 #end
 pigment{PigR2} normal{bumps .25 scale .1} finish{ambient 0 diffuse 1}
}
#declare RoofRock = isosurface {
    function{-f_superellipsoid(x*4,y,z,.3,.3)-f_noise3d(x*1.5,y*1.5,z*1.5)*1} 
    contained_by { box { -2, 2 } } 
    max_gradient 10
    threshold 0.001
    pigment{PigR2} finish{ambient 0 diffuse 1}
}

#declare CorrRoof=union{ 
 union{
  superellipsoid{<.1,.1> scale<15,1.8,.1> rotate x*51 translate z*-1.3}
  superellipsoid{<.1,.1> scale<15,1.8,.1> rotate x*-51 translate z*1.3}
  pigment{rgb<207,193,182>/255*1.4} normal{wrinkles 1 scale 5} finish{ambient 0}
  scale .75 translate y*4
 }
 union{
 #declare TT=0; #while (TT<4) 
  #declare TTT = -10+6.75*TT;
  cylinder{<TTT,0,-2><TTT,3,-3>,.1 }
  cylinder{<TTT,0, 2><TTT,3, 3>,.1 }
  #declare TT=TT+1; 
 #end
 pigment{Gray} finish{ambient 0 diffuse 1}
 }
 object{RoofRock scale <2,2,1.5> translate x*7}  
 object{RoofRock scale <2,2,-1.25> translate x*-5}
 object{RoofRock scale <2,1.75,-1.15> translate x*23}
 object{RoofRock scale <.25,2.25,-.25> translate x*25}
 object{Brick1b scale 1 translate <-215,-11,-350> pigment{PigR2}}
}


//--****sand****--
#declare Tsand = texture{
  pigment{ 
        bumps
        color_map{
          [0.0 color rgb<188,153,124>/255*1.3]
          [0.5 color rgb<188,153,124>/255*1.3]
          [0.6 color rgb<169,128, 80>/255*1.3]
          [1.0 color rgb<169,128, 80>/255*1.3]
         }
  }
 scale <.75,1,1>*.75 translate z*-4.45 translate x*7.75
            
 finish{ambient 0 diffuse 1}
}

#declare PF0 = pigment{bumps turbulence 0.1 color_map { [0 rgb .12] [1 rgb .1] } scale <1,.9,1>*0.1 translate x*-5}
#declare PF1 = pigment{crackle form<.86,0,0> turbulence 0.4 color_map { [0 rgb .105] [1 rgb .08] } scale <1,.8,10>*0.1 translate <-2,-1,0>}
#declare PF2 = pigment{bumps color_map { [0 rgb .11] [1 rgb .072] } scale .2 translate x*-1}
#declare PF=function { pigment{
                       gradient z 
                       pigment_map{[0 PF0]
                                   [.40 PF0]
                                   [.50 PF1]
                                   [.60 PF2]
                                   [1 PF2]
                                  }
                       turbulence .3
                             }
                    }

#declare sandh1 = height_field{function 600,600 {PF(x,0,y).grey}  clipped_by{box{<-1,0,.25>,<1,1,1>}} translate <-0.5,0,-0.5>}  
#declare sandh = union{
  object{sandh1 scale 1}
  object{sandh1 scale <1,1,-1> translate z*-.5}
  texture{Tsand translate <-1,0,-5.2>}
  finish{ambient 0 diffuse 1} scale <1.25,1,1.75>//*6
}                                                                                                    
                                                   
#declare N1 = normal{average normal_map{[1, bumps .3 scale <.05,1,.5>*.5][.5, crackle metric 2 form<1.03,-.99,0> scale <-.75,5,-1>*35][1, crackle metric 2 form<1.03,-.995,0> scale <-.75,5,-1>*35 translate<2,0,1>]}} 

#macro Make_Rubble(Xres,Zres,Xwidth,Zwidth, Xplace,Zplace, TLambda, TOmega, TOctaves,Turb,RockMaxScale,RockflatnessC,RockflatnessV, RockBuried, RockRoughness, VB)
   #declare J = 0;
   #while(J < Xres)
     #declare K = 0;
     #while(K < Zres)
       #declare rndro = rand(seed(K*J));
       #declare rndrp = rand(seed(J));
       #declare rndrq = rand(seed(K));
       #if (VB) #declare VBC = rndrp; #else #declare VBC = 1; #end 
       #declare RubRock = isosurface {
          function{f_sphere(x*1,y*(RockflatnessC+RockflatnessV*rndro),z*1,1)+FPR(x*1+1*rndrp,y*1+1*rndro,z*1+1*rndrq).grey*(RockRoughness/2+(RockRoughness/2)*rndro)}
          contained_by { box { -1,1 } } 
          max_gradient 7
          threshold 0.001
         }
       #declare stPt = Turb*vturbulence(TLambda,TOmega,TOctaves,<Xwidth*J/(Xres-1) + Xplace , 10, Zwidth*K/(Zres-1) + Zplace>);
       #declare iNorm = y;
       #declare iPt = trace(sandh, stPt, stPt-y, iNorm);
       #if(!VZero(iNorm))
           object {RubRock scale (.0001+RockMaxScale*rand(seed(K*J))) translate iPt translate y*RockBuried*VBC}
       #end
       #declare K = K + 1;
     #end
     #declare J = J + 1;
   #end
#end
 
#declare Rubble0 = union{
   Make_Rubble(8,8,.075,.05,.42,-.76,5.002,.5,5,1,.0054,1,.25,-.00025,.5,true)
   texture{pigment {rgb<188,153,124>/255*1.6} finish { ambient 0 diffuse 1 } normal{bumps .05 scale <.05,1,.5>*.5}}
}
#declare Rubble1 = union{
   Make_Rubble( 40,30,.075,.05,.42,-.76,5.005,.5,5,1,.0014,1,.5,-.0001,.5,true)
   texture{pigment {rgb<188,153,124>/255*1.3} finish { ambient 0 diffuse 1 } normal{bumps .05 scale <.05,1,.5>*.5}}
}

#declare Rubble2 = union{
   Make_Rubble(50,50,.5,.01,.45,-.77,4.999,.5,6,1,.0012,0.2,1,-.0001,.5,false)
   texture{pigment {rgb<188,153,124>/255*1.5} finish { ambient 0 diffuse 1 } normal{bumps .05 scale <.05,1,.5>*.5}}
}
#declare Rubble3 = union{
   Make_Rubble(40,40,.5,.01,1.18,-1.15,4.897,.5,6,.85,.0007,.75,1.0,-.002,.5,true)
   texture{pigment {rgb<169,128, 80>/255*1.03} finish { ambient 0 diffuse .95 } normal{bumps .05 scale <.05,1,.5>*.5}}
}
#declare Rubble4 = union{
   Make_Rubble(50,40,.5,.01,.875,-.87,4.997,.5,6,1,.0014,0.8,0.7,-.0001,.5,false)
   texture{pigment {rgb<169,128, 80>/255*1.03} finish { ambient 0 diffuse .95 } normal{bumps .05 scale <.05,1,.5>*.5}}
}

#declare Rubble5 = union{
   Make_Rubble(30,20,.095,.009,.52,-.285,4.990,.5,6,.75,.0049,1,.25,-.0005,.5,true)
   texture{pigment {rgb<188,153,124>/255*1.5} finish { ambient 0 diffuse 1 } normal{bumps .05 scale <.05,1,.5>*.5}}
}

#declare Rubble6 = union{
Make_Rubble(
50,   //xres
30,   //zres
.195, //xwidth
.09,  //zwidth
.32,  //xplace
-.4775, //zplace
4.994,//lambda
.5,   //omega
6,    //octaves
.75,    //turb
.0025,  //rockMaxScale
1,     //Rockflatness constant
.25,     //Rockflatness variable
-.0005, // buried
.4,      //RockRoughness
true     // var buried
)
   texture{pigment {rgb<188,153,124>/255*1.3} finish { ambient 0 diffuse 1 } normal{bumps .05 scale <.05,1,.5>*.5}}
}

#declare sandhh = union{
 object{sandh clipped_by{box{-10,<10,10,-.4>}} scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100> normal{N1 rotate y*45}} 
 object{sandh clipped_by{box{<-10,-10,-.4>,10}} scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100> normal{bumps .06 scale <.05,1,.5>*.5}} 
 object{Rubble0 scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100>}
 object{Rubble1 scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100>}
 object{Rubble2 scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100>}
 object{Rubble3 scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100>}
 object{Rubble4 scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100>}
 object{Rubble5 scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100>}
 object{Rubble6 scale <-100,100,120>*6 rotate y*25 rotate x*-4 translate<-575,-85,-1100>}
}
object{sandhh}

#macro makeFamRock(XP,YP,XYseed)
  #declare TT=0; #while (TT<25) #declare RrF = rand(seed(TT*XYseed));
   #declare stPt = <XP+.25*TT,10,YP-1*RrF*TT>;
   #declare iNorm = y;
   #declare iPt = trace(sandhh, stPt, -y, iNorm);
   #if(!VZero(iNorm))
      object {RoofRock scale <.2,.1,.2> translate iPt translate y*-.05*RrF}
   #end
   #declare TT=TT+1;
  #end
#end
#declare RubFam1 = union{makeFamRock(-800,-1310,1234)} object{RubFam1}
#declare RubFam2 = union{makeFamRock(-810,-1315,9876)} object{RubFam2}

//--***
#declare Pyramid2 = intersection {                                                                                    
   plane {  x, 227/200  rotate <  0, 0,  39>}
   plane { -x, 227/200  rotate <  0, 0, -39>}
   plane {  z, 227/200  rotate <-39, 0,   0>}
   plane { -z, 227/200  rotate < 39, 0,   0>}
   plane { <0, -1, 0>, 0 }
   translate <0 ,-1, 0>
   
   bounded_by {box {<-3,0,-3>, <3,3,3>}}
}

object{Corr scale 2.75 translate<350,38,200>}
object{CorrRoof scale <1.1,1,1>*2.5 translate<334,36,200>}

#declare PnT = texture{pigment{checker pigment{White},pigment{Blue}} scale .05 finish{ambient 0 diffuse 1}}
#declare PnF = function{pigment{wrinkles turbulence 0.2 color_map { [0 rgb .15] [1 rgb .1] } scale <1,1,1>*0.1 translate x*-5}}
#declare Pnblanket = height_field{function 600,600 {PnF(x,0,y).grey}  clipped_by{box{<-1,-1,-.8>,<1,1,.8>}} translate <-0.5,0,-0.5>}  

#declare Basket = union{
 union{
  difference{box{<-1,0,-.7>,<1,1,.7>} box{<-.9,.1,-.6>,<.9,2,.6>}}
  torus{.6,.1 rotate<90,90,0> scale<1,1.1,1>translate<0,1,0>}
  pigment{rgb<.8,.6,.2>} normal{bumps 1.1 scale .03}
 }
 box{<-.9,.1,-.6><.9,.9,.6> pigment{bumps color_map {[0.3  color Yellow][0.4  color Red][0.6  color Green]}} normal{bumps 5 scale .1} finish{ambient 0 diffuse 1}}
}

object{Basket rotate <-5,-35,3> scale .45 translate <-804,-45.6,-1322>}
object{Pnblanket rotate <-4,0,3> scale 6 translate <-805,-46.22,-1320> texture{PnT}}

#include "people.inc"
//#include "CAR79M.pov"
//object{ Car79 scale<1,-1.1,1>*.55 rotate x*-85.4 rotate y*160 rotate z*4 translate <-790,-43.33,-1320> }
object{Man scale .25 rotate <0,55,0> translate <-795,-42.4,-1315>}  
object{Woman rotate <-10,0,3> scale <1.1,1,1>*.24 rotate <0,55,0> translate <-807,-45.3,-1320>}  
object{Kid rotate <0,35,0> scale <1.1,1,1>*.35 translate <-800,-44.1,-1310>}