// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions

#version 3.6;

//--**man**--
#declare M_upperarm = union{
 superellipsoid{<.5,.75> scale<.5,1.2,.5>}
 superellipsoid{<.75,.5> scale<.6,.2,.6> translate y*-1 }
 superellipsoid{<.65,.75> scale<.6,.2,.6> translate y*-.9 }
 pigment{White} normal{wrinkles scale .5} finish{ambient 0 diffuse 1}
}
#declare M_underarm = union{
 sphere{0,.5}
 sphere{<0,-2,0>,.3}
 cone{<0,0,0>,.5,<0,-2,0>,.3 } 
 pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1}
}
#declare M_hand = union{
 superellipsoid{<1,.5> scale<.4,.5,.2> translate z*-.08}
 cone{<0,-.2,-.1>,.2<0,-.7,-.20>,.1 translate x*-.15}
 cone{<0,-.2,-.1>,.2<0,-.8,-.20>,.1 translate x*-.06}
 cone{<0,-.2,-.1>,.2<0,-.7,-.20>,.1 translate x* .06}
 cone{<0,-.2,-.1>,.2<0,-.6,-.20>,.1 translate x* .17}
 pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1}
} 
#declare M_Larm = union{
 object{M_upperarm}
 object{M_underarm rotate x*40 translate y*-1}
 object{M_hand scale<1,1.1,1> translate y*-3.5 rotate x*27}   
}
#declare M_Rarm = union{
 object{M_upperarm}
 object{M_underarm rotate x*20 translate y*-1}
 object{M_hand scale<1,1.1,1> rotate y*-80 translate y*-3.5 rotate x*15.5}   
}
#declare M_legs = union{
 superellipsoid{<.73,.73> scale<1.1,1.2,.95> pigment{Brown} normal{wrinkles scale .75} finish{ambient 0 diffuse 1}}
 superellipsoid{<.73,.73> scale<1.2,.3,1> translate y*.3 pigment{rgb<.4,.2,0>} finish{ambient 0 diffuse 1}}
}
#declare M_Lleg = union{
 superellipsoid{<.75,.5> scale<.6,1.7,.6>}
 superellipsoid{<.75,.5> scale<.5,1.7,.6> rotate x*-30 translate <0,-2.8,1>}
 superellipsoid{<.75,.5> scale<.4,.4,1> rotate x*-30 translate <0,-4.5,1.75>}
 pigment{Brown} normal{wrinkles scale .75} finish{ambient 0 diffuse 1}
}
#declare M_Rleg = union{
 superellipsoid{<.75,.5> scale<.6,1.8,.6>}
 superellipsoid{<.75,.5> scale<.5,1.8,.6> rotate x*-10 translate <0,-2.8,.2>}
 superellipsoid{<.75,.5> scale<.4,.4,1> rotate x*-10 translate <0,-4.5,.2>}
 pigment{Brown}  normal{wrinkles scale .75} finish{ambient 0 diffuse 1}
}
#declare M_Head1 = difference{
 union{
  sphere{<0,0,0>,.75 } 
  sphere{<0,-.8,0>,.5 scale<1,.6,.6> translate <0,-.3,-.30>} 
  cone{<0,0,0>,.7,<0,-.8,0>,.5 scale<1,1,.7>translate <0,0,-.25>}
  cone{<0,0,0>,.05,<0,-.4,0>,.2 scale<1,1,.7>translate <0,0,-.7>}
  cone{<0,0,0>,.7,<0,-1,.2>,.8 scale<.7,1,.7>translate <0,-.4,.175>}
  sphere{0,.2 scale<1,.5,.5> translate <0,-.65,-.575>}
 }
 sphere{0,.2 scale<1,.5,1> translate <-.30,0,-.7>}
 sphere{0,.2 scale<1,.5,1> translate <.30,0,-.7>}
 pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1}           
} 
#declare M_Head2 = union{
 difference{
  sphere{<0,0,0>,.85} 
  sphere{<0,-.2,-.3>,.85 scale<1,.75,1>} 
  pigment{rgb<.5,.4,0>} normal{bumps 1 scale .1} finish{ambient 0 diffuse 1} 
 }
 sphere{0,.2 scale<1,.5,.3> translate <-.25,0,-.6> pigment{rgb 1}}
 sphere{0,.2 scale<1,.5,.3> translate <.25,0,-.6> pigment{rgb 1}}
}

#declare M_Head = union{
 object {M_Head1}       
 object {M_Head2}       
}

#declare Coolbox = union{
 superellipsoid{<.25,.25> scale <1,.8,.8> pigment{rgb<.5,.5,1>}}
 superellipsoid{<.25,.25> scale <1.1,.1,.9> translate y* .25 pigment{rgb 1}}
 difference{
  superellipsoid{<.25,.25> scale <1.1,.9,.1> translate y* .5} 
  superellipsoid{<.25,.25> scale <1,.8,1> translate y* .5} 
  pigment{rgb 1} finish{ambient 0 diffuse 1}
 }
}

#declare Man = union{
 object{M_Head translate <0,2.5,-1> }
 superellipsoid{<.5,.5> scale<1.2,1.8,1> rotate x*-10 translate <0,-.4,-.2> pigment{White} normal{wrinkles scale .5} finish{ambient 0 diffuse 1}}
 object{M_legs translate y*-2.25}
 object{M_Lleg rotate<20,0,-20> translate <-1,-4.5,-1>}
 object{M_Rleg rotate<0,0,10> translate <1,-4.5,-.0>}
 object{M_Larm rotate <20,0,-40> translate<-1.5,0,-.6>}
 object{M_Rarm rotate <-40,0,20> translate<1.5,0,.2>}
 object{Coolbox scale 1.2 rotate y*-60 rotate x*-10 translate <-2.75,-3.5,-3>} 
}

//--**woman**--
#declare F_dress = union{
  union{
   cone{<0,0,0>,1.3,<0,3,0>,2 scale<.5,1,.7>} sphere{<0,0,0>,1.75 scale<.5,.5,.8>}
   cone{<0,3,0>,2.,<0,4,0>,1.5 scale<.5,1,.7>} 
   sphere{<0,16,0>,1.25 scale<.5,.25,.7> pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1}}
   cone{<.75,2.75,0>,.75,<1.75,2.75,0>,.1 scale<1,1,1> translate z*.8}
   cone{<.75,2.75,0>,.75,<1.75,2.75,0>,.1 scale<1,1,1> translate z*-.7}
   rotate z*-25  rotate x*15
  }
  difference{
   cone{<0,3,0>,1,<0,-2.5,0>,3 scale<1,1,.5> rotate x*80 translate y*-.5}
   cone{<0,1,0>,1,<0,-3,0>,3 scale<1,1,.5> rotate x*80 translate y*-.5}
   box{<4,-.75,4>,-4}
   translate z*-2 rotate y*-40
  }
  texture{pigment{leopard pigment_map{[0,rgb<1,1,0>][.5,rgb<1,1,0>][.5,rgb<1,0,0>][1,rgb<1,0,0>]} scale .1} normal{wrinkles 1.2 scale .5} finish{ambient 0 diffuse 1}}
}

#declare F_legs = union{
 cone{<-1,-.2,-5>,.35,<3,0,-4>,.55} sphere{<3,0,-4>,.55}
 cone{<1,-.5,-5.5>,.35,<5,-.5,-3>,.55} sphere{<5,-.5,-3>,.55}
 cone{<.5,0,0>,.5,<5,-.5,-3>,.55}
 sphere{0,.8 scale <1,.5,.5> rotate y*-20 translate<-1,-.2,-5> pigment{rgb<.5,0,0>} finish{ambient 0 diffuse 1}}
 sphere{0,.8 scale <1,.5,.5> rotate y*-40 translate<1,-.5,-5.5> pigment{rgb<.5,0,0>} finish{ambient 0 diffuse 1}}
 pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1} 
}
#declare F_arm = union{
 superellipsoid{<.5,.5> scale <.8,4,.8>*.38 translate y*2}
 cone{<0,.7,0>,.30,<1,-1.5,0>,.25}
 object{M_hand translate<1,-1.8,0>}
 pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1} 
}
#declare F_Head1 = difference{
 union{
  sphere{<0,0,0>,.75 } 
  sphere{<0,-.8,0>,.5 scale<.6,.6,.6> translate <0,-.3,-.30>} 
  cone{<0,0,-.1>,.7,<0,-.8,-.2>,.3 scale<1,1,.7>translate <0,0,-.25>}
  cone{<0,0,0>,.05,<0,-.4,0>,.2 scale<1,1,.7>*.7 translate <0,0,-.75>}
  cone{<0,0,0>,.5,<0,-1,.2>,.6 scale<.7,1,.7>translate <0,-.4,.175>}
  sphere{0,.2 scale<1,.5,.5>*.8 translate <0,-.65,-.575>}
 }
 sphere{0,.2 scale<1,.5,1> translate <-.30,0,-.7>}
 sphere{0,.2 scale<1,.5,1> translate <.30,0,-.7>}
 pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1}           
} 
#declare F_Head2 = union{
 difference{
  sphere{<0,0,0>,.85} 
  sphere{<0,-.2,-.3>,.85 scale<1,.75,1>} 
  pigment{rgb<.2,.1,0>} normal{bumps 1 scale .1} finish{ambient 0 diffuse 1} 
 }
 sphere{0,1 scale<.7,1.5,.5> rotate x*-15 translate <0,-1,1> pigment{rgb<.2,.1,0>} normal{bumps 1 scale .1} finish{ambient 0 diffuse 1} }
 sphere{0,.2 scale<1,.5,.3> translate <-.25,0,-.6> pigment{rgb 1}}
 sphere{0,.2 scale<1,.5,.3> translate <.25,0,-.6> pigment{rgb 1}}
}

#declare F_Head = union{
 object {F_Head1}       
 object {F_Head2}       
}
 
#declare Woman = union{
 object{F_Head scale 1.1 rotate y*-90 translate <2.1,4.85,.75>}
// sphere{0,.9 translate <1.75,4.75,1.25> pigment{Flesh} finish{ambient 0 diffuse 1}}
 object{F_dress}                         
 object{F_legs}
 object{F_arm rotate x*-10 translate<1.5,0,2.7>}
 object{F_arm rotate x*15 rotate z*45 translate<3.25,1,-1.4>}
}

//--**kid**--
#declare K_shirt = union{
 superellipsoid{<.5,.5> scale<1.2,1.8,1>*.5 } 
 cylinder{<-.5,0,0><1,1,0>,.2}
 cylinder{<.5,0,0><-1,1,0>,.2}
 rotate x*-10 translate <0,-.4,-.2>
 pigment{checker pigment{Jade},pigment{White} scale.25} normal{wrinkles scale .5} finish{ambient 0 diffuse 1}
}
#declare K_arms = union{
 cone{<-.5,0,.15>,.2<1.7,1.7,0>,.12}
 cone{<.5,0,.15>,.2<-1.7,1.7,0>,.12}
 object{M_hand scale .5 rotate y*180 rotate z*135 translate <1.7,1.7,-.06>}
 object{M_hand scale .5 rotate y*180 rotate z*225 translate <-1.7,1.7,-.06>}
 translate<0,-.6,-.4>
 pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1}
}
#declare K_trousers = union{
 superellipsoid{<.73,.73> scale<1.2,.3,1>*.5 translate y*.3 pigment{rgb<.4,.2,0>} finish{ambient 0 diffuse 1}}
 union{
  superellipsoid{<.73,.73> scale<1.1,1.2,.95>*.5}
  cone{<0,0,0>,.3<-.5,-1,0>,.32}
  cone{<0,0,0>,.3<.5,-1,0>,.32}
  superellipsoid{<.75,.5> scale<.4,.4,1>*.5 rotate x*-10 translate <-1.1,-2.25,.2>}
  superellipsoid{<.75,.5> scale<.4,.4,1>*.5 rotate x*-10 translate <1.1,-2.25,.2>}
  pigment{rgb<.7,.5,.2>} normal{wrinkles scale .75} finish{ambient 0 diffuse 1}
 }
}
#declare K_legs = union{
 cone{<0,0,0>,.2<-1.1,-2.25,0>,.18}
 cone{<0,0,0>,.2<1.1,-2.25,0>,.18}
 translate y*-1.5
 pigment{Flesh} normal{bumps .1 scale .05} finish{ambient 0 diffuse 1}
}
#declare Kid1 = union{
 object{M_Head scale .6 rotate x*20 rotate y*180 translate <0,1,-.3>}
 object {K_shirt}
 object {K_arms}
 object {K_trousers translate y*-1.5}
 object {K_legs}
}

#declare Kid = object{Kid1 translate y*2.25}

