global_settings {assumed_gamma 1.0}

#include "functions.inc"
#include "colors.inc"
#include "Stones.inc"


#declare legsOnly = 0;

#declare R = seed(0);    

#declare rockPig = pigment{rgb<.3,.25,.15>}
#declare rockTex = texture{pigment{rockPig}}

#include "scorpian.inc"

#declare R = seed(0);


light_source {
       <6000,2500, -500> 
       color rgb <1,1,1>*6   
       parallel
}  
        
light_source {
        <9000,1000, 0> 
       color rgb <1,1,1>*6 
       spotlight         
       radius 0.8
       falloff 0
       point_at<0,140,500>
}  
        
light_source {
       <0, 20.5, -80>
       color rgb <1,1,1>*1     
       shadowless
       fade_distance 7   
       fade_power 1
}  
        
 
background { color rgb<0.4,0.4,1>  }

camera { 
   location <0, 20.5, -80>   
   look_at  < 0, 0, 0>          
   focal_point <-0.4,18,-73>   
   aperture 0.025     
   blur_samples 20           
   angle 70 
}




height_field{

   tga
   "MakeLand.tga"
   smooth
   translate<-0.5,-0,-0.5>  
   texture{
       spherical     
       turbulence 0
       texture_map{
         [0     pigment{rockPig}]
         [0.65  pigment{rockPig}]
         [0.66  pigment{rockPig}  normal{agate bump_size 0.1 scale .0125}]          
         [1     pigment{rockPig}  normal{agate bump_size 0.75 scale .0125}]
   
       }
   }
   rotate 45*y
   scale<100,50,100> 
   translate <0,0,0>
   
   translate <35,0,20>
   
  matrix 
     < 1, 0, 0,
       0, 1, 0.22,
       0, 0, 1,
       0, 0, 0 >
}    


height_field{

   tga
   "MakeLand.tga"
   smooth
   translate<-0.5,-0,-0.5> 
   texture{
       spherical     
       turbulence 0
       texture_map{
         [0     pigment{rockPig}]
         [0.65  pigment{rockPig}]
         [0.66  pigment{rockPig}  normal{agate bump_size 0.1 scale .0125}]          
         [1     pigment{rockPig}  normal{agate bump_size 0.75 scale .0125}]
   
       }
   }
   scale<100,50,100> 
   translate <15,0,0>
  matrix 
     < 1, 0, 0,
       0, 1, 0.17,
       0, 0, 1,
       0, 0, 0 >
}     


plane{<0,1,0>,0 pigment{rockPig} normal{bumps bump_size 1 scale 0.0125 }}

union{
  #declare N = 0;
  #while (N<3000)

   object{stone2      
   scale <1+rand(R),1,1>
   rotate 360*rand(R)*y    
   scale 0.125*(2-rand(R))
   translate<150*(0.5-rand(R)), 0, 300*rand(R)-80> 
   }
   #declare N=N+1;
  #end  

  #declare N = 0;
  #while (N<6000)

   object{stone1      
   scale <1+rand(R),1,1>
   rotate 360*rand(R)*y    
   scale 0.0625*(2-rand(R))
   translate<150*(0.5-rand(R)), 0, 300*rand(R)-80> 
   }
   #declare N=N+1;
  #end
  
  union{
    #declare N = 0;
    #while (N<6000)

     object{stone3      
     scale <1+rand(R),1,1>
     rotate 360*rand(R)*y    
     scale 0.03125*(2-rand(R))
     translate<150*(0.5-rand(R)), 0, 240*rand(R)-80> 
     }
     #declare N=N+1;
    #end
  }
  pigment{rockPig}
  rotate 6*y
}  

height_field{

   tga
   "MakeRange.tga"
   smooth
   translate<-0.5,-0.6,0> 
   rotate -30*x
   scale<1500,220,100> 
   translate <50,0,450>
   pigment{
     bozo
     color_map{
       [0 rgb<.15,.1,.05>]
       [1 rgb<.1,.05,0>]
     }            
     scale 100
   }
}
 
height_field{

   tga
   "MakeLand2.tga"
   smooth
   translate<-0.5,-0,-0.5> 
   scale<40,24,25> 
   translate <-7.5,0,-74>
   texture{rockTex}
   normal{agate}
}
 
object{scorpian  rotate -0*z  scale 1.6 rotate 170*y translate <-0.4,14.9,-73>}

fog {        
   distance 200
   color rgbt<0.6, 0.5, 0.4, 0.3>
   fog_type 2
   fog_offset 1
   fog_alt 10
}

sky_sphere{
     pigment{
       gradient y
       color_map{
          [0 White]   
          [.3 rgb<.1,.1,0.2>]
          [1 rgb<.1,.1,0.2>]
       }  
     }
}