// Parametric variable form

#declare uMin = 0; // Minimum u value
#declare uMax = 10*pi; // Maximum u value
#declare uNum = 241; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 9135; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(348); // Maximum v value
#declare vNum = 30; // Number of points in v direction
#declare vWrap = 1; // v wraps around if != 0
#declare vSeed = 2252; // Random number seed for v parameter

#declare IsRnd = false; // True if random number used
#declare IsUV = true; // True if uv-mapping used
#declare Smooth = 1; // Smooth flag

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
*/

// Optional functions
#macro cen(i) 
	<sin(i)*pow(i*i,.25),0,pow(i*i,0.6)-10>*10 
#end
#declare cry =  86;
#declare cox = 226;
#declare coz = -946;
#declare eps = .0001;

// point function
#macro pnt(i, j, p, q)
	#if (j=vMin) // Calculate only at start of circle
		#declare _st = cen(i);
		#declare _dr = vnormalize(cen(i+eps)-cen(i-eps));
		//#debug concat("pnt = <", vstr(3,_dr,",",0,4),">/n")
		#if (i=uMin) // Initialization
			#local nrm = vcross(_dr,z);
			#if (vlength(nrm)<.1) #local nrm = vcross(_dr,y); #end
			#declare _norm = vnormalize(nrm);
		#else
			#local bas = _ost+_onrm;
			#local prj = (bas+_dr*(vdot(_dr,_st)-vdot(_dr,bas)));
			#declare _norm = vnormalize(prj-_st);
		#end
		#declare _onrm = _norm;
		#declare _ost = _st;
		#declare _ortho = vcross(_dr,_norm);
		#declare _mxy = sqrt(1-_dr.y*_dr.y);
	#end

	#local mr0 = sin(pow(i/uMax,6)*pi);
	#local mrad = pow(mr0*mr0,.10)*8;
	#local mdir = _norm*cos(j)+_ortho*sin(j)+y*_mxy;
	#local pt0 = (_st+mdir*mrad)*.008;
	#local trnPnt = transform { trnGnd( Ground, cry, cox+pt0.x, coz+pt0.z, pt0.y+0.0) }
	vtransform(pt0, trnPnt)
#end
