#global_settings { 
	hf_gray_16 on 
	number_of_waves 35
}

#declare aspect = image_width/image_height;
#declare aperSize = 3000;

#declare l0Pat = function { pattern {
	leopard
	turbulence 0.13
	omega 0.75
	phase 0.0
	scale 800
} }

#declare l1Pat = function { pattern {
	crackle
	metric 1.5
	form <1, 1,-1>
	scale 100
} }

#declare l2Pat = function { pattern {
	agate
	agate_turb 0.64
	scale 300
} }

#declare lkpat = function { (1.05-l0Pat(x+1200,y,z+1400)*.90-l1Pat(x,y,z)*.20+l2Pat(x,y,z)*.15)*0.8 }
//#declare lkpat = function { l0Pat(x+1200,y,z+1400) }

plane { y, 0
	texture {
		pigment {
			function { lkpat(x,y,z) }
			color_map { [0 rgb 0] [1 rgb 1] }
		}
		finish { ambient 1 }
	}
}

camera { 
	orthographic
	location < 0.0, 2.0, 0.0> look_at < 0.0, 0.0, 0.0>
	right x*aperSize*aspect
	up z*aperSize
}
