// Parametric variable form

#declare uMin = 0; // Minimum u value
#declare uMax = pi; // Maximum u value
#declare uNum = 73; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 9135; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(350); // Maximum v value
#declare vNum = 36; // Number of points in v direction
#declare vWrap = 1; // v wraps around if != 0
#declare vSeed = 2252; // Random number seed for v parameter

#declare IsRnd = false; // True if random number used
#declare IsUV = true; // True if uv-mapping used
#declare Smooth = 0; // Smooth flag

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
*/

// Optional functions

// point function
#macro pnt(i, j, p, q)
	#if (i=uMin & j=vMin) // Initialization
		#declare _pc = mCen(lps); // mouse pos
		#declare _dr = mDir(lps); // mouse direction
		#local _n0 = vnormalize(vcross(_dr,y));
		#declare _or = vcross(_n0,_dr);
		#declare _nr = vcross(_or,_dr);
	#end
	#local pt0 = <sin(i)*cos(j),cos(i)-0.7,sin(i)*sin(j)>;
	#local cny = pt0.y+1.5;
	#local sqx = pow(cny*cny,1.4)+1;
	#local squ = lsq*<sqx,1,sqx>;
	#local ofb = ofs*<1,1,sin(i)>;
	#local pt1 = vrotate(pt0*squ+ofb,<xro,yro,0>);
	#local pt2 = (_pc+_dr*pt1.z+_nr*pt1.x+_or*pt1.y)*mScale;
	pAlt( Ground, cox+pt2.x, coz+pt2.z, pt2.y)
#end
