#version unofficial MegaPov 1.0;

#declare mScale = 0.25;

#declare msEps = .001;
#macro mCen(i)
	#local py = select(i-3*pi,cos(i/3)*.2+.2,0);
	#local px = select(i-3*pi,0,sin(i*2/3)*pow(i,1.2)*0.02);
	#local pz = i*.3;
	vrotate(<px,py,pz>,y*cry)
#end

#macro mDir(i) (vnormalize(mCen(i+msEps)-mCen(i))) #end

#macro mfSec(len,sca,esc,pos) // Foot or toe section
	#local cp1 = len/3;
	#local cp2 = len-cp1;
	union {
		sphere { 0, 1 }
		cylinder { 0, z*.4, 1 }
		cone { z*.4, 1, z*cp1, .5 }
		cylinder { z*cp1, z*cp2, .5 }
		cone { z*cp2, .5, z*len-.4, 1 }
		cylinder { z*len-.4, z*len, 1 }
		sphere { 0, 1 scale <1,1,esc> translate z*len }
		scale sca
		translate pos
	}
#end

#macro mcSec(len,wid,bnd,pos) // Toe claw
	#local hl = len*.5;
	#local hw = wid*.5;
	union {
		cone { 0, wid, z*hl, hw }
		sphere { z*hl, hw }
		cylinder { 0, z*hw*.5, hw rotate x*bnd translate z*hl }
		cone { z*hw*.5, hw, z*hl, 0 rotate x*bnd translate z*hl }
		rotate -x*bnd*.5
		translate pos
	}
#end

#declare mFoot = union {
	mfSec(4, <1,.2,1>, .3, 0)
	mfSec(6, 0.2, 0.3,<-.8,0,4>)
	mcSec(1, 0.05,-25,<-.8,0,5.2>)
	mfSec(7, 0.2, 0.3,<-.4,0,4>)
	mcSec(1, 0.05,-25,<-.4,0,5.2>)
	mfSec(8, 0.2, 0.3,<0.0,0,4>)
	mcSec(1, 0.05,-25,<0.0,0,5.2>)
	mfSec(8, 0.2, 0.3,<0.4,0,4>)
	mcSec(1, 0.05,-25,<0.4,0,5.2>)
	mfSec(4, 0.2, 0.3,<0.8,0,4>)
	mcSec(1, 0.05,-25,<0.8,0,5.2>)
	scale .01
	texture { texFootM }
}

#macro ftpnt(i, j)
	#declare _pc = mCen(lps); // mouse pos
	#declare _dr = mDir(lps); // mouse direction
	#local _n0 = vnormalize(vcross(_dr,y));
	#declare _or = vcross(_n0,_dr);
	#declare _nr = vcross(_or,_dr);
	#local pt0 = <sin(i)*cos(j),cos(i)-0.7,sin(i)*sin(j)>;
	#local cny = pt0.y+1.5;
	#local sqx = pow(cny*cny,1.4)+1;
	#local squ = lsq*<sqx,1,sqx>;
	#local ofb = ofs*<1,1,sin(i)>;
	#local pt1 = vrotate(pt0*squ+ofb,<xro,yro,0>);
	#local pt2 = (_pc+_dr*pt1.z+_nr*pt1.x+_or*pt1.y)*mScale;
	pAlt( Ground, cox+pt2.x, coz+pt2.z, pt2.y)
#end

#declare msd = seed(481); // Mouse random seed
#macro mWhiskers(num,wid,hgt) union {
	#local i=0;
	#local xd=1;
	#while (i<num)
		#local rt = .25+.10*rand(msd);
		#local rp = mCen(rt)*mScale;
		#local dr = mDir(rt);
		#local za = (.5-rand(msd))*40;
		#local len = 2.5+rand(msd);
		#local pt0 = y*hgt;
		#local pt1 = pt0+vrotate(x*xd*len,z*xd*za);
		#local pt2 = pt1+vrotate(x*xd*len,z*(za-10)*xd);
		union {
			cone { pt0, wid*2, pt1, wid }
			sphere { pt1, wid }
			cone { pt1, wid, pt2, 0 }
			scale .2*mScale
			trnGnd(Ground, cry, cox+rp.x, coz+rp.z, rp.y)
		}
		#set xd = -xd;
		#set i = i + 1;
	#end
	texture { texWhiskers }
} #end


#macro Mouse(cry, cox, coz, lga0, lga1, build) 
	#if (build) MakePara("mouse.inc", "mouse.pbj",0,0) #end
	#declare mBody = object { #include "mouse.pbj" texMouse(1,0.40) }
	
	#declare lps = 2.55; // mouse spline position
	#declare lsq = <0.015,0.35,0.05>; // mouse leg shape
	#declare ofs = <0.25,0.10,0.2>; // mouse leg offset
	#declare xro = lga0;
	#declare yro =-00;
	#if (build) MakePara("mfleg.inc", "mrfleg.pbj",0,0) #end
	#declare mrfLeg = object { #include "mrfleg.pbj" texMouse(1,0.70) }
	#declare mrfFoot = object { 
		mFoot
		scale <0.5,1,1>
		Reorient(-z,mDir(lps)) 
		translate ftpnt(pi,0) 
	}
	
	#declare ofs = <-.25,0.10,0.2>; // mouse leg offset
	#declare xro =-lga1;
	#declare yro = 00;
	#if (build) MakePara("mfleg.inc", "mlfleg.pbj",0,0) #end
	#declare mlfLeg = object { #include "mlfleg.pbj" texMouse(1,0.20) }
	#declare mlfFoot = object { 
		mFoot 
		scale <-.5,1,1> 
		Reorient(-z,mDir(lps)) 
		translate ftpnt(pi,0) 
	}
	
	#declare lps = 6.55; // mouse spline position
	#declare lsq = <0.02,0.40,0.06>; // mouse leg shape
	#declare ofs = <0.25,0.10,0.2>; // mouse leg offset
	#declare xro =-lga0;
	#declare yro =-30;
	#if (build) MakePara("mfleg.inc", "mrhleg.pbj",0,0) #end
	#declare mrhLeg = object { #include "mrhleg.pbj" texMouse(1,0.70) }
	#declare mrhFoot = object { 
		mFoot 
		scale <0.5,1,1> 
		Reorient(-z,mDir(lps)) 
		translate ftpnt(pi,0) 
	}
	
	#declare ofs = <-.25,0.10,0.2>; // mouse leg offset
	#declare xro = lga1;
	#declare yro = 30;
	#if (build) MakePara("mfleg.inc", "mlhleg.pbj",0,0) #end
	#declare mlhLeg = object { #include "mlhleg.pbj" texMouse(1,0.20) }
	#declare mlhFoot = object { 
		mFoot 
		scale <-.5,1,1> 
		Reorient(-z,mDir(lps)) 
		translate ftpnt(pi,0) 
	}
	
	#declare lps = 0.80; // mouse spline position
	#declare lsq = <0.15,0.1,0.2>; // mouse ear shape
	#declare ofs = <-.15,0.15,0.00>; // mouse ear offset
	#declare xro = 20;
	#declare zro =-60;
	#declare yro =  0;
	#if (build) MakePara("mear.inc", "mrear.pbj",0,0) #end
	#declare mrEar = object { #include "mrear.pbj" texMouse(0,0.00) }
	
	#declare ofs = <0.15,0.15,0.00>; // mouse ear offset
	#declare xro =-40;
	#declare zro = 60;
	#if (build) MakePara("mear.inc", "mlear.pbj",0,0) #end
	#declare mlEar = object { #include "mlear.pbj" texMouse(0,0.00) }
	
	#declare lps = 0.42; // mouse spline position
	#declare leyp = WorldTrans(<-.06,.14,0>,mCen(lps),mDir(lps))*mScale;
	#declare reyp = WorldTrans(<0.06,.14,0>,mCen(lps),mDir(lps))*mScale;
	#declare mEyes = union {
		sphere { 0, 0.03*mScale	trnGnd(Ground,cry,cox+leyp.x,coz+leyp.z,leyp.y) }
		sphere { 0, 0.03*mScale	trnGnd(Ground,cry,cox+reyp.x,coz+reyp.z,reyp.y) }
		material { matmsEyes }
	}

	union {
		object { mBody }
		object { mlfLeg }
		object { mlfFoot }
		object { mrfLeg }
		object { mrfFoot }
		object { mlhLeg }
		object { mlhFoot }
		object { mrhLeg }
		object { mrhFoot }
		object { mrEar }
		object { mlEar }
		object { mEyes }
		mWhiskers(20,4.7e-3,.20)
	} 
#end
