#version unofficial MegaPov 1.0;

#include "colors.inc"
#include "textures.inc"

// Sky
#declare Sky1 = pigment { image_map { png "skyday14.png" interpolate 2 } scale .5 }

#declare Sky = sky_sphere {
	pigment { 
		#if (IsTest)
			rgb <0.3, 0.6, 0.8>
		#else
			Sky1
			warp{
				spherical
				orientation z
				dist_exp 1
			}			
		#end
		//rotate x*180
	}
}

// Water
#declare WaterColC = pigment { color rgbf 1 }

#declare matWater = material {
	texture {
		pigment { WaterColC }
		normal {
			granite
			normal_map {
				[ 0.00 ripples 3 ]
				[ 0.25 bumps ]
				[ 0.50 agate agate_turb 0.1 ]
				[ 0.75 waves ]
				[ 1.00 ripples 3 ]
			}
			scale 5
		}
		finish {
			ambient 0
			diffuse 1
			phong 0.6
			phong_size 70
			conserve_energy
			reflection {
				.02, .60
				fresnel on
				exponent 0.54
			}
		}
	}
	interior { 
		ior 1.33
		media {
			absorption <1, .6, .4> * 0.01
			samples 2, 2
		}
		caustics 0.5
	}
}

// Ground
#declare pigGr1 = pigment {
	granite
	color_map {
		[0.62 rgb <1.00, 1.00, 0.84> ] // Light sand
		[0.68 rgb <0.98, 0.98, 0.65> ] // Yellow sand
		[0.74 rgb <0.97, 0.84, 0.60> ] // Orange sand
		[0.78 rgb <0.88, 0.82, 0.57> ] // Tan Sand
		[0.81 rgb <0.82, 0.55, 0.50> ] // Red Sand
		[0.85 rgb <0.52, 0.41, 0.35> ] // Brown Sand
		[0.91 rgb <0.00, 0.00, 0.00> ] // Black pebbles
		[0.91 rgb <1.00, 1.00, 0.94> ] // Light sand
	}
	scale 1.1e-4
}

#declare pigGr2 = pigment {
	ripples
	turbulence 1.23
	sine_wave
	frequency 4
	color_map {
		[ 0.00 rgb <0.35, 0.33, 0.08> ]
		[ 1.00 rgb <0.76, 0.75, 0.71> ]
	}
	scale 1.0e-2
}

#declare texGnd = texture {
	pigment {
		gradient y
		//turbulence 0.1
		phase 0.5
		#if(IsTest)
			pigment_map {
				[ 0.00 rgb <0,0,1> ]
				[ 1.00 rgb <1,1,0> ]
			}
		#else
			pigment_map {
				[ 0.30 pigGr2 ]
				[ 0.45 pigGr1 ]
			}
		#end
	}
	normal { granite 0.09 scale 3.2e-3 }
}

// Tree
#declare texBark = texture {
	pigment {
		gradient y
		turbulence 0.23
		omega 0.701
		color_map {
			[ 0.00 rgb <1.00, 0.96, 0.25> ]
			[ 1.00 rgb <0.45, 0.48, 0.23> ]
		}
	}
	finish { 
		diffuse 1 ambient 0
		phong 0.12 phong_size 29
	}
}

#declare texLeaf = texture {
	pigment {
		wood
		turbulence 0.13
		octaves 7
		omega 0.63
		color_map {
			[ 0.10 rgb <0.26, 0.86, 0.12> ]
			[ 0.20 rgb <0.96, 0.96, 0.52> ]
			[ 0.40 rgb <0.23, 0.47, 0.23> ]
			[ 1.00 rgb <0.13, 0.99, 0.13> ]
		}
	}
}

// Dragonfly
#declare texDragonF = texture {
	uv_mapping
	pigment {
		gradient y
		color_map {
			[ 0.30 rgbf <0.34, 0.41, 0.11, 0.12> ]
			[ 0.30 rgbf <0.34, 0.13, 0.12, 0.04> ]
			[ 0.50 rgbf <0.86, 0.84, 0.65, 0.56> ]
			[ 0.70 rgbf <0.34, 0.13, 0.12, 0.04> ]
			[ 0.70 rgbf <0.34, 0.41, 0.11, 0.12> ]
		}
		scale pi
	}
	finish { phong 0.24 phong_size 149 }
}

#declare texDragonM = texture {
	uv_mapping
	pigment {
		gradient y
		color_map {
			[ 0.10 rgbf <0.97, 0.13, 0.18, 0.12> ]
			[ 0.30 rgbf <0.15, 0.11, 0.12, 0.04> ]
			[ 0.30 rgbf <0.94, 0.81, 0.61, 0.56> ]
			[ 0.70 rgbf <0.94, 0.81, 0.61, 0.56> ]
			[ 0.70 rgbf <0.34, 0.21, 0.16, 0.04> ]
			[ 0.90 rgbf <0.45, 0.34, 0.14, 0.12> ]
		}
		scale pi
	}
	finish { phong 0.24 phong_size 149 }
}

// Grass blade
#declare texFoliage = texture {
	uv_mapping
	pigment {
		gradient x
		frequency 1
		color_map {
			[ 0.05 rgb <0.72, 0.98, 0.45> ]
			[ 0.10 rgb <0.31, 0.63, 0.28> ]
			[ 0.55 rgb <0.31, 0.63, 0.28> ]
			[ 0.65 rgb <0.72, 0.98, 0.45> ]
			[ 0.75 rgb <0.31, 0.63, 0.28> ]
		}
		scale pi
	}
	finish { phong 0.24 phong_size 73 metallic 0.03 }
}

// Bone
#declare Bone = texture {
	pigment {
		granite
		color_map {
			[ 0.00 color rgb < 0.80, 0.80, 0.40> ]
			[ 0.13 color rgb < 0.70, 0.70, 0.70> ]
			[ 0.26 color rgb < 0.90, 0.70, 0.50> ]
			[ 0.39 color rgb < 0.85, 0.85, 0.80> ]
			[ 0.52 color rgb < 0.80, 0.80, 0.80> ]
			[ 0.65 color rgb < 0.70, 0.85, 0.85> ]
			[ 0.78 color rgb < 0.75, 0.85, 0.95> ]
			[ 0.91 color rgb < 0.70, 0.70, 0.70> ]
			[ 1.00 color rgb < 0.80, 0.80, 0.40> ]
		}
	}
	normal { granite 0.3 scale 0.3 }
	finish { phong 0.2 phong_size 24 }
	scale 0.1
}

// Coral snake
#declare texCoral = texture {
	pigment {
		uv_mapping
		gradient x
		frequency 2
		color_map {
			[ 0.20 rgb <1,0,0> ]
			[ 0.20 rgb <1,1,0> ]
			[ 0.50 rgb <1,1,0> ]
			[ 0.50 rgb <1,0,0> ]
			[ 0.70 rgb <1,0,0> ]
			[ 0.70 rgb <0,0,0> ]
		}
	}
	finish {
		diffuse 1.0
		specular 0.56
		roughness 0.003
		metallic 0.15
	}
}

// Mouse
#macro texMouse(xy,ph) texture { 
	pigment {
		uv_mapping
		#if (xy) gradient y #else gradient x #end
		color_map {
			[ 0.00 rgb <0.47,0.40,0.33> ]
			[ 0.10 rgb <1.00,1.00,1.00> ]
			[ 0.25 rgb <1.00,1.00,1.00> ]
			[ 0.35 rgb <0.47,0.40,0.33> ]
		}
		phase ph
		scale select(xy,pi*2,pi,pi*2)
	}
	finish { phong 0.20 phong_size 31 }
} #end

#declare texFootM = texture { 
	pigment {
		gradient y
		color_map {
			[ 0.80 rgb <0.87,0.80,0.43> ]
			[ 1.00 rgb <1.00,1.00,1.00> ]
		}
		phase 0.5
	}
	finish { phong 0.20 phong_size 31 }
}

#declare texWhiskers = texture {
	pigment { rgb 0.4 }
}

#declare matmsEyes = material {
	texture {
		pigment { rgbt <0.1,0.1,0.1,0.43> }
		finish {
			reflection { 0.1, 0.34
				fresnel
				metallic 0.45
			}
			conserve_energy
			specular 0.35
			roughness 1.34e-3
			metallic 0.45
		}
	}
	interior {
		ior 1.23
	}
}
