// Parametric variable form

#declare uMin = 0; // Minimum u value
#declare uMax = 10*pi; // Maximum u value
#declare uNum = 241; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 9135; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(348); // Maximum v value
#declare vNum = 30; // Number of points in v direction
#declare vWrap = 1; // v wraps around if != 0
#declare vSeed = 2252; // Random number seed for v parameter

#declare IsRnd = false; // True if random number used
#declare IsUV = false; // True if uv-mapping used
#declare Smooth = 1; // Smooth flag

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
*/

// Optional functions
#macro cen(i) <sin(i)*sqrt(i),0,pow(i,1.2)> #end

// point function
#macro pnt(i, j, p, q)
	#if 
	#local si = sin(i);
	#local ci = cos(i);
	#local sj = sin(j);
	#local cj = cos(j);
	
	#local stx = (1.6-cos(j*20))*exp(cj-1);
	#local xp = sj*ci*stx; 
	#local yp = (cj+1)*5;
	#local zp = sj*si+si*si*0.6; 
	<xp,yp,zp>*.2
#end
