// Parametric variable form

#declare uMin = 0; // Minimum u value
#declare uMax = 1; // Maximum u value
#declare uNum = 60; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 2252; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(342); // Maximum v value
#declare vNum = 20; // Number of points in v direction
#declare vWrap = 0; // v wraps around if != 0
#declare vSeed = 9135; // Random number seed for v parameter

#declare IsRnd = false; // True if random number used
#declare IsUV = false; // True if uv-mapping used
#declare Smooth = 1; // Smooth flag

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
*/

// Optional functions

// point function
#macro pnt(i, j, p, q)
	#local sc = 2*pi/ln(2);
	
  #local xp = cos(j);
  #local zp = sin(j)+sin(i*pi)*20; 
  #local yp = i;
  <xp,yp,zp>
#end
