// Parametric variable form

#declare uMin = 0; // Minimum u value
#declare uMax = radians(357); // Maximum u value
#declare uNum = 120; // Number of points in u direction
#declare uWrap = 1; // u wraps around if != 0
#declare uSeed = 2252; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(180); // Maximum v value
#declare vNum = 61; // Number of points in v direction
#declare vWrap = 0; // v wraps around if != 0
#declare vSeed = 9135; // Random number seed for v parameter

#declare IsRnd = true; // True if random number used
#declare IsUV = false; // True if uv-mapping used
#declare Smooth = 1; // Smooth flag

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
*/

// Optional functions

// point function
#macro pnt(i, j, p, q)
	#local squ = (1+p)/3;
	#local rdo = pow(1-cos(j*squ),2);
	#local rdi = 0.90+0.10*cos(i*20)+0.02*q+rdo*0.2;

  #local xp = cos(i)*rdi; 
  #local yp = pow(sin(j*squ),0.5)*4; 
  #local zp = sin(i)*rdi;
  <xp,yp,zp>
#end
