#version unofficial MegaPov 1.0;

#declare tsd = seed(5882); // Tree seed
#declare ksd = seed(7342); // Trunk seed
#declare lsd = seed(2539); // Leaf seed

#declare nty = 8;
#local i = 0;
#declare trunks = array[nty]
#declare psPull = 20;

#while(i<nty)
	#local fnm = concat("ptrunk",str(i,0,0),".pbj");
	//MakePara("ptrunk.inc",fnm,usd,vsd)
	#local usd = rand(tsd)*10000;
	#local vsd = rand(tsd)*10000;
	#declare trunks[i] = object { #include fnm texture { texBark } }
	#set i = i + 1;
#end
//MakePara("pfrond.inc","pfrond.pbj",usd,vsd)
//MakePara("pstem.inc","pstem.pbj",usd,vsd)
//MakePara("grass.inc","grass.pbj",usd,vsd)

#declare trMin = wLev+.3;
#declare trMax = wLev+35.5;

#declare trObjs = array[13]
#declare trLens = array[13]
#declare trAngs = array[13]
#declare trMoves = array[13]

#declare tStem = object { #include "pstem.pbj" texture { texLeaf } }
#declare tFrond = object { #include "pfrond.pbj" rotate y*90 texture { texLeaf } }
#declare gBlade = object { #include "grass.pbj" texture { texFoliage } translate y*4.5 scale .2 }

#macro Trees(ntrees, trcx, trcz)
	#local tri = 0;
	#while (tri<ntrees)
		// Position the tree
		#local tps = <0,trMin*2,0>;
		#while (tps.y<trMin | tps.y>trMax)
			#local trd = sqrt(rand(tsd))*600;
			#local tang = rand(tsd)*2*pi;
			#local tx = trcx+trd*cos(tang);
			#local ty = trcz+trd*sin(tang);
			#set tps = pAlt(Ground, tx, ty, 0);
		#end
		
		// Tree parameters
		#local trTnkNum = 9+int(rand(tsd)*4); // # of trunk segments
		#local trFrnNum = 4+int(rand(tsd)*5); // # of leaf fronds per level
		#local trFrnLev = 3+int(rand(tsd)*3); // # of leaf frond levels
	
		#local trRadI = 1.5+rand(ksd)*.75; // Initial trunk radius
		#local trHgtI = 7.5+rand(ksd)*1.5; // Initial segment height
		#local trAngI = 1+rand(ksd)*20; // Initial bend angle
		#local trAngD = 0.2-rand(ksd)*2; // Angle bend rate
		#local trAngS = rand(ksd)*360; // Trunk spin angle
		
		// Leaf parameters
		#local ssang = rand(lsd)*360; // Stem spin angle
		#local lsegs = int(trTnkNum*2+rand(lsd)*7); // # of leaf fronds
		#local ldist = 0.05*trTnkNum+rand(lsd)*0.3; // separation between leaf fronds
		#local slen = (lsegs+1)*ldist; // Stem length
		#local fsc0 = pow(slen,.1); // Frond length
		#local shgt = 0.01*trTnkNum+rand(lsd)*0.1; // stem bending height
		#local trob = 0;
		
		// Trunk segments
		#declare trr = trRadI;
		#declare trh = trHgtI;
		#declare tra = trAngI;
		#while (trob<trTnkNum)
			// Position segment
			#local trh0 = trh*(0.95+rand(ksd)*0.10);
			#declare trLens[trob] = select(trob, trh0, 0, trh0);
			#declare trAngs[trob] = x*tra+vRndRange(ksd,<-1,-1,-1>,<1,1,1>)*.23;
			#local trm = trob+1;
			#declare trMoves[trob] = transform {
				#while (trm>0)
					#set trm = trm - 1;
					rotate trAngs[trm]
					translate y*trLens[trm]
				#end
				rotate y*trAngS
				translate tps
			}
	
			// Render segment
			object {
				trunks[int(rand(ksd)*nty)]
				rotate y*rand(ksd)*360
				scale <trr,trh*0.3,trr>
				transform trMoves[trob]
			}
			#set trr = trr * 0.985;
			#set trh = trh * 0.975;
		  #set tra = trAngD;
		  #set trob = trob + 1;
		#end 

		#local llev = 0;
		#while (llev<trFrnLev)
			#local lfob = 0;
			#local llaz = llev/trFrnLev*90;
			#local lllg = llev/trFrnLev*180/trFrnNum;
			#while (lfob<trFrnNum)
				// Build leaf
				#local sbang = rand(lsd)*10+100-llaz; // Stem bend angle
				#local spin = ssang+lfob*360/trFrnNum+lllg+rand(lsd)*5;
				#local fadr = select(rand(lsd)-.5,-1,1); // Initial leaf rotation
				#local trnLeaves = transform {
					scale 2
					rotate x*sbang
					translate y*trLens[trTnkNum-1]
					rotate y*spin
					transform trMoves[trTnkNum-1]
				}
				
				// Build stem
				object { tStem scale <shgt, slen,-shgt> transform { trnLeaves } }
				#local fpy = slen;
				#local fsca = fsc0;
				#local fdr = 0;
				#local i = 0;
				#while (i<lsegs)
					// Build fronds
					#local fpz = sin(fpy/slen*pi)*-20*shgt;
					#local fmz = cos(fpy/slen*pi)*20*shgt/slen/pi;
					#local fang = -degrees(atan2(fmz,1));
					object { tFrond
						scale <1, fsca, 1>
						rotate z*60*fdr
						rotate x*fang
						translate <0, fpy, fpz>
						transform { trnLeaves }
					}
					#set fpy = fpy - ldist;
					#set fsca = fsca * 1.01;
					#set fdr = select(fdr,-fdr,fadr,-fdr);
					#set i = i + 1;
				#end
				#set lfob = lfob + 1;
			#end
			#set llev = llev + 1;
		#end
	  #set tri = tri + 1;
	#end
#end 

#macro Grass(ngrass, grcx, grcz) 
	#local gri = 0;
	#while (gri<ngrass)
		// Position the blade
		#local gps = <0,trMin*2,0>;
		#while (gps.y<trMin | gps.y>trMax*1.3)
			#local grd = pow(rand(lsd),0.7)*600;
			#local gang = rand(lsd)*2*pi;
			#local gx = grcx+grd*cos(gang);
			#local gy = grcz+grd*sin(gang);
			#set gps = pAlt(Ground, gx, gy, 0);
		#end
		object { gBlade
			scale 0.8+0.3*rand(lsd)
			rotate x*(rand(lsd)*20-10)
			rotate y*360*rand(lsd)
			translate gps
			//#debug concat("Setting grass blade #",str(gri,0,0),".\n")
		}
	  #set gri = gri + 1;
	#end
#end
